@csrf

<div>
    <input type="hidden" name="id" value="{{ $data->id }}">
    <div class="form-group font-weight-bold">
        <label for="employee_name">Employee Name</label>
        <input type="text" class="form-control mt-1" name="employee_name" id="employee_name" value="{{ $data->employee_name ? $data->employee_name : old('employee_name')}}" required autocomplete="off">
    </div>
    <div class="flex flex-col md:flex-row md:gap-x-5">
                        <div class="mb-5 md:w-3/4">
                            <label class="font-weight-bold">
                                {{ __('translation.Email') }}
                            </label>
                            <x-input type="email" name="email" id="email" value="{{ $data->email ? $data->email : old('email') }}"/>
                        </div>
                        <div class="mb-5 md:w-3/4">
                            <label class="font-weight-bold">
                                {{ __('translation.Phone') }}
                            </label>
                            <x-input type="text" name="phone" id="phone" value="{{ $data->phone ? $data->phone : old('phone') }}"/>
                        </div>
                    </div>

                    <div class="mb-5">
                        <label class="font-weight-bold">
                            {{ __('translation.Address') }}
                        </label>
                        <x-form.textarea name="address" rows="3">{{ $data->address ? $data->address : old('address') }}</x-form.textarea>
                    </div>

                    <div class="mb-5">
                        <label class="font-weight-bold">
                            {{ __('translation.Note') }}
                        </label>
                        <x-form.textarea name="note" rows="3">{{ $data->note ? $data->note : old('note') }}</x-form.textarea>
                    </div>
</div>

<div class="flex justify-end py-6">
    <x-button type="reset" color="gray" class="mr-2" id="cancelModalUpdate">
        {{ __('translation.Cancel') }}
    </x-button>
    <x-button type="submit" color="blue">
        {{ __('translation.Update') }}
    </x-button>
</div>

<script>
    $(document).on('click', '#cancelModalUpdate', function() {
        $('.modal-update').addClass('modal-hide');
    });
</script>
