@csrf
<style type="text/css">
    .district_new, .sub_district_new, .province_new, .postcode_new{
        display: none;
    }
    .reset_nutton{
        border-radius: 5px;
    }
</style>

<input type="hidden" name="id" id="id" value="{{ $editData->id ?? '' }}">

<div class="form-group">
    <label for="name" class="font-weight-bold mb-1">Shop Name</label>
    <input type="text" name='name' class="form-control" required value="{{ $editData->name ?? old('name') }}">
</div>
<div class="form-group">
    <label for="address" class="font-weight-bold mb-1">Address</label>
    <textarea name='address' class="form-control">{{ $editData->address ?? old('address') }}</textarea>
</div>

<div class="form-group">
    <label for="phone" class="font-weight-bold mb-1">Phone (Showroom)</label>
    <input type="text" name='phone_showroom' class="form-control" value="{{ $editData->phone_showroom ?? old('phone_showroom') }}">
</div>

<div class="form-group">
    <label for="phone" class="font-weight-bold mb-1">Phone (Service)</label>
    <input type="text" name='phone_service' class="form-control" value="{{ $editData->phone_service ?? old('phone_service') }}">
</div>

<div class="form-group">
    <label for="email" class="font-weight-bold mb-1">Email</label>
    <input type="email" name='email' class="form-control" value="{{ $editData->email ?? old('email') }}">
</div>

<div class="form-group">
    <label for="logo" class="font-weight-bold mb-1">Upload Logo</label>
    <input type="file" onchange="previewFile(this);" class="form-control logo" name="logo" id="logo" style="height: auto">
</div>
@if(!empty($editData->logo))
    <img id="previewImg" class="mt-2 previewImg" width="130" height="130" src="{{asset($editData->logo)}}" alt="image">
@else
    <img id="previewImg" class="mt-2 previewImg" width="130" height="130" src="{{asset('img/No_Image_Available.jpg')}}" alt="image">
@endif

<div class="flex justify-end py-6">
    <x-button type="reset" color="gray" class="mr-1 cancelModalUpdate" id="cancelModalUpdate">
        {{ __('translation.Cancel') }}
    </x-button>
    <x-button type="submit" color="blue">
        {{ __('translation.Submit') }}
    </x-button>
</div>

<script>
    $(document).ready(function() {
        $('.cancelModalUpdate').click(function() {
            $('body').removeClass('modal-open');
            $('.modal-update').addClass('modal-hide');
        });
    });

    function previewFile(input){
        var file = $(".logo").get(0).files[0];

        if(file){
            var reader = new FileReader();
            reader.onload = function(){
                $(".previewImg").attr("src", reader.result);
            }
            reader.readAsDataURL(file);
        }
    }
</script>
