@csrf

<input type="hidden" name="id" value="{{ $customer->id }}">
<div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8 mb-4">
    <div class="sm:col-span-3 grid grid-cols-3 sm:grid-cols-3 gap-4 sm:gap-x-8">
        <div id="__customerNameWrapper">
            <x-label for="customer_name">
                Customer's Name
                <x-form.required-mark />
            </x-label>
            <x-input required type="text" name="customer_name" id="customer_name" class="bg-gray-200" 
            value="{{$customer->customer_name}}" />
        </div>

        <div id="__customerPhoneWrapper">
            <x-label for="phone">
                {{ __('translation.phone') }}
                <x-form.required-mark />
            </x-label>
            <x-input required type="text" name="contact_phone" id="contact_phone" class="bg-gray-200" 
            value="{{$customer->contact_phone}}" />
        </div>
        
    </div>
</div>


<div class="mb-1 xl:mb-1">
    <div class="flex flex-row items-center justify-between mb-2">
        <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
            Present Address
        </h2>
        <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
    </div>
</div>


<div class="sm:col-span-4 grid grid-cols-4 sm:grid-cols-4 gap-4 sm:gap-x-8 mb-4">
    <div id="__customerDistrictWrapper">
        <x-label for="district">
            {{ __('translation.District Name') }}
            <x-form.required-mark />
        </x-label>

        @php 
            $arr_present_address = isset($customer->present_address) ? json_decode($customer->present_address,true) : array();
            
            $present_district = isset($arr_present_address['present_district']) ? $arr_present_address['present_district'] : '';
            $present_thana = isset($arr_present_address['present_thana']) ? $arr_present_address['present_thana'] : '';
            $present_postoffice = isset($arr_present_address['present_postoffice']) ? $arr_present_address['present_postoffice'] : '';
            $present_postcode = isset($arr_present_address['present_postcode']) ? $arr_present_address['present_postcode'] : '';
            $present_village_street = isset($arr_present_address['present_village_street']) ? $arr_present_address['present_village_street'] : '';
        
        @endphp
        <select required style="width: 100%; margin-bottom: 15px;" id="district"
            class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 district"
            name="present_district">
            <option></option>
            @if($districts):
                @foreach($districts as $item):
                <option @if($item->district==$present_district) selected @endif value='{{$item->district}}'>{{$item->district}}</option>
                @endforeach
            @endif
        </select>
    </div>

    <div id="__customerThanaWrapper">
        <x-label for="thana">
            {{ __('translation.Thana Name') }}
            <x-form.required-mark />
        </x-label>
        <select required style="width: 100%; margin-bottom: 15px;" id="thana"
            class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 thana"
            name="present_thana">
            <option></option>
            @if($thanas):
                @foreach($thanas as $item):
                <option @if($item->thana==$present_thana) selected @endif value='{{$item->thana}}'>{{$item->thana}}</option>
                @endforeach
            @endif
        </select>
    </div>

    <div id="__customerPostOfficeWrapper">
        <x-label for="post_office">
            {{ __('translation.Post Office Name') }}
            <x-form.required-mark />
        </x-label>
        <select required style="width: 100%; margin-bottom: 15px;" id="post_office"
            class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 post_office"
            name="present_post_office">
            <option></option>
            @if($postoffices):
                @foreach($postoffices as $item):
                <option @if($item->postoffice==$present_postoffice) selected @endif value='{{$item->postoffice}}'>{{$item->postoffice}}</option>
                @endforeach
            @endif
        </select>
    </div>

    <div id="__customerNameWrapper">
        <x-label for="__customer_nameCreateOrder">
            {{ __('translation.Postcode') }}
            <x-form.required-mark />
        </x-label>
        <x-input type="text" name="present_post_code" id="post_code" class="bg-gray-200" value="{{$present_postcode}}" />
    </div>
</div>

<div class="grid grid-cols-1 sm:grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 mb-4">
    <div id="__customerStreetWrapper">
        <x-label for="village_street">
            {{ __('translation.Village/Street') }}
            <x-form.required-mark />
        </x-label>
        <x-textarea name="present_village_street" id="village_street" class="bg-gray-200">{{$present_village_street}}</x-textarea>
    </div>
</div>

<div class="mb-1 xl:mb-1">
    <div class="flex flex-row items-center justify-between mb-2">
        <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
            Permanent Address
        </h2>
        <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
    </div>
</div>

<div class="mb-4">
    <div class="flex flex-row gap-x-4">
        <input type="checkbox" name="same_as_present" id="same_as_present" @if($customer->same_as_present) checked="true" @endif>
        Same as present address
    </div>
</div>

<div class='permanent_address_wrapper @if($customer->same_as_present) hide @endif'>
    @php 
        $arr_permanent_address = isset($customer->permanent_address) ? json_decode($customer->permanent_address,true) : array();
        
        $permanent_district = isset($arr_permanent_address['permanent_district']) ? $arr_permanent_address['permanent_district'] : '';
        $permanent_thana = isset($arr_permanent_address['permanent_thana']) ? $arr_permanent_address['permanent_thana'] : '';
        $permanent_postoffice = isset($arr_permanent_address['permanent_postoffice']) ? $arr_permanent_address['permanent_postoffice'] : '';
        $permanent_postcode = isset($arr_permanent_address['permanent_postcode']) ? $arr_permanent_address['permanent_postcode'] : '';
        $permanent_village_street = isset($arr_permanent_address['permanent_village_street']) ? $arr_permanent_address['permanent_village_street'] : '';
    @endphp

    <div class="sm:col-span-4 grid grid-cols-4 sm:grid-cols-4 gap-4 sm:gap-x-8 mb-4">
        <div id="__customerDistrictWrapper">
            <x-label for="district">
                {{ __('translation.District Name') }}
            </x-label>
            
            <select style="width: 100%; margin-bottom: 15px;" id="district2"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 district"
                name="permanent_district">
                <option></option>
                @if($districts):
                    @foreach($districts as $item):
                    <option @if($item->district==$permanent_district) selected @endif  value='{{$item->district}}'>{{$item->district}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        <div id="__customerThanaWrapper">
            <x-label for="thana">
                {{ __('translation.Thana Name') }}
            </x-label>
            <select style="width: 100%; margin-bottom: 15px;" id="thana2"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 thana"
                name="permanent_thana">
                <option></option>
                @if($thanas):
                    @foreach($thanas as $item):
                    <option @if($item->thana==$permanent_thana) selected @endif  value='{{$item->thana}}'>{{$item->thana}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        <div id="__customerPostOfficeWrapper">
            <x-label for="post_office">
                {{ __('translation.Post Office Name') }}
            </x-label>
            <select style="width: 100%; margin-bottom: 15px;" id="post_office2"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 post_office"
                name="permanent_post_office">
                <option></option>
                @if($postoffices):
                    @foreach($postoffices as $item):
                    <option @if($item->postoffice==$permanent_postoffice) selected @endif  value='{{$item->postoffice}}'>{{$item->postoffice}}</option>
                    @endforeach
                @endif
            </select>
        </div>

        <div id="__customerNameWrapper">
            <x-label for="__customer_nameCreateOrder">
                {{ __('translation.Postcode') }}
            </x-label>
            <x-input type="text" name="permanent_post_code" id="post_code" class="bg-gray-200" value="{{$permanent_postcode}}" />
        </div>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-1 lg:grid-cols-1 gap-4 sm:gap-x-8 mb-4">
        <div id="__customerStreetWrapper2">
            <x-label for="village_street">
                {{ __('translation.Village/Street') }}
            </x-label>
            <x-textarea name="permanent_village_street" id="village_street" class="bg-gray-200">{{$permanent_village_street}}</x-textarea>
        </div>
    </div>
</div>

<div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8 mb-4">
    <div class="sm:col-span-3 grid grid-cols-3 sm:grid-cols-3 gap-4 sm:gap-x-8">
        <div id="__customerNameWrapper">
            <x-label for="nationality">
                {{ __('translation.Nationality') }}
            </x-label>
            <x-input type="text" name="nationality" id="nationality" class="bg-gray-200" value="{{$customer->nationality}}" />
        </div>

        <div id="__customerNameWrapper">
            <x-label for="sex">
                {{ __('translation.Sex') }}
                <x-form.required-mark />
            </x-label>
            <div class="flex flex-row gap-x-4">
            @php 
                 $checked_male = ($customer->sex=='male') ? 'checked' : '';
                 $checked_female = ($customer->sex=='female') ? 'checked' : '';
            @endphp
                <input type="radio" name="sex" id="male" value="male" {{$checked_male}}>
                    Male

                    <input type="radio" name="sex" id="female" value="female" {{$checked_female}}>
                    Female
            </div>
        </div>
    </div>
</div>




<div class="flex justify-end py-6">
    <x-button type="reset" color="gray" class="mr-2" id="cancelModalUpdate">
        {{ __('translation.Cancel') }}
    </x-button>
    <x-button type="submit" color="blue">
        {{ __('translation.Update') }}
    </x-button>
</div>






<script>
$(document).on('click', '#cancelModalUpdate', function() {
    $('.modal-update').addClass('modal-hide');
});
</script>

<script>

$(document).ready(function() {
    
    $('.district').select2({
        placeholder: "Select A District Name"
    });
    $('.thana').select2({
        placeholder: "Select A Thana Name"
    });
    $('.post_office').select2({
        placeholder: "Select A Post Office Name"
    });
});
</script>

<script>
        $(document).ready(function() {
            // // Load District 
            // $.ajax({
            //     url: '/districts/',
            //     type: 'GET',
            //     dataType: 'json',
            //     success: function(data) {
            //         console.log(data);
            //         $('.district').empty();
            //         $('.district').append('<option value="">Select District</option>');
            //         $.each(data, function(key, value) {
            //             console.log('<?php echo $customer->present_address;?>');
            //             $('.district').append('<option value="' + value.district + '">' + value.district + '</option>');
            //         });
            //     }
            // });

            // Fetch postal codes based on selected district
            $('.district').change(function() {
                var districtName = $(this).val();
                var current = $(this);
                if(districtName) {
                    $.ajax({
                        url: '/thana/' + districtName,
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            console.log(data);
                            current.parent().next().find('select').empty();
                            current.parent().next().find('select').append('<option value="">Select Thana</option>');
                            $.each(data, function(key, value) {
                                current.parent().next().find('select').append('<option value="' + value.thana + '">' + value.thana + '</option>');
                            });
                        }
                    });
                } else {
                    current.parent().next().find('select').empty();
                    current.parent().next().find('select').append('<option value="">Select Thana</option>');
                }
            });
            
            // Fetch postal codes based on selected district
            $('.thana').change(function() {
                var thanaName = $(this).val();
                var current = $(this);
                if(thanaName) {
                    $.ajax({
                        url: '/post-offices/' + thanaName,
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            console.log(data);
                            current.parent().next().find('select').empty();
                            current.parent().next().find('select').append('<option value="">Select Post Office</option>');
                            $.each(data, function(key, value) {
                                current.parent().next().find('select').append('<option value="' + value.postoffice + '">' + value.postoffice + '</option>');
                            });
                        }
                    });
                } else {
                    current.parent().next().find('select').empty();
                    current.parent().next().find('select').append('<option value="">Select Postal office</option>');
                }
            });
            
            // Fetch postal codes based on selected district
            $('.post_office').change(function() {
                var post_office = $(this).val();
                var current = $(this);
                if(post_office) {
                    $.ajax({
                        url: '/postal-code/' + post_office,
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            console.log(data);
                            current.parent().next().find('select').empty();
                            current.parent().next().find('input').val(data.postcode);                            
                        }
                    });
                } else {
                    current.parent().next().find('input').empty();                    
                }
            });
        });

        
        

    </script>