
@csrf
<input type="hidden" name="id" value="{{$receive_payment->id}}" id="id" />
<input type="hidden" name="order_id" value="{{$receive_payment->order_id}}" id="order_id" />
<input type="hidden" name="customer_id" value="{{$receive_payment->customer_id}}" id="customer_id" />
<input type="hidden" name="receive_for" value="{{$receive_payment->receive_for}}" id="receive_for" />
<!-- Modal content -->
<div class="px-5 py-4">
    <div class="text-sm">
        <div id='msg-success' class="font-medium text-green-700  dark:text-green-700 mb-3">
        </div>
        <ul id="error-list" class="text-red-500 mb-3"></ul>
    </div>
    <div class="space-y-3">
        <div>
            <label class="block text-sm font-medium mb-1" for="name">Payment Date<span
                    class="text-red-500">*</span></label>
            <input type="text" name="payment_date" value="{{$receive_payment->payment_date}}" autocomplete=off
                id="payment_date" class="datepicker-1 form-input w-full px-2 py-1" />
        </div>
        <div>
            <label class="block text-sm font-medium mb-1" for="email">Payment Method <span
                    class="text-red-500">*</span></label>
            <select id="payment_method" class="form-select w-full px-2 py-" name="payment_method_id">
                <option disabled selected value="0">
                    - Select Method -
                </option>
                @if($payment_methods)
                @foreach($payment_methods as $pm)
                <option value="{{$pm->id}}" @if($receive_payment->payment_method_id==$pm->id) selected @endif>{{$pm->name}}</option>
                @endforeach
                @endif
            </select>
        </div>
        
 
        <div id="modal_bankOrMobileDetailsWrapper" @if($receive_payment->payment_method_id==1) style="display: none;" @endif>                                    
            @if($receive_payment->payment_method_id==App\Models\ReceivePayments::BANKING)
                <x-label>
                    {{ __('translation.Bank Name') }}
                </x-label>
            
                <select name="bank_or_mobile_wallet_id" class='form-select w-full px-2' id="bank_or_mobile_wallet_id">
                    <option disabled selected value="0">
                        - {{ __('translation.Bank Name') }} -
                    </option>
                    @if($banks_or_mobiles)
                        @foreach($banks_or_mobiles as $bank)
                            @if($bank->type=='bank')
                                <option value="{{$bank->id}}" @if($receive_payment->bank_or_mobile_wallet_id==$bank->id) selected @endif>{{$bank->name}}</option>
                            @endif
                        @endforeach
                    @endif
                </select>
            @endif

            @if($receive_payment->payment_method_id==App\Models\ReceivePayments::MOBILE_BANKING)
                <x-label>
                    {{ __('translation.Mobile Wallet Name') }}
                </x-label>
            
                <select name="bank_or_mobile_wallet_id" class='form-select w-full px-2' id="bank_or_mobile_wallet_id">
                    <option disabled selected value="0">
                        - {{ __('translation.Mobile Wallet Name') }} -
                    </option>
                    @if($banks_or_mobiles)
                        @foreach($banks_or_mobiles as $bank)
                            @if($bank->type=='mobile')
                                <option value="{{$bank->id}}" @if($receive_payment->bank_or_mobile_wallet_id==$bank->id) selected @endif>{{$bank->name}}</option>
                            @endif
                        @endforeach
                    @endif
                </select>
            @endif
        </div>

        <div id="modal_AccountNoWrapper" @if($receive_payment->payment_method_id==1) style="display: none;" @endif>                                
            <x-label>
                {{ __('translation.Account No') }}
            </x-label>
           
            <select name="account_no_id" class='form-select' id="account_no_id" style="width: 100%">
                <option disabled selected value="0">
                    - {{ __('translation.Select') }} -
                </option>
                @if($receive_payment->bank_or_mobile_wallet)
                    @foreach($receive_payment->bank_or_mobile_wallet->accounts as $item)
                        <option value="{{$item->id}}" @if($receive_payment->account_no_id==$item->id) selected @endif>{{$item->account_no}}</option>
                    @endforeach
                @endif
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium mb-1" for="name">Paid<span
                    class="text-red-500">*</span></label>
            <input type="text" name="paid" value="{{$receive_payment->paid}}" autocomplete=off
                id="paid" class="form-input w-full px-2 py-1" />
        </div>

        <div class="w-full mt-2">
            <ul class="space-y-2">
                <li>
                    <label class="flex items-center">
                        <input type="checkbox" class="form-checkbox" name="have_model_note" id="have_model_note" value="0">
                        <span class="text-sm text-gray-600 dark:text-gray-300 font-medium ml-2">Write Note</span>
                    </label>
                </li>
            </ul>

        </div>

        <div id="modal_notes_wrapper">
            <label class="block text-sm font-medium mb-1" for="feedback">Notes</label>
            <textarea name="notes" class="form-textarea w-full px-2 py-1" rows="2"></textarea>
        </div>
    </div>
</div>
<!-- Modal footer -->
<div class="px-5 py-4 border-t border-gray-200 dark:border-gray-700/60">
    <div class="flex flex-wrap justify-end space-x-2">
        <button
            class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
        <button type="submit"
            class="btn-sm bg-gray-900 text-gray-100 hover:bg-gray-800 dark:bg-gray-100 dark:text-gray-800 dark:hover:bg-white">Submit</button>
    </div>
</div>

<script>
    $(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});


$('.modalArea #payment_method').change(function() {
        if ($(this).val() == 1) {
            $("#modal_bankOrMobileDetailsWrapper").hide();
            $("#modal_AccountNoWrapper").hide();
            $("#modal_bank_or_mobile_wallet_id").val('');
            $("#modal_account_no_id").val('');

        } else {
            $("#modal_bankOrMobileDetailsWrapper").show();
            $("#modal_AccountNoWrapper").show();
        }
        $.ajax({
            url: '{{ route('load-bank-or-mobile-dropdown') }}',
            type: 'post',
            data: {
                'id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#modal_bankOrMobileDetailsWrapper').html(result);
        });

    });

    $('.modalArea #bank_or_mobile_wallet_id').on('change', function() {
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#modal_AccountNoWrapper').html(result);
        });
    });

    $('#bank_or_mobile_wallet_id').on('change', function() {
        alert();
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_AccountNoWrapper').html(result);
        });
    });


$("#modal_notes_wrapper").hide();
    $('#have_model_note').change(function() {
        
        if($(this).is(":checked")){
            $("#modal_notes_wrapper").slideDown();
        } else {
            $("#modal_notes_wrapper").slideUp();
        }
    });




    
    
    
</script>