
@csrf
<input type="hidden" name="id" value="{{$receive_payment->id}}" id="id" />

<div class="p-5 flex space-x-4" id="msg-success">
    <!-- Icon -->
    <div class="w-10 h-10 rounded-full flex items-center justify-center shrink-0 bg-gray-100 dark:bg-gray-700">
        <svg class="shrink-0 fill-current text-red-500" width="16" height="16" viewBox="0 0 16 16">
            <path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 12c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1zm1-3H7V4h2v5z" />
        </svg>
    </div>

    <!-- Content -->
    <div>
        <!-- Modal header -->
        <!-- <div class="mb-2">
            <div class="text-lg font-semibold text-gray-800 dark:text-gray-100">Delete This Payment ?</div>
        </div> -->
        <!-- Modal content -->

        <div class="mb-3 last:mb-0">
            <ul class="text-sm">
                <li>
                    <a class="flex items-center p-2 text-gray-800 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700/20 rounded-lg" href="#0" @click="searchOpen = false" @focus="searchOpen = true" @focusout="searchOpen = false">
                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 mr-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M14 0H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h8l5-5V1c0-.6-.4-1-1-1zM3 2h10v8H9v4H3V2z"></path>
                        </svg>
                        <span><span class="font-medium">Amount</span> &nbsp; <span class="text-gray-600 dark:text-gray-400">{{$receive_payment->paid}} /=</span></span>
                    </a>
                </li>

                <li>
                    <a class="flex items-center p-2 text-gray-800 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700/20 rounded-lg" href="#0" @click="searchOpen = false" @focus="searchOpen = true" @focusout="searchOpen = false">
                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 mr-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M14 0H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h8l5-5V1c0-.6-.4-1-1-1zM3 2h10v8H9v4H3V2z"></path>
                        </svg>
                        <span><span class="font-medium">Payment Date</span> - <span class="text-gray-600 dark:text-gray-400">{{$receive_payment->payment_date}} / … / Mike Mills</span></span>
                    </a>
                </li>

                <li>
                    <a class="flex items-center p-2 text-gray-800 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700/20 rounded-lg" href="#0" @click="searchOpen = false" @focus="searchOpen = true" @focusout="searchOpen = false">
                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0 mr-3" width="16" height="16" viewBox="0 0 16 16">
                            <path d="M14 0H2c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h8l5-5V1c0-.6-.4-1-1-1zM3 2h10v8H9v4H3V2z"></path>
                        </svg>
                        <span><span class="font-medium">{{$receive_payment->payment_method->name}}</span> -
                            <span class="text-gray-600 dark:text-gray-400">
                                @if($receive_payment->payment_method_id !=App\Models\ReceivePayments::CASH)
                                    {{$receive_payment->bank_or_mobile_wallet->name}}                                                  
                                    @isset($receive_payment->bank_or_mobile_wallet_account->account_no)
                                        #{{$receive_payment->bank_or_mobile_wallet_account->account_no}}
                                    @endisset
                                @endif
                            </span> 
                        </span>
                    </a>
                </li>
            </ul>
        </div>
        <div class="text-sm mb-10">
            <div class="space-y-2 text-gray-600 dark:text-gray-400">
                <p>If you confirm then it will be removed.</p>
            </div>
        </div>                                   

        <!-- Modal footer -->
        <div class="flex flex-wrap justify-end space-x-2">
            <button type="button" class="__closeModal btn-sm border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600 text-gray-800 dark:text-gray-300">Cancel</button>
            <button type="submit" class="btn-sm bg-red-500 hover:bg-red-600 text-white">Yes, Delete it</button>
        </div>
    </div>
</div>
            
<script>
    $(".datepicker-1").datepicker({
    dateFormat: 'dd-mm-yy'
});


$('.modalArea #payment_method').change(function() {
        if ($(this).val() == 1) {
            $("#modal_bankOrMobileDetailsWrapper").hide();
            $("#modal_AccountNoWrapper").hide();
            $("#modal_bank_or_mobile_wallet_id").val('');
            $("#modal_account_no_id").val('');

        } else {
            $("#modal_bankOrMobileDetailsWrapper").show();
            $("#modal_AccountNoWrapper").show();
        }
        $.ajax({
            url: '{{ route('load-bank-or-mobile-dropdown') }}',
            type: 'post',
            data: {
                'id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#modal_bankOrMobileDetailsWrapper').html(result);
        });

    });

    $('.modalArea #bank_or_mobile_wallet_id').on('change', function() {
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#modal_AccountNoWrapper').html(result);
        });
    });

    $('#bank_or_mobile_wallet_id').on('change', function() {
        alert();
        $.ajax({
            url: '{{ route('load-bank-or-mobile-account-dropdown') }}',
            type: 'post',
            data: {
                'bank_or_mobile_wallet_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#_AccountNoWrapper').html(result);
        });
    });


$("#modal_notes_wrapper").hide();
    $('#have_model_note').change(function() {
        
        if($(this).is(":checked")){
            $("#modal_notes_wrapper").slideDown();
        } else {
            $("#modal_notes_wrapper").slideUp();
        }
    });




    
    
    
</script>