<style type="text/css">
.display_none {
    display: none;
}

.contact_add_wrapper {
    display: none;
}
</style>


@if($customer_type=='New')
    <x-input required type="hidden" name="customer_type" id="customer_type" value="services" class="bg-gray-200" />
    <div class="grid grid-cols-3 sm:grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8 mb-4">
        <div class="sm:col-span-3 grid grid-cols-3 sm:grid-cols-3 gap-4 sm:gap-x-8">
            <div id="__customerNameWrapper">
                <x-label for="customer_name">
                    Customer's Name
                    <x-form.required-mark />
                </x-label>
                <x-input required type="text" name="customer_name" id="customer_name" class="bg-gray-200" />
            </div>

            <div id="__customerPhoneWrapper">
                <x-label for="phone">
                    {{ __('translation.phone') }}
                    <x-form.required-mark />
                </x-label>
                <x-input required type="text" name="contact_phone" id="contact_phone" class="bg-gray-200" />
            </div>

            <div id="__customerNameWrapper">
                <x-label for="customer_type">
                    {{ __('translation.Customer Type') }}
                    <x-form.required-mark />
                </x-label>
                <div class="flex flex-row gap-x-4">
                <x-select name="customer_type" class="customer" required>
                    <option value="">Select Customer Type </option>
                        <option value="Contractor">Contractor</option>
                        <option value="House Owner">House Owner</option>
                        <option value="Retailer">Retailer</option>
                </x-select>
                </div>
            </div>

        </div>
    </div>

    <div class="mb-1 xl:mb-1">
        <div class="flex flex-row items-center justify-between mb-2">
            <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                Present Address
            </h2>
            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
        </div>
    </div>


    <div class="sm:col-span-4 grid grid-cols-4 sm:grid-cols-4 gap-4 sm:gap-x-8 mb-4">
        <div id="__customerDistrictWrapper">
            <x-label for="district">
                {{ __('translation.District Name') }}
                <x-form.required-mark />
            </x-label>
            <select required style="width: 100%; margin-bottom: 15px;" id="district"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 district"
                name="present_district">
                <option></option>
            </select>
        </div>

        <div id="__customerThanaWrapper">
            <x-label for="thana">
                {{ __('translation.Thana Name') }}
                <x-form.required-mark />
            </x-label>
            <select required style="width: 100%; margin-bottom: 15px;" id="thana"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 thana"
                name="present_thana">
                <option></option>
            </select>
        </div>

        <div id="__customerPostOfficeWrapper">
            <x-label for="post_office">
                {{ __('translation.Post Office Name') }}
                <x-form.required-mark />
            </x-label>
            <select required style="width: 100%; margin-bottom: 15px;" id="post_office"
                class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 post_office"
                name="present_post_office">
                <option></option>
            </select>
        </div>

        <div id="__customerNameWrapper">
            <x-label for="__customer_nameCreateOrder">
                {{ __('translation.Postcode') }}
                <x-form.required-mark />
            </x-label>
            <x-input type="text" name="present_post_code" id="post_code" class="bg-gray-200" />
        </div>
    </div>

    <div class="mb-1 xl:mb-1">
        <div class="flex flex-row items-center justify-between mb-2">
            <h2 class="block whitespace-nowrap text-yellow-500 text-base font-bold">
                Permanent Address
            </h2>
            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-yellow-300">
        </div>
    </div>

    <div class="mb-4">
        <div class="flex flex-row gap-x-4">
            <input type="checkbox" name="same_as_present" id="same_as_present" checked="true">
            Same as present address
        </div>
    </div>

    <div class="permanent_address_wrapper">
        <div class="sm:col-span-4 grid grid-cols-4 sm:grid-cols-4 gap-4 sm:gap-x-8 mb-4">
            <div id="__customerDistrictWrapper">
                <x-label for="district">
                    {{ __('translation.District Name') }}
                </x-label>
                <select style="width: 100%; margin-bottom: 15px;" id="district2"
                    class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 district"
                    name="permanent_district">
                    <option></option>
                </select>
            </div>

            <div id="__customerThanaWrapper">
                <x-label for="thana">
                    {{ __('translation.Thana Name') }}
                </x-label>
                <select style="width: 100%; margin-bottom: 15px;" id="thana2"
                    class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 thana"
                    name="permanent_thana">
                    <option></option>
                </select>
            </div>

            <div id="__customerPostOfficeWrapper">
                <x-label for="post_office">
                    {{ __('translation.Post Office Name') }}
                </x-label>
                <select style="width: 100%; margin-bottom: 15px;" id="post_office2"
                    class="form-control block font-medium w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 post_office"
                    name="permanent_post_office">
                    <option></option>
                </select>
            </div>

            <div id="__customerNameWrapper">
                <x-label for="__customer_nameCreateOrder">
                    {{ __('translation.Postcode') }}
                </x-label>
                <x-input type="text" name="permanent_post_code" id="post_code" class="bg-gray-200" />
            </div>
        </div>
    </div>
@else

    <x-input required type="hidden" name="customer_type" id="customer_type" value="{{$customer_type}}" class="bg-gray-200" />
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8">
        <div>
            <label for="__tax_enable_CreateOrder" class="block mb-2">
                {{ __('translation.Customer') }}
                <x-form.required-mark />
            </label>
            <div class="flex flex-row gap-x-4">
                <x-select id="customer_id" name="customer_id" class="customer">
                    <option value="">Select Show Room Customer
                    <option>
                        @if($customers)
                        @foreach($customers as $customer)
                            <option value="{{$customer->id}}">{{$customer->customer_name}}
                        @endforeach
                        @endif
                </x-select>
            </div>
        </div>
    </div>
@endif


<script>
$('.customer').select2({
    placeholder: '- Select Customer -',
    width: 'resolve'
});
</script>

<script>

$('#customer_id').change(function() {
        $.ajax({
            url: '{{ route('customer-due') }}',
            type: 'post',
            data: {
                'customer_id': $(this).val(),
                '_token': $('meta[name=csrf-token]').attr('content')
            }
        }).done(function(result) {
            $('#__previousDue').html(result);
            calculateCartSummary();
        });

    });

$(document).ready(function() {
    
    $('.district').select2({
        placeholder: "Select A District Name"
    });
    $('.thana').select2({
        placeholder: "Select A Thana Name"
    });
    $('.post_office').select2({
        placeholder: "Select A Post Office Name"
    });
});
</script>

<script>
$(document).ready(function() {
// Load District 
$.ajax({
    url: '/districts/',
    type: 'GET',
    dataType: 'json',
    success: function(data) {
        console.log(data);
        $('.district').empty();
        $('.district').append('<option value="">Select District</option>');
        $.each(data, function(key, value) {
            $('.district').append('<option value="' + value.district + '">' + value.district + '</option>');
        });
    }
});

// Fetch postal codes based on selected district
$('.district').change(function() {
    var districtName = $(this).val();
    var current = $(this);
    if(districtName) {
        $.ajax({
            url: '/thana/' + districtName,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log(data);
                current.parent().next().find('select').empty();
                current.parent().next().find('select').append('<option value="">Select Thana</option>');
                $.each(data, function(key, value) {
                    current.parent().next().find('select').append('<option value="' + value.thana + '">' + value.thana + '</option>');
                });
            }
        });
    } else {
        current.parent().next().find('select').empty();
        current.parent().next().find('select').append('<option value="">Select Thana</option>');
    }
});

// Fetch postal codes based on selected district
$('.thana').change(function() {
    var thanaName = $(this).val();
    var current = $(this);
    if(thanaName) {
        $.ajax({
            url: '/post-offices/' + thanaName,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log(data);
                current.parent().next().find('select').empty();
                current.parent().next().find('select').append('<option value="">Select Post Office</option>');
                $.each(data, function(key, value) {
                    current.parent().next().find('select').append('<option value="' + value.postoffice + '">' + value.postoffice + '</option>');
                });
            }
        });
    } else {
        current.parent().next().find('select').empty();
        current.parent().next().find('select').append('<option value="">Select Postal office</option>');
    }
});

// Fetch postal codes based on selected district
$('.post_office').change(function() {
    var post_office = $(this).val();
    var current = $(this);
    if(post_office) {
        $.ajax({
            url: '/postal-code/' + post_office,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log(data);
                current.parent().next().find('select').empty();
                current.parent().next().find('input').val(data.postcode);                            
            }
        });
    } else {
        current.parent().next().find('input').empty();                    
    }
});
});

jQuery(".permanent_address_wrapper").addClass('hide');
jQuery(document).on('change','#same_as_present',function () {   
jQuery(".permanent_address_wrapper").toggleClass('hide');
});

</script>