
<?php
use App\Http\Controllers\ChannelController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\LenderController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SalariesController;

use App\Http\Controllers\RcvPaymentsController;
use App\Http\Controllers\MyBankingController;


use App\Http\Controllers\DropshipperController;
use App\Http\Controllers\ExchangeRateController;
use App\Http\Controllers\FacebookController;
use App\Http\Controllers\LineController;
use App\Http\Controllers\ProductTagController;
use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\DefectStockController;
use App\Http\Controllers\RoleController;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TrackController;
use App\Http\Controllers\SellerController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\Admin\ScanTranslationJobController;
use App\Http\Controllers\Admin\TranslationController;
use App\Http\Controllers\CompanyInfoSettingController;
use App\Http\Controllers\TaxRateSettingController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\BuyerPage\BankTransferConfirmController;
use App\Http\Controllers\BuyerPage\CancelOrderController;
// use App\Http\Controllers\BuyerPage\PaymentMethodController;
use App\Http\Controllers\BuyerPage\SelectDistrictController;
use App\Http\Controllers\BuyerPage\SelectPostCodeController;
use App\Http\Controllers\BuyerPage\SelectProvinceController;
use App\Http\Controllers\BuyerPage\SelectSubDistrictController;
use App\Http\Controllers\BuyerPage\ShippingAddressController;
use App\Http\Controllers\BuyerPage\ShippingMethodController;
use App\Http\Controllers\Category\CategorySelectController;
use App\Http\Controllers\Category\ParentOnlySelectController;
use App\Http\Controllers\FeatureController;
use App\Http\Controllers\SizeController;
use App\Http\Controllers\ModelNameController;
use App\Http\Controllers\BankOrMobileController;


use App\Http\Controllers\CategoryController;
use App\Http\Controllers\Customer\CustomerPhoneController;
use App\Http\Controllers\CustomOrderController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\OptController;
use App\Http\Controllers\OrderManage\BuyerPageController;
use App\Http\Controllers\OrderManage\ProductGridController;
use App\Http\Controllers\OrderManage\QuotationController;
use App\Http\Controllers\OrderManage\ShipmentController as OrderShipmentController;
use App\Http\Controllers\OrderManage\ShipmentLabelController;
use App\Http\Controllers\OrderManage\StatusController;
use App\Http\Controllers\OrderManage\SubCategoryGridController;

use App\Http\Controllers\ReceiveController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\RmStockController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\RawMaterialController;


use App\Http\Controllers\ShipperController;
use App\Http\Controllers\PartnerController;
use App\Http\Controllers\InvestmentController;

use App\Http\Controllers\StaffController;
use App\Http\Controllers\QrCodeController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\OrderManageController;
use App\Http\Controllers\ServicesController;

use App\Http\Controllers\ProductCostController;
use App\Http\Controllers\OrderAnalysisController;

use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\Shipper\ShippingCostWeightController;
use App\Http\Controllers\ShippingCostController;
use App\Http\Controllers\ShipTypeController;
use App\Http\Controllers\DomesticShipperController;
use App\Http\Controllers\PoShipmentController;

use App\Http\Controllers\FormsController;

use App\Http\Controllers\InventoryController;
use App\Http\Controllers\CronReportController;
use App\Http\Controllers\LangSwitcherController;

use App\Http\Controllers\OrderManage\InvoiceController;

use App\Http\Controllers\Shop\ShopSelectController;

use App\Http\Controllers\TaxInvoiceController;
use App\Http\Controllers\User\LanguageController;


use Illuminate\Http\Request;

// Route::get('/', [AuthenticatedSessionController ::class, 'create'])->name('front page');
Route::get('/', [TrackController::class, 'index'])->name('front page');
Route::post('/', [TrackController::class, 'getData']);
// Route::get('tes', [TrackController::class, 'getData']);
Route::get('/token', function () {
    return csrf_token();
});

Route::group(['middleware' => ['auth', 'translation']], function () {

    // Route::middleware(['staff'])->group(function () {

    //     Route::get('/staff', function () {
    //         return redirect(route('dashboard'));
    //     });
    //     Route::get('staff/dashboard', [StaffController::class, 'dashboard'])->name('staff dashboard');
    //     Route::get('quantity-update', [StaffController::class, 'quantityUpdate'])->name('quantity update');
    //     Route::get('staff/product/data', [StaffController::class, 'productData'])->name('product data staff');

    //     Route::get('staff/see-details/{id}', [StaffController::class, 'seeDetails'])->name('see quantity details');

    // });


    //Route::middleware(['member', 'staff'])->group(function () {

        Route::get('/seller', function () {
            return redirect(route('product'));
        });
        Route::get('/dashboard', [ProductController::class, 'product'])->name('product');
        Route::get('/chart-data', [SellerController::class, 'chartData']);
        Route::get('/seller/manage-tracking', [TrackingController::class, 'index'])->name('manage tracking');
        Route::get('/tracking/data', [TrackingController::class, 'data'])->name('data tracking');
        Route::post('/tracking/insert', [TrackingController::class, 'store'])->name('insert tracking');
        Route::post('/tracking/import', [TrackingController::class, 'import'])->name('import tracking');
        Route::post('/tracking/update', [TrackingController::class, 'update'])->name('update order');
        Route::post('/tracking/delete', [TrackingController::class, 'delete'])->name('delete tracking');
        Route::get('/track-page', [TrackingController::class, 'trackPage'])->name('track page');

        //Tracking
        Route::post('/track-id', [SellerController::class, 'TrackId'])->name('Track Id');

        //product
        Route::get('/product', [ProductController::class, 'product'])->name('product');
        Route::get('/product/data', [ProductController::class, 'data'])->name('data product');
        Route::POST('/form-insert-modal-product',[ ProductController::class,'loadInsertForm'])->name('form-insert-modal-product');
        Route::post('/product/insert', [ProductController::class, 'insert'])->name('product.insert');
        Route::get('/product/edit/{id}', [ProductController::class, 'edit'])->name('product.edit');
        Route::post('/product/update', [ProductController::class, 'update'])->name('product.update');
        Route::POST('/form-delete-modal-product',[ ProductController::class,'loadDeleteForm'])->name('form-delete-modal-product');
        Route::post('/product/delete', [ProductController::class, 'delete'])->name('product.delete');
    


        //product
        Route::get('/production-units', [ShopController::class, 'shops'])->name('production-units');
        Route::get('/production-units/data', [ShopController::class, 'data'])->name('data production-units');
        Route::POST('/form-insert-modal-production-unit',[ ShopController::class,'loadInsertForm'])->name('form-insert-modal-production-unit');
        Route::post('/production-unit/insert', [ShopController::class, 'insert'])->name('production-unit.insert');
        Route::get('/production-unit/edit/{id}', [ShopController::class, 'edit'])->name('production-unit.edit');
        Route::post('/production-unit/update', [ShopController::class, 'update'])->name('production-unit.update');
        Route::POST('/form-delete-modal-production-unit',[ ShopController::class,'loadDeleteForm'])->name('form-delete-modal-production-unit');
        Route::post('/production-unit/delete', [ShopController::class, 'delete'])->name('production-unit.delete');
    


        //raw-materials
        Route::get('/raw-materials', [RawMaterialController::class, 'rawMaterials'])->name('raw-materials');
        Route::get('/raw-materials/data', [RawMaterialController::class, 'data'])->name('data raw-materials');
        Route::POST('/form-insert-modal-raw-material',[ RawMaterialController::class,'loadInsertForm'])->name('form-insert-modal-raw-material');
        Route::post('/raw-material/insert', [RawMaterialController::class, 'insert'])->name('raw-material.insert');
        Route::get('/raw-material/edit/{id}', [RawMaterialController::class, 'edit'])->name('raw-material.edit');
        Route::post('/raw-material/update', [RawMaterialController::class, 'update'])->name('raw-material.update');
        Route::POST('/form-delete-modal-raw-material',[ RawMaterialController::class,'loadDeleteForm'])->name('form-delete-modal-raw-material');
        Route::post('/raw-material/delete', [RawMaterialController::class, 'delete'])->name('raw-material.delete');
    

        


        //quantity update
       
        Route::get('seller/see-details/datatable', [ProductController::class, 'seeDetailsDataTable'])->name('seller-quantity-details-datatable');
        Route::get('seller/see-details/{id}', [ProductController::class, 'seeDetails'])->name('seller quantity details');

        Route::get('/date-quantity-log', [ProductController::class, 'dataQuantityLog'])->name('date quantity log');
        Route::post('/update-quantity-log', [ProductController::class, 'updateQuantityLog'])->name('update quantity log');
        Route::post('/delete-quantity-log', [ProductController::class, 'deleteQuantityLog'])->name('delete quantity log');
        Route::post('/delete-quantity-log-bulk', [ProductController::class, 'deleteQuantityLogBulk'])->name('delete quantity log bulk');

        // woo quantity update
        Route::post('/product/inventory-sync/shops', [ProductController::class, 'getShopsList'])->name('product.inventory_sync.shop_list');
        Route::post('/product/inventory-sync/filter-quantities', [ProductController::class, 'getFilterQuantities'])->name('product.inventory_sync.filter_quantities');
        Route::get('/product/inventory-sync/datatable', [ProductController::class, 'inventorySyncDataTable'])->name('product.inventory_sync.datatable');
        Route::get('/product/inventory-sync/{id}', [ProductController::class, 'inventorySync'])->name('product.inventory_sync');
        Route::post('product/save-link', [ProductController::class, 'saveProductLink'])->name('product.save_link');
        Route::post('product/save-multiple-links', [ProductController::class, 'saveMultipleProductLinks'])->name('product.save_multiple_links');
        Route::post('/product/inventory-auto-link', [ProductController::class, 'inventoryAutoLink'])->name('product.inventory_auto_link');
        Route::post('/product/inventory-sync-quantity', [ProductController::class, 'inventorySyncQuantity'])->name('product.inventory_sync.quantity');

        Route::get('/product/{id}', [ProductController::class, 'show'])->name('product.show');



        //ReceivePayment
        Route::get('/receive-payments', [ReceiveController::class, 'index'])->name('receive-payments');
        Route::get('/receive-payments/data', [ReceiveController::class, 'data'])->name('data receive-payments');
        Route::GET('/form-insert-modal-receive-payment',[ ReceiveController::class,'loadInsertForm'])->name('form-insert-modal-receive-payment');
        Route::post('/receive-payments/insert', [ReceiveController::class, 'insert'])->name('receive-payment.insert');
        Route::get('/receive-payments/edit/{id}', [ReceiveController::class, 'edit'])->name('receive-payment.edit');
        Route::post('/receive-payments/update', [ReceiveController::class, 'update'])->name('receive-payment.update');
        Route::POST('/form-delete-modal-receive-payment',[ ReceiveController::class,'loadDeleteForm'])->name('form-delete-modal-receive-payment');
        Route::post('/receive-payments/delete', [ReceiveController::class, 'delete'])->name('receive-payment.delete');
        Route::post('/receive-payments/bulk-delete', [ReceiveController::class, 'bulkDelete'])->name('bulk-delete-receive-payment');

        
        //Payment
        Route::get('/payments', [PaymentController::class, 'index'])->name('payments');
        Route::get('/payments/data', [PaymentController::class, 'data'])->name('data payments');
        Route::GET('/form-insert-modal-payment',[ PaymentController::class,'loadInsertForm'])->name('form-insert-modal-payment');
        Route::post('/payments/insert', [PaymentController::class, 'insert'])->name('payment.insert');
        Route::get('/payments/edit/{id}', [PaymentController::class, 'edit'])->name('payment.edit');
        Route::post('/payments/update', [PaymentController::class, 'update'])->name('payment.update');
        Route::POST('/form-delete-modal-payment',[ PaymentController::class,'loadDeleteForm'])->name('form-delete-modal-payment');
        Route::post('/payments/delete', [PaymentController::class, 'delete'])->name('payment.delete');
        Route::post('/payments/bulk-delete', [PaymentController::class, 'bulkDelete'])->name('bulk-delete-payment');


        //Expense
        Route::get('/expenses', [ExpenseController::class, 'index'])->name('expenses');
        Route::get('/expenses/data', [ExpenseController::class, 'data'])->name('data expenses');
        Route::GET('/form-insert-modal-expense',[ ExpenseController::class,'loadInsertForm'])->name('form-insert-modal-expense');
        Route::post('/expenses/insert', [ExpenseController::class, 'insert'])->name('expense.insert');
        Route::get('/expenses/edit/{id}', [ExpenseController::class, 'edit'])->name('expense.edit');
        Route::post('/expenses/update', [ExpenseController::class, 'update'])->name('expense.update');
        Route::POST('/form-delete-modal-expense',[ ExpenseController::class,'loadDeleteForm'])->name('form-delete-modal-expense');
        Route::post('/expenses/delete', [ExpenseController::class, 'delete'])->name('expense.delete');
        Route::post('/expenses/bulk-delete', [ExpenseController::class, 'bulkDelete'])->name('bulk-delete-expense');


        //Customer
        Route::get('/customers', [CustomerController::class, 'index'])->name('customers');
        Route::get('/customers/data', [CustomerController::class, 'data'])->name('data customers');
        Route::GET('/form-insert-modal-customer',[ CustomerController::class,'loadInsertForm'])->name('form-insert-modal-customer');
        Route::post('/customers/insert', [CustomerController::class, 'insert'])->name('customer.insert');
        Route::get('/customers/edit/{id}', [CustomerController::class, 'edit'])->name('customer.edit');
        Route::post('/customers/update', [CustomerController::class, 'update'])->name('customer.update');
        Route::POST('/form-delete-modal-customer',[ CustomerController::class,'loadDeleteForm'])->name('form-delete-modal-customer');
        Route::post('/customers/delete', [CustomerController::class, 'delete'])->name('customer.delete');
        Route::post('/customers/bulk-delete', [CustomerController::class, 'bulkDelete'])->name('bulk-delete-customer');
        Route::get('/change/customer/status', [CustomerController::class, 'statusFormLoad'])->name('change-customer-status');
        Route::post('/customers/updateStatus', [CustomerController::class, 'updateStatus'])->name('customer.updateStatus');


        //Supplier
        Route::get('/suppliers', [SupplierController::class, 'index'])->name('suppliers');
        Route::get('/suppliers/data', [SupplierController::class, 'data'])->name('data suppliers');
        Route::GET('/form-insert-modal-supplier',[ SupplierController::class,'loadInsertForm'])->name('form-insert-modal-supplier');
        Route::post('/suppliers/insert', [SupplierController::class, 'insert'])->name('supplier.insert');
        Route::get('/suppliers/edit/{id}', [SupplierController::class, 'edit'])->name('supplier.edit');
        Route::post('/suppliers/update', [SupplierController::class, 'update'])->name('supplier.update');
        Route::POST('/form-delete-modal-supplier',[ SupplierController::class,'loadDeleteForm'])->name('form-delete-modal-supplier');
        Route::post('/suppliers/delete', [SupplierController::class, 'delete'])->name('supplier.delete');
        Route::post('/suppliers/bulk-delete', [SupplierController::class, 'bulkDelete'])->name('bulk-delete-supplier');
        Route::get('/change/supplier/status', [SupplierController::class, 'statusFormLoad'])->name('change-supplier-status');
        Route::post('/suppliers/updateStatus', [SupplierController::class, 'updateStatus'])->name('supplier.updateStatus');

        //Employee
        Route::get('/employees', [EmployeeController::class, 'index'])->name('employees');
        Route::get('/employees/data', [EmployeeController::class, 'data'])->name('data employees');
        Route::GET('/form-insert-modal-employee',[ EmployeeController::class,'loadInsertForm'])->name('form-insert-modal-employee');
        Route::post('/employees/insert', [EmployeeController::class, 'insert'])->name('employee.insert');
        Route::get('/employees/edit/{id}', [EmployeeController::class, 'edit'])->name('employee.edit');
        Route::post('/employees/update', [EmployeeController::class, 'update'])->name('employee.update');
        Route::POST('/form-delete-modal-employee',[ EmployeeController::class,'loadDeleteForm'])->name('form-delete-modal-employee');
        Route::post('/employees/delete', [EmployeeController::class, 'delete'])->name('employee.delete');
        Route::post('/employees/bulk-delete', [EmployeeController::class, 'bulkDelete'])->name('bulk-delete-employee');
        Route::get('/change/employee/status', [EmployeeController::class, 'statusFormLoad'])->name('change-employee-status');
        Route::post('/employees/updateStatus', [EmployeeController::class, 'updateStatus'])->name('employee.updateStatus');
    

        //Lender
        Route::get('/lenders', [LenderController::class, 'index'])->name('lenders');
        Route::get('/lenders/data', [LenderController::class, 'data'])->name('data lenders');
        Route::GET('/form-insert-modal-lender',[ LenderController::class,'loadInsertForm'])->name('form-insert-modal-lender');
        Route::post('/lenders/insert', [LenderController::class, 'insert'])->name('lender.insert');
        Route::get('/lenders/edit/{id}', [LenderController::class, 'edit'])->name('lender.edit');
        Route::post('/lenders/update', [LenderController::class, 'update'])->name('lender.update');
        Route::POST('/form-delete-modal-lender',[ LenderController::class,'loadDeleteForm'])->name('form-delete-modal-lender');
        Route::post('/lenders/delete', [LenderController::class, 'delete'])->name('lender.delete');
        Route::post('/lenders/bulk-delete', [LenderController::class, 'bulkDelete'])->name('bulk-delete-lender');
        Route::get('/change/lender/status', [LenderController::class, 'statusFormLoad'])->name('change-lender-status');
        Route::post('/lenders/updateStatus', [LenderController::class, 'updateStatus'])->name('lender.updateStatus');
    
        


        //Stocks
        Route::get('/stocks', [StockController::class, 'stocks'])->name('stocks');
        Route::get('/stocks/data', [StockController::class, 'data'])->name('data stocks');
        Route::POST('/form-insert-modal-stock',[ StockController::class,'loadInsertForm'])->name('form-insert-modal-stock');
        Route::post('/stocks/insert', [StockController::class, 'insert'])->name('stock.insert');
        Route::get('/stocks/edit/{id}', [StockController::class, 'edit'])->name('stock.edit');
        Route::post('/stocks/update', [StockController::class, 'update'])->name('stock.update');
        Route::POST('/form-delete-modal-stock',[ StockController::class,'loadDeleteForm'])->name('form-delete-modal-stock');
        Route::post('/stocks/delete', [StockController::class, 'delete'])->name('stock.delete');
        Route::post('/stocks/bulk-delete', [StockController::class, 'bulkDelete'])->name('bulk-delete-stock');

        //RM Stocks
        Route::get('/rm-stocks', [RmStockController::class, 'rMstocks'])->name('rm-stocks');
        Route::get('/rm-stocks/data', [RmStockController::class, 'data'])->name('data rm-stocks');
        Route::POST('/form-insert-modal-rm-stock',[ RmStockController::class,'loadInsertForm'])->name('form-insert-modal-rm-stock');
        Route::post('/rm-stocks/insert', [RmStockController::class, 'insert'])->name('rm-stock.insert');
        Route::get('/rm-stocks/edit/{id}', [RmStockController::class, 'edit'])->name('rm-stock.edit');
        Route::post('/rm-stocks/update', [RmStockController::class, 'update'])->name('rm-stock.update');
        Route::POST('/form-delete-modal-rm-stock',[ RmStockController::class,'loadDeleteForm'])->name('form-delete-modal-rm-stock');
        Route::post('/rm-stocks/delete', [RmStockController::class, 'delete'])->name('rm-stock.delete');
        Route::post('/rm-stocks/bulk-delete', [RmStockController::class, 'bulkDelete'])->name('bulk-delete-rm-stock');
     
     
        //
        //Purchases
        Route::get('/purchases', [PurchaseController::class, 'purchases'])->name('purchases');
        Route::get('/purchases/data', [PurchaseController::class, 'data'])->name('data purchases');
        Route::get('purchases/create/', [PurchaseController::class, 'create'])->name('purchase.create');
        Route::post('/purchase/store', [PurchaseController::class, 'store'])->name('purchase.store');
        Route::post('supplier-due', [PurchaseController::class, 'SupplierDue'])->name('supplier-due');
        Route::get('/purchase/edit/{id}', [PurchaseController::class, 'edit'])->name('purchase.edit');
        Route::POST('/form-insert-modal-purchase',[ PurchaseController::class,'loadInsertForm'])->name('form-insert-modal-purchase');
        Route::post('/purchases/insert', [PurchaseController::class, 'insert'])->name('purchase.insert');
        Route::post('/purchases/update', [PurchaseController::class, 'update'])->name('purchase.update');
        Route::POST('/form-view-modal-purchase',[ PurchaseController::class,'loadViewPurchase'])->name('form-view-modal-purchase');
        Route::POST('/form-delete-modal-purchase',[ PurchaseController::class,'loadDeleteForm'])->name('form-delete-modal-purchase');
        Route::post('/purchases/delete', [PurchaseController::class, 'delete'])->name('purchase.delete');
        Route::post('/purchases/bulk-delete', [PurchaseController::class, 'bulkDelete'])->name('bulk-delete-purchase');
        

        Route::get('/order_managements', [OrderManageController::class, 'index'])->name('order_managements');
        Route::get('/order_managements/data', [OrderManageController::class, 'data'])->name('data order_managements');
        Route::get('order_managements/create/', [OrderManageController::class, 'create'])->name('order_management.create');
        Route::post('/order_managements/store', [OrderManageController::class, 'store'])->name('order_management.store');
        Route::post('customer-due', [OrderManageController::class, 'CustomerDue'])->name('customer-due');
        Route::get('/order_managements/edit/{id}', [OrderManageController::class, 'edit'])->name('order_management.edit');
        Route::post('/order_managements/update', [OrderManageController::class, 'update'])->name('order_management.update');
   
     

        
         //partner
         Route::get('manage-partner', [PartnerController::class, 'managePartner'])->name('partner.manage');
         Route::get('partner/data', [PartnerController::class, 'data'])->name('partner.data');
         Route::post('partner/insert', [PartnerController::class, 'insert'])->name('partner.insert');
         Route::post('partner/update', [PartnerController::class, 'update'])->name('partner.update');
         Route::post('partner/delete', [PartnerController::class, 'delete'])->name('partner.delete');
        

          
         //investment
         Route::get('manage-investment', [InvestmentController::class, 'manageInvestment'])->name('investment.manage');
         Route::get('investment/data', [InvestmentController::class, 'data'])->name('investment.data');
         Route::post('investment/insert', [InvestmentController::class, 'insert'])->name('investment.insert');
         Route::post('investment/update', [InvestmentController::class, 'update'])->name('investment.update');
         Route::post('investment/delete', [InvestmentController::class, 'delete'])->name('investment.delete');
        
        

         
        //staff
        Route::get('manage-staff', [StaffController::class, 'manageStaff'])->name('staff.manage');
        Route::get('staff/data', [StaffController::class, 'data'])->name('staff.data');
        Route::post('staff/insert', [StaffController::class, 'insert'])->name('staff.insert');
        Route::post('staff/update', [StaffController::class, 'update'])->name('staff.update');
        Route::post('staff/delete', [StaffController::class, 'delete'])->name('staff.delete');
        Route::get('staff/password-modal', [StaffController::class, 'changePasswordModal'])->name('staff.change_password_modal');
        Route::post('staff/change-password', [StaffController::class, 'changePassword'])->name('staff.change_password');

        // Roles and permissions
        Route::get('roles', [RoleController::class, 'staffRole'])->name('role');
        Route::get('roles/data', [RoleController::class, 'data'])->name('role.data');
        Route::post('roles/insert', [RoleController::class, 'insert'])->name('role.insert');
        Route::post('roles/update', [RoleController::class, 'update'])->name('role.update');
        Route::post('roles/delete', [RoleController::class, 'delete'])->name('role.delete');

        Route::get('roles/assign/{id}', [RoleController::class, 'assignPermission'])->name('role.assign_permission');
        Route::post('roles/save-assign/{id}', [RoleController::class, 'saveAssignPermission'])->name('assign_permission.save');
        Route::get('roles/no-role', [RoleController::class, 'noRole'])->name('no_role_profile');

        Route::get('permissions', [RoleController::class, 'permissions'])->name('staff.permissions');
        Route::get('permissions/data', [RoleController::class, 'dataPermission'])->name('staff.permissions.data');
        Route::post('permissions/insert', [RoleController::class, 'insertPermission'])->name('staff.permissions.insert');
        Route::post('permissions/update', [RoleController::class, 'updatePermission'])->name('staff.permissions.update');
        Route::post('permissions/delete', [RoleController::class, 'deletePermission'])->name('staff.permissions.delete');


       
        Route::get('services', [ServicesController::class, 'index'])->name('service.index');
        Route::get('service/list', [ServicesController::class, 'data'])->name('servicesList');
        Route::get('services/status', [StatusController::class, 'index'])->name('service.status.index');
        Route::post('service/order_status', [StatusController::class, 'getOrderStatusList'])->name('service.status.list');
        Route::get('services/create/', [ServicesController::class, 'create'])->name('service.create');
        Route::post('/service/store', [ServicesController::class, 'store'])->name('service.store');
        Route::get('services/money_receipt/{service_id}/{receive_payment_id}', [ServicesController::class, 'moneyReceipt'])->name('service.money_receipt');
        Route::get('services/edit/{id}', [ServicesController::class, 'edit'])->name('service.edit');
        

        //Route::resource('all_shipment', ShipmentController::class);
        Route::get('all_shipment/{shipment_for}', [ShipmentController::class, 'index'])->name('all_shipment_index');

        Route::post('shipment', [OrderShipmentController::class, 'store'])->name('shipment.store');
        Route::post('shipmentForOrder', [OrderShipmentController::class, 'storeForOrder'])->name('shipment.storeForOrder');
        Route::post('shipmentUpdateForOrder', [OrderShipmentController::class, 'shipmentUpdateForOrder'])->name('shipment.shipmentUpdateForOrder');
        Route::post('shipment/update', [OrderShipmentController::class, 'update'])->name('shipment.update');
        Route::post('shipment/delete', [OrderShipmentController::class, 'destroy'])->name('shipment.destroy');
       
       

        //WOO Shipments
        Route::get('shipment/woo-shipments', [ShipmentController::class, 'wooShipments'])->name('shipment.woo-shipments');
        Route::get('all_woo_shipment_list/list', [ShipmentController::class, 'dataWooShipments'])->name('all_woo_shipment_list');
        Route::get('getWOOCustomerOrderHistory', [ShipmentController::class, 'getWOOCustomerOrderHistory']);

        // Custom Order
        Route::get('custom-order/datatable', [ CustomOrderController::class, 'dataTable' ])->name('custom-order.datatable');
        Route::post('custom-order/update', [CustomOrderController::class, 'update'])->name('custom-order.update');
        Route::post('custom-order/delete', [CustomOrderController::class, 'destroy'])->name('custom-order.destroy');
        Route::resource('custom-order', CustomOrderController::class)->except([ 'show', 'update', 'destroy' ]);

        //   Route::get('students/list', [StudentController::class, 'getStudents'])->name('students.list');
        // Route::get('students', [StudentController::class, 'index']);
        // Route::get('students/list', [StudentController::class, 'getStudents'])->name('students.list');


        Route::get('check_customer_phone', [OrderManageController::class,'check_customer_phone']);
        Route::get('order_management-show/get_ordered_products', [OrderManageController::class, 'getOrderedProducts'])->name('get_ordered_products');
        Route::get('order_management-show/get_services_items', [OrderManageController::class, 'getServicesItems'])->name('get_services_items');
        Route::get('order_management-show/get_service_address', [OrderManageController::class, 'getShippingAddress'])->name('get_service_address');

    //Forms
    Route::get('form/list', [FormsController::class, 'data'])->name('formsList');
    Route::get('forms/owner-particulars/{order_id}', [FormsController::class, 'ownerPerticulars'])->name('forms.owner-particulars');
    Route::post('/pdfPrintOwnerParticulars', [FormsController::class, 'pdfPrintOwnerParticulars'])->name('pdfPrintOwnerParticulars');
    Route::get('forms/fees-detail/{order_id}', [FormsController::class, 'feesDetailBRTA'])->name('forms.fees-detail');
    Route::post('/pdfDeliveryChallan', [FormsController::class, 'pdfDeliveryChallan'])->name('pdfDeliveryChallan');

    Route::get('forms/appication-for-registration/{order_id}', [FormsController::class, 'applicationForRegistration'])->name('forms.appication-for-registration');

    Route::get('forms/delivery-challan/{order_id}', [FormsController::class, 'deliveryChallan'])->name('forms.delivery-challan');
    Route::post('/pdfFeesDetailBRTA', [FormsController::class, 'pdfFeesDetailBRTA'])->name('pdfFeesDetailBRTA');

    
    
    Route::get('forms/{customerType?}', [FormsController::class, 'index'])->name('forms.index');
    
    Route::get('forms/{order_id}-{shipment_id}/shipment-label', [ShipmentLabelController::class, 'printShipmentPdf'])->name('shipment-label.pdf');

    Route::resource('forms', FormsController::class)->except([ 'index', 'show', 'update', 'create' ]);
    Route::get('forms/quotation/pdf/{order_id}', [QuotationController::class, 'printPdf'])->name('order_manage.quotation.pdf');
    Route::get('forms/invoice/pdf/{order_id}', [InvoiceController::class, 'printPdf'])->name('order_manage.invoice.pdf');

        //Feature
        Route::get('features', [FeatureController::class, 'index'])->name('features');
        Route::get('/features/data', [FeatureController::class, 'data'])->name('features.data');
        Route::get('/features/create', [FeatureController::class, 'create'])->name('feature.create');
        Route::post('/features/store', [FeatureController::class, 'store'])->name('feature.store');
        Route::post('/features/update',[ FeatureController::class,'update'])->name('feature.update');
        Route::post('/features/delete', [FeatureController::class, 'delete'])->name('feature.delete');    

            
        //Size
        Route::get('sizes', [SizeController::class, 'index'])->name('sizes');
        Route::get('/sizes/data', [SizeController::class, 'data'])->name('sizes.data');
        Route::get('/sizes/create', [SizeController::class, 'create'])->name('size.create');
        Route::post('/sizes/store', [SizeController::class, 'store'])->name('size.store');
        Route::post('/sizes/update',[ SizeController::class,'update'])->name('size.update');
        Route::post('/sizes/delete', [SizeController::class, 'delete'])->name('size.delete');    


        //Model
        Route::get('models', [ModelNameController::class, 'index'])->name('models');
        Route::get('/models/data', [ModelNameController::class, 'data'])->name('models.data');
        Route::get('/models/create', [ModelNameController::class, 'create'])->name('model.create');
        Route::post('/models/store', [ModelNameController::class, 'store'])->name('model.store');
        Route::post('/models/update',[ ModelNameController::class,'update'])->name('model.update');
        Route::post('/models/delete', [ModelNameController::class, 'delete'])->name('model.delete');    
          
        //categories
        Route::resource('banks_or_mobiles', BankOrMobileController::class)->except([ 'create', 'show', 'edit', 'update', 'destroy' ]);
        Route::POST('bank_or_mobile_update/{id}',[ BankOrMobileController::class,'updateBankOrMobile']);
        Route::GET('bank_or_mobile-delete/{id}', [BankOrMobileController::class, 'delete'])->name('delete bank_or_mobile');
        // Route::POST('post-sortable',[ BankOrMobileController::class,'reOrder']);
        Route::post('/banks_or_mobiles/store', [BankOrMobileController::class, 'store'])->name('store bank_or_mobile');
        Route::post('/bank_or_mobile_account/store', [BankOrMobileController::class, 'storeAccount'])->name('store bank_or_mobile_account');

        Route::get('/account/edit', [BankOrMobileController::class, 'editAccount'])->name('edit account');
        Route::POST('/account/update',[ BankOrMobileController::class,'updateAccount'])->name('update account');
        Route::GET('account-delete/{id}', [BankOrMobileController::class, 'deleteAccount'])->name('delete account');

        Route::POST('/load-bank-or-mobile',[ BankOrMobileController::class,'loadBankOrMobileDropdown'])->name('load-bank-or-mobile-dropdown');
        Route::POST('/load-bank-or-mobile-account',[ BankOrMobileController::class,'loadBankOrMobileAccountDropdown'])->name('load-bank-or-mobile-account-dropdown');


        //categories
        Route::resource('categories', CategoryController::class)->except([ 'create', 'show', 'edit', 'update', 'destroy' ]);
        Route::get('categories/select', [CategorySelectController::class, 'index'])->name('categories.select');
        Route::get('categories-parent/select', [ParentOnlySelectController::class, 'index'])->name('categories-parent.select');
        Route::get('product_list/select', [ParentOnlySelectController::class, 'getProducts'])->name('product_list.select');


        Route::POST('categories_update/{id}',[ CategoryController::class,'updateCategory']);
        Route::get('/categories-delete/{id}', [CategoryController::class, 'delete']);
        Route::POST('post-sortable',[ CategoryController::class,'reOrder']);
        Route::POST('/categories/update_sub_categories',[ CategoryController::class,'updateSubCategory'])->name('update sub category');
        //sub categories
        Route::get('sub_categories', [SubCategoryController::class, 'index'])->name('sub_categories');
        // Route::resource('/sub_categories', SubCategoryController::class);
        Route::get('/sub_categories/data', [SubCategoryController::class, 'data'])->name('data sub category');
        Route::post('/sub_categories/store', [SubCategoryController::class, 'store'])->name('store sub category');
        // Route::POST('/sub_categories/update',[ SubCategoryController::class,'updateCategory'])->name('update sub category');
        Route::post('/sub_categories/delete', [SubCategoryController::class, 'delete'])->name('delete sub category');

        Route::get('categories/get-all-sub-categories', [CategoryController::class, 'getAllSubCategories'])->name('get all sub categories');
        Route::post('categories/fetch-sub-categories', [CategoryController::class, 'fetchSubCategory'])->name('fetch sub categories');


 
        //shop
        Route::get('shops', [ShopController::class, 'index'])->name('shops');
        Route::get('/shops/data', [ShopController::class, 'data'])->name('shops.data');
        Route::get('/shops/create', [ShopController::class, 'create'])->name('shop.create');
        Route::post('/shops/store', [ShopController::class, 'store'])->name('shop.store');
        Route::post('/shops/update',[ ShopController::class,'update'])->name('shop.update');
        Route::post('/shops/delete', [ShopController::class, 'delete'])->name('shop.delete');

        Route::get('shops/select', [ ShopSelectController::class, 'index' ])->name('shop.select');

        //channels
        Route::resource('channels', ChannelController::class);
        Route::post('channels-update/{id}',[ChannelController::class,'update']);
        Route::get('channels-delete/{id}', [ChannelController::class, 'delete']);

        //exchange-rates
        Route::resource('exchange-rates', ExchangeRateController::class);
        Route::post('exchange-rates-update/{id}',[ExchangeRateController::class,'update']);
        Route::get('exchange-rates-delete/{id}', [ExchangeRateController::class, 'delete']);


        //shiptypes
        Route::resource('ship-types', ShipTypeController::class);
        Route::post('ship-types-update/{id}',[ShipTypeController::class,'update']);
        Route::get('ship-types-delete/{id}', [ShipTypeController::class, 'delete']);


        //product tags
        Route::resource('product-tags', ProductTagController::class);
        Route::post('product-tags-update/{id}',[ProductTagController::class,'update']);
        Route::get('product-tags-delete/{id}', [ProductTagController::class, 'delete']);


 

        // PO Shipment Datatable and actions From PO Shimpent page >> Page URL : ../po_shipments
        Route::group(['prefix' => 'po_shipments'], function () {
            Route::get('/', [PoShipmentController::class, 'shipments'])->name('po_shipments');
            Route::get('/single_edit_form', [PoShipmentController::class, 'SinglePOEditForm'])->name('single edit po_shipment form');
            Route::get('/data', [PoShipmentController::class, 'listData'])->name('data_po_shipments');
            Route::get('/edit_form', [PoShipmentController::class, 'LoadPOShipmentEditForm'])->name('edit shipment form');
            Route::post('/update_po_shipment', [PoShipmentController::class, 'updatePoShipment'])->name('update po_shipment');
            Route::post('/delete', [PoShipmentController::class, 'PoShipmentDelete'])->name('delete po_shipment');
        });


        //product cost price
        Route::group(['prefix' => 'product_cost'], function () {
            Route::get('/', [ProductCostController::class, 'productCost'])->name('product_cost');
            Route::get('/data', [ProductCostController::class, 'listData'])->name('data_product_cost');
            Route::get('/create', [ProductCostController::class, 'createProductCost'])->name('create product cost');
            Route::post('/store', [ProductCostController::class, 'storeProductCost'])->name('store product cost');
            Route::get('/product-cost-markup-profit-calculation', [ProductCostController::class, 'markUpLowestSellPriceAndProfitCalculation'])->name('product_cost_markup_profit_calculation');
            Route::get('/update_form', [ProductCostController::class, 'updateForm'])->name('update cost form');
            Route::post('/update_product_cost', [ProductCostController::class, 'updateProductCost'])->name('update product lowest cost');
            Route::get('/show_reoder_form', [ProductCostController::class, 'showReOrderForm'])->name('show product reorder form');
            Route::post('/update_reoder_data', [ProductCostController::class, 'updateReOrderData'])->name('update product reorder data');
        });

        Route::group(['prefix' => 'order_analysis'], function () {
            Route::get('/', [OrderAnalysisController::class, 'orderAnalysis'])->name('order_analysis');
            Route::get('/datatable', [OrderAnalysisController::class, 'loadOrderAnalysisDataTable'])->name('datatable_order_analysis');
            Route::get('/update_form', [PurchaseOrderController::class, 'updateForm'])->name('update form');
            Route::post('/update_reorder_stock', [PurchaseOrderController::class, 'updateReorderStock'])->name('update reorder stock');

        });


        // Cost Analysis Page >>URL : .../cost_analysis
        Route::group(['prefix' => 'cost_analysis'], function () {
            Route::get('/', [ProductCostController::class, 'productCostAnalysis'])->name('cost_analysis');
            Route::get('/data', [ProductCostController::class, 'datatableCostAnalysis'])->name('datatable product cost analysis');
            Route::post('/update', [ProductCostController::class, 'changeProductCostPrice'])->name('update product cost');
        });

        Route::get('po_product_analysis', [PurchaseOrderController::class, 'POProductAnalysisData'])->name('data_product_analysis');
        Route::get('export order analysis', [PurchaseOrderController::class, 'ExportOrderAnalysis'])->name('export order analysis');

        Route::get('po_settings', [PurchaseOrderController::class, 'poSettings'])->name('po_settings');
        Route::post('domestic_shipper', [PurchaseOrderController::class, 'domesticShipper'])->name('domestic_shipper');
        Route::get('/get_qr_code', [QrCodeController::class, 'get_qr_code']);


         //domestic_shippers
         Route::resource('domestic_shippers', DomesticShipperController::class);
         Route::post('domestic_shippers-update/{id}',[DomesticShipperController::class,'update']);
         Route::get('domestic_shippers-delete/{id}', [DomesticShipperController::class, 'delete']);


        //manage service
        Route::get('manage-shipper', [ShipperController::class, 'index'])->name('manage shipper');
        Route::get('shipper/data', [ShipperController::class, 'data'])->name('data shipper');
        Route::post('shipper/insert', [ShipperController::class, 'insert'])->name('insert shipper');
        Route::post('shipper/update', [ShipperController::class, 'update'])->name('update shipper');
        Route::post('shipper/delete', [ShipperController::class, 'delete'])->name('delete shipper');

        Route::get('shipper/service-cost', [ ShippingCostWeightController::class, 'show' ])->name('shipper.service-cost.weight');

        //service cost
        Route::get('add-cost/{id}', [ShippingCostController::class, 'index'])->name('add-service-cost');
        Route::resource('service-cost', ShippingCostController::class)->except([ 'index', 'create', 'show', 'update', 'destroy' ]);
        Route::POST('service-cost_update/{id}',[ ShippingCostController::class,'updateShippingCost']);
        Route::get('/service-cost-delete/{id}', [ShippingCostController::class, 'delete']);
        Route::get('/service-cost-edit/{id}/{shipper_id}', [ShippingCostController::class, 'serviceCostEdit']);

        Route::get('initial-transaction', [ReportController::class, 'initialTransaction'])->name('initial-transaction');
         
        
        // daily summary report
        Route::get('/report-pettycash', [ReportController::class, 'pettycash'])->name('report-pettycash');    
        Route::post('/pettycash-data', [ReportController::class, 'ajaxPettyCash'])->name('ajax-pettycash');


        // daily summary report
        Route::get('/report-summary', [ReportController::class, 'summary'])->name('report-summary'); 
        Route::post('sales_list', [ReportController::class, 'salesData'])->name('sales_list');       
        Route::post('/summary-data', [ReportController::class, 'ajaxSummary'])->name('ajax-summary');

        Route::get('report/profit-loss', [ReportController::class, 'partnerProfit'])->name('report-profit-loss');
        
        // daily sales report
        Route::get('/report-sales', [ReportController::class, 'sales'])->name('report-sales');
        Route::post('/sales-report-data', [ReportController::class, 'ajaxSales'])->name('ajax-sales');

        // customer report
        Route::get('/report-customer', [ReportController::class, 'customerReport'])->name('report-customer');
        Route::get('sales_table', [ReportController::class, 'salesReport'])->name('sales_table');
        Route::post('/customer-summary', [ReportController::class, 'ajaxCustomerSummary'])->name('customer-summary');

        // coupon report
        Route::get('/report-coupon', [ReportController::class, 'couponReport'])->name('report-coupon');
        Route::get('coupon_table', [ReportController::class, 'couponTable'])->name('coupon_table');
        Route::get('receive_payments_coupon', [ReportController::class, 'couponPayments'])->name('receive_payments_coupon');
        Route::post('/coupon-summary', [ReportController::class, 'ajaxCouponSummary'])->name('coupon-summary');


        // supplier report
        Route::get('/report-supplier', [ReportController::class, 'supplierReport'])->name('report-supplier');
        Route::post('/supplier-summary', [ReportController::class, 'ajaxSupplierSummary'])->name('supplier-summary');

        // Loan report
        Route::get('/report-loan', [ReportController::class, 'loanReport'])->name('report-loan');
        Route::get('loans_table', [ReportController::class, 'LoanTable'])->name('loans_table');
        Route::post('/lender-summary', [ReportController::class, 'ajaxLenderSummary'])->name('lender-summary');


         // salary report
        Route::get('/report-salary', [ReportController::class, 'salaryReport'])->name('report-salary');
        Route::post('/salary-summary', [ReportController::class, 'ajaxSalarySummary'])->name('salary-summary');

         // expense report
         Route::get('/report-expense', [ReportController::class, 'expenseReport'])->name('report-expense');
         Route::post('/expense-summary', [ReportController::class, 'ajaxExpenseSummary'])->name('expense-summary');
 

        // bank statement report
        Route::get('/report-bank-statement', [ReportController::class, 'bankStatementReport'])->name('report-bank-statement');
        Route::post('/bank-statement-summary', [ReportController::class, 'ajaxBankStatementSummary'])->name('bank-statement-summary');
       

        // customer report
        Route::get('/report-stocks', [ReportController::class, 'mainStockReport'])->name('report-stocks');
        Route::get('sale-details-list', [ReportController::class, 'saleDetailsData'])->name('sale-details-list');
        Route::get('purchase-details-list', [ReportController::class, 'purchaseDetailsData'])->name('purchase-details-list');
        
        Route::post('/stock-summary', [ReportController::class, 'ajaxStockSummary'])->name('stock-summary');



        //report
        Route::get('/report-stock', [ReportController::class, 'report'])->name('product_report');
        Route::get('/report/data', [ReportController::class, 'reportData'])->name('data_product_report');
        // Route::post('filter_product_report', [ReportController::class, 'filterReport'])->name('filter_report');

        Route::get('/report-stock-movements', [ReportController::class, 'stockReport'])->name('stock_movement_report');
        Route::get('/report-stock-movements/data', [ReportController::class, 'stockReportData'])->name('data_stock_movement_report');

        Route::get('activity-log', [ReportController::class, 'activityLog'])->name('activity_log');
        Route::get('/activity-log/data', [ReportController::class, 'dataActivityLog'])->name('activity_log.data');
        Route::post('/undo-activity-log', [ReportController::class, 'undoActivityLog'])->name('activity_log.undo');

        // Location controll
        Route::get('/districts', [LocationController::class,'getDistricts']);
        Route::get('/thana/{districtName}', [LocationController::class,'getThanas']);
        Route::get('/post-offices/{thanaName}', [LocationController::class,'getPostOffices']);        
        Route::get('/postal-code/{postofficeName}', [LocationController::class,'getPostalCodes']);
        //Route::get('/postal-codes/{districtName}', 'LocationController@getPostalCodes');

        // customers
        // Route::get('customer', [CustomerController::class, 'index'])->name('customer');
        // Route::get('/customers', [CustomerController::class,'getCustomers']);
        // Route::get('customer/data', [CustomerController::class, 'data'])->name('customer.data');
        // Route::post('customer/store', [CustomerController::class, 'store'])->name('customer.store');
        // Route::post('customer/update', [CustomerController::class, 'update'])->name('customer.update');
        // Route::post('customer/delete', [CustomerController::class, 'delete'])->name('customer.delete');
        // Route::get('customer/orders/datatable', [CustomerController::class, 'orderListData'])->name('customer.order_datatable');
        // Route::get('customer/orders/{id}', [CustomerController::class, 'orderList'])->name('customer.order_list');
        // Route::get('customer/custom-orders/datatable', [CustomerController::class, 'customOrderListData'])->name('customer.custom_order_datatable');
        // Route::get('customer/custom-orders/{id}', [CustomerController::class, 'customOrderList'])->name('customer.custom_order_list');



        // Drop shippers
        Route::get('manage-dropshippers', [DropshipperController::class, 'index'])->name('dropshippers');
        Route::get('dropshippers/data', [DropshipperController::class, 'data'])->name('dropshipper.data');
        Route::get('dropshippers/create', [DropshipperController::class, 'create'])->name('dropshipper.create');
        Route::post('dropshippers/store', [DropshipperController::class, 'store'])->name('dropshipper.store');
        Route::post('dropshippers/update', [DropshipperController::class, 'update'])->name('dropshipper.update');
        Route::post('dropshippers/delete', [DropshipperController::class, 'delete'])->name('dropshipper.delete');

        // Dropshippers Roles and Permissions
        Route::get('dropshipper/roles', [DropshipperController::class, 'dropshipperRole'])->name('dropshipper.role');
        Route::get('dropshipper/roles/data', [DropshipperController::class, 'dropshipperData'])->name('dropshipper.role_data');

        Route::get('dropshipper/roles/permissions/datatable', [DropshipperController::class, 'dataDropshipperPermissionByRole'])->name('dropshipper.assign_permission.role_datatable');
        Route::get('dropshipper/roles/permissions/{id}', [DropshipperController::class, 'dropshipperPermissionByRole'])->name('dropshipper.assign_permission.role');
        Route::post('dropshipper/roles/save-assign', [DropshipperController::class, 'dropshipperAssignPermissionByRole'])->name('dropshipper.assign_permission.role_save');

        Route::get('dropshippers/permissions/datatable', [DropshipperController::class, 'dataDropshipperPermissionByUser'])->name('dropshipper.assign_permission.user_datatable');
        Route::get('dropshippers/permissions/{id}', [DropshipperController::class, 'dropshipperPermissionByUser'])->name('dropshipper.assign_permission.user');
        Route::post('dropshippers/save-assign', [DropshipperController::class, 'dropshipperAssignPermissionByUser'])->name('dropshipper.assign_permission.user_save');

        Route::get('dropshipper/orders', [DropshipperController::class, 'dropshipperOrders'])->name('dropshipper.orders');
        Route::get('dropshipper/orders/data', [DropshipperController::class, 'dropshipperOrdersData'])->name('dropshipper.orders_datatable');


        Route::get('customer-phone', [ CustomerPhoneController::class, 'show' ])->name('customer-phone.show');

        Route::get('tax-rate-settings', [TaxRateSettingController::class, 'index'])->name('tax-rate-settings.index');
        Route::post('tax-rate-settings/update', [TaxRateSettingController::class, 'update'])->name('tax-rate-settings.update');
        Route::get('company-info-settings', [CompanyInfoSettingController::class, 'index'])->name('company-info-settings.index');
        Route::post('company-info-settings/update', [CompanyInfoSettingController::class, 'update'])->name('company-info-settings.update');

        Route::get('tax-invoice', [TaxInvoiceController::class, 'index'])->name('tax-invoice.index');
        Route::get('tax-invoice/datatable', [TaxInvoiceController::class, 'dataTable'])->name('tax-invoice.datatable');
        Route::get('tax-invoice/pdf/{order_id}', [TaxInvoiceController::class, 'generatePdfInvoice'])->name('tax-invoice.pdf-invoice');
//});

    Route::group(['prefix' => 'admin'], function () {
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('admin dashboard');
        Route::get('manage-seller', [AdminController::class, 'manageSeller'])->name('manage seller');
        Route::get('seller/data', [AdminController::class, 'data'])->name('data seller');
        Route::post('seller/insert', [AdminController::class, 'insert'])->name('insert seller');
        Route::post('seller/update', [AdminController::class, 'update'])->name('update seller');
        Route::post('seller/delete', [AdminController::class, 'delete'])->name('delete seller');

        Route::get('/user-logo', [AdminController::class, 'userLogo'])->name('user logo');
        Route::post('/user-logo-update', [AdminController::class, 'uploadUserLogo'])->name('upload user logo');
         //package
         Route::get('/package', [SellerController::class, 'package'])->name('package');
         Route::get('/package/data', [SellerController::class, 'data'])->name('data package');
         Route::post('/package/insert', [SellerController::class, 'insert'])->name('insert package');
         Route::post('/package/update', [SellerController::class, 'update'])->name('update package');
         Route::post('/package/delete', [SellerController::class, 'delete'])->name('delete package');
         //trackinglog
         Route::get('seller/tracking-log/{id}', [AdminController::class, 'trackingLog'])->name('seller tracking log');

        Route::get('translation', [TranslationController::class, 'index'])->name('translation.index');
        Route::post('translation/store', [TranslationController::class, 'store'])->name('translation.store');
        Route::post('translation/update', [TranslationController::class, 'update'])->name('translation.update');
        Route::post('translation/delete', [TranslationController::class, 'delete'])->name('translation.delete');
        Route::get('translation/datatable', [ TranslationController::class, 'dataTable' ])->name('translation.datatable');
        Route::get('translation/show/{id}', [TranslationController::class, 'show'])->name('translation.show');

        Route::get('scan-translation-job', [ScanTranslationJobController::class, 'index'])->name('scan-translation-job.index');
    });

    //gerereate qr code
    Route::get('/generate-qr-code', [QrCodeController::class, 'generateQrCode'])->name('generate qr code');

    Route::get('/view-qr-code/{id}', [QrCodeController::class, 'viewQrCode'])->name('view qr code');
    Route::post('/add-product-code', [QrCodeController::class, 'addProductChassis'])->name('add part_name');
    Route::post('/generate_qr_code_pdf', [QrCodeController::class, 'generateQrCodePdf'])->name('print qr code');

    Route::get('/in-out', [QrCodeController::class, 'inOutWithQrCode'])->name('inout qr code');
    Route::get('/in-out/history', [QrCodeController::class, 'inOutHistory'])->name('in-out-history');
    Route::get('/in-out/history/{id}', [QrCodeController::class, 'inOutHistoryDetail'])->name('in-out-history-detail');
    Route::get('/in-out/datatable', [QrCodeController::class, 'inOutDataTable'])->name('in-out-datatable');
    Route::post('/in-out/history/update', [QrCodeController::class, 'inOutHistoryUpdate'])->name('in-out-history-update');
    Route::post('/in-out/history/delete', [QrCodeController::class, 'inOutHistoryDelete'])->name('in-out-history-delete');

    Route::get('/get-qr-code-raw-material', [QrCodeController::class, 'getRawMaterial'])->name('get_qr_code_raw_material');
    Route::get('/get-qr-code-product', [QrCodeController::class, 'getQrCodeProduct'])->name('get_qr_code_product');
    Route::get('/get-qr-code-productget-order-purchase', [QrCodeController::class, 'getQrCodeProductForOrderPurchase'])->name('get_qr_code_product_order_purchase');

    Route::get('/get-qr-code-productget-order_managment', [QrCodeController::class, 'getQrCodeProductForOrderManagment'])->name('get_qr_code_product_order_managment');
    Route::get('/reset-qr-code-product', [QrCodeController::class, 'resetQrCodeProduct'])->name('reset_session_product');
    Route::get('/delete-session-product', [QrCodeController::class, 'deleteSessionProduct'])->name('delete_session_product');
    Route::get('/delete-session-product2', [QrCodeController::class, 'deleteSessionProduct2'])->name('delete_session_product2');
    Route::post('/submit-input', [QrCodeController::class, 'updateInOut'])->name('submit input');
    Route::post('/autocomplete/getAutocomplete/',[QrCodeController::class, 'getAutocomplete'])->name('Autocomplte.getAutocomplte');

    // Defect stocks
    Route::get('/defect-stock', [DefectStockController::class, 'index'])->name('defect-stock');
    Route::get('/defect-stock/data', [DefectStockController::class, 'data'])->name('defect_stock.data');
    Route::get('/defect-stock/show', [DefectStockController::class, 'show'])->name('defect_stock.show');
    Route::get('/defect-stock/show-result', [DefectStockController::class, 'showResult'])->name('defect_stock.show_result');
    Route::get('/defect-stock/create', [DefectStockController::class, 'create'])->name('defect_stock.create');
    Route::get('/get-qr-code-for-defect-stocks', [DefectStockController::class, 'getQrCodeProductForDefectStock'])->name('get-qr-code-for-defect-stocks');
    Route::post('/defect-stock/autocomplete',[DefectStockController::class, 'defectStockAutocomplete'])->name('defect_stock.autocomplete');
    Route::post('/defect-stock/store', [DefectStockController::class, 'store'])->name('defect_stock.store');
    Route::post('/defect-stock/update', [DefectStockController::class, 'update'])->name('defect_stock.update');
    Route::post('/defect-stock/delete', [DefectStockController::class, 'defectStockDelete'])->name('defect_stock.delete');
    Route::get('/reset-qr-code-defect-product', [DefectStockController::class, 'resetQrCodeDefectProduct'])->name('reset_session_defect_product');
    Route::get('/delete-session-defect-product', [DefectStockController::class, 'deleteSessionDefectProduct'])->name('delete_session_defect_product');
    Route::post('/defect-stock/update-gallery', [DefectStockController::class, 'addGallery'])->name('update gallery');

    Route::post('address_autocomplete',[OrderManageController::class, 'address_autocomplete'])->name('address_autocomplete');

    Route::get('/your_packages', [AccountController::class, 'yourPackages'])->name('your_packages');
    Route::get('/profile', [AccountController::class, 'profile'])->name('profile');
    Route::post('/profile-update', [AccountController::class, 'profileUpdate']);
    Route::post('/change-password', [AccountController::class, 'changePassword'])->name('change_password');

    Route::post('change-language', [LanguageController::class, 'update'])->name('user.change-language');   
});


Route::get('verify_mobile', [OptController::class, 'verifyMobile'])->name('verify_mobile');
Route::post('/get-otp', [OptController::class, 'getOtp'])->name('get-otp');
Route::post('/reset-pass', [OptController::class, 'resetpass'])->name('reset-pass');
Route::post('/get-phone', [OptController::class, 'getPhone'])->name('get-phone');
Route::get('/forget_password', [OptController::class, 'forgetPassword'])->name('forget-password');
Route::get('/reset_password', [OptController::class, 'resetPassword'])->name('reset-password');

//order_mangment_buyer_pages
Route::get('order_status/{order_id}', [BuyerPageController::class, 'orderStatus'])->name('order-status');
Route::get('payment-order-notify/{order_id}', [BuyerPageController::class, 'paymentOrderNotify'])->name('payment-order-notify');

Route::get('sales_management_customer/{order_id}', [BuyerPageController::class, 'edit'])->name('order-management.public-url');
Route::post('sales_management_customer/{order_id}', [BuyerPageController::class, 'update'])->name('order-management.buyer.place-order');


Route::post('changePaymentMethod', [BuyerPageController::class, 'changePaymentMethod']);

Route::post('buyer-page/service-address/check-address', [ShippingAddressController::class, 'checkShippingAddress'])->name('buyer-page.service-address.check-address');
Route::post('buyer-page/service-method/update/{order_id}', [ShippingMethodController::class, 'update'])->name('buyer-page.service-method.update');
Route::post('buyer-page/service-address/update/{order_id}', [ShippingAddressController::class, 'update'])->name('buyer-page.service-address.update');
Route::post('buyer-page/bank-transfer-confirm/{order_id}', [BankTransferConfirmController::class, 'store'])->name('buyer-page.bank-transfer-confirm.store');
Route::post('buyer-page/cancel-order/{order_id}', [CancelOrderController::class, 'store'])->name('buyer-page.cancel-order');

Route::get('buyer-page/select-province', SelectProvinceController::class)->name('buyer-page.select-province');
Route::get('buyer-page/select-district', SelectDistrictController::class)->name('buyer-page.select-district');
Route::get('buyer-page/select-sub-district', SelectSubDistrictController::class)->name('buyer-page.select-sub-district');
Route::get('buyer-page/select-post-code', SelectPostCodeController::class)->name('buyer-page.select-post-code');

Route::get('payment_success_notify', [OrderManageController::class, 'paymentSuccessNotify']);

Route::get('get_all_service_methods', [OrderManageController::class, 'get_all_service_methods']);
Route::get('getOrderHistory', [OrderManageController::class, 'getOrderHistory']);

//Line WebHook
Route::post('line/webhook', [LineController::class, 'triggeredPayload'])->name('line.webhook.payload');
Route::post('line/webhook/ac-sale-notify', [LineController::class, 'triggeredPayloadACSale'])->name('line.webhook.payload.ac');

Route::post('/make_order_payment', [OrderManageController::class, 'makeOrderPayment'])->name('make_order_payment');

Route::get('isPaymentSuccess', [OrderManageController::class, 'isPaymentSuccess']);
require __DIR__ . '/auth.php';

// All Route area start For Shipments
Route::get('getCustomerOrderHistory', [ShipmentController::class, 'getCustomerOrderHistory']);

Route::get('getOrderPaymentDetails', [OrderManageController::class, 'getOrderPaymentDetails']);


Route::post('/printLevelPrint', [ShipmentController::class, 'printLevelPrint'])->name('printLevelPrint');
Route::post('/printLevelBulk', [ShipmentController::class, 'printLevelBulk'])->name('printLevelBulk');
Route::post('/orderPrintLabelBulk', [ShipmentController::class, 'orderPrintLabelBulk'])->name('orderPrintLabelBulk');

Route::get('getCustomerOrderHistoryForPack', [ShipmentController::class, 'getCustomerOrderHistoryForPack']);


Route::post('storeForCustomShipment', [OrderShipmentController::class, 'storeForCustomShipment'])->name('shipment.storeForCustomShipment');

Route::post('updateForCustomShipment', [OrderShipmentController::class, 'updateForCustomShipment'])->name('shipment.updateForCustomShipment');



//payment_method
Route::resource('payment_methods', PaymentMethodController::class);
Route::get('load_payment_methods', [PaymentMethodController::class, 'payment_methods'])->name('load_payment_methods');

//salaries
Route::resource('salaries', SalariesController::class);
Route::get('salaries_list', [SalariesController::class, 'data'])->name('salaries_list');
Route::get('salary/edit/{id}', [SalariesController::class, 'edit'])->name('salary.edit');
Route::post('/salary/delete', [SalariesController::class, 'paymentDelete'])->name('delete salary');



//My Banking
Route::resource('my_banking', MyBankingController::class);
Route::get('my_banking_list', [MyBankingController::class, 'data'])->name('my_banking_list');


 //WC Controller

Route::get('testing', function(){
    $url_record = "https://kradat.com/wp-json/wc/v3/products?consumer_key=ck_fca8f74ec29481d888cce350dcef5a63655e3167&consumer_secret=cs_3c52aa520805aec356b2b4bfcb17801515c591fa&pagination_type=page&page=1&limit=200&per_page=100";
    $response = Illuminate\Support\Facades\Http::get($url_record);
    $response = json_decode($response);
    print_r(($response[0]->id));
});

 //oder purchase
Route::get('/cron-report', [CronReportController::class,"index"])->name('cronReport');

 //WC Stocks
 Route::get('/wc_stocks/getVariationByID', [InventoryController::class, 'getVariationByID'])->name('data get_inventories_variations_by_id');
 Route::post('/wc_stocks/addToInventory', [InventoryController::class, 'addToInventory'])->name('data add_to_inventory');
  Route::post('/wc_stocks/addProductBySKU', [InventoryController::class, 'addProductBySKU'])->name('data add_product_by_sku');
 Route::any('/wc_stocks/searchProductBySKU', [InventoryController::class, 'searchProductBySKU'])->name('autocomplete.fetch');
 Route::any('/wc_stocks/autocomplete_inventrory', [InventoryController::class, 'autocompleteInventrory'])->name('autocomplete.inventrory');
 Route::get('/wc_stocks/getLinkedProductBySKU', [InventoryController::class, 'getLinkedProductBySKU'])->name('data inventory products');
 Route::get('/wc_stocks/editProductForm', [InventoryController::class, 'editStockForm'])->name('data stock_edit_form');
 Route::get('/wc_stocks/data', [InventoryController::class, 'data'])->name('data stock');
 Route::resource('wc_stocks', InventoryController::class);
 Route::get('create-inventory', [InventoryController::class,"createInventory"])->name('createInventory');
 Route::get('edit-inventory', [InventoryController::class,"editInventory"])->name('editInventory');
 Route::get('inventory-to-product', [InventoryController::class,"inventoryToProduct"])->name('inventoryToProduct');
 Route::get('inventories', [InventoryController::class,"inventories"])->name('inventories');
 Route::get('inventories_product', [InventoryController::class,"inventoryProduct"])->name('inventoryProduct');
 Route::post('inventories_delete', [InventoryController::class,"inventoriesDelete"])->name('inventoriesDelete');
 Route::post('inventories_product_delete', [InventoryController::class,"inventoryProductDelete"])->name('inventoryProductDelete');
 Route::post('inventories_product_add', [InventoryController::class,"inventoryProductAdd"])->name('inventoryProductAdd');
 Route::get('SyncProduct', [InventoryController::class,"SyncProduct"])->name('SyncProduct');
 Route::get('SyncAllInv', [InventoryController::class,"SyncAllInv"])->name('SyncAllInv');


Route::get('test', [ShipmentController::class,"testCheck"])->name('testCheck');



// Facebook
Route::group(['prefix' => 'facebook'], function () {
    Route::get('/', [FacebookController::class, 'index'])->name('facebook.index');
    Route::get('oauth/authorization', [FacebookController::class, 'facebookAuthorization'])->name('facebook.auth');
    Route::get('oauth/redirect', [FacebookController::class, 'authRedirect'])->name('facebook.auth.redirect');
    Route::get('page/list', [FacebookController::class, 'facebookPageList'])->name('facebook.page.list');
    Route::get('page/edit', [FacebookController::class, 'facebookPageEdit'])->name('facebook.page.edit');
    Route::post('page/delete/{id}', [FacebookController::class, 'facebookPageDelete'])->name('facebook.page.delete');
    Route::post('page/autoreply', [FacebookController::class, 'facebookAutoReplyCampaign'])->name('facebook.autoreply.campaign');

    Route::get('page/subscription', [FacebookController::class,'facebookPageSubscribers']);
});

Route::group(['prefix' => 'dodochat'], function() {
    Route::get('new/app', [SettingController::class, 'DoDoChatApp'])->name('dodochat.app');
    Route::get('activity', [SettingController::class, 'dodochat_users_activity'])->name('dodochat.log');
});

Route::get('checkIfExistsShipmentId', [ShipmentController::class, 'checkIfExistsShipmentId']);

Route::get('shipmentPickOrderCancel', [ShipmentController::class, 'shipmentPickOrderCancel']);
Route::get('shipment_status_update', [ShipmentController::class, 'shipmentStatusUpdate']);
Route::get('after_search_modal_content', [ShipmentController::class, 'afterSearchModalContent']);

Route::get('lang/{lang}', LangSwitcherController::class)->name('lang-switcher');
//woo
Route::get('checkIfExistsShipmentIdForWoo', [ShipmentController::class, 'checkIfExistsShipmentIdForWoo']);
Route::get('after_search_modal_content_shipments_products', [ShipmentController::class, 'afterSearchModalContentShipmentsProducts']);
