<?php

namespace Database\Seeders;

use App\Imports\DistrictImport;
use App\Models\District;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Excel as MaatwebsiteExcel;
use Maatwebsite\Excel\Facades\Excel;

class DistrictSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $districtTable = (new District())->getTable();
        DB::table($districtTable)->truncate();

        $districtData = storage_path('/framework/seeders/thai_district.csv');
        Excel::import(new DistrictImport, $districtData, null, MaatwebsiteExcel::CSV);
    }
}
