<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToShopeeProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shopee_products', function (Blueprint $table) {
            $table->integer('dodo_product_id')->nullable()->after('parent_id');
            $table->integer('is_linked')->default(0)->comment('0=not linked, 1=linked to dodo product')->after('dodo_product_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shopee_products', function (Blueprint $table) {
            $table->dropColumn('dodo_product_id');
            $table->dropColumn('is_linked');
        });
    }
}
