<?php

namespace Database\Factories;

use App\Models\Category;
use App\Models\Product;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class ProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Product::class;

    /**
     * Defined other properties
     *
     * @var mixed
     */
    private $fakeImage;

    /**
     * Configure the factory while creating new object
     *
     * @return void
     */
    public function configure()
    {
        $this->afterCreating(function() {
            $productImageFileName = Str::random(10) . '.jpg';
            $this->fakeImage = UploadedFile::fake()->image($productImageFileName);
        });
    }

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            // 'category_id' => Category::factory(),
            // 'seller_id' => User::factory(),
            'image' => $this->fakeImage,
            'part_name' => $this->faker->text(),
            'part_no' => $this->faker->word(),
            'weight' => $this->faker->randomNumber(2) . 'kg',
            'price' => $this->faker->randomNumber(2),
            'pack' => $this->faker->randomNumber(2),
            'specifications' => $this->faker->text(),
            'cost_pc' => $this->faker->randomNumber(2),
            'currency' => $this->faker->randomNumber(2),
            'alert_stock' => $this->faker->randomNumber(2),
            'from_where' => 1
        ];
    }
}
