<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Size extends Model
{
    use HasFactory;

    protected $table = 'sizes';

    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'seller_id',
    ];


    /**
     * Relationship to itself
     * Get the 'children' data
     *
     * @return mixed
     */
    public function children()
    {
        return $this->hasMany(self::class, 'parent_category_id', 'id');
    }

    /**
     * Relationship to itself
     * Get the 'parent' data
     *
     * @return mixed
     */
    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_category_id', 'id');
    }

    /**
     * Relationship to `products` table
     *
     * @return mixed
     */
    public function products()
    {
        return $this->hasMany(Product::class);
    }
}
