<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ProductionCharge extends Model
{
    use HasFactory;
    protected $table = 'production_charges';

    /**
     * Define `stock_status`
     *
     * @var mixed
     */
    CONST STATUS_ACTIVATE = 1;
    CONST STATUS_DEACTIVATE = 0;



    public function daily_production()
    {
        return $this->belongsTo(DailyProduction::class, 'production_id', 'id');
    }

    public function stockLog()
    {
        return $this->hasMany(StockLog::class, 'daily_production_id', 'id');
    }

    public function rmStockLog()
    {
        return $this->hasMany(RmStockLog::class, 'daily_production_id', 'id');
    }

    public function production_unit()
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault(['name' => '']);
    }
    

    /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $productTable = $this->getTable();
            $query->Where('name', 'like', "%$keyword%")
                    ->orWhere('location', 'like', "%$keyword%");
        }
        return;
    }


    /**
     * Query to search from quantity logs table page.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  string|null  $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByShop($query, $shop_id = '')
    {
        if($shop_id) return $query->whereIn('shop_id', explode(",",$shop_id));

        return;
    }


    /**
     * Sub Query to get total of incoming / order_purchase_detail
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeTotalIncoming($query)
    {
        $productTable = $this->getTable();
        $orderPurchaseTable = (new OrderPurchase())->getTable();
        $orderPurchaseDetailsTable = (new OrderPurchaseDetail())->getTable();

        return $query->addSelect(['total_incoming' => OrderPurchaseDetail::selectRaw("
        SUM({$orderPurchaseDetailsTable}.quantity)
        ")
        ->join("{$orderPurchaseTable}", "{$orderPurchaseTable}.id", '=', "{$orderPurchaseDetailsTable}.purchase_id")
            ->whereColumn("{$orderPurchaseDetailsTable}.product_code", "{$productTable}.product_code")
            ->where("{$orderPurchaseTable}.status", '<>', OrderPurchase::STATUS_CLOSE)
            ->limit(1)
        ]);
    }

}
