<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use DB;

class Payments extends Model
{
    // protected $table = 'payments';
    use HasFactory;

        /**
     * Define `Payment Method` value field
     *
     * @var string
     */
    CONST CASH = '1';
    CONST CHEQUE = '2';
    CONST MOBILE_BANKING = '3';
    CONST ONLINE = '4';


    
    public function shop()
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault([ 'name' => '' ]);
    }
    

    // Define the relationships for supplier and lender
    public function supplier()
    {
        return $this->belongsTo(Suppliers::class);
    }

    public function lender()
    {
        return $this->belongsTo(Lenders::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employees::class);
    }

    public function partner()
    {
        return $this->belongsTo(Partner::class);
    }

    public function mobileOrBank()
    {
        return $this->belongsTo(BanksOrMobiles::class,'bank_or_mobile_wallet_id','id');
    }
    public function account()
    {
        return $this->belongsTo(Account::class,'account_no_id','id');
    }


    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function bank_or_mobile_wallet()
    {
        return $this->hasOne(BanksOrMobiles::class,'id' ,'bank_or_mobile_wallet_id');
    }

    public function bank_or_mobile_wallet_account()
    {
        return $this->hasOne(Account::class,'id' ,'bank_or_mobile_wallet_id');
    }

     /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $paymentTable = $this->getTable();
            $supplierTable = (new Suppliers())->getTable();
            $lenderTable = (new Lenders())->getTable();
            $employeeTable = (new Employees())->getTable();
            $bankOrMobilesTable = (new BanksOrMobiles())->getTable();
            $payment_methodsTable = (new PaymentMethods())->getTable();

            return $query->where(function(Builder $payment) use ($paymentTable, $supplierTable, $lenderTable,$employeeTable,$bankOrMobilesTable,$payment_methodsTable,$keyword) {
 
                $payment->where("{$paymentTable}.id", 'like', "%$keyword%")
                ->orWhere("{$paymentTable}.payment_date", 'like', "%$keyword%")
                ->orWhere("{$paymentTable}.paid", 'like', "%$keyword%");
                    
            });
        }
        return;
    }

    /**
     * Query to search from quantity logs table page.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  string|null  $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByShop($query, $shop_id = '')
    {
        if($shop_id) return $query->where('shop_id', $shop_id);

        return;
    }
}
