<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use DB;

class OrderManagementDetails extends Model
{
    use HasFactory;

 /**
     * Define table name
     *
     * @var string
     */
    protected $table = 'order_management_details';
    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function order_management()
    {
        return $this->hasOne(OrderManagement::class, 'id','order_management_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id')
            ->withDefault()
            ->quantity();
    }

    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function receive_payments()
    {
        return $this->hasOne(ReceivePayment::class, 'order_id','order_management_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }


        /**
     * Sub Query to get the total Paid
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeTotalDeliveredQty($query)
    {
        $orderManagementDetailsTable = $this->getTable();
        $deliveryChallanDetailsTable = (new DeliveryChallanDetails())->getTable();

        return $query->addSelect(['total_delivered_qty' => DeliveryChallanDetails::selectRaw("SUM({$deliveryChallanDetailsTable}.quantity)")
            ->whereColumn("{$orderManagementDetailsTable}.order_management_id", "{$deliveryChallanDetailsTable}.order_management_id")
            ->whereColumn("{$orderManagementDetailsTable}.product_id", "{$deliveryChallanDetailsTable}.product_id")
            ->groupBy("{$orderManagementDetailsTable}.product_id")
            ->limit(1)
        ]);
    }
}
