<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Investment extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Define table name
     *
     * @var string
     */
    protected $table = 'investments';

    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'shop_id',
        'partner_id',
        'amount'
    ];


    /**
     * Relationship to `users` table as a seller
     *
     * @return mixed
     */
    public function shop()
    {
        return $this->belongsTo(Shop::class)->withDefault();
    }

    /**
     * Relationship to `partner` table as a seller
     *
     * @return mixed
     */
    public function partner()
    {
        return $this->belongsTo(Partner::class)->withDefault();
    }

    /**
     * Filter by `order_type` custom only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeCustomOrder($query)
    {
        return $query->where('order_type', self::ORDER_TYPE_CUSTOM);
    }

    /**
     * Query to check if customer is Dropshipper
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  int  $customerType
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeCustomerType($query, $customerType)
    {
        if ($customerType != '0') {
            return $query->where('is_dropshipper', '=', 1);
        }

        return;
    }
}
