<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Feature extends Model
{
    use HasFactory;

    protected $table = 'features';

    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'is_required',
        'seller_id',
    ];



    /**
     * Relationship to itself
     * Get the 'children' data
     *
     * @return mixed
     */
    public function children()
    {
        
    }

    /**
     * Relationship to itself
     * Get the 'parent' data
     *
     * @return mixed
     */
    public function parent()
    {
        //return $this->belongsTo(self::class, 'parent_category_id', 'id');
    }

    /**
     * Relationship to `products` table
     *
     * @return mixed
     */
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    /**
     * Query to search form select2
     *
     * @param  \Illuminate\Database\Query\Builder   $query
     * @param  string|null                          $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchSelectTwo($query, $keyword = null)
    {
        if (!empty($keyword)) {
            return $query->where(function($query) use ($keyword) {
                $query->where('name', 'like', "%$keyword%");
            });
        }

        return;
    }


    /**
     * Query to search from datatable
     *
     * @param  \Illuminate\Database\Query\Builder   $query
     * @param  string|null                          $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchDatatable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            return $query->where(function($query) use ($keyword) {
                $query->where('name', 'like', "%$keyword%");
            });
        }

        return;
    }
}
