<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Expenses extends Model
{
    use HasFactory;



    public function shop()
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault([ 'name' => '' ]);
    }

   /**
     * Relationship to `expense_details` table
     *
     * @return mixed
     */
    public function expense_details()
    {
        return $this->hasMany(ExpenseDetails::class, 'expense_id','id');
    }
       /**
     * Relationship to `payment_method` table
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment_method()
    {
        return $this->belongsTo(PaymentMethods::class, 'payment_method_id', 'id');
    }

        /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $productTable = $this->getTable();
            $query->Where('entry_date', 'like', "%$keyword%")
                    ->orWhere('total', 'like', "%$keyword%");
        }
        return;
    }

    /**
     * Query to search from quantity logs table page.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  string|null  $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByShop($query, $shop_id = '')
    {
        if($shop_id) return $query->where('shop_id', $shop_id);

        return;
    }


}