<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use DB;

class DeliveryChallanDetails extends Model
{
    use HasFactory;

 /**
     * Define table name
     *
     * @var string
     */
    protected $table = 'delivery_challan_details';
    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function delivery_challan()
    {
        return $this->hasOne(DeliveryChallan::class, 'id','order_management_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id')
            ->withDefault()
            ->quantity();
    }

    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function receive_payments()
    {
        return $this->hasOne(ReceivePayment::class, 'order_id','order_management_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }
}
