<?php

namespace App\Http\Requests\Salaries;

use App\Models\Salaries;
use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employee_id' => [
                'required'
            ],
            'paid' => [
                'required',
                'numeric',
                'min:0'
            ],
         ];
    }


    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'employee_id' => 'Employee Name',
            'paid' => 'Paid Amount',
        ];
    }
}