<?php

namespace App\Http\Requests\RmStock;

use App\Models\RmStockLog;
use Illuminate\Foundation\Http\FormRequest;

class RmStockStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'stock_date' => [
                'required',
            ],  
      
                   
            'stock_status' => [
                'required'
            ],
            'quantity.* ' => [
                'required',
                'integer',
                'min:1'
            ],
            'raw_material_id.* ' => [
                'required',
                'integer',
                'min:1'
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'stock_date' => __('translation.Date'), 
            'raw_material_id' => __('translation.Raw Material Name'), 
            'shop_id' => __('translation.Unit Name'), 
            'stock_type' => __('translation.Stock Type'), 
            'product_qty.*' => __('translation.Quantity')
        ];
    }
}
