<?php

namespace App\Http\Requests\RawMaterial;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class RawMaterialUpdateRequest extends FormRequest
{
    private $unitId = 0;

    /**
     * Create new instance
     *
     * @param Request $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->unitId = $request->id;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

     /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [          
            'name' => [
                'required',
                'max:255',
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'name' => __('translation.Product Name'), 
        ];
    }
}
