<?php

namespace App\Http\Requests\RanconProduct;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class RanconProductUpdateRequest extends FormRequest
{
    private $productId = 0;

    /**
     * Create new instance
     *
     * @param Request $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->productId = $request->id;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

     /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'part_name' => [
                'required',
                'max:255'
            ],            
            'price' => [
                'required',
                
            ],
        ];
    }

    /**
     * Get the validation fields name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'part_name' => __('translation.Part Name'), 
            'product_code' => __('translation.Product Code'), 
            'price' => __('translation.Price')
        ];
    }
}
