<?php

namespace App\Http\Requests\Purchase;

use App\Models\Purchase;
use Illuminate\Foundation\Http\FormRequest;

class PurchaseUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
                
            'id' => [
                'required'
            ],             

            'supplier_id' => [
                'required'
            ], 
            'product_id' => [
                'required'
            ],
            'product_id.*' => [
                'required'
            ], 
        ];
    }

    /**
     * The the validation attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'id' => 'Purchase Id',
            'supplier_id' => 'Supplier Name',
            'shop_id' => 'Shop',
            'paid' => 'Paid',
            'product_id' => 'Product',
        ];
    }

    /**
     * Get validation messages
     *
     * @return array
     */
    public function messages()
    {
        return [
            'required_if' => __('translation.validation.required')
        ];
    }
}
