<?php

namespace App\Http\Requests\Purchase;

use App\Models\Purchase;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class PurchaseStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $purchaseTable = (new Purchase())->getTable();
    
            return [

                'order_date' => [
                    'required'
                ],
              
                'supplier_id' => [
                    'required'
                ],
                'product_id' => [
                    'required'
                ],
                'product_id.*' => [
                    'required'
                ],                
                
            ];
        
    }

    /**
     * The the validation attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'shop_id' => 'Shop',            
            'supplier_id' => 'Supplier Name',
            'order_date' => 'Order Date',
            'product_id' => 'Raw Material',
        ];
    }

    /**
     * Get validation messages
     *
     * @return array
     */
    public function messages()
    {
        return [
            'required_if' => __('translation.validation.required')
        ];
    }
}
