<?php

namespace App\Http\Requests\OrderManagement;

use App\Models\OrderManagement;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class OrderStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $orderManagementTable = (new OrderManagement())->getTable();
    
            return [
                'order_date' => 'required',
                'shop_id' => 'required',
                'product_id' => [
                    'required',
                ],
                'product_id.*' => [
                    'required',
                ],
                'customer_id' => [
                    'required',
                ],               
                
            ];
        
    }

    /**
     * The the validation attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'order_date' => 'Order Date',
            'shop_id' => 'Production Unit',
            'customer_id' => 'Customer Name',
            'paid' => 'Paid',
            'quantity.*' => 'Products Quantity',       
            'product_description.*' => 'Products Description',
        ];
    }

    /**
     * Get validation messages
     *
     * @return array
     */
    public function messages()
    {
        return [
            'required_if' => __('translation.validation.required'),
        ];
    }
}
