<?php

namespace App\Http\Requests\CustomOrder;

use App\Models\Channel;
use App\Models\CustomOrder;
use App\Models\Shop;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class StoreRequest extends FormRequest
{
    /**
     * Define properties
     *
     * @var mixed
     */
    private $allowedShopIds = [];
    private $allowedChanneldIds = [];

    /**
     * Create new instance
     *
     * @return void
     */
    public function __construct()
    {
        $sellerId = Auth::user()->id;

        $channels = Channel::selectRaw('id')->where('seller_id', $sellerId)->where('display_channel', 1)->get();
        $channels->map(function($channel) {
            array_push($this->allowedChanneldIds, $channel->id);
        });

        $shops = Shop::selectRaw('id')->where('seller_id', $sellerId)->get();
        $shops->map(function($shop) {
            array_push($this->allowedShopIds, $shop->id);
        });
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'shop_id' => [
                'required', 'integer', 'in:' . implode(',' , $this->allowedShopIds)
            ],
            'channel_id' => [
                'required', 'integer', 'in:' . implode(',', $this->allowedChanneldIds)
            ],
            'contact_name' => [
                'required', 'string', 'min:3', 'max:50'
            ],
            'customer_name' => [
                'required', 'string', 'min:3', 'max:50'
            ],
            'contact_phone' => [
                'required', 'string', 'min:10', 'max:20'
            ],

            'product_price' => [
                'required', 'array'
            ],
            'product_price.*' => [
                'required', 'min:0'
            ],
            'quantity' => [
                'required', 'array'
            ],
            'quantity.*' => [
                'required', 'integer', 'min:1'
            ],
            'product_description' => [
                'required', 'array'
            ],
            'product_description.*' => [
                'nullable', 'string'
            ],
            'product_image_one' => [
                'nullable',
                'array'
            ],
            'shipping_name' => [
                'required', 'string', 'min:3', 'max:50'
            ],
            'shipping_cost' => [
                'required', 'min:0'
            ]
        ];
    }

    /**
     * Get the attributes name
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'customer_id' => 'Customer Name',
            'part_name.*' => 'Products Name',
            'product_price.*' => 'Products Price',
            'quantity.*' => 'Products Quantity',
            'product_description.*' => 'Products Description'
        ];
    }
}
