<?php

namespace App\Http\Controllers;

use App\Models\Shop;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;

class ShopController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function index()
    {
        $title = 'shop';
        $data = Shop::get();
        
        return view('settings.shop',compact('title','data'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()){
            if (isset($request->id) && $request->id != null) {
                $editData = Shop::where([
                    'id' => $request->id
                ])->first();
                return view('elements.form-update-shop',compact( 'editData'));
            }

            $data = Shop::get();

            $table = Datatables::of($data)
                ->addColumn('image', function ($row) {
                    if(!empty($row->logo) && file_exists(public_path($row->logo))) {
                        return '<span><img src="'.asset($row->logo).'" style="width:60px;height:55px"></span>';
                    }
                    return '<span><img src="'.asset('No-Image-Found.png').'" style="width:60px;height:55px"></span>';
                })
                ->addColumn('phone', function ($row) {
                    return  "Showroom: ".$row->phone_showroom . ' <br> '
                            . "Services: ". $row->phone_service;
                })
                
                ->addColumn('address_detail', function ($row) {
                    return  $row->address . ' <br> '
                            . $row->sub_district . ', '
                            . $row->district . ' <br> '
                            . $row->province . ' '
                            . $row->postcode;
                })
                ->addColumn('manage', function ($row) {
                    return '
                        <div class="w-full text-center">
                            <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                <i class="fas fa-pencil-alt"></i>
                            </button>
                            <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    ';
                })
                ->rawColumns(['image', 'phone', 'address_detail','manage'])
                ->make(true);

            return $table;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('elements.form-update-shop');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $shop = new Shop();
        $shop->name = $request->name;
        $shop->address = $request->address;        
        $shop->phone_showroom = $request->phone_showroom;
        $shop->phone_service = $request->phone_service;
        $shop->email = $request->email;

        $shop->username = $request->shop_username;
        $shop->password = $request->shop_password;

        $shop_credentials = [];

        $shop->shop_type = json_encode($shop_credentials);

        if ($request->hasFile('logo')) {
            $upload = $request->file('logo');
            $upload_name =  time() . $upload->getClientOriginalName();
            $destinationPath = public_path('uploads/shop_logo');
            $upload->move($destinationPath, $upload_name);
            $shop->logo = 'uploads/shop_logo/'.$upload_name;
        }
        $shop->seller_id = Auth::user()->id;
        $shop->save();

        if($shop)
        {
            return redirect()->back()->with('success','Shop Added Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Shop::where('seller_id',Auth::user()->id)->get();

        return view('settings.shop',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $shop = Shop::where('id', $request->id)->first();
        $shop->name = $request->name;
        $shop->address = $request->address;
        $shop->phone_showroom = $request->phone_showroom;
        $shop->phone_service = $request->phone_service;
        $shop->email = $request->email;


        $shop->username = $request->shop_username;
        $shop->password = $request->shop_password;

        $shop_credentials = [];

        $shop->shop_type = json_encode($shop_credentials);

        if ($request->hasFile('logo')) {
            $upload = $request->file('logo');
            $upload_name =  time() . $upload->getClientOriginalName();
            $destinationPath = public_path('uploads/shop_logo');
            $upload->move($destinationPath, $upload_name);
            $shop->logo = 'uploads/shop_logo/'.$upload_name;
        }
        $shop->seller_id = Auth::user()->id;
        $shop->save();

        if($shop)
        {
            return redirect('shops')->with('success','Shop Updated Successfully');
        }
        else{
            return redirect('shops')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            $shop = Shop::where('id',$request->id)->where('seller_id',Auth::user()->id)->first();
            if(file_exists($shop->logo)){
                unlink($shop->logo);
            }
            $shop->delete();

            return [
                'status' => 1
            ];
        }
    }
}
