<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\DoDoChat;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('dodochat_users_logout');
    }

    public function index()
    {
        $categories = Category::where('parent_category_id',0)->where('seller_id',Auth::user()->id)->get();
        $data = Category::with('children')->where('seller_id',Auth::user()->id)->get();
        return view('settings.category',compact('categories','data'));
    }
    public function store(Request $request)
    {
       $category = new Category();
       $category->cat_name = $request->cat_name;
       if(empty($request->parent_category_id))
       {
            $category->parent_category_id = 0;
       }
       else
       {
            $category->parent_category_id = $request->parent_category_id;
       }

       $category->seller_id = Auth::user()->id;
       $category->save();

       if($category)
       {
           return redirect()->back()->with('success','Category Added Successfully');
       }
       else{
        return redirect()->back()->with('danger','Something happened wrong');
       }
    }
    public function edit($id)
    {
        $categories = Category::where('parent_category_id',0)->where('seller_id',Auth::user()->id)->get();
        $data = Category::with('children')->where('seller_id',Auth::user()->id)->get();
        $editData = Category::where('id',$id)->where('seller_id',Auth::user()->id)->first();

        return view('settings.category',compact('categories','data','editData'));
    }
    public function update(Request $request ,$id){
        $category = Category::find($id);
        $category->cat_name = $request->cat_name;
        if(!empty($request->parent_category_id))
        {
             $category->parent_category_id = $request->parent_category_id;
        }
        $category->save();

        if($category)
        {
            return redirect()->back()->with('success','Category Updated Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }
    public function delete($id)
    {
        $category = Category::where('id',$id)->where('seller_id',Auth::user()->id)->delete();
        if($category)
        {
            return redirect()->back()->with('success','Category Deleted Successfully');
        }
        else{
         return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    public function DoDoChatApp()
    {
        return view('settings.dodochat');
    }

    public function dodochat_users_activity()
    {
        $chatLogs = DoDoChat::all();
        return view('settings.dodochat_activity_log', compact('chatLogs'));
    }

    public function dodochat_users_logout($authCode)
    {
        $dodochat = DoDoChat::where('auth_code', trim($authCode))->first();
        $dodochat->logout_time = now();
        $dodochat->save();

        return response()->json([
            'status'=>'success',
        ], 200);
    }

    public static function takaInWord($number){
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'One', 2 => 'Two',
            3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
            7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
            10 => 'Ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred','thousand','lakh', 'crore');
        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        $Taka = implode('', array_reverse($str));
        $poysa = ($decimal) ? " and " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' poysa' : '';
        return ($Taka ? $Taka . 'taka ' : '') . $poysa ;
    }
    
    public static function takaBDFormat($number){
        if(!empty($number)){
        $number = (float)$number;    
        $number = number_format($number, 2, '.', ''); // Converts number to 2 decimal places
        
        // Apply Indian numbering system formatting using preg_replace
        $formatted_number = preg_replace("/(\d+?)(?=(\d\d)+(\d)(?!\d))(\.\d+)?/", "$1,", $number);
        
        return $formatted_number;
        }
    }
}
