<?php

namespace App\Http\Controllers;

use App\Actions\Service\CalculateTotalAmountAction;
use App\Http\Requests\Service\DatatableRequest;
use App\Http\Requests\Service\StoreRequest;
use App\Http\Requests\Service\UpdateRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Channel;
use App\Models\Customer;
use App\Models\CustomerOrder;
use App\Models\Service;
use App\Models\ServiceDetail;
use App\Models\ProductMainStock;

use App\Models\Permission;
use App\Models\Product;
use App\Models\Payment;
use App\Models\ReceivePayment;
use App\Models\ProductPrice;
use App\Models\Category;
use App\Models\PaymentMethod;
use App\Models\BanksOrMobiles;
use App\Models\Account;

use App\Models\District;
use App\Models\CustomerShippingMethod;
use App\Models\Shipper;
use App\Models\Shipment;
use App\Models\ShipmentProduct;
use App\Models\ShippingCost;
use App\Models\Shop;
use App\Models\TaxRateSetting;
use App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use Jenssegers\Agent\Agent;
use Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use KsherPay;
use Carbon\Carbon;
use DateTime;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;

/**
 * @TODO do not include, put KSHER SDK in 'App->Custom' directory
 * @TODO then load KSHER with composer autoloader and use like other classes
 * @TODO you have to put namespace in order to use it
 * @TODO remove all unused variables
 */

/**
 * @TODO Lot of strings without translation method, refactor them like __('translation.Your String')
 */

class ServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $shop_id = Auth::user()->shop_id;
        $roleName = Auth::user()->role;
       
        $totalProcessingOrders = Service::where('shop_id', $shop_id)
                                ->customerAsset($roleName)
                                ->count();
        
        $totalProcessingDropshipperOrders = Service::where('shop_id', $shop_id)
                                ->count();

        
        $data = [
            'totalProcessingOrders' => $totalProcessingOrders,
            'totalProcessingDropshipperOrders' => $totalProcessingDropshipperOrders,
            'totalProcessingWooCommerce' => '',
            'defaultStatusOrderId' => 0,
        ];

        return view('seller.service.index', $data);
    }

    /**
     * Handle server-side datatable of order managements
     *
     * @param  \App\Http\Requests\Service\DatatableRequest  $request
     * @return Response
     */
    public function data(DatatableRequest $request)
    {
        $sellerId = Auth::user()->id;

        $orderManagementsTable = (new Service())->getTable();
        $customersTable = (new Customer())->getTable();
        $shipmentTable = (new Shipment())->getTable();

        $orderStatusId = $request->get('status', 0);
       
        //return $orderStatusId;


        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 1;
        $orderDir = isset($request->get('order')[0]['dir'])
                    ? $request->get('order')[0]['dir']
                    : 'desc';

        $availableColumnsOrder = [
            'id', 'id'
        ];

        $orderColumnName = isset($availableColumnsOrder[$orderColumnIndex])
                            ? $availableColumnsOrder[$orderColumnIndex]
                            : $availableColumnsOrder[0];

        $roleName = Auth::user()->role;

        if(!empty($request->customerType)){
            $customerType = $request->customerType;
        }
        else{
            $customerType = '0';
        }
        
        $orderManagements = Service::selectRaw("{$orderManagementsTable}.*,
                                {$customersTable}.customer_name AS customer_customer_name,
                                {$customersTable}.contact_phone AS customer_contact_phone")
                ->where("{$orderManagementsTable}.shop_id", Auth::user()->shop_id)
                ->with('shop')
                ->withCount('service_details')
                ->joinedDatatable()
                ->customerAsset($roleName, $customerType)
                ->byOrderStatus($orderStatusId)
                ->searchDatatable($search)
                ->orderBy($orderColumnName, $orderDir)
                ->groupByOrderStatus($orderStatusId)
                ->get();
  

        return Datatables::of($orderManagements)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($row) {
                    return $row->id;
                })
                ->addColumn('order_data', function ($row) use ($orderStatusId) {
                    $currentShipment = Shipment::where('id', $row->shipment_row_id)->first();
                    $paymentStatus = '
                        <span class="badge-status--red">
                            '. $row->str_payment_status .'
                        </span>
                    ';

                    $manualPaymentSum = Service::getManualPaymentSum($row->id);
                    $manualRefundedSum = Service::getmanualRefundedSum($row->id);
                    $paymentDetailsAllManual = ReceivePayment::with('payment_method')->with('bank_or_mobile_wallet')->where('service_id',$row->id)->get();
  

                    if($row->payment_status == 1)
                        $paymentStatus = '<span class="badge-status--green">PAID</span>';
                    else

                        if($manualPaymentSum == 0 AND $row->payment_status == 0 AND empty($paymentDetailsOthers))
                            $paymentStatus = '<span class="badge-status--red">NOT PAID</span>';
                        

                        if($manualPaymentSum > 0 AND $manualPaymentSum < $row->in_total)
                            $paymentStatus = '<span class="badge-status--yellow">PARTIAL PAID</span>';
                        

                        if($manualPaymentSum == $row->in_total AND $row->order_status == 1)
                            $paymentStatus = '<span class="badge-status--green">PAID</span>';
                        
                        if($row->in_total == $manualPaymentSum AND $row->in_total == $manualRefundedSum)
                            $paymentStatus = '<span class="badge-status--green">NOT PAID</span>';


                    $channelName = $row->channels->name;
                    $shopName = $row->shop->name;
                    if (!empty($row->channels) && file_exists(public_path($row->channels->image))) {
                        $image = asset($row->channels->image);
                    }
                    else {
                        $image = asset('img/No_Image_Available.jpg');
                    }
                    if ($row->customer_type == 1) {
                        $channelName = 'Dropshipper';
                    }

                    $shippingMethod = '';
                    

                    
                        $confirmBtn = '';
                        $cancelBtn = '';
                        $printLabelBtn = '';
                        $publicPageBtn = '';
                        $shipmentStatusBtns = '';
                        $updateStatusBtnForProcessedAction = '';
                        $updateStatusBtnForProcessed = '<button type="button" class="btn-action--yellow mr-1" title="Update Status"
                                                data-order-id="' . $row->id . '"
                                                data-shipment-id="' . $row->shipment_row_id . '"
                                                onClick="updateStatusForProcessed(this)">
                                                <i class="fa fa-edit mr-2" aria-hidden="true"></i>
                                                Update status
                                            </button>
                                            ';

                                            
                        $array_order_status_id = array('2','8','9');

                        if(in_array($orderStatusId, $array_order_status_id) AND $row->order_status == Service::ORDER_STATUS_PROCESSED){
                            $updateStatusBtnForProcessedAction = $updateStatusBtnForProcessed;
                        }
                        else{
                            $updateStatusBtnForProcessedAction = '';
                        }

                        if ($orderStatusId >= 10 || $row->order_status == Service::ORDER_STATUS_PROCESSED) {
                            $publicPageBtn = '';
                        }
                        elseif ($row->order_status == Service::ORDER_STATUS_CANCEL) {
                            $publicPageBtn = '<a href="'. route('order-management.public-url', [ 'service_id' => $row->service_id ]) .'" target="_blank" class="btn-action--blue" title="Public Page">
                                                <i class="fas fa-share-alt"></i>
                                                <span class="ml-2 hidden lg:inline">Public Page</span>
                                            </a>';
                        }
                        elseif ($row->order_status == Service::ORDER_STATUS_PROCESSING) {
                            $publicPageBtn = '  <button type="button" class="btn-action--green"
                                                    data-id="' . $row->id . '"
                                                    onClick="createShipment(this)">
                                                    <i class="fa fa-shipping-fast mr-1" aria-hidden="true"></i>
                                                    '.__('translation.Arrange Shipment').'
                                                </button>';
                        }
                        else {
                            if($row->order_status != Service::ORDER_STATUS_COMPLETED){
                            $publicPageBtn = '<a href="'. route('service.edit', [ 'service' => $row ]) .'" target="_blank" class="btn-action--blue" title="Pay Link">
                                                <i class="fas fa-share-alt"></i>
                                                <span class="ml-2 mr-2 hidden lg:inline">Pay Link</span>
                                            </a>';
                            }
                        }
                        if ($row->order_status == Service::ORDER_STATUS_PENDING || $row->order_status == Service::ORDER_STATUS_PENDING_PAYMENT) {
                            $cancelBtn = '<button type="button" class="mr-2 btn-action--red BtnCancel" title="Cancel"
                                                data-id="' . $row->id . '"
                                                data-service_id="' . $row->id . '">
                                                <i class="fas fa-trash"></i>
                                                <span class="ml-2 hidden lg:inline">Cancel Order</span>
                                            </button>';
                        }
                        if ($row->order_status == Service::ORDER_STATUS_PAYMENT_UNCONFIRMED) {
                            $confirmBtn = '<button type="button" class="ml-2 btn-action--red confirmPayment" title="Confirm Payment" id="confirmPayment"
                                                data-id="' . $row->id . '"
                                                data-service_id="' . $row->id . '">
                                                <i class="fas fa-check"></i>
                                                <span class="ml-2 hidden lg:inline">Confirm Payment</span>
                                            </button>';
                        }
                        $breakLine = '<span class="sm:hidden"><br></span>';

                        if ($orderStatusId == Shipment::SHIPMENT_STATUS_READY_TO_SHIP || $orderStatusId == Shipment::SHIPMENT_STATUS_READY_TO_SHIP_PRINTED){
                            if ($currentShipment->pack_status == 1){
                                $packageContent = '<div class="mb-1 sm:mb-2">
                                                         Pick Confirm At : ' . date('d-m-Y h:i A', strtotime($currentShipment->packed_date_time)) . ' ( ' . $currentShipment->packer->name . ' )
                                                    </div>
                                                    ' . $breakLine;
                            }
                            else{
                                $packageContent = '<button type="button" class="btn-action--blue mr-2" title="Pack Order"
                                                        data-order-id="' . $row->id . '"
                                                        data-shipment-id="' . $row->shipment_row_id . '"
                                                        onClick="packOrder(this)">
                                                        PICK CONFIRM
                                                    </button>
                                                    ' . $breakLine;
                            }
                            $updateStatusBtn = '<button type="button" class="btn-action--yellow mr-1" title="Update Status"
                                                    data-order-id="' . $row->id . '"
                                                    data-shipment-id="' . $row->shipment_row_id . '"
                                                    onClick="updateStatus(this)">
                                                    Update status
                                                </button>
                                                ';

                            if ($orderStatusId >= 10 && $orderStatusId != Shipment::SHIPMENT_STATUS_CANCEL) {
                                $printLabelBtn = '
                                              <a href="' . route('shipment-label.pdf', ['service_id' => $row->id, 'shipment_id' => $row->shipment_row_id]) . '">
                                                  <button type="button" class="btn-action--green mr-2" title="Print Label">
                                                      PRINT LABEL
                                                  </button>
                                              </a>
                                               ';
                            }

                            $shipmentStatusBtns = $packageContent . $updateStatusBtn . $printLabelBtn;
                        }
                        $functionalBtns = $publicPageBtn . $cancelBtn . $confirmBtn . $shipmentStatusBtns;
                    

                    $rowId = $row->id;
                    if ($orderStatusId >= 10){
                        $rowId = $row->id . ' (Ship ID #' . $row->shipment_row_id . ')';
                    }

                    $printDate = '';
                    if ($orderStatusId >= 10 && $currentShipment->print_status == 1){
                        $printDate = '<div class="mb-1 sm:mb-2">
                                             Printed At : ' . date('d-m-Y h:i A', strtotime($currentShipment->print_date_time)) . ' ( ' . $currentShipment->printer->name . ' )
                                        </div>
                                        ';
                    }

                    $totalItemsTitle = 'Total Amount : ';
                    if ($orderStatusId == Shipment::SHIPMENT_STATUS_READY_TO_SHIP){
                        $totalItemsTitle = 'Total Items : ';
                    }

                    $statusStr = Service::getOrderStatus($orderStatusId);

                    $spliter = '_';

                    if(!empty($currentShipment->shipment_date)){
                        $shipment_date = 'Shipment Date: <strong>'.date('d/m/Y',strtotime($currentShipment->shipment_date)).'</strong>';
                    }
                    else{
                        $shipment_date='';
                    }

                    return '
                        <div class="border border-solid border-gray-400 lg:border-gray-300 rounded-md hover:bg-blue-50">
                            <div class="border border-dashed border-t-0 border-r-0 border-l-0 border-gray-300">
                                <div class="grid grid-cols-3">
                                    <div class="col-span-3 sm:col-span-1">
                                        <a href="'. route('service.edit', [ 'service' => $row ]) .'" data-id="'.$row->id.'" order-status-id="'.$row->order_status.'" class="cursor-pointer underline" title="Edit">
                                            <div class="text-center px-2 py-1 sm:py-2">
                                                <span class="font-bold text-gray-400">#</span>
                                                <span class="relative -left-1 text-blue-500 font-bold">
                                                    '. $rowId .'
                                                </span>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-span-3 sm:col-span-1">
                                        <div class="px-2 py-1 sm:py-2">
                                            <span class="text-xs sm:text-sm">
                                                '. strtoupper($statusStr) .'
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-span-3 sm:col-span-1">
                                        <div class="px-2 py-1 sm:py-2">
                                            '. $shipment_date .'

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="grid grid-cols-1 lg:grid-cols-3">
                                    <div class="lg:col-span-2">
                                        <div class="grid grid-cols-5">
                                            <div class="col-span-5 sm:col-span-2 px-2 py-2">
                                                <div class="mb-1 md:mb-3">
                                                    <img src="'. $image .'" alt="'. $channelName .'" title="'. $channelName .'" class="w-10 h-auto" />
                                                </div>
                                                <div class="">
                                                    <span class="badge-status--yellow">
                                                        '. $shopName .'
                                                    </span>
                                                </div>
                                                <div>
                                                    <span class="">
                                                        '. $row->contact_name .'
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-span-5 sm:col-span-3">
                                                <div class="text-left px-2 py-2">
                                                    <div>
                                                        <span class="text-gray-600">
                                                            Cust. Name :
                                                        </span>'. $row->customer_customer_name .'
                                                    </div>
                                                    <div>
                                                        <span class="text-gray-600">
                                                            '. $totalItemsTitle .'
                                                        </span> '. currency_symbol('BDT') . number_format((float)$row->in_total, 2, '.', '').'
                                                       ( <a data-order-id="' . $row->id . '" data-shipment-id="' . $row->shipment_row_id . '" class="modal-open cursor-pointer" onClick="productsOrdered(this)">' . $row->service_details_count .' Item/s</a> )
                                                    </div>
                                                    <div class="mb-2">
                                                        <a data-id="'. $row->id .'" id="BtnAddress" class="modal-open cursor-pointer">' . $shippingMethod .'</a>
                                                    </div>
                                                    <div class="mb-3 text_uppercase">
                                                        <a id="" class="modal-open cursor-pointer text_uppercase"><font class="">' . $paymentStatus .'</font></a>
                                                    </div>
                                                    
                                                    <div class="text-center sm:text-left">
                                                         '. $printDate .'
                                                    </div>
                                                    <div class="text-center sm:text-left">
                                                         '. $functionalBtns .'
                                                         '.$updateStatusBtnForProcessedAction.'
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="lg:col-span-1">
                                        <div class="border border-dashed border-r-0 border-b-0 border-l-0 border-gray-300">
                                            <div class="px-2 py-2 lg:text-left">
                                                <div class="text-xs sm:text-sm">
                                                    <span class="text-gray-600">Order Date :</span> '. date('d/m/Y h:i a', strtotime($row->created_at)) .'
                                                </div>
                                                <div class="text-xs sm:text-sm">
                                                    <span class="text-gray-600">Created By :</span> '. $row->creator->name .'
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    ';
                })
                ->rawColumns(['checkbox', 'order_data'])
                ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function createOrderId($len=16)
    {
        $nonce_str = Str::random($len);
        return $nonce_str;
    }

    /**
     * Show create order_managemenst page
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        $sellerId = Auth::user()->id;

        Session::put('itemArray', []);
        $customers = DB::connection('mysql_secondary')->select('SELECT * FROM customers');
        $service_id = '';
        do {
            $service_id = $this->createOrderId();
            $orderManagement = Service::where('seller_id', $sellerId)
                                    ->where('service_id', $service_id)
                                    ->first();
        } while(!empty($orderManagement));

        $products = Product::where('seller_id', Auth::user()->id)->get();

        

        $data = [
            'service_id' => $service_id,
            'products' => ProductTypeAheadResource::collection($products),
            'customers' => $customers,
            'payment_methods' => PaymentMethod::all(),
            'banks_or_mobiles' => BanksOrMobiles::all()
        ];

        return view('seller.service.create', $data);
    }
    

    /**
     * Show create order_managemenst page
     *
     * @return \Illuminate\View\View
     */
    public function loadPaymentTypeData(Request $request)
    {
        $sellerId = Auth::user()->id;       
        $paymentType = $request->paymentType;
        $data = [
            'paymentType' => $paymentType
        ];

        return view('elements.load-payment-type', $data);
    }


    public function moneyReceipt($orderId = '0',$rcvPaymentID)
    {
        $orderManagement = Service::where('service_id', $orderId)
                            ->with('shop')
                            ->with('channels')
                            ->with('customer')
                            ->with(['service_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->first();
                        
        $paymentDeatails = ReceivePayment::with('payment_method')->with('bank_or_mobile_wallet')->where('id', $rcvPaymentID)->first();
   
        abort_if(!$orderManagement, Response::HTTP_NOT_FOUND, 'Order not found.');

        $sellerId = $orderManagement->seller_id;
        
        QrCode::generate($orderManagement->service_id, public_path('qrcodes/' . $orderManagement->service_id.'.svg'));
        $manualPaymentSum = Service::getManualPaymentSum($orderManagement->id);
        $manualRefundedSum = Service::getmanualRefundedSum($orderManagement->id);
        $paymentDetailsAllManual = ReceivePayment::with('payment_method')->with('bank_or_mobile_wallet')->where('service_id',$orderManagement->id)->get();

        
        $data = [
            'orderManagement' => $orderManagement,            
            'manualPaymentSum' => $manualPaymentSum,            
            'manualRefundedSum' => $manualRefundedSum,            
            'paymentDetailsAllManual' => $paymentDetailsAllManual,            
            'shop_details' => Shop::where('id',Auth::user()->shop_id)->first(),
            'payment_methodBankTransfer' => Service::PAYMENT_METHOD_BANK_TRANSFER,
            'payment_methodInstant' => Service::PAYMENT_METHOD_INSTANT,
            'orderStatusPending' => Service::ORDER_STATUS_PENDING,
            'orderStatusPendingPayment' => Service::ORDER_STATUS_PENDING_PAYMENT,
            'orderStatusProcessing' => Service::ORDER_STATUS_PROCESSING,
            'paymentStatusUnPaid' => Service::PAYMENT_STATUS_UNPAID,
            'paymentStatusPaid' => Service::PAYMENT_STATUS_PAID,
            'orderStatusPaymentUnconfirmed' => Service::ORDER_STATUS_PAYMENT_UNCONFIRMED,
            'orderStatusCancel' => Service::ORDER_STATUS_CANCEL,
            'statusForInfoAlert' => Service::getStatusForInfoAlert(),
            'paymentDeatails' => $paymentDeatails,
            'taxEnableValues' => Service::getAllTaxEnableValues(),
            'taxEnableYes' => Service::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first()
        ];
        
        return view('seller.service.money-receipt', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreRequest $request
     * @param  \App\Actions\Service\CalculateTotalAmountAction $calculateTotalAmount
     * @return Response
     */
    public function store(StoreRequest $request)
    {
        
        
        
        try {
            $sellerId = Auth::user()->id;
            $createdBy = Auth::user()->id;

            DB::beginTransaction();
            $show_rooms_customers = DB::connection('mysql_secondary')->select('SELECT * FROM customers where shop_id=4');    

            if($request->customer_id){
                $customerId = $request->customer_id;
            }

            if (empty($customerId)) {
                $customerData = new Customer();
                $customerData->customer_name = $request->customer_name;
                $customerData->contact_phone = $request->contact_phone;
                $customerData->save();
                $customerId = $customerData->id;
            }

            

            $orderManagementData = new Service();
            $orderManagementData->shop_id = Auth::user()->shop_id;
            $orderManagementData->customer_id = $customerId;
            $orderManagementData->customer_name = $request->customer_name;
            $orderManagementData->contact_phone = $request->contact_phone;
            $orderManagementData->order_status = Service::ORDER_STATUS_PENDING;
            $orderManagementData->customer_type = $request->customer_type;
            
            $orderManagementData->seller_id= $sellerId;
            $orderManagementData->created_by= $createdBy;
            $orderManagementData->user_id= Auth::user()->id;
            $orderManagementData->created_at = new DateTime();
            
            
            $orderManagementData->save();
            $orderManagementId = $orderManagementData->id;

            $paymentUrl = '';           
            $rcvPaymentId = $this->createPayment($request->paid,$orderManagementId,$request);
           
            $subTotal = 0;
            $shippingCostTotal = 0;
            $discountTotal = 0;
            $totalAmount = 0;

            $totalProductWeight = 0;
           
            foreach ($request->services as $idx => $service_name) {
                $servicePrice = $request->service_price[$service_name] ?? 0;
                $orderQty = $request->product_qty[$service_name] ?? 0;
                $serviceDiscount = $request->service_discount[$service_name] ?? 0;
                

                $subTotal += $servicePrice;
                $discountTotal += $serviceDiscount;

                $orderManagementDetailData = new ServiceDetail();
                $orderManagementDetailData->service_id = $orderManagementId;
                $orderManagementDetailData->service_name = $service_name;
                $orderManagementDetailData->shop_id = Auth::user()->shop_id;
                $orderManagementDetailData->price = $servicePrice;
                $orderManagementDetailData->discount_price = $serviceDiscount;
                $orderManagementDetailData->seller_id = $sellerId;
                $orderManagementDetailData->created_at = new DateTime();
                $orderManagementDetailData->save();

            }

            


           
            $orderManagement = Service::where('id', $orderManagementId)->first();

           
            // $manualPaymentSumDtl = Service::getManualPaymentSum($orderManagementId);
            // $manualRefundedSumDtl = Service::getManualRefundedSum($orderManagementId);
            // $totalPaidAmount = $manualPaymentSumDtl - $manualRefundedSumDtl;

            // if($orderManagementDtl->in_total == $totalPaidAmount){
            //     $orders->payment_status = Service::PAYMENT_STATUS_PAID;
            //     $orders->order_status = Service::ORDER_STATUS_COMPLETED;
            // }

            // if($orderManagementDtl->in_total == $manualRefundedSumDtl){
            //         $orders->payment_status = Service::PAYMENT_STATUS_UNPAID;
            //         $orders->order_status = Service::ORDER_STATUS_PENDING;
            // }
            


            $orderManagementsData = Service::find($orderManagementId);
            $orderManagementsData->product_price_total = $subTotal;
            $orderManagementsData->in_total = $subTotal;
            $orderManagementsData->update();

            DB::commit();

            $responseData = [
                'orderId' => $orderManagementId,
                'subTotal' => $subTotal,
                'shippingCost' => $shippingCostTotal,
                'discountTotal' => $discountTotal,
                'totalAmount' => $totalAmount,
                'totalPaid' => $request->paid, 
                'moneyReceipt' => route('service.money_receipt', [ 'service_id' => $orderManagementId ,'receive_payment_id' => $rcvPaymentId ]),
                'editUrl' => route('service.edit', [ 'id' => $orderManagementId ])
            ];

           // dd($responseData);

            return $this->apiResponse(Response::HTTP_CREATED, 'Order created.', $responseData);

        } catch (\Throwable $th) {
            report($th);

            DB::rollBack();

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
        /**
         * @TODO instead of Throwable, use Exception
         */
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $sellerId = Auth::user()->id;
      
        $orderManagement = Service::where('id', $id)
                            ->where('seller_id', $sellerId)
                            ->with('shop')
                            ->with(['service_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->first();
        dd($orderManagement);                    
        abort_if(!$orderManagement, 404, __('translation.Data not found'));

        if ($orderManagement->customer_type == 1)
            $channels = Channel::where('name', 'Dropshipper')->first();
        else
            $channels = Channel::where('seller_id', $sellerId)->where('display_channel', 1)->orderBy('name')->get();

        $products = Product::where('seller_id', Auth::user()->id)->get();

        $enabledShippingMethodIds = [];
        


        $totalProductWeight = $orderManagement->total_product_weight;

        $defaultshippingCostsByWeight = ShippingCost::filterWeightBetween($totalProductWeight)
                                        ->with('shipper')
                                        ->whereHas('shipper', function(Builder $shipper) use ($sellerId) {
                                            $shipper->where('seller_id', $sellerId);
                                        })
                                        ->orderBy('name', 'asc')
                                        ->get();

        $availableShippingCosts = $defaultshippingCostsByWeight->filter(function($shippingCost) use ($enabledShippingMethodIds) {
            return !in_array($shippingCost->id, $enabledShippingMethodIds);
        });


        $addedProductCodes = $orderManagement->service_details->map(function($detail) {
            return $detail->product->part_no;
        });

        $manualPaymentSum = Service::getManualPaymentSum($id);
        $manualRefundedSum = Service::getmanualRefundedSum($id);
        $paymentDetailsAllManual = ReceivePayment::with('payment_method')->with('bank_or_mobile_wallet')->where('service_id',$id)->get();
        $paymentDetailsOthers = ReceivePayment::where('service_id', $id)->first();

        $getOrderStatus = Service::getOrderStatus($orderManagement->order_status);

        $data = [
            'manualPaymentSum' => $manualPaymentSum,
            'manualRefundedSum' => $manualRefundedSum,
            'paymentDetailsAllManual' => $paymentDetailsAllManual,
            'paymentDetailsOthers' => $paymentDetailsOthers,
            'getOrderStatus' => $getOrderStatus,
            'channels' => $channels,
            'orderStatuses' => Service::getAllAvailableStatusForEdit(),
            'paymentStatuses' => Service::getAllPaymentStatus(),
            'products' => ProductTypeAheadResource::collection($products),
            'orderManagement' => $orderManagement,
            'availableShippingCosts' => $availableShippingCosts,
            'addedProductCodes' => $addedProductCodes,
            'isSelectedShippingMethod' => CustomerShippingMethod::IS_SELECTED_YES,
            'taxEnableValues' => Service::getAllTaxEnableValues(),
            'taxEnableYes' => Service::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first(),
            'customerType' => $orderManagement->customer_type,
            'taxEnableNo' => Service::TAX_ENABLE_NO,
            'customers' => Customer::all(),
            'payment_methods' => PaymentMethod::all(),
            'banks_or_mobiles' => BanksOrMobiles::get(),
            'accounts' => Account::get(),
            'districts' => District::distinct('district')->select('district')->get(),
            'thanas' => District::distinct('thana')->select('thana')->get(),
            'postoffices' => District::distinct('postoffice')->select('postoffice')->orderBy('postoffice','asc')->get(),
            'postcodes' => District::distinct('postcode')->select('postcode')->orderBy('postcode','asc')->get(),
        ];

        return view('seller.service.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\Service\UpdateRequest  $request
     * @param  \App\Actions\Service\CalculateTotalAmountAction  $calculateTotalAmount
     * @return Response
     */
    public function update(UpdateRequest $request, CalculateTotalAmountAction $calculateTotalAmount)
    {
        try {
            $sellerId = Auth::user()->id;

            $orderManagementId = $request->id;
            $order = Service::where('id', $orderManagementId)->first();

            
            $customersTable = (new Customer())->getTable();
            $orderManagementsTable = (new Service())->getTable();
            $orderManagementDetailsTable = (new ServiceDetail())->getTable();

            $taxRateSettingTable = (new TaxRateSetting())->getTable();


            DB::beginTransaction();

            $customerData = [
                'customer_name' => $request->customer_name,
                'contact_phone' => $request->contact_phone,
                'seller_id' => $sellerId,
                'order_type' => Customer::ORDER_TYPE_DEFAULT
            ];

            $customer = Customer::where($customerData)->first();
            if(!empty($customer->id)){
                $customerId = $customer->id;
            }
            else{
                $customerId = 0;
            }
            if (empty($customerId)) {
                $customerData['created_at'] = new DateTime();
                $customerId = DB::table($customersTable)->insertGetId($customerData);
            }

            $taxRate = 0;

            $subTotal = 0;
            $shippingCostTotal = 0;
            $discountTotal = 0;
            $totalAmount = 0;

            $totalProductWeight = 0;

            /* Add data to stock before deleting item*/
            if($orderManagementId){
                $previousData = ServiceDetail::where('service_id',$orderManagementId)->get();
                if($previousData){
                    foreach($previousData as $item){
                        $productMainStock = ProductMainStock::where('product_id',$item->product_id)->first();
                        
                        $productMainStock->quantity = $productMainStock->quantity+$item->quantity;
                        $productMainStock->save();
                    }
                }
            }
            DB::table($orderManagementDetailsTable)
                ->where('service_id', $orderManagementId)
                ->delete();

           

            foreach ($request->product_id as $idx => $productId) {
                $productOriginPrice = $request->product_price[$idx] ?? 0;
                $productDiscount = $request->product_discount[$idx] ?? 0;
                $productWeight = $request->product_weight[$idx] ?? 0;
                $orderQty = $request->product_qty[$idx] ?? 0;

                $subTotal += $productOriginPrice * $orderQty;
                $discountTotal += $productDiscount * $orderQty;

                
                $orderManagementDetailData = [
                    'service_id' => $orderManagementId,
                    'product_id' => $productId,
                    'shop_id' => Auth::user()->shop_id,
                    'quantity' => $orderQty,
                    'price' => $productOriginPrice,
                    'discount_price' => $productDiscount,
                    'seller_id' => $sellerId,
                    'created_at' => new DateTime()
                ];

                DB::table($orderManagementDetailsTable)->insert($orderManagementDetailData);

                if($orderManagementDetailData){
                    $productMainStock = ProductMainStock::where('product_id',$productId)->first();
                   
                    $productMainStock->quantity = $productMainStock->quantity-$orderQty;
                    $productMainStock->save();
                }
            }

            $shippingCostTotal = 0;
            $totalAmount = $calculateTotalAmount->handle($subTotal, $taxRate, $shippingCostTotal, $discountTotal);
            
            //dd($request->all());
            DB::table($orderManagementsTable)
                ->where('id', $orderManagementId)
                ->update([
                    'shipping_name' => $request->shipping_name,
                    'shipping_phone' => $request->shipping_phone,
                    'shipping_address' => $request->shipping_address,
                    'shipping_district' => $request->shipping_district,
                    'shipping_sub_district' => $request->shipping_sub_district,
                    'shipping_province' => $request->shipping_province,
                    'shipping_postcode' => $request->shipping_postcode,
                    'tax_enable' => $request->tax_enable,
                    'tax_invoice_note' => $request->tax_invoice_note,
                    'tax_number' => $request->tax_number,
                    'company_phone_number' => $request->company_phone_number,
                    'company_contact_name' => $request->company_contact_name,
                    'company_name' => $request->company_name,
                    'company_address' => $request->company_address,
                    'company_district' => $request->company_district,
                    'company_thana' => $request->company_thana,
                    'company_postoffice' => $request->company_postoffice,
                    'company_postcode' => $request->company_postcode,
                    'owner_type' => 'private',
                    'customer_id' => $request->customer_id,
                    'product_price_total' => $subTotal,
                    'tax_rate' => $taxRate,
                    'shipping_cost' => $shippingCostTotal,
                    'in_total' => $totalAmount,
                    'updated_at' => new DateTime()
                ]);

            if ($request->customer_type != 1){
                $order->shop_id = Auth::user()->shop_id;
                $order->channel_id = $request->channel_id;
                $order->customer_id = $customerId;
                $order->contact_name = $request->contact_name;
                $order->update();
            }

            DB::commit();

            $responseData = [
                'subTotal' => $subTotal,
                'shippingCost' => $shippingCostTotal,
                'discountTotal' => $discountTotal,
                'totalAmount' => $totalAmount
            ];

            return $this->apiResponse(Response::HTTP_CREATED, 'Order successfully updated.', $responseData);

        } catch (\Throwable $th) {
            report($th);

            DB::rollBack();

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
    }

    public function orderManagementUpdate(Request $request, $id)
    {

        // updated by Fatima
        if ($request->customer_id_main == 0){
            $customer = new Customer();
            $customer->contact_phone = $request->contact_phone_main;
            $customer->customer_name = $request->customer_name_main;
            $customer->seller_id = Auth::id();
            $customer->order_type = 1;
            $customer->save();
        } else{
            $customer = Customer::find($request->customer_id_main);
            $customer->contact_phone = $request->contact_phone_main;
            $customer->customer_name = $request->customer_name_main;
            $customer->order_type = 1;
            $customer->update();
        }

        $channel = Channel::where('name', $request->channel_main)->first();

        $orderManagement = Service::find($id);
        if ($channel)
        $orderManagement->channel_id = $channel->id;
        $orderManagement->shop_id = $request->shop_id;

        $orderManagement->customer_id = $customer->id;
        $orderManagement->contact_name = $request->contact_name_main;
        $orderManagement->shipping_name = $request->shipping_name_main;
        $orderManagement->shipping_phone = $request->shipping_phone_main;
        $orderManagement->shipping_address = $request->shipping_address_main;

        $orderManagement->shipping_district = $request->dis_main;
        $orderManagement->shipping_sub_district = $request->sub_main;
        $orderManagement->shipping_province = $request->pro_main;
        $orderManagement->shipping_postcode = $request->postcodes_main;

        $orderManagement->shipping_methods = $request->shipping_methods;
        $orderManagement->order_status = $request->order_status;
        $orderManagement->payment_status = $request->payment_status;
        $orderManagement->total_discount = $request->total_discount;
        $orderManagement->total_product_weight = $request->total_product_weight;
        $orderManagement->created_by = Auth::user()->id;
        $orderManagement->save();

        ServiceDetail::where('service_id',$orderManagement->id)->delete();

        if(count($request->product_id)>0)
        {
            foreach($request->product_id as $key=>$row)
            {
                $orderManagementDetails = new ServiceDetail();
                $orderManagementDetails->product_id = $row;
                $orderManagementDetails->quantity = $request->product_quantity[$key];
                $orderManagementDetails->shop_id = Auth::user()->shop_id;
                $orderManagementDetails->discount_price = $request->product_discount[$key];
                $orderManagementDetails->seller_id = Auth::user()->id;
                $orderManagementDetails->service_id = $orderManagement->id;
                $orderManagementDetails->save();
            }
        }

        if($orderManagement)
        {
            return redirect('service')->with('success','Your Order Updated Successfully');
        }
        else{
            return redirect('service')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }

    public function orderManagementDelete($id)
    {
        $orderPurchase = Service::where('id',$id)->where('shop_id',Auth::user()->shop_id)->delete();
        ServiceDetail::where('service_id',$id)->where('shop_id',Auth::user()->shop_id)->delete();
        if($orderPurchase)
        {
            return redirect()->back()->with('success','Order Purchase Deleted Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    public function orderManagementCancel(Request $request)
    {
        try {
            $orderManagement = Service::where('id', $request->id)->first();
            $orderManagement->order_status = Service::ORDER_STATUS_CANCEL;
            $orderManagement->save();

            return [
                'status' => 1
            ];

        } catch (\Throwable $th) {
            report($th);

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Something went wrong');
        }
    }

    public function getOrderedProducts(Request $request)
    {
        $orderId = $request->get('orderId', 0);
        $shipmentId = $request->get('shipmentId', 0);

        $orderDetails = ServiceDetail::where('service_id', $orderId)->where('shop_id',Auth::user()->shop_id)->with('product')->get();
        $shipments = ShipmentProduct::where('shipment_id', $shipmentId)->get();

        $productData = [];

        foreach ($orderDetails as $item) {

            $row = [];
            $row[] = '
                <div class="grid grid-cols-1 gap-4">
                    <div>
                        <img src="'. $item->product->image_url .'" class="w-16 md:w-11/12 h-auto" />
                    </div>
                    <div>
                        <span class="whitespace-nowrap text-blue-500">
                            ID : <strong>'. $item->product->id .'</strong>
                        </span>
                    </div>
                </div>
            ';

            $productPrice = $item->price - $item->discount_price;
            $shippedProducts = $item->quantity;
            foreach ($shipments as $shipment){
                if ($shipment->product_id == $item->product_id){
                    $shippedProducts = $shipment->quantity;
                }
            }

            $shippedProductsContents = '';
            if (!empty($shipmentId)){
                $shippedProductsContents = '
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Shipment Qty :
                            </label>
                            <span class="text-gray-900">
                                '. number_format($shippedProducts) .'
                            </span>
                        </div>
                    </div>
                    ';
            }

            $row[] = '
                <div>
                    <div class="mb-1">
                        <strong>'. $item->product->part_name .'</strong>
                    </div>
                    <div class="mb-1">
                        <strong class="text-blue-500">'. $item->product->part_no .'</strong>
                    </div>
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Price :
                            </label>
                            <span>'. currency_symbol('BDT') . number_format(floatval($productPrice), 2) .'</span>
                        </div>
                    </div>
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Ordered Qty :
                            </label>
                            <span class="text-gray-900">
                                '. number_format($item->quantity) .'
                            </span>
                        </div>
                    </div>
                   ' . $shippedProductsContents . '
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Total Price :
                            </label>
                            <strong class="">'. currency_symbol('BDT') . number_format(floatval($productPrice * $shippedProducts), 2) .'</strong>
                        </div>
                    </div>
                </div>
            ';

            $productData[] = $row;
        }

        return response()->json([
            'data' => $productData,
        ]);
    }

    public function getShippingAddress(Request $request)
    {
        $orderId = $request->get('orderId', 0);

        $order = Service::where(['id' => $orderId])->first();

        $data = '';
        if ($order){
            $data = '
                <div>
                    <div class="mb-2 pl-3">
                        <span class="font-bold">'.  strtoupper('Shipping To :') .'</span>
                    </div>
                    <div class="w-full overflow-x-auto">
                        <table class="w-full table table-borderless">
                            <tr>
                                <td class="text-gray-700">Cust. Name</td>
                                <td class="text-blue-600 font-semibold">'.  strtoupper($order->customer->customer_name) .'</td>
                            </tr>
                            <tr>
                                <td class="text-gray-700 align-content-start">Address</td>
                                <td class="">
                                    <span>'. $order->shipping_address .'</span> <br>
                                    <span>'. $order->shipping_sub_district .', </span>
                                    <span>'. $order->shipping_district .',</span> <br>
                                    <span>'. $order->shipping_province .', </span>
                                    <span>'. $order->shipping_postcode .'</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-gray-700">Phone No.</td>
                                <td class="font-bold">'. $order->shipping_phone .'</td>
                            </tr>
                        </table>
                    </div>
                </div>
            ';
        }

        return [
            'data' => $data,
        ];
    }

    /**
     * @TODO put private key in a file and read it here
     */
    public function private_key(){
        $privatekey=<<<EOD
    -----BEGIN RSA PRIVATE KEY-----
    MIICYgIBAAKBgQCPzwGZv5sCMwf8Sv+FXUqrULSEdeB846z2OCnPw+ynDTUqApRz
    0Goj1gYaK5Gu4vLxTH06PpL96sAB9C0pACBz3xewotdAwoHK0B86TaWk0bt4+jSL
    HMAvgLOF2DH5uAlDzYp8KtQAyhXOowds/20POw+Q3m2RgLCMXQ4OzElp8QIDAQAB
    AoGBAI4VecBdZhp7LwWfV+x9axvuRhyllmHuVOKERRNIwZWfYAqct+3hWi0D9c1/
    hJWlF2E/MG8Oig6kFIcZp5OwAvIHsEkJjryQSk4qERpuU99TG9u5ayGmFUPaC0x6
    fzgEw3+ANYOytWTfsxGbUL1SFoZ1yqKD/iKuBE2BXgM6fZbBAkUAv3jyTVA5R+kg
    B3eFSu+hywi87Q2zZ+myBHGBC4Zb3mhmKRoiBMGZS40y9JXNsmrx3IhynQDSiywJ
    7DyX+Bo7SJ90eykCPQDAReuuYuU/wqcqtnscRzVCW9aydquaDYUHOUXWsAGdghtK
    SJFJW717RLHO/3L230f2pl5TBfPG3hGYmYkCRA8O0e9mmbqgCNbNfXwRMGYpP8Jc
    y3kmlctnqcBgRqVNDIu69GXvW8DnT9SQW2bmpjKzwF+8itJLGlSrxz/JwFPLxntR
    Aj0AjT1PqaSAHtxQjDHMMbOlTf/EsQg3ekzgIbRStyhHp3qBrYmtICRCBqEptJM1
    0l+mr2r68yX2M2nBp0VxAkUAkT6IL2UAbBi5mTK2YgakqyWCcFsLg7fGtArKcNiF
    QssbrooyyUHq8GKQ/4IYQO6M80xTf6vY3r3Gxs8LkqoQirHwRN0=
    -----END RSA PRIVATE KEY-----
    EOD;

    return $privatekey;
    }

    /**
     * @TODO put private key in a file and read it here
     */
    public function createPayment($payment_amount,$service_id,$request)
    {
        
        $paymentDetails = new ReceivePayment();
        $paymentDetails->amount = $payment_amount;
        $paymentDetails->paid = $payment_amount;
        $paymentDetails->is_confirmed = 1;
        $paymentDetails->service_id = $service_id;
        $paymentDetails->payment_date = Carbon::now()->format('Y-m-d');
        $paymentDetails->payment_time = Carbon::now()->format('h:i');
        $paymentDetails->payment_method_id = $request->payment_method_id;
        $paymentDetails->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;
        $paymentDetails->account_no_id = $request->account_no_id ?? 0;
        $result = $paymentDetails->save();
        return $paymentDetails->id;
    }


    public function orderStatus($service_id)
    {
         $orderManagement = Service::where('service_id',$service_id)->first();
         set_time_limit(0);
         $random_str = $this->generateRandomString();

         
        $orderManagement->payment_status = 1;
        $orderManagement->payment_channel_from_ksher = $gateway_pay_array['data']['channel'];
        $orderManagement->order_status = 2;
        $orderManagement->payment_date  = $gateway_pay_array['data']['time_end'];
        $result = $orderManagement->save();

        return Redirect::to('/sales_management_customer/'.$service_id)->with('success', 'Your Order Updated Successfully');
        
    }

    public function getSubCatName(){
        $subCategoryID = $_GET['subCategoryID'];
        $cats = Category::select('cat_name')->where('id',$subCategoryID)->first();
        if($cats){
            return $result = array(
                'cat_name'=>$cats->cat_name
            );
        }
        else{
            return 0;
        }
    }

    /**
     * @TODO remove commented code
     */
    public function check_customer_phone(){
        $customer_phone = $_GET['customer_phone'];

        $customers_details = Customer::where('contact_phone', $customer_phone)->first();
        if(!empty($customers_details->contact_phone)){

           $customers_orders_details = Service::where('customer_id', $customers_details->id)->first();
            if (!empty($customers_orders_details)) {
                $contact_name = $customers_orders_details->contact_name;
                if ($customers_orders_details->channels)
                    $channel =  $customers_orders_details->channels->id;
            }
            else {
                $contact_name = '';
                $channel = '';
            }

            return $result = array(
                'customer_id' => $customers_details->id,
                'customer_name'=> $customers_details->customer_name,
                'channel'=> $channel,
                'contact_name'=> $contact_name
            );
        }
        else{
            return 0;
        }
    }

    public function bulkStatus(Request $request)
    {
        if ($request->ajax()) {

            if (isset($request->jSonData) && $request->jSonData != null) {
                $arr = json_decode($request->jSonData);
                foreach ($arr as $webIDOrderID) {

                    //SAVE TO LOCAL DB
                    $orderManagement = Service::find($webIDOrderID);
                    $orderManagement->order_status = $request->status;
                    $orderManagement->save();
                    $flag = 1;
                }

                if($flag==1){
                    echo 'Order Status Changed Successfully';
                }
            }
        }
    }

    /**
     * @TODO remove commented code
     * @TODO refactor DB::table(), use Model
     * @TODO missing return statement, return void
     */
    public function getAllSubCatgeory(Request $request){

        if ($request->ajax()) {
            if (isset($request->categoryID) && $request->categoryID != null && $request->categoryID != 'all') {
                $categoryID = $request->categoryID;
                $data = DB::table('products')
                    ->leftjoin('categories', 'products.category_id', '=', 'categories.id')
                    ->select('products.part_name','categories.*')
                    ->groupBy('products.category_id')
                    ->where('categories.parent_category_id', $categoryID)
                    ->get();
            }
            else{

                $data = DB::table('products')
                    ->leftjoin('categories', 'products.category_id', '=', 'categories.id')
                    ->select('products.part_name','categories.*')
                    ->groupBy('products.category_id')
                    ->where('categories.parent_category_id', '!=', 0)
                    ->get();
            }


            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('image', function ($row) {
                    $image_loc = asset($row->image);
                    $no_image = asset('img/No_Image_Available.jpg');
                    if(!empty($row->image)){
                        return '<img style="text-align:center;" class="text-center" src="'.$image_loc.'" width="60" height="60">';
                    }
                    else{
                        return '<img style="text-align:center;" class="text-center" src="'.$no_image.'" width="60" height="60">';
                    }
                })
                ->addColumn('cat_name', function ($row) {
                    return $row->cat_name;
                })
                ->addColumn('action', function ($row) {
                    return '<a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer subCat" data-id="' . $row->id . '" >Select</a>';
                })
                ->rawColumns(['image','action', 'cat_name'])
                ->make(true);
        }

    }

    /**
     * @TODO remove commented code
     * @TODO refactor DB::table(), use Model
     * @TODO $subCategoryID is undefined
     * @TODO missing return statement, return void
     */
    public function getAllProductCatWise(Request $request){

        if ($request->ajax()) {
            if (isset($request->subCategoryID) && $request->subCategoryID != null && $request->subCategoryID != 'all') {
                $subCategoryID = $request->subCategoryID;
                $data = Product::where('category_id',$subCategoryID)->get();
            }else{
                //$data = Service::where('shop_id',Auth::user()->shop_id)->get();
                $data = Product::where('category_id', $subCategoryID)->get();
            }

            //$data = Service::latest()->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('product_details', function ($row) {
                    $image_loc = asset($row->image);
                    $no_image = asset('img/No_Image_Available.jpg');

                    if(!empty($row->image)){
                        $product_image =  $image_loc;
                    }
                    else{
                        $product_image =  $no_image;
                    }

                    return '
                <div style="float:left; width:21%; marging-right:20px !important;"><img src="'.$product_image.'" width="70" height="70" style="marging-right:25px;"></div>
                <div style="padding-left:38px !important; text-align:left; float:left; width:75%">
                 <strong>ID:</strong>'.$row->id.'<br>
                 '.$row->part_name.'<br>
                 '.$row->part_no.'<br>
                 <strong style="padding-bottom:5px;">Price:</strong>'.$row->price.'<br><br>
                 <a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer add_product_to_cart" data-id="' . $row->part_name . ' ('.$row->part_no.')" >Add to Cart</a>
                </div>';
                })
                ->addColumn('action', function ($row) {
                    // return '
                    // <a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer subCat" data-id="' . $row->id . '" >Select</a>

                    // ';
                })
                ->rawColumns(['product_details','action'])
                ->make(true);
        }
    }


    /**
     * @TODO remove commented code
     * @TODO refactor DB::table(), use Model
     */
    public function get_all_shipping_methods(){
        $totalWeights = $_GET['totalWeights'];
        //echo $totalWeights;
        $shippers =  DB::table('shipping_costs')
            ->join('shippers', 'shipping_costs.shipper_id', '=', 'shippers.id')
            ->select('shipping_costs.id','shipping_costs.name', 'shipping_costs.price', 'shippers.name as shippers_name')
            ->where('shipping_costs.weight_from', '<=', $totalWeights)
            ->where('shipping_costs.weight_to', '>=', $totalWeights)
            ->get();

            //echo count($shippers);exit;
        return view('seller.service.all_shippers', compact('shippers'));
    }

    public function getOrderHistory(Request $request){
        $editData = Service::where('id',$request->service_id)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();

        $data = [];
        if(isset($editData->orderProductDetails) && count($editData->orderProductDetails)>0){
            $priceAndShop = [];
            foreach($editData->orderProductDetails as $key=>$row)
            {
                $price = ProductPrice::where('shop_id',Auth::user()->shop_id)->where('product_id',$row->product->id)->where('shop_id',$row->shop_id)->first();

                if(!empty($price->price))
                {
                    $priceAndShop[$key]['price'] = $price->price;
                }
                else
                {
                    $priceAndShop[$key]['price'] = '';
                }
                if(!empty($price->shop_id))
                {
                    $priceAndShop[$key]['shop'] = $price->shop_id;
                }
                else
                {
                    $priceAndShop[$key]['shop'] = '';
                }
                if(!empty($row->shop_id))
                {
                    $getShopId = 'shop_id'.$row->shop_id;
                }
                else{
                    $getShopId = '';
                }

                array_push($data,$row->product->part_no.$getShopId);
            }
        }
        Session::put('itemArray',$data);
        return view('seller.service.getOrderHistory', compact('editData', 'priceAndShop'));
    }

    public function createShipment(Request $request){
        $shipments = new Shipment();
        $shipments->service_id = $request->service_id;
        $shipments->shipment_date  = Carbon::parse($request->shipment_date)->format('Y-m-d');
        $shipments->shipment_status = Shipment::SHIPMENT_STATUS_READY_TO_SHIP;
        $shipments->seller_id = Auth::user()->id;
        $result = $shipments->save();
        if($result)
        {
            $orderManagement = Service::find($request->service_id);
            $orderManagement->order_status = Shipment::SHIPMENT_STATUS_READY_TO_SHIP;
            $orderManagement->save();
            $qrcode = 'ACS'.$shipments->id;
            QrCode::generate($qrcode, public_path('public/shipments_qrcodes/' . $qrcode . '.svg'));
            return redirect('service')->with('success','Your Shipment Created Successfully');
        }
        else{
            return redirect('service')->with('danger','Something happened wrong');
        }
    }

    /**
     * @TODO Go through the statements, remove unused or commented codebase
     * @TODO refactor code, a lot of static strings used here, use ENV
     * @TODO not sure why you're detecting mobile usage, refactor or make helper function for that
     * @TODO set_time_limit(0) is inefficient, shouldn't be used at all
     * @TODO if your execution requires time, you can queue it. Refactor set_time_limit
     */
    public function makeOrderPayment(Request $request){

    if(empty($request->shipping_name_main)){
        return Redirect::back()->with('danger','Shipping Address must be filled up');
    }
    if(empty($request->payment_method)){
        return Redirect::back()->with('danger','You need to select payment method');
    }

    if($request->payment_method == 2){
        if(isset($_SERVER['HTTP_USER_AGENT']) and !empty($_SERVER['HTTP_USER_AGENT'])){
           $user_ag = $_SERVER['HTTP_USER_AGENT'];
           if(preg_match('/(Mobile|Android|Tablet|GoBrowser|[0-9]x[0-9]*|uZardWeb\/|Mini|Doris\/|Skyfire\/|iPhone|Fennec\/|Maemo|Iris\/|CLDC\-|Mobi\/)/uis',$user_ag)){
               $device = 'h5';
           }
           else{
               $device = 'PC';
        }
    };

    $fee = 1;
    $appid='mch37567';
    $privatekey = $this->private_key();

    set_time_limit(0);
    $class = new KsherPay($appid, $privatekey);

    //$service_id_with =  Crypt::encryptString($request->service_id);
    $encryted_service_id = $request->encryted_service_id;
    $part_name = $request->shop_name.' order';

    $gateway_pay_data = array('mch_order_no'=>$request->service_id,
        "total_fee" => round($fee, 2)*100,
        "fee_type" => 'BDT',
        "channel_list" => 'bbl_promptpay,wechat,alipay,truemoney,airpay,linepay,ktbcard',

        'mch_code' => $request->service_id,
        'mch_redirect_url' => url('order_status/'.$encryted_service_id),
         //'mch_redirect_url_fail' => 'http://www.ksher.com',
        'mch_redirect_url_fail' => url('sales_management_customer/'.$encryted_service_id),
        'part_name' => $part_name,
        'refer_url' => 'http://dodostock/public',
        'device' => $device,
        'expire_time' => 5,
        'logo' =>$request->shop_logo,
        'time_stamp' =>date("YmdHis", time())
    );

    $gateway_pay_response = $class->gateway_pay($gateway_pay_data);
    $gateway_pay_array = json_decode($gateway_pay_response, true);


    if (isset($gateway_pay_array['data']['pay_content'])){


            $orderManagement = Service::where('id',$request->service_id)->first();
            $orderManagement->shipping_methods = $request->shipping_methodss;
            $orderManagement->shipping_cost = $request->shipping_cost;
            $orderManagement->in_total = $request->in_total;
            $orderManagement->shipping_name = $request->shipping_name_main;
            $orderManagement->shipping_phone = $request->shipping_phone_main;
            $orderManagement->shipping_address = $request->shipping_address_main;

            $orderManagement->place_order_time = Carbon::now()->format('Y-m-d H:i:s');
            $orderManagement->sign = $gateway_pay_array['sign'];
            $orderManagement->shipping_district = $request->dis_main;
            $orderManagement->shipping_sub_district = $request->sub_main;
            $orderManagement->shipping_province = $request->pro_main;
            $orderManagement->shipping_postcode = $request->postcodes_main;
            $orderManagement->save();


        return \Redirect::to($gateway_pay_array['data']['pay_content']);

        }else{
            print_r($gateway_pay_array);
        }
        exit();
    }

    if($request->payment_method == 1){

        if(empty($request->payment_date) || empty($request->payment_time) || empty($request->payment_slip)){
            return Redirect::back()->with('danger','Bank Details must be filled up');
        }
        //$service_id = $request->service_id;
        $orderPayments = new Payment();
        $orderPayments->service_id = $request->service_id;

        $orderPayments->amount = $request->in_total_inputs;
        //$orderPayments->payment_status = 1;
        $orderPayments->payment_method = 'Bank Transfer';

        $orderPayments->payment_date  = Carbon::parse($request->payment_date)->format('Y-m-d');

        $orderPayments->payment_time = $request->payment_time;
        $orderPayments->is_confirmed = 0;
        if ($request->hasFile('payment_slip')) {
                $upload = $request->file('payment_slip');
                // $file_type = $upload->getClientOriginalExtension();
                $upload_name =  time() . '_' . Str::random(10) . '_' . $upload->getClientOriginalName();
                $destinationPath = public_path('uploads/payment_slip');
                $upload->move($destinationPath, $upload_name);
                $orderPayments->payment_slip = 'uploads/payment_slip/'.$upload_name;
        }
        $orderPayments->save();

        return Redirect::back()->with('success','Your Order has been successfully Placed.');

    }


    }

    public function orderDelete(Request $request)
    {
        $Service = Service::where('id',$request->id)->delete();
        Service::where('service_id',$request->id)->where('shop_id',Auth::user()->shop_id)->delete();
        if($Service)
        {
             return [
                'status' => 1
             ];
        }
     }

    /**
     * @TODO not sure why you're detecting mobile usage, refactor or make helper function for that
     */
    public function isMobile(){
        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }

    /**
     * @TODO Go through the statements, remove unused or commented codebase
     * @TODO set_time_limit(0) is inefficient, shouldn't be used at all
     * @TODO if your execution requires time, you can queue it. Refactor set_time_limit
     */
    public function isPaymentSuccess(){
        $order_primary_id = $_GET['service_id'];
        //echo $order_primary_id; exit;
        $orderManagement = Service::select('payment_status', 'service_id', 'place_order_time')->where('id',$order_primary_id)->first();

        if($orderManagement->payment_status == 0 && isset($orderManagement->place_order_time)){

             $appid='mch37567';
             $privatekey = $this->private_key();
             set_time_limit(0);
             //$random_str = $this->generateRandomString();

             $class = new KsherPay($appid, $privatekey);
             $order_query_request_param = array(
                'mch_order_no'=>$orderManagement->id,
                'appid'=>$appid,
                //'nonce_str'=>$random_str,
                //'sign'=>$orderManagement->sign,
                //'time_stamp' =>Carbon::now()->format('Ymdhis')
            );

            $gateway_pay_response = $class->gateway_order_query($order_query_request_param);
            $gateway_pay_array = json_decode($gateway_pay_response, true);


        if(isset($gateway_pay_array['code']) && $gateway_pay_array['code'] == 0 && $gateway_pay_array['data']['result'] == 'SUCCESS'){

            $orderManagement->payment_status = 1;
            $orderManagement->payment_channel_from_ksher = $gateway_pay_array['data']['channel'];
            $orderManagement->order_status = 2;
            $orderManagement->payment_date  = $gateway_pay_array['data']['time_end'];
            $result = $orderManagement->save();

            if($result){
                $orderPayments = new ReceivePayment();
                $orderPayments->service_id = $order_primary_id;
                $orderPayments->payment_status = 1;
                $orderPayments->payment_method = $gateway_pay_array['data']['channel'];
                $orderPayments->payment_date  = $gateway_pay_array['data']['time_end'];
                $orderPayments->save();
             }
            }

            $orderManagement = Service::select('payment_status', 'service_id', 'place_order_time', 'order_status', 'payment_date')->where('id',$order_primary_id)->first();
                return json_encode($orderManagement);
        }
    }

    /**
     * @TODO Like I mentioned above, use built-in method for random string
     */
    function generateRandomString($length = 10) {
        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
    }

    public function getOrderPaymentDetails(Request $request){
        $paymentDetails = ReceivePayment::where('service_id',$request->service_id)->first();

        $data = [
            'amount'=>$paymentDetails->amount,
            'paid'=>$paymentDetails->amount,
            'payment_date'=>date('d/m/Y', strtotime($paymentDetails->payment_date)),
            'payment_time'=>$paymentDetails->payment_time,
            'payment_slip'=>$paymentDetails->payment_slip
        ];
        return $data;


    }

    public function confirmPaymentForOrder(Request $request){
            $paymentDetails = ReceivePayment::where('service_id',$request->service_id)->first();
            $paymentDetails->is_confirmed = 1;
            $result = $paymentDetails->save();
            if($result){
                 $orders = Service::find($request->service_id);
                 $orders->payment_status = 1;
                 $orders->is_confirmed = 1;
                 $orders->order_status = Service::ORDER_STATUS_PROCESSING;
                 $orders->payment_channel_from_ksher = 'Bank Transfer';
                 $orders->payment_date  = Carbon::parse($request->payment_date)->format('Y-m-d h:i:s');
                 $orders->save();
            }
            return "ok";
    }

    public function makeNewPayment(Request $request){

            $paymentDetails = new ReceivePayment();
            $paymentDetails->shop_id = Auth::user()->shop_id;
            $paymentDetails->amount = $request->payment_amount;
            $paymentDetails->paid = $request->payment_amount;
            $paymentDetails->is_confirmed = $request->is_confirmed;
            $paymentDetails->service_id = $request->service_id;
            $paymentDetails->payment_date = Carbon::now()->format('Y-m-d');
            $paymentDetails->payment_time = Carbon::now()->format('h:i');
            $paymentDetails->payment_method_id = $request->payment_method_id;
            $paymentDetails->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;
            $paymentDetails->account_no_id = $request->account_no_id ?? 0;
            $paymentDetails->is_refund = $request->is_refund;
            $result = $paymentDetails->save();

            if($result){
                $orderManagementDtl = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
                $manualPaymentSumDtl = Service::getManualPaymentSum($request->service_id);
                $manualRefundedSumDtl = Service::getManualRefundedSum($request->service_id);
                $totalPaidAmount = $manualPaymentSumDtl - $manualRefundedSumDtl;

                if($orderManagementDtl->in_total == $totalPaidAmount){
                    $orders = Service::find($request->service_id);
                     $orders->payment_status = Service::PAYMENT_STATUS_PAID;
                     $orders->order_status = Service::ORDER_STATUS_COMPLETED;
                     $orders->save();
                }

                if($orderManagementDtl->in_total == $manualRefundedSumDtl){
                    $orders = Service::find($request->service_id);
                     $orders->payment_status = Service::PAYMENT_STATUS_UNPAID;
                     $orders->order_status = Service::ORDER_STATUS_PENDING;
                     $orders->save();
                }
             }

            $orderManagement = Service::select('service_id','in_total', 'payment_status')->where('id',$request->service_id)->first();
            $manualPaymentSum = Service::getManualPaymentSum($request->service_id);
            $manualRefundedSum = Service::getmanualRefundedSum($request->service_id);

            $paymentDetailsAllManual = ReceivePayment::where('service_id',$request->service_id)->get();

            return view('seller.service.payment_table', compact('manualPaymentSum', 'paymentDetailsAllManual', 'orderManagement', 'manualRefundedSum'));
    }

    /**
     * @TODO Go through the statements, remove unused or commented codebase
     */
    public function updateManualPayment(Request $request){


            
            $paymentDetails = ReceivePayment::find($request->payment_id);
            
            $paymentDetails->amount = $request->amount;
            $paymentDetails->paid = $request->amount;
            $paymentDetails->is_confirmed = $request->is_confirmed;
            $paymentDetails->payment_method_id = $request->payment_method_id;
            $paymentDetails->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;
            $paymentDetails->account_no_id = $request->account_no_id ?? 0;
            $paymentDetails->is_refund = $request->is_refund;

            $result = $paymentDetails->save();

             if($result){
                $orderManagementDtl = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
                
                $manualPaymentSumDtl = Service::getManualPaymentSum($request->service_id);
                $manualRefundedSumDtl = Service::getManualRefundedSum($request->service_id);
                $totalPaidAmount = $manualPaymentSumDtl - $manualRefundedSumDtl;
                
                if($orderManagementDtl->in_total == $totalPaidAmount){
                     $orders = Service::find($request->service_id);
                     $orders->payment_status = Service::PAYMENT_STATUS_PAID;
                     $orders->payment_channel_from_ksher = 'manual';
                     //$orders->payment_date  = Carbon::parse($request->payment_date)->format('Y-m-d h:i:s');
                     $orders->order_status = Service::ORDER_STATUS_COMPLETED;
                     $orders->save();
                }
                
                if($orderManagementDtl->in_total == $manualRefundedSumDtl){
                    $orders = Service::find($request->service_id);
                     $orders->payment_status = Service::PAYMENT_STATUS_UNPAID;
                     $orders->order_status = Service::ORDER_STATUS_PENDING;
                     $orders->save();
                }

            }

            $orderManagement = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
            $manualPaymentSum = Service::getManualPaymentSum($request->service_id);
            $manualRefundedSum = Service::getmanualRefundedSum($request->service_id);
            $paymentDetailsAllManual = ReceivePayment::where('service_id',$request->service_id)->get();

            return view('seller.service.payment_table', compact('manualPaymentSum', 'paymentDetailsAllManual', 'orderManagement', 'manualRefundedSum'));
    }


    public function getManualPaymentData(Request $request){
        $accounts = Account::get();
        $payment_methods = PaymentMethod::get();
        $banks_or_mobiles = BanksOrMobiles::get();
        
        $paymentDetails = ReceivePayment::where('id',$request->payment_id)->first();
        if($paymentDetails){
         $orderDetails = Service::where('id',$paymentDetails->service_id)->first();
        }
        $manualPaymentSum = ReceivePayment::where('service_id',$paymentDetails->service_id)->where('is_confirmed',1)->where('is_refund',0)->sum('amount');
         $manualRefundedSum = ReceivePayment::where('service_id',$paymentDetails->service_id)->where('is_confirmed',1)->where('is_refund',1)->sum('amount');
         $paymentDetailsAllManual = ReceivePayment::where('service_id',$paymentDetails->service_id)->get();
         $paymentDetailsOthers = ReceivePayment::where('service_id', $paymentDetails->service_id)->first(); 
        $data = array(
            'accounts'=>$accounts,
            'payment_methods'=>$payment_methods,
            'banks_or_mobiles'=>$banks_or_mobiles,
            'paymentDetails'=>$paymentDetails,
            'orderDetails'=>$orderDetails,
            'manualPaymentSum'=>$manualPaymentSum,
            'manualRefundedSum'=>$manualRefundedSum,
            'paymentDetailsAllManual'=>$paymentDetailsAllManual,
            'paymentDetailsOthers'=>$paymentDetailsOthers,
        );
             
        return view('elements.form-edit-order-payment', $data);

    }

    public function delManualPaymentData(Request $request){
        $result = ReceivePayment::where('id', $request->payment_id)->delete();

        if($result){
                $orderManagementDtl = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
                $manualPaymentSumDtl = Service::getManualPaymentSum($request->service_id);
                $manualRefundedSumDtl = Service::getManualRefundedSum($request->service_id);
                $totalPaidAmount = $manualPaymentSumDtl - $manualRefundedSumDtl;

                if($orderManagementDtl->in_total != $totalPaidAmount){
                     $orders = Service::find($request->service_id);
                     $orders->payment_status = Service::PAYMENT_STATUS_UNPAID;
                     $orders->order_status = Service::ORDER_STATUS_PENDING;
                     $orders->save();
                }

        }

        $orderManagement = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
        $manualPaymentSum = Service::getManualPaymentSum($request->service_id);
        $manualRefundedSum = Service::getmanualRefundedSum($request->service_id);
        $paymentDetailsAllManual = ReceivePayment::where('service_id',$request->service_id)->get();

        return view('seller.service.payment_table', compact('manualPaymentSum', 'paymentDetailsAllManual', 'orderManagement', 'manualRefundedSum'));

    }

    public function bulkShipment(Request $request)
    {

        if ($request->ajax()) {

            if (isset($request->jSonData) && $request->jSonData != null) {
                $arr = json_decode($request->jSonData);
                foreach ($arr as $webIDOrderID) {

                    $orderManagement = Service::find($webIDOrderID);
                    $orderManagement->order_status = Service::ORDER_STATUS_PROCESSED;
                    $result = $orderManagement->save();

                    if($result){
                        $shipments = new Shipment();
                        $shipments->service_id = $webIDOrderID;
                        $shipments->shipment_date  = Carbon::parse($request->shipment_date)->format('Y-m-d');
                        $shipments->seller_id = Auth::user()->id;
                        $shipments->save();
                    }
                }

               echo "OK";
            }
        }
    }

    public function changeBankPaymentStatus(Request $request){
       $paymentDetails = ReceivePayment::find($request->payment_id);
       $paymentDetails->is_confirmed = 1;
       $result = $paymentDetails->save();

       if($result){
            $orderManagementDtl = Service::find($request->service_id);
            $orderManagementDtl->payment_status = 1;
            $orderManagementDtl->order_status = Service::ORDER_STATUS_PROCESSING;
            $orderManagementDtl->save();
       }

         $orderManagement = Service::select('in_total', 'payment_status')->where('id',$request->service_id)->first();
         $manualPaymentSum = ReceivePayment::where('service_id',$request->service_id)->where('is_confirmed',1)->where('is_refund',0)->sum('amount');
         $manualRefundedSum = ReceivePayment::where('service_id',$request->service_id)->where('is_confirmed',1)->where('is_refund',1)->sum('amount');
         $paymentDetailsAllManual = ReceivePayment::where('service_id',$request->service_id)->get();
         $paymentDetailsOthers = ReceivePayment::where('service_id', $request->service_id)->first();

         return view('seller.service.payment_table', compact('manualPaymentSum', 'paymentDetailsAllManual', 'orderManagement', 'paymentDetailsOthers', 'manualRefundedSum'));

    }
    /**
     * @TODO Go through the statements, remove unused or commented codebase
     */
    public function getAllOrderedPro(Request $request){
        $allShipments = Shipment::where('service_id',$request->orderId)->get();

        $editData = Service::where('id',$request->orderId)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();

        $totalOrderedQty = ServiceDetail::where('service_id',$request->orderId)->where('shop_id',Auth::user()->shop_id)->sum('quantity');

        $data = [];
        $product_price = [];

        // dd($editData->orderProductDetails);
        if(isset($editData->orderProductDetails) && count($editData->orderProductDetails)>0){


            foreach($editData->orderProductDetails as $key=>$row)
            {

                if(empty($row->discount_price) || $row->discount_price == NULL){
                    $product_price[$key]['price'] = $row->product->price;
                }
                else{
                    $product_price[$key]['price'] = $row->discount_price;
                }

            }
        }

        return view('seller.service.getAllOrderedPro', compact('editData', 'product_price', 'allShipments', 'totalOrderedQty'));
    }


    public function getAllOrderedProForOrder(Request $request){

        $editData = Service::where('id',$request->orderId)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();

        $totalOrderedQty = ServiceDetail::where('service_id',$request->orderId)->where('shop_id',Auth::user()->shop_id)->sum('quantity');

        $data = [];
        $product_price = [];

        if(isset($editData->orderProductDetails) && count($editData->orderProductDetails)>0){

            foreach($editData->orderProductDetails as $key=>$row)
            {

                if(empty($row->discount_price) || $row->discount_price == NULL){
                    $product_price[$key]['price'] = $row->product->price;
                }
                else{
                    $product_price[$key]['price'] = $row->discount_price;
                }

                $getShippedQty = ShipmentProduct::where('service_id', $row->service_id)
                ->where('product_id', $row->product_id)
                ->sum('quantity');

                if(!empty($getShippedQty)){
                    $product_price[$key]['shipped_qty'] = $getShippedQty;
                }
                else{
                    $product_price[$key]['shipped_qty'] = 0;
                }
             }
        }

        return view('seller.service.getAllOrderedProForOrder', compact('editData', 'product_price', 'totalOrderedQty'));
    }

    public function getAllOrderedProForOrderEdit(Request $request){

        $editData = Service::where('id',$request->orderId)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();

        $totalOrderedQty = ServiceDetail::where('service_id',$request->orderId)->where('shop_id',Auth::user()->shop_id)->sum('quantity');

        $shipmentDetails = Shipment::where('id',$request->shipment_id)->first();

        $data = [];
        $product_price = [];
        $shipmentQtyPerPro = [];

        if(isset($editData->orderProductDetails) && count($editData->orderProductDetails)>0){

            foreach($editData->orderProductDetails as $key=>$row)
            {

                if(empty($row->discount_price) || $row->discount_price == NULL){
                    $product_price[$key]['price'] = $row->product->price;
                }
                else{
                    $product_price[$key]['price'] = $row->discount_price;
                }

                $getShippedQty = ShipmentProduct::where('service_id', $row->service_id)
                ->where('product_id', $row->product_id)
                ->sum('quantity');

                if(!empty($getShippedQty)){
                    $product_price[$key]['shipped_qty'] = $getShippedQty;
                }
                else{
                    $product_price[$key]['shipped_qty'] = 0;
                }

                $shipmentQtyPerProduct = ShipmentProduct::where('service_id', $row->service_id)
                ->where('product_id', $row->product_id)
                ->where('shipment_id', $request->shipment_id)
                ->first();

                if(!empty($shipmentQtyPerProduct->quantity)){
                    $shipmentQtyPerPro[$key]['shipment_qty'] = $shipmentQtyPerProduct->quantity;
                }
                else{
                    $shipmentQtyPerPro[$key]['shipment_qty'] = 0;
                }
             }
        }

        return view('seller.service.getAllOrderedProForOrderEdit', compact('editData', 'product_price', 'totalOrderedQty', 'shipmentQtyPerPro', 'shipmentDetails'));
    }


    public function orderTakeAction(Request $request){
        try{
            if($request->action_value == '0'){
                $orderManagement = Service::where('id', $request->service_id)->first();
                $orderManagement->order_status = Service::ORDER_STATUS_CANCEL;
                $orderManagement->save();

            /* Add data to stock before deleting item*/
            if($orderManagement){
                $previousData = ServiceDetail::where('service_id',$request->service_id)->get();
                if($previousData){
                    foreach($previousData as $item){
                        $productMainStock = ProductMainStock::where('product_id',$item->product_id)->first();
                        
                        $productMainStock->quantity = $productMainStock->quantity+$item->quantity;
                        $productMainStock->save();
                    }
                }
            }

            }

            if($request->action_value == '2' || $request->action_value == '4'){
                $orderManagement = Service::where('id', $request->service_id)->first();
                $orderManagement->order_status = Service::ORDER_STATUS_PROCESSING;
                $orderManagement->save();

            /* substract data to stock before deleting item*/
                if($orderManagement){
                $previousData = ServiceDetail::where('service_id',$request->service_id)->get();
                if($previousData){
                    foreach($previousData as $item){
                        $productMainStock = ProductMainStock::where('product_id',$item->product_id)->first();
                        
                        $productMainStock->quantity = $productMainStock->quantity - $item->quantity;
                        $productMainStock->save();
                    }
                }
                }
            }

            if($request->action_value == 9){
                $orderManagement = Service::where('id', $request->service_id)->first();
                $orderManagement->order_status = Service::ORDER_STATUS_PENDING;
                $orderManagement->save();

                /* substract data to stock before deleting item*/
                if($orderManagement){
                    $previousData = ServiceDetail::where('service_id',$request->service_id)->get();
                    if($previousData){
                        foreach($previousData as $item){
                            $productMainStock = ProductMainStock::where('product_id',$item->product_id)->first();
                            
                            $productMainStock->quantity = $productMainStock->quantity - $item->quantity;
                            $productMainStock->save();
                        }
                    }
                }
            }
        }
        catch (\Throwable $th) {
            report($th);

            DB::rollBack();

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
         /**
         * @TODO use Exception instead of Throwable
         */
    }

    /**
     * @TODO Go through the statements, remove unused or commented codebase
     * There duplicate calls of Service
     * @TODO collect Service with common query and query on the collection
     */
    public function getShipmentDetailsData(Request $request){
        $service_id = $request->service_id;
        $getAllOredredDetails = Service::getAllOredredDetails($request->service_id);
        $allShipments = DB::table('shipments')
                    ->leftJoin('services', 'services.id', '=', 'shipments.service_id')
                    ->leftJoin('customers', 'services.customer_id', '=', 'customers.id')
                    ->select('shipments.*', 'customers.customer_name')
                    ->where('shipments.seller_id', '=', Auth::user()->id)
                    ->where('shipments.is_custom', '=', 0)
                    ->where('shipments.service_id', '=', $request->service_id)
                    ->get();

        $order = Service::findOrFail($service_id);
        

        return view('seller.service.shipmentDetails', compact('service_id', 'getAllOredredDetails', 'allShipments', 'shippingMethod'));
    }

    public function getCustomShipmentDetailsData(Request $request){
        $service_id = $request->service_id;
        $allShipments = Shipment::where('shipments.seller_id', '=', Auth::user()->id)
                     ->where('shipments.service_id', '=', $request->service_id)
                     ->where('shipments.is_custom', '=', 1)
                     ->leftJoin('services', 'services.id', '=', 'shipments.service_id')
                    ->leftJoin('customers', 'services.customer_id', '=', 'customers.id')
                    ->select('shipments.*', 'customers.customer_name')
                    ->get();

        return view('seller.service.customShipmentDetails', compact('service_id', 'allShipments'));

    }

    public function getModalContentForCustomShipment(Request $request){
        $service_id = $request->orderId;
        $editData = Service::where('id',$request->orderId)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();
        return view('seller.service.getModalContentForCustomShipment', compact('service_id', 'editData'));
    }

    public function getModalContentForEditCustomShipment(Request $request){
        $service_id = $request->orderId;
        $use_for = $request->use_for;
        $editData = Service::where('id',$request->orderId)->with('orderProductDetails')->where('shop_id',Auth::user()->shop_id)->first();
        $shipmentDetails = Shipment::where('id',$request->shipment_id)->first();
        $getShipmentsProductsDetails = ShipmentProduct::where('shipment_id',$request->shipment_id)
                                     ->leftJoin('products', 'shipment_products.product_id', '=', 'products.id')
                                     ->select('products.*', 'shipment_products.quantity')
                                     ->get();

        if($use_for == 'edit'){
         return view('seller.service.getModalContentForEditCustomShipment', compact('service_id', 'editData', 'shipmentDetails', 'getShipmentsProductsDetails'));
        }

        if($use_for == 'view'){
        return view('seller.service.getModalContentForViewCustomShipment', compact('service_id', 'editData', 'shipmentDetails', 'getShipmentsProductsDetails'));
        }


    }

    public function getOrderedProductDetails(Request $request){
        $service_id = $request->orderId;
        $product_id = $request->product_id;
        $editData = Product::where('id',$request->product_id)->where('shop_id',Auth::user()->shop_id)->first();

        $shipped_qty = '';
        $product_price = '';
        if(isset($editData)){

            $getShippedQty = ShipmentProduct::where('service_id', $request->orderId)
            ->where('product_id', $request->product_id)
            ->sum('quantity');

            if(!empty($getShippedQty)){
                $shipped_qty = $getShippedQty;
            }
            else{
                $shipped_qty = 0;
            }

        }

        return view('seller.service.orderedProductedDetails', compact('service_id', 'editData', 'shipped_qty', 'product_price'));
    }


    /**
     * @TODO Go through the statements, remove unused or commented codebase
     */
    public function allShipmentData(Request $request)
    {
          if ($request->ajax()) {
            if (isset($request->service_id) && $request->service_id != null) {
                $service_id = $request->service_id;
                $data = DB::table('shipments')
                    ->leftJoin('services', 'services.service_id', '=', 'shipments.service_id')
                    ->select('shipments.*')
                    ->where('shipments.seller_id', '=', Auth::user()->id)
                    ->where('shipments.service_id', '=', $request->service_id)
                    ->get();

            }

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($row) {
                    return $row->id;
                })
                ->addColumn('shipment_data', function ($row) {
                    $ordersDetails = ServiceDetail::select('id')->where('service_id',$row->service_id)->where('shop_id',Auth::user()->shop_id)->get();
                })
                ->rawColumns(['checkbox','shipment_data'])
                ->make(true);
        }
    }

    public function deleteShipmentForOrder(Request $request){
        $shipment = Shipment::where('id', $request->shipment_id)->where('seller_id', Auth::user()->id)->first();

        if($shipment) {
            $order = Service::where('id', $shipment->service_id)->first();
            $order->order_status = Service::ORDER_STATUS_PROCESSING;
            $order->update();

            $result = $shipment->delete();
            if ($result) {
                ShipmentProduct::where('shipment_id', $request->shipment_id)->delete();
            }
        }
    }

    public function deleteCustomShipmentForOrder(Request $request){
        $result = Shipment::where('id',$request->shipment_id)->delete();
        if($result){
             ShipmentProduct::where('shipment_id',$request->shipment_id)->delete();
        }

    }
     public function markAsShipped(Request $request){
       $shipments = Shipment::find($request->shipment_id);
       $shipments->shipment_status = Shipment::SHIPMENT_STATUS_SHIPPED;
       $shipments->mark_as_shipped_status = 1;
       $shipments->mark_as_shipped_date_time = Carbon::now()->format('Y-m-d h:i:s');
       $shipments->mark_as_shipped_by = Auth::user()->id;
       $result = $shipments->save();
    }

    public function updateOrderStatus($orderId,$orderStatus)
    {
        try {
            $orderDetails = Service::where('id', $orderId)->first();           
            $orderDetails->order_status = $orderStatus;
            $orderDetails->update();

           

            return $this->apiResponse(Response::HTTP_OK, 'Order Status successfully updated.');

        } catch (\Throwable $th) {
            report($th);

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
    }
    
    public function updateOrderStatusByUser(Request $request)
    {
        try {
            $orderId = $request->id;

            $orderDetails = Service::where('id', $orderId)->first();
            $orderDetails->order_status = $request->orderStatus;
            $orderDetails->update();

            return $this->apiResponse(Response::HTTP_OK, 'Order Status successfully updated.');

        } catch (\Throwable $th) {
            report($th);

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
    }

}
