<?php

namespace App\Http\Controllers;
use App\Models\ActivityLog;

use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Expenses;
use App\Models\Customers;
use App\Models\Category;
use App\Models\Employees;
use App\Models\OrderManagement;
use App\Models\OrderManagementDetail;
use App\Models\Purchase;
use App\Models\PurchaseDetails;
use App\Models\StockIn;
use App\Models\PaymentMethods;
use App\Models\Suppliers;
use App\Models\Lenders;
use App\Models\Partner;

use App\Models\Payments;
use App\Models\ReceivePayment;

use App\Models\BanksOrMobiles;
use App\Models\Investment;
use App\Models\StockLog;
use App\Models\Coupon;
use App\Models\initialTransaction;

use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

class ReportController extends Controller
{

    public function initialTransaction(Request $request)
    {
        
        
        $initialTransaction = InitialTransaction::select('*',DB::raw('sum(amount) as total')                                )
                ->groupBy('transaction_type','type')
                
                ->get();


        $data = [
            'initialTransaction' => $initialTransaction
        ];

        return view('seller.report.initial-transaction.index',$data);
    }


    public function pettycash()
    {
        $time = Carbon::now()
        ->setTimezone('Asia/Kolkata')
        ->toDateTimeString();
       
        $payment_date = date('Y-m-d', strtotime($time));
        $previousDaysCashInHand = $this->getPreviousDaysClosingBalance($payment_date);  
        $previous_date = date('Y-m-d', strtotime('-1 day', strtotime($payment_date)));
        //dd($previousDaysCashInHand);

        $suppliers = Suppliers::where('seller_id',Auth::user()->id)->get();

        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customers())->getTable();

        $orderManagements = OrderManagement::selectRaw("{$orderManagementsTable}.*,
                                {$customersTable}.customer_name AS customer_name,
                                {$customersTable}.phone AS customer_contact_phone")
                ->with('shop')
                ->totalPaid()
                ->with('services_details')
                ->withCount('order_management_details')
                ->joinedDatatable();

                if($payment_date){
                    $orderManagements->where("{$orderManagementsTable}.order_date", $payment_date);
                }

        $purchases = Purchase::with(['purchase_details' => function ($query) {
                        $query->with('product');
                    }])
                    ->with('supplier')
                    ->withCount('purchase_details');
        if($payment_date){
            $purchases->where("purchases.order_date", $payment_date);
        }
               


        $cashIn = ReceivePayment::with(['customer' => function ($query) {
            $query->whereNotNull('customers.id');
        }])
        ->with(['lender' => function ($query) {
            $query->whereNotNull('lenders.id');
        }])
        ->with('mobileOrBank')
        ->with('payment_method')        
        ->with('account')
        ->where('payment_date',$payment_date)
        ->get();
    

       
                                
                            
                          
        $cashOut = Payments::with(['supplier' => function ($query) {
                        $query->whereNotNull('suppliers.id');
                    }])
                    ->with(['lender' => function ($query) {
                        $query->whereNotNull('lenders.id');
                    }])
                    ->with(['employee' => function ($query) {
                        $query->whereNotNull('employees.id');
                    }])
                    ->with('payment_method')
                    ->with('mobileOrBank')
                    ->with('account')
                    ->where('payment_date',$payment_date)
                    ->get();
       
        $expenses = Expenses::with('expense_details')
                    ;

        if($payment_date){
            $expenses->where("expenses.entry_date", $payment_date);
        }

        
     
        $data = [
            'openning_balance' => isset($previousDaysCashInHand[$previous_date]) ? $previousDaysCashInHand[$previous_date] : 0,
            'payments' => Payments::orderBy('type')->get(),
            'orderManagements' => $orderManagements->get(),
            'purchases' => $purchases->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses->get()
        ];
        return view('seller.report.pettycash',$data);
    }



    public function ajaxPettyCash(Request $request)
    {
        $payment_date = date('Y-m-d', strtotime($request->payment_date));
        $previousDaysCashInHand = $this->getPreviousDaysClosingBalance($payment_date);  
        $previous_date = date('Y-m-d', strtotime('-1 day', strtotime($payment_date)));

        $suppliers = Suppliers::where('seller_id',Auth::user()->id)->get();
        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customers())->getTable();

        $orderManagements = OrderManagement::selectRaw("{$orderManagementsTable}.*,
                                {$customersTable}.customer_name AS customer_name,
                                {$customersTable}.phone AS customer_contact_phone")
                ->where("{$orderManagementsTable}.shop_id", Auth::user()->shop_id)
                ->with('shop')
                ->totalPaid()
                ->with('services_details')
                ->withCount('order_management_details')
                ->joinedDatatable();

                if($payment_date){
                    $orderManagements->where("{$orderManagementsTable}.order_date", $payment_date);
                }

        $purchases = Purchase::with(['purchase_details' => function ($query) {
                        $query->with('product');
                    }])
                    ->with('supplier')
                    ->withCount('purchase_details');
        if($payment_date){
            $purchases->where("purchases.order_date", $payment_date);
        }
               


        $cashIn = ReceivePayment::with(['customer' => function ($query) {
            $query->whereNotNull('customers.id');
        }])
        ->with(['lender' => function ($query) {
            $query->whereNotNull('lenders.id');
        }])
        ->with('mobileOrBank')
        ->with('payment_method')        
        ->with('account')
        ->where('payment_date',$payment_date)
        ->get();
        

        $cashOut = Payments::with(['supplier' => function ($query) {
                        $query->whereNotNull('suppliers.id');
                    }])
                    ->with(['lender' => function ($query) {
                        $query->whereNotNull('lenders.id');
                    }])
                    ->with(['employee' => function ($query) {
                        $query->whereNotNull('employees.id');
                    }])
                    ->with('payment_method')
                    ->with('mobileOrBank')
                    ->with('account')
                    ->where('payment_date',$payment_date)
                    ->get();
       
        $expenses = Expenses::with('expense_details');

        if($payment_date){
            $expenses->where("expenses.entry_date", $payment_date);
        }

        

        $data = [
            'openning_balance' => isset($previousDaysCashInHand[$previous_date]) ? $previousDaysCashInHand[$previous_date] : 0,
            'payments' => Payments::orderBy('type')->get(),
            'orderManagements' => $orderManagements->get(),
            'purchases' => $purchases->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses->get()
        ];

       
        
        return view('seller.report.ajax-pettycash',$data);
    }


    public function getPreviousDaysClosingBalance($endDate)
    {
        $startDate = '2024-07-01';
      

       $sql = "CALL CalculateDailyClosingBalance()";

            
        $cashInComulativeCashInHand = DB::select(DB::raw($sql));
       
        $arr_date_cash_in = array();
        $arr_date_cash_out = array();
        $arr_date_cash_paid = array();
        $arr_date_closing_balance = array();
        if($cashInComulativeCashInHand){
            
            foreach ($cashInComulativeCashInHand as $item){
                $arr_date_cash_in[$item->report_date] = $item->cash_in;
                $arr_date_cash_out[$item->report_date] = $item->cash_out;
                $arr_date_cash_spent[$item->report_date] = $item->cash_spent;
                $arr_date_closing_balance[$item->report_date] = $item->closing_balance; 
                          
            }
        }

     
       return $arr_date_closing_balance;

    
    }

    
    public function summary()
    {
        $time = Carbon::now()
        ->setTimezone('Asia/Kolkata')
        ->toDateTimeString();
       
        $payment_date = date('Y-m-d', strtotime($time));

        $categories = Category::where('seller_id',Auth::user()->id)->get();
        $suppliers = Suppliers::where('seller_id',Auth::user()->id)->get();

        $cashIn = ReceivePayment::select('*',DB::raw('sum(paid) as total'))
                ->groupBy('type','payment_method_id')
                //->with('payment_method')
                ->where('payment_date','<=',$payment_date)
                
                ->get();

        $cashOut = Payments::select('*',DB::raw('sum(paid) as total'))
                ->groupBy('type','payment_method_id')
                //->with('payment_method')
                
                ->where('payment_date','<=',$payment_date)
                ->get();
        // dd($cashIn);
        $expenses = Expenses::select('*',DB::raw('total'))
                
                ->where('entry_date','<=',$payment_date)
                ->get();

        $data = [
            'payments' => Payments::orderBy('type')->get(),
            'totalProcessingOrders' => 0,
            'totalProcessingDropshipperOrders' => 0,
            'totalProcessingWooCommerce' => 0,
            'statusSchema' => '',
            'defaultStatusOrderId' => 0,
            'customerType' => '',
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses
        ];
        return view('seller.report.summary',$data);
    }



    public function ajaxSummary(Request $request)
    {

        $payment_date = date('Y-m-d', strtotime($request->payment_date));
        
        $cashIn = ReceivePayment::select('*',DB::raw('sum(paid) as total'))
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=',$payment_date)
                
                ->get();
        $cashOut = Payments::select('*',DB::raw('sum(paid) as total'))
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=',$payment_date)
                
                ->get();

        $expenses = Expenses::select('*',DB::raw('total'))
                ->where('entry_date','<=',$payment_date)
                ->
                get();

        $data = [
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses
        ];

        
        return view('seller.report.ajax-summary',$data);
    }


    public function sales()
    {

        $order_date = date('Y-m-d');


        $data = [
            'payments' => Payments::orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
            'order_date' => $order_date,
            'customers' => Customers::orderBy('customer_name','asc')->get()
        ];
        return view('seller.report.sales',$data);
    }


    public function ajaxSales(Request $request)
    {

        $payment_date = date('Y-m-d', strtotime($request->payment_date));

        // This will be used as a parameter to get data
        $arr_param['sellerId'] = Auth::user()->id;
        $arr_param['payment_date'] = $payment_date;
        $arr_param['statusFilter'] = '';
        $arr_param['customerId'] = '';
        $arr_param['search'] = '';
        $arr_param['orderColumn'] = 'sales.id';
        $arr_param['orderDir'] = 'desc';
        $arr_param['limit'] = 20;
        $arr_param['start'] = 0;
        $arr_param['arrive_or_over_due'] = '';
        $arr_param['days_limit'] = '';

        $sales = Sales::SalesDetails($arr_param);

        //dd($sales);


        $data = [
            'sales' => $sales,
            
        ];
        return view('seller.report.ajax-sales',$data);
    }



    public function salesData(Request $request)
    {
        if ($request->ajax()){

            $product_name = $request->get('product_name', '');
            $unitId = $request->get('unitId', '');
            $statusId = $request->get('statusId', '-1');
            
            $customer_id = $request->get('customer_id', '');
      
        
            $start_date = $request->get('start_date') != null ? date('Y-m-d', strtotime($request->get('start_date'))) : '';
            $end_date = $request->get('end_date') != null ? date('Y-m-d', strtotime($request->get('end_date'))) : '';
 
            

            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'order_managements.id',
                'customer_id',
                'in_total',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'id';

            $userRole = 'member';
            $userId = Auth::id();
            
            $data = OrderManagement::select('order_managements.id', 'order_managements.*')->searchDataTable($search)
                    ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                        $query->whereBetween('order_managements.order_date', [$start_date, $end_date]);
                    })
                    ->when(!empty($customer_id), function ($query) use ($customer_id) {
                        $query->where('order_managements.customer_id', $customer_id);
                    })
                    ->with('customer')
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    ->get();

            
            
            $totalData = OrderManagement::select('order_managements.id', 'order_managements.*')->searchDataTable($search)
                            ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                                $query->whereBetween('order_managements.order_date', [$start_date, $end_date]);
                            })
                            ->when(!empty($customer_id), function ($query) use ($customer_id) {
                                $query->where('order_managements.customer_id', $customer_id);
                            })
                            ->with('customer')
                            ->count();


            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;
                })

                ->addColumn('order_date', function ($row) {                    
                    return date('Y-m-d', strtotime($row->order_date));
                })
                
                ->addColumn('customer_name', function ($row) { 
                    $suppler_details = '<p>';
                        $suppler_details .= $row->customer->company;
                        $suppler_details .= ' , '.$row->customer->customer_name.' ';
                        $suppler_details .= "<span class='ml-3 text-xs italic text-gray-500 align-middle'>";
                        $suppler_details .= $row->customer->address;
                        if($row->customer->address && $row->customer->phone)
                        $suppler_details .= ",".$row->customer->phone;
                        $suppler_details .= "</span> ";
                    $suppler_details .= '<p>';
                    
                    return $suppler_details;
                })

                ->addColumn('product_name', function ($row) {
                })

                ->addColumn('in_total', function ($row) {    
                    return SettingController::takaBDFormat($row->in_total);              
                })
                ->addColumn('status', function ($row) {   
                    
                    if($row->purchase_status==Purchase::PAID){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-green-500/20 text-green-700 rounded-full text-center px-2.5 py-1">Paid</div>
                        </div>
                        ';
                    }

                    if($row->purchase_status==Purchase::DUE){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-red-500/20 text-red-700 rounded-full text-center px-2.5 py-1">Due</div>
                        </div>
                        ';
                    }

                    if($row->purchase_status==Purchase::PARTIAL_PAID){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-yellow-500/20 text-yellow-700 rounded-full text-center px-2.5 py-1">Partial Paid</div>
                        </div>
                        ';
                    }
                    
                })

                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">

                        <div class="mt-2 ml-2">
                                <!-- Start -->
                                <button id="BtnViewPurchase" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg xmlns="http://www.w3.org/2000/svg"  width="32" height="32" viewBox="5 2 14 17" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-eye">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>

                            <div class="m-1.5">
                                <!-- Start -->
                                <a href="'. route('purchase.edit', [ 'id' => $row->id ]) .'" class="btn-action--blue mr-2" title="Pay Link">
                                    <button id="BtnEditPurchase" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                            <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                        </svg>
                                    </button>
                                </a>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['customer_name','product_name','status','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }


    public function customerReport()
    {

        $payment_date = date('Y-m-d');

        $expenses = Expenses::select('*',DB::raw('total')                                )
                ->groupBy('entry_date')
                ->where('entry_date',$payment_date)->get();

        $data = [
            'customers' => Customers::get(),
            'payments' => Payments::orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.customer.index',$data);
    }




    public function ajaxCustomerSummary(Request $request)
    {
        
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $customer_id = $request->customer_id != null ? $request->customer_id : '';

       
        $order_managements = OrderManagement::select(DB::raw('sum(in_total) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('order_managements.order_date', [$start_date, $end_date]);
                })
                ->when(!empty($customer_id), function ($query) use ($customer_id) {
                    $query->where('order_managements.customer_id', $customer_id);
                })
                ->first();

        $receive_payments = ReceivePayment::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('receive_payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($customer_id), function ($query) use ($customer_id) {
                    $query->where('receive_payments.customer_id', $customer_id);
                })
                ->first();      
        $data = [
            'customer_details' => Customers::with('opening_due')->where('id',$customer_id)->first(),
            'order_managements' => $order_managements,
            'receive_payments' => $receive_payments,
        ];

        return view('seller.report.customer.ajax-customer-summary',$data);
    }

    public function couponReport()
    {

        $payment_date = date('Y-m-d');
        
        $expenses = Expenses::select('*',DB::raw('total')                                )
                ->groupBy('entry_date')
                ->where('entry_date',$payment_date)
                ->get();

        $data = [
            'customers' => Customers::get(),
            'payments' => Payments::where('type','coupon')->orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.coupon.index',$data);
    }




    public function ajaxCouponSummary(Request $request)
    {
        
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        
        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customers())->getTable();



        $incommingCoupon = Coupon::select(DB::raw('sum(total_coupon) as totalCoupon'))
                ->where('status','in');
        if($request->customerId){            
            $incommingCoupon = $incommingCoupon->where('customer_id',$request->customerId);
        } 
        if($start_date){
            $incommingCoupon = $incommingCoupon->whereBetween('coupon_date',[$start_date, $end_date]);
        }
        
        $incommingCoupon = $incommingCoupon->first();
        

        $outgoingCoupon = Coupon::select(DB::raw('sum(total_coupon) as totalCoupon'))
                ->where('status','out');
        if($request->customerId){            
            $outgoingCoupon = $outgoingCoupon->where('customer_id',$request->customerId);
        } 
        if($start_date){
            $outgoingCoupon = $outgoingCoupon->whereBetween('coupon_date',[$start_date, $end_date]);
        }
        
        $outgoingCoupon = $outgoingCoupon->first();
        
     

        $receive_payments_lifetime = ReceivePayment::select(DB::raw('sum(paid) as total'))
                ->with('payment_method')
                ->where('type','coupon') ;
        if($start_date) $receive_payments_lifetime->whereBetween('payment_date',[$start_date, $end_date]);

        if($request->customerId) $receive_payments_lifetime = $receive_payments_lifetime->orders($request->customerId);
        $receive_payments_lifetime = $receive_payments_lifetime->first();
        //dd($receive_payments_lifetime);
        $data = [
            'customer_details' => Customers::where('id',$request->customerId)->first(),
            'incommingCoupon' => $incommingCoupon,
            'outgoingCoupon' => $outgoingCoupon
        ];


        return view('seller.report.coupon.ajax-coupon-summary',$data);
    }

    
    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function couponPayments(Request $request)
    {
        if ($request->ajax()) {

            $data = [];
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            if($request->get('customer_name')){
                $search = $request->get('customer_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }

            $orderColumnList = [
                'id',
                'payment_date',
                'total_coupon',
                'paid',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;

            $orderDir = isset($request->get('order')[0]['dir'])
                            ? $request->get('order')[0]['dir']
                            : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'id';

            // This will be used as a parameter to get data
            $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
            $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';


            $receive_payments = ReceivePayment::with('coupon')
                ->with('payment_method')
                ->where('type','coupon') ;
        if($start_date) $receive_payments->whereBetween('payment_date',[$start_date, $end_date]);
        $data = $receive_payments->get();
           
        $table = Datatables::of($data)
        ->addColumn('date', function ($row) {
            
            if(!empty($row->payment_date))
            {
                return $row->payment_date ? date('d-m-Y', strtotime($row->payment_date)) : NULL ;
            }
        })
        ->addColumn('total_coupon', function ($row) {

            return $row->total_coupon;
        })
        ->addColumn('payment_method', function ($row) {
            return $row->payment_method->name;
        })
        ->addColumn('paid', function ($row) {
            return $row->paid;
        })

        ->rawColumns(['date','total_coupon','payment_method','manage'])
        ->make(true);
        return $table;
        }
    }

        /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function couponTable(Request $request)
    {
        if ($request->ajax()) {

            $data = [];
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            if($request->get('customer_name')){
                $search = $request->get('customer_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }

            $orderColumnList = [
                'id',
                'coupon_date',
                'total',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;

            $orderDir = isset($request->get('order')[0]['dir'])
                            ? $request->get('order')[0]['dir']
                            : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'id';

            // This will be used as a parameter to get data
            $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
            $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';


        $coupons = Coupon::where('status','in') ;
        if($start_date) $coupons->whereBetween('coupon_date',[$start_date, $end_date]);
        $data = $coupons->get();
   
        $table = Datatables::of($data)
        ->addColumn('date', function ($row) {
            if(!empty($row->coupon_date))
            {
                return $row->coupon_date ? date('d-m-Y', strtotime($row->coupon_date)) : NULL ;
            }
        })
        ->addColumn('total_coupon', function ($row) {

            return $row->total_coupon;
        })

        ->rawColumns(['date','total_coupon'])
        ->make(true);
        return $table;
        }
    }



    
    public function mainStockReport()
    {

        $data = [
            'products' => Product::get(),
            'payments' => Payments::orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
        ];
        return view('seller.report.stocks.index',$data);
    }

    public function ajaxStockSummary(Request $request)
    {
        
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        
        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customers())->getTable();


        $orderPurchaseDetail = PurchaseDetails::selectRaw("*")
                ->with('product');
                if($request->productId){
                    $orderPurchaseDetail->where("product_id", $request->productId);
                }
        $orderPurchaseDetail->get();

    
        $sales = OrderManagementDetail::selectRaw("*")
                ->with('product');

                if($request->productId){
                    $sales->where("product_id", $request->productId);
                }

        $sales->get();

        $stockLogs = StockLog::selectRaw("*")
                ->with('product');
                if($request->productId){
                    $stockLogs->where("product_id", $request->productId);
                }
        $stockLogs->orderBy('id','desc')->get();
        
     
        $param['order_date'] = '';
        

        
        $payment_date = date('Y-m-d');
        

        $investment = Investment::with('shop')->with('partner')->orderBy('id', 'desc')->get();
        $payments = Payments::with('partner')
        ->with('payment_method')
        ->where('type', 'partner')
        ->where('shop_id', Auth::user()->shop_id)
        ->orderBy('id', 'desc')->get();
       
        $partners = array();
        $total_payment = 0;
        if($payments){
            foreach($payments as $row){
                $partners[$row->partner->name][] = $row->paid;  
            }

            $arr_payments = [];
            $arr_inv_percentage = [];
            foreach($partners as $partner_name=>$arr_item){
            $arr_payments[$partner_name] = array_sum($arr_item); 
            }  

        }
   

        $cashIn = ReceivePayment::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();
        $cashOut = Payments::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();

        $expenses = Expenses::select('*',DB::raw('total')                                )
                ->groupBy('entry_date')
                ->where('entry_date','<=', $payment_date)
                ->
                get();


        $data = [
            'customer_details' => Customers::where('id',$request->customerId)->first(),
            'orderPurchaseDetail' => $orderPurchaseDetail->get(),
            'sales' => $sales->get(),            
            'stockLogs' => $stockLogs->get(),
            'investment' => $investment,
            'arr_payments' => $arr_payments,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses
        ];

        return view('seller.report.stocks.ajax-stock-summary',$data);
    }

    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function saleDetailsData(Request $request)
    {
        if ($request->ajax()) {
            if($request->get('customer_name')){
                $search = $request->get('customer_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }


        $sellerId = Auth::user()->id;

        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customers())->getTable();
  

        $orderStatusId = $request->get('status', 0);
       
        //return $orderStatusId;


        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 1;
        $orderDir = isset($request->get('order')[0]['dir'])
                    ? $request->get('order')[0]['dir']
                    : 'desc';

        $availableColumnsOrder = [
            'id', 'id'
        ];

        $orderColumnName = isset($availableColumnsOrder[$orderColumnIndex])
                            ? $availableColumnsOrder[$orderColumnIndex]
                            : $availableColumnsOrder[0];

        $roleName = Auth::user()->role;

        if(!empty($request->customerType)){
            $customerType = $request->customerType;
        }
        else{
            $customerType = '0';
        }


        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        
        

        $sales = OrderManagementDetail::selectRaw("*")
        ->with('order_management')
        ->with('product');
        
        if($request->productId){
            $sales->where("product_id", $request->productId);
        }
    
                
        if($start_date){
            $sales->whereBetween('order_date',[$start_date, $end_date]);
        }
        $sales->get();

        return Datatables::of($sales)
                ->addIndexColumn()
                ->addColumn('date', function ($row) {
                    return $row->order_date;
                })

                ->addColumn('part_name', function ($row) {
                    $details = '';
                    
                    if($row->product->part_name){
                        $details .= $row->product->part_name;
                    }                       
                    return $details;
                })

                ->addColumn('part_no', function ($row) {
                    $details = '';
                    if($row->product->part_no){
                        $details .= $row->product->part_no;
                    }
                    if($row->order_management->order_status==6){
                        $details .= ' <span class="badge-status--red">Cancelled</span>';
                    }
                        
                    return $details;
                })

                ->addColumn('quantity', function ($row) {                   
                    return $row->quantity;
                   
                })
                
                ->rawColumns(['part_name', 'part_no', 'quantity'])
                ->make(true);
                

        }
    }


               /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function purchaseDetailsData(Request $request)
    {
        if ($request->ajax()) {
            if($request->get('customer_name')){
                $search = $request->get('customer_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }


        $sellerId = Auth::user()->id;


        $orderStatusId = $request->get('status', 0);
       
        //return $orderStatusId;


        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 1;
        $orderDir = isset($request->get('order')[0]['dir'])
                    ? $request->get('order')[0]['dir']
                    : 'desc';

        $availableColumnsOrder = [
            'id', 'id'
        ];

        $orderColumnName = isset($availableColumnsOrder[$orderColumnIndex])
                            ? $availableColumnsOrder[$orderColumnIndex]
                            : $availableColumnsOrder[0];

        $roleName = Auth::user()->role;

        if(!empty($request->customerType)){
            $customerType = $request->customerType;
        }
        else{
            $customerType = '0';
        }


        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        
        

        $purchases = PurchaseDetails::selectRaw("*")
        ->with('product');

        if($request->productId){
            $purchases->where("product_id", $request->productId);
        }
    
                
        if($start_date){
            $purchases->whereBetween('created_at',[$start_date, $end_date]);
        }
        $purchases->get();


        return Datatables::of($purchases)
                ->addIndexColumn()
                ->addColumn('date', function ($row) {
                    return $row->created_at;
                })

                ->addColumn('part_no', function ($row) {
                    return $row->product->part_no;
                })

                ->addColumn('quantity', function ($row) {                   
                    return $row->quantity;
                   
                })
                
                ->rawColumns(['part_no', 'quantity'])
                ->make(true);
                

        }
    }
    

    public function loanReport()
    {

        $payment_date = date('Y-m-d');
       
        $data = [
            'lenders' => Lenders::get(),
            'payments' => Payments::where('type','loan')->orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.loan.index',$data);
    }


    public function ajaxLenderSummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $lender_id = $request->lender_id;


        $receives = ReceivePayment::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('receive_payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($lender_id), function ($query) use ($lender_id) {
                    $query->where('receive_payments.lender_id', $lender_id);
                })
                ->where('type','loan')
                ->first();  

        $payments = Payments::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($lender_id), function ($query) use ($lender_id) {
                    $query->where('payments.lender_id', $lender_id);
                })
                ->where('type','loan')
                ->first(); 

        $data = [
            'lender_details' => Lenders::with('opening_due')->where('id',$request->lender_id)->first(),
            'receives' => $receives,
            'payments' => $payments,
        ];

        return view('seller.report.loan.ajax-loan-summary',$data);
    }


    public function supplierReport()
    {

        $payment_date = date('Y-m-d');

        $data = [
            'suppliers' => Suppliers::get(),
            'payments' => Payments::get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.supplier.index',$data);
    }




    public function ajaxSupplierSummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $supplier_id = $request->supplier_id;

        // $purchases = Purchase::PurchasesDetailsByParam($param);

        $purchases = Purchase::select(DB::raw('sum(in_total) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('purchases.order_date', [$start_date, $end_date]);
                })
                ->when(!empty($supplier_id), function ($query) use ($supplier_id) {
                    $query->where('purchases.supplier_id', $supplier_id);
                })
                ->first();

        $payments = Payments::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($supplier_id), function ($query) use ($supplier_id) {
                    $query->where('payments.supplier_id', $supplier_id);
                })
                ->first();      
        $data = [
            'supplier_details' => Suppliers::with('opening_due')->where('id',$supplier_id)->first(),
            'purchases' => $purchases,
            'payments' => $payments,
        ];
        

       return view('seller.report.supplier.ajax-supplier-summary',$data);
    }

    public function partnerReport()
    {

        $payment_date = date('Y-m-d');

        $data = [
            'partners' => Partner::get(),
            'payments' => Payments::get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.partner.index',$data);
    }




    public function ajaxPartnerSummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $partner_id = $request->partner_id;

        $receives = ReceivePayment::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('receive_payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($partner_id), function ($query) use ($partner_id) {
                    $query->where('receive_payments.partner_id', $partner_id);
                })
                ->where('type','partner')
                ->first();  

        $payments = Payments::select(DB::raw('sum(paid) as total'))
                ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                    $query->whereBetween('payments.payment_date', [$start_date, $end_date]);
                })
                ->when(!empty($partner_id), function ($query) use ($partner_id) {
                    $query->where('payments.partner_id', $partner_id);
                })
                ->where('type','partner')
                ->first();      
        $data = [
            'partner_details' => Partner::where('id',$partner_id)->first(),
            'receives' => $receives,
            'payments' => $payments,
        ];
        

       return view('seller.report.partner.ajax-partner-summary',$data);
    }



    public function bankStatementReport()
    {

        $payment_date = date('Y-m-d');

        $data = [
            'banks' => BanksOrMobiles::where('type','bank')->orderBy('name')->get(),
            'payments' => Payments::orderBy('type')->where('payment_method_id',2)->get(),
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.bank-statement.index',$data);
    }




    public function ajaxBankStatementSummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $payment_methodID = $request->pm;
        $param['bank_or_mobile_wallet_id'] = $request->bank_or_mobile_wallet_id;
        $param['start_date'] = $start_date;
        $param['end_date'] = $end_date;
        $param['payment_methodID'] = $payment_methodID;
        
        $payment_total = Payments::getPaymentsTotal($param);
        $receive_total = ReceivePayment::getReceivePaymentTotal($param);

        $param['payment_date'] = '';
        
        $payment_lifetime = Payments::getPaymentsTotal($param);
        
        $receive_lifetime = ReceivePayment::getReceivePaymentTotal($param);

        $data = [
            'bank_details' => BanksOrMobiles::where('id',$request->bank_or_mobile_wallet_id)->first(),
            'payment_total' => $payment_total,
            'receive_total' => $receive_total,
            'payment_lifetime' => $payment_lifetime,
            'receive_lifetime' => $receive_lifetime,
        ];

        return view('seller.report.bank-statement.ajax-summary',$data);
    }





    public function salaryReport()
    {

        $payment_date = date('Y-m-d');


        $payments = Payments::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('type','salary')
                ->first();

        $data = [
            'employees' => Employees::get(),
            'payments' => $payments,
            'payment_methods' => PaymentMethods::get(),
            'payment_date' => $payment_date,
        ];
        return view('seller.report.salary.index',$data);
    }




    public function ajaxSalarySummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $param['employee_id'] = $request->employee_id;
    
        $payments = Payments::select(DB::raw('sum(paid) as total'))
                ->with('payment_method')
                ->where('type','salary');
        if($request->employee_id) $payments = $payments->where('employee_id',$request->employee_id);
        if($start_date){
            $payments = $payments->whereBetween('payment_date',[$start_date, $end_date]);
        }
        $payments = $payments->first();

        $data = [
            'payments' => $payments,
        ];

        return view('seller.report.salary.ajax-salary-summary',$data);
    }


    
    public function expenseReport(Request $request)
    {

        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';


        $expenses = Expenses::select(DB::raw('total'))
            ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                $query->whereBetween('expenses.entry_date', [$start_date, $end_date]);
            })
            ->first();
        $data = [
            'expenses' => $expenses,
        ];
        return view('seller.report.expense.index',$data);
    }




    public function ajaxExpenseSummary(Request $request)
    {
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';

        $expenses = Expenses::select(DB::raw('sum(total) as total'))
            ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                $query->whereBetween('expenses.entry_date', [$start_date, $end_date]);
            })
            ->first();


        $data = [
            'expenses' => $expenses,
        ];

        return view('seller.report.expense.ajax-expense-summary',$data);
    }





    public function report()
    {
        $categories = Category::where('seller_id',Auth::user()->id)->get();
        $suppliers = Suppliers::where('seller_id',Auth::user()->id)->get();


        $data = [
            'categories' => $categories,
            'suppliers' => $suppliers,
        ];

        return view('seller.report.report',$data);
    }


    /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function reportData(Request $request)
    {
        if ($request->ajax()) {
            $sellerId = Auth::user()->id;

            $reportStatus = $request->get('status', array());
            $categoryId = $request->get('categoryId', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                '',
                'part_name',
                'part_no',
                'quantity',
                'total_incoming',
                'alert_stock',
                ''
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'part_name';

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'category_id' => $categoryId
            ];

            $data = Product::reportStockTable($sellerId, $reportStatus, $otherReportParams);
            $dataCount = Product::reportStockTableCount($sellerId, $reportStatus, $otherReportParams);

            $table = Datatables::of($data)
                        ->addColumn('image', function ($row) {
                            return '<img src="'. product_image_url($row->image) .'" class="w-28 h-auto">';
                        })
                        ->addColumn('quantity', function ($row) {
                            return '<a href="'. route('seller quantity details', [ 'id' => $row->id ]) .'" class="text-gray-800 underline">'
                                        . number_format($row->quantity) .
                                    '</a>' ;
                        })
                        ->addColumn('incoming', function ($row) {
                            return '<span x-on:click="showEditModal=true" style="cursor: pointer;" data-id="'. $row->id .'" class="modal-open custome_quantity" id="BtnProduct" href="#">'
                                        . number_format($row->total_incoming) .
                                    '</span>';
                        })
                        ->addColumn('report_status', function ($row) {
                            if (trim($row->alert_stock) == '') {
                                return '<span class="badge badge-pill badge-secondary">N/A</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity > $row->alert_stock) {
                                return '<span class="badge badge-pill badge-success">OVER STOCK</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity <= $row->alert_stock && $row->quantity > 0) {
                                return '<span class="badge badge-pill badge-warning">Low Stock</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity <= 0) {
                                return '<span class="badge badge-pill badge-danger">Out 0f Stock</span>';
                            }

                            return '<span class="badge badge-pill badge-secondary">N/A</span>';
                        })
                        ->rawColumns(['image', 'quantity', 'incoming', 'report_status'])
                        ->skipPaging()
                        ->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }

    public function filterReport(Request $request)
    {
        $data1 =  DB::table("products")
            ->join('product_main_stocks','product_main_stocks.product_id','products.id')
            ->where('seller_id',Auth::user()->id)
            ->where(function($query) use($request){
                return $request->category ?
                    $query->from('products')->where('category_id',$request->category) : '';
            })
            ->get();

        $data = [];
        foreach($data1 as $row)
        {
            if(isset($request->status) && $request->status == 1){
                if($row->alert_stock != '' && $row->quantity <= 0)
                {
                    array_push($data,$row);
                }
            }
            elseif(isset($request->status) && $request->status == 2){
                if($row->quantity > 0 && $row->quantity <= $row->alert_stock){
                    array_push($data,$row);
                }
            }
            elseif(isset($request->status) && $request->status == 3){
                if($row->alert_stock != '' && $row->quantity > $row->alert_stock)
                {
                    array_push($data,$row);
                }
            }
            elseif(isset($request->status) && $request->status == 4){
                if($row->alert_stock == '')
                {
                    array_push($data,$row);
                }
            }
        }
        $table = Datatables::of($data)
            ->addColumn('image', function ($row) {
                if(!empty($row->image))
                {
                    return '<span><img src="'.asset($row->image).'" class="cutome_image" ></span>';
                }
            })
            ->addColumn('quantity', function ($row) {
                return '<a class="custome_quantity" href="'.url("seller/see-details/$row->id").'">'.$row->quantity.'</a>' ;
            })
            ->addColumn('incoming', function ($row) {
                $total_incoimg_products = DB::table('order_purchase_details')
                    ->where('product_id', '=', $row->id)
                    ->sum('quantity');

                return '<span x-on:click="showEditModal=true" style="cursor: pointer;" data-id="' . $row->id . '" class="modal-open custome_quantity" id="BtnProduct" href="#">'.$total_incoimg_products.'</span>';
            })
            ->addColumn('reprort_status', function ($row) {
                if($row->alert_stock != '' && $row->quantity <= 0)
                {
                    return '<span class="badge badge-pill badge-danger">Out 0f Stock</span>';
                }
                elseif($row->quantity > 0 && $row->quantity <= $row->alert_stock )
                {
                    return '<span class="badge  badge-pill badge-warning">Low Stock</span>';
                }
                elseif($row->alert_stock != '' &&  $row->quantity > $row->alert_stock )
                {
                    return '<span class="badge badge-pill badge-success">OVER STOCK</span>';
                }
                elseif($row->alert_stock == '' )
                {
                    return '<span class="">N/A</span>';
                }
            })
            ->rawColumns(['image','quantity','incoming','reprort_status'])
            ->make(true);
        return $table;
    }

    public function stockReport()
    {
        return view('seller.report.stock_movements');
    }


    public function stockReportData(Request $request)
    {
        if ($request->ajax()) {
            $sellerId = Auth::user()->id;

            $reportStatus = $request->get('status', array());
            $supplierId = $request->get('supplierId', '');
            $categoryId = $request->get('categoryId', '');

            $offset = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                 '',
                'part_name',
                'part_no',
                'added',
                'removed',
                'net_change'
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'part_name';


            $from_date = $to_date = '';
            if(!empty($request->from_date) && !empty($request->to_date)){
                $from_date = $request->from_date;
                $to_date = $request->to_date;
            } elseif (!empty($request->from_date) && empty($request->to_date)){
                $from_date = $request->from_date;
                $to_date = $request->from_date;
            } elseif (empty($request->from_date) && !empty($request->to_date)){
                $from_date = $request->to_date;
                $to_date = $request->to_date;
            }

            $otherReportParams = [
                'search' => $search,
                'limit' => $limit,
                'offset' => $offset,
                'order_column' => $orderColumn,
                'order_dir' => $orderColumnDir,
                'from_date' => $from_date,
                'to_date' => $to_date
            ];



            $data = StockLog::reportStockTable($sellerId, $otherReportParams);
            $dataCount = StockLog::reportStockTableCount($sellerId, $otherReportParams);

            $table = Datatables::of($data)
                        ->addColumn('image', function ($row) {
                            return '<img src="'. product_image_url($row->image) .'" class="w-28 h-auto">';
                        })
                        ->addColumn('added', function ($row) {
                           return number_format($row->added);
                        })
                        ->addColumn('removed', function ($row) {
                                return number_format($row->removed);

                        })

                        ->addColumn('net_change', function ($row) {
                            if (!empty($row->net_change)) {
                                return $row->net_change ;
                            }else{
                                return 0 ;
                            }
                        })

                        ->rawColumns(['image'])
                        ->skipPaging()
                        ->setTotalRecords($dataCount)
                        ->make(true);

            return $table;
        }
    }


    public function activityLog()
    {
        $data = ActivityLog::all();

        return view('seller.report.activity_log', compact('data'));
    }

    public function dataActivityLog(Request $request)
    {
        $data = [];

        $start = $request->get('start', 0);
        $limit = $request->get('length', 10);
        $search = isset($request->get('search')['value'])
            ? $request->get('search')['value']
            : null;

        $orderColumnIndex = isset($request->get('order')[0]['column'])
            ? $request->get('order')[0]['column']
            : 2;
        $orderDir = isset($request->get('order')[0]['dir'])
            ? $request->get('order')[0]['dir']
            : 'desc';

        $availableColumnsOrder = [
            'id', 'action', 'part_name', 'part_no', 'quantity', 'user_name', 'created_at'
        ];

        $orderColumnName = isset($availableColumnsOrder[$orderColumnIndex])
            ? $availableColumnsOrder[$orderColumnIndex]
            : $availableColumnsOrder[6];

        $fields = ActivityLog::with('product')
            ->userNameAsColumn()
            ->searchActivityLogTable($search)
            ->orderBy($orderColumnName, $orderDir)
            ->take($limit)
            ->skip($start)
            ->get();

        if (!empty($fields)) {
            foreach ($fields as $field) {
                $row = [];

                $row[] = $field->id;
                $row[] = $field->action;
                $row[] = $field->product->part_name;
                $row[] = $field->product->part_no;
                $row[] = number_format($field->quantity);
                $row[] = $field->user->name;
                $row[] = $field->created_at->format('Y-m-d H:i');
                $row[] = '
                    <button
                        type="button"
                        class="btn-action--red"
                        title="Undo"
                        id="UndoBtn"
                        data-id="'. $field->id .'"
                        onClick="undoActivityLog(this)">
                        <i class="fas fa-exchange-alt"></i>
                    </button>';

                $data[] = $row;
            }
        }

        $count_total = ActivityLog::whereHas('product')->count();
        $count_total_search = ActivityLog::searchActivityLogTable($search)->count();

        $response = [
            'draw' => $request->get('draw'),
            'recordsTotal' => $count_total,
            'recordsFiltered' => $count_total_search,
            'data' => $data
        ];

        return response()->json($response);

    }

    public function undoActivityLog(Request $request)
    {
        try {
            $activityLog = ActivityLog::where('id', $request->id)->first();
            ActivityLog::undoActivityLog($request->id);

            return response()->json(['status' => 1]);

        } catch (\Throwable $th) {
            report($th);

            return response()->json([ 'message' => $th->getMessage() ], 500);
        }
    }


    public function partnerProfit(Request $request)
    {
        $orderPurchaseDetail = PurchaseDetails::selectRaw("*")
                ->with('product');
                if($request->productId){
                    $orderPurchaseDetail->where("product_id", $request->productId);
                }
        $orderPurchaseDetail->get();

        
        $sales = OrderManagementDetail::selectRaw("*")
                ->with('product');

                if($request->productId){
                    $sales->where("product_id", $request->productId);
                }

        $sales->get();

   
     
        $param['order_date'] = '';
        

        
        $payment_date = date('Y-m-d');
        

        $investment = Investment::with('shop')->with('partner')->where('shop_id', Auth::user()->shop_id)->orderBy('id', 'desc')->get();
        $payments = Payments::with('partner')
        ->with('payment_method')
        ->where('type', 'partner')
        ->where('shop_id', Auth::user()->shop_id)
        ->orderBy('id', 'desc')->get();
       
        $partners = array();
        $total_payment = 0;
        if($payments){
            foreach($payments as $row){
                $partners[$row->partner->name][] = $row->paid;  
            }

            $arr_payments = [];
            $arr_inv_percentage = [];
            foreach($partners as $partner_name=>$arr_item){
            $arr_payments[$partner_name] = array_sum($arr_item); 
            }  

        }
   

        $cashIn = ReceivePayment::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();
        $cashOut = Payments::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();

        $expenses = Expenses::select('*',DB::raw('sum(total) as total')                                )
                ->where('entry_date','<=', $payment_date)
                //->groupBy('entry_date')
                ->get();


        $data = [
            'customer_details' => Customers::where('id',$request->customerId)->first(),
            'orderPurchaseDetail' => $orderPurchaseDetail->get(),
            'sales' => $sales->get(),            
            'investment' => $investment,
            'arr_payments' => $arr_payments,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses
        ];

        return view('seller.report.profit-loss',$data);
    }


    public function categoryProfit(Request $request)
    {
        $sales = OrderManagement::select('*',DB::raw('sum(service_price_total) as servicesTotal'))
                ->first();
        
        $saleDetails = OrderManagementDetail::with('product.category')        
        ->selectRaw('products.product_name,order_managements.order_date')
        ->selectRaw('SUM(order_management_details.cost_price) as totalCostPrice')
        ->selectRaw('SUM(order_management_details.price) as totalPrice')
        ->join('order_managements', 'order_management_details.order_management_id', '=', 'order_managements.id')
        ->join('products', 'order_management_details.product_id', '=', 'products.id')
        ->groupBy('order_management_details.product_id')
        ->get();

           



        $data = [
            'categories' => Category::get(),
            'sales' => $sales,
            'saleDetails' => $saleDetails,
        ];

        return view('seller.report.profit-category',$data);
    }

    public function categoryProfitByDateRange(Request $request)
    {
        
        $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
        $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
        $catgory_id = $request->category_id;

        $sales = OrderManagement::select('*',DB::raw('sum(service_price_total) as servicesTotal'));
                if($end_date){
                    $sales->whereBetween('order_date',["$start_date", "$end_date"]);
                }

        $sales->first();
        
        $saleDetails = OrderManagementDetail::with('product.category')
        ->selectRaw('products.product_name,order_managements.order_date')
        ->selectRaw('SUM(order_management_details.cost_price) as totalCostPrice')
        ->selectRaw('SUM(order_management_details.price) as totalPrice')
        ->join('order_managements', 'order_management_details.order_management_id', '=', 'order_managements.id')
        ->join('products', 'order_management_details.product_id', '=', 'products.id')
        ->groupBy('order_management_details.product_id');
        if($end_date){
            $saleDetails->whereBetween('order_managements.order_date1',["$start_date", "$end_date"]);
        }
        $saleDetails->get();

        dd($saleDetails->get());
        $data = [           
            'sales' => $sales->first(),
            'saleDetails' => $saleDetails->get(),
        ];

        //

        return view('seller.report.ajax-profit-category',$data);
    }

}