<?php

namespace App\Http\Controllers;


use App\Models\Customer;
use App\Models\Lender;
use App\Models\Banks;
use App\Models\BanksOrMobiles;
use App\Models\PaymentMethods;
use App\Models\ReceivePayments;
use App\Models\Account;
use App\Models\Coupon;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Datatables;
use DB;
use PDF;
class RcvPaymentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        Session::put('itemArray', []);
        $customers = Customer::orderBy('customer_name','asc')->get();

        $saleTotalAll = array();

        //SET Total by pm
        $data = [
            'saleTotalAll' => array_sum($saleTotalAll),
            'banks_or_mobiles' => BanksOrMobiles::orderBy('name','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),
            'customers' =>  Customer::where('shop_id',Auth::user()->shop_id)->orderBy('customer_name','asc')->get(),
            'lenders' =>   Lender::where('shop_id',Auth::user()->shop_id)->orderBy('lender_name','asc')->get(),
        ];

        

        return view('seller.receive_payments', $data);
    }

     public function formLoad(Request $request)
    {
        $data = [
            'banks_or_mobiles' => BanksOrMobiles::orderBy('name','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),
            'customers' =>  Customer::orderBy('customer_name','asc')->get(),
            'lenders' =>   Lender::orderBy('lender_name','asc')->get(),
        ];
        $type = $request->type;
        return view('seller.receive_payments.create.'.$type,$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        Session::put('itemArray', []);

        $sellerId = Auth::user()->id;

        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        $data = [
            'timestamp' => $timestamp,
            'banks_or_mobiles' => BanksOrMobiles::orderBy('name','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),
            'customers' =>  Customer::orderBy('customer_name','asc')->get(),
        ];

        return view('seller.receive_payments.create', $data);
    }

    /**
     * Store `sale` data
     *
     * @param  \App\Http\Requests\ReceivePayments\StoreRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {
        try {
            $receive_payment = new ReceivePayments();
            $receive_payment->payment_date = $request->payment_date ? date('Y-m-d', strtotime($request->payment_date)) : NULL ;
            $receive_payment->order_id = 0;
            $receive_payment->type = $request->type;
            $receive_payment->customer_id = $request->customer_id ?? 0;
            $receive_payment->lender_id = $request->lender_id ?? 0;
            $receive_payment->amount = $request->paid ?? 0;
            $receive_payment->paid = $request->paid ?? 0;
            $receive_payment->payment_method_id = $request->payment_method_id ?? '';
            $receive_payment->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id ?? '';
            $receive_payment->account_no_id = $request->account_no_id ?? '';
            $receive_payment->receive_for = $request->receive_for ?? '';            
            $receive_payment->notes = $request->notes;
            $receive_payment->user_id = Auth::user()->id;
            $receive_payment->shop_id = Auth::user()->shop_id;

            $receive_payment->save();


            if($request->type=='coupon'){
                $coupon = new Coupon();
                $coupon->coupon_date = $request->payment_date ? date('Y-m-d', strtotime($request->payment_date)) : NULL ;
                $coupon->total_coupon = $request->total_coupon;
                $coupon->payment_id = $receive_payment->id;
                $coupon->status = 'out';
                $coupon->shop_id = Auth::user()->shop_id;
                $coupon->seller_id = Auth::user()->id;
                $coupon->created_at = new DateTime();
                $coupon->save();
            }

            return response()->json([
                'message' => 'Payment created successfully'
            ]);

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something went wrong. ' . $th->getMessage()
            ], 500);
        }
    }





    /**
     * Update the `sale` data
     *
     * @param  \App\Http\Requests\Sales\UpdateRequest $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateRequest $request)
    {

       
        try {

            $receive_payment = ReceivePayments::find($request->id);            

            $receive_payment->payment_date = $request->payment_date ? date('Y-m-d', strtotime($request->payment_date)) : NULL ;
            $receive_payment->order_id = $request->order_id ?? 0;;
            $receive_payment->type = $request->type;
            $receive_payment->customer_id = $request->customer_id ?? 0;
            $receive_payment->lender_id = $request->lender_id ?? 0;
            $receive_payment->amount = $request->paid ?? 0;
            $receive_payment->paid = $request->paid ?? 0;
            $receive_payment->payment_method_id = $request->payment_method_id ?? '';
            $receive_payment->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id ?? '';
            $receive_payment->account_no_id = $request->account_no_id ?? 0;
            $receive_payment->receive_for = $request->receive_for ?? ''; 
            $receive_payment->notes = $request->notes;
            $receive_payment->user_id = Auth::user()->id;
            $receive_payment->save();

            return response()->json([
                'status' => 'Payment Updated Successfully'
            ]);

        } catch (\Exception $th) {
            report($th);

            return response()->json([
                'message' => 'Something happened wrong ' . $th->getMessage()
            ], 500);
        }
    }




    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sellerId = Auth::user()->id;

        $receive_payment = ReceivePayments::find($id);

       // dd($receive_payment);
        abort_if(!$receive_payment, 404);

        $data = [
            'receive_payment' => $receive_payment,
            'banks_or_mobiles' => BanksOrMobiles::orderBy('name','asc')->get(),
            'accounts' => Account::orderBy('account_no','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),
            'customers' =>  Customer::where('shop_id',Auth::user()->shop_id)->orderBy('customer_name','asc')->get(),
            'lenders' =>  Lender::where('shop_id',Auth::user()->shop_id)->orderBy('lender_name','asc')->get(),
        ];

   

        if($receive_payment->type =='customer') {
            return view('seller.receive_payments.edit.customer', $data);
        }

        if($receive_payment->type =='withdraw') {
            return view('seller.receive_payments.edit.withdraw', $data);
        }

        if($receive_payment->type =='loan') {
            return view('seller.receive_payments.edit.loan', $data);
        }


    }





    /**
     * Handle datatable serverside
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        if ($request->ajax()) {

            $data = [];
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            if($request->get('customer_name')){
                $search = $request->get('customer_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }

            if($request->get('lender_name')){
                $search = $request->get('lender_name');
            }else{
                $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;
            }



            $orderColumnList = [
                'id',
                'payment_date',
                'customer_name',
                'pm',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;

            $orderDir = isset($request->get('order')[0]['dir'])
                            ? $request->get('order')[0]['dir']
                            : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'id';

            // This will be used as a parameter to get data
            $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
            $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';

            $payment_methodID = $request->get("pm");
            $customerId = $request->get('customerId', 0);
            $lenderId = $request->get('lenderId', 0);
            $bank_or_mobile_wallet_id = $request->get('bank_or_mobile_wallet_id', 0);
            $type = $request->get('type');
            
            // This will be used as a parameter to get data
            $arr_param['sellerId'] = Auth::user()->id;
            $arr_param['start_date'] = $start_date;
            $arr_param['end_date'] = $end_date;
            $arr_param['payment_methodID'] = $payment_methodID;
            $arr_param['customerId'] = $customerId;
            $arr_param['lenderId'] = $lenderId;
            $arr_param['bank_or_mobile_wallet_id'] = $bank_or_mobile_wallet_id;
            $arr_param['type'] = $type;
            $arr_param['search'] = $search;
            $arr_param['orderColumn'] = $orderColumn;
            $arr_param['orderDir'] = $orderDir;
            $arr_param['limit'] = $limit;
            $arr_param['start'] = $start;

            $receive_payments = ReceivePayments::getPaymentDetails($arr_param);
           
            $arr_param['limit'] = '-1';
            $totalData = [];
            $totalData = ReceivePayments::getPaymentDetails($arr_param);
            $totalFiltered = count($totalData);

      
            $data = array();
            if($receive_payments){
            foreach ($receive_payments as $row)
            {
                
                $edit =  route('receive_payment.edit',$row->id);

                $nestedData['id'] = $row->id ? $row->id : NULL ;
                $nestedData['date'] = $row->payment_date ? date('d-m-Y', strtotime($row->payment_date)) : NULL ;

                $type = $row->type ? ucwords(str_replace("_"," ",$row->type)) : 'Customer';

                $nestedData['type'] = '
                                        <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                                            '. $type .'
                                        </span>';

                $from = '';

                if(isset($row->customer_name)){
                    $from = '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        '. ucwords($row->customer_name) .'
                    </span>';
                }
                if($row->lender_name){
                    $from = '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        '. ucwords($row->lender_name) .'
                    </span><br>';
                }

                if($row->type=='withdraw' || $row->type=='bank-loan'){
                    $from = '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        '. ucwords($row->banks_or_mobile) .'
                    </span><br>';
                }

                if($row->type=='other'){
                    $from = '
                    <span class="whitespace-nowrap cursor-pointer hover:text-blue-500">
                        '. ucwords($row->receive_for) .'
                    </span><br>';
                }

                
                $nestedData['from'] = $from;

                
                $nestedData['payment_method'] =  $row->payment_method ;
                $nestedData['bank_name'] =  $row->banks_or_mobile ;
                $nestedData['paid'] = number_format($row->paid,2);
                $nestedData['note'] =  $row->notes ;
                $nestedData['action'] = '
                    <a href="'. $edit .'"
                        class="btn-action--yellow">
                        &nbsp;<i class="fas fa-pencil-alt"></i>&nbsp;
                    </a>
                    <button type="button"
                        class="btn-action--red"
                        id="BtnDelete"
                        data-id="' . $row->id . '">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                ';


                $data[] = $nestedData;

            }
        }


        $json_data = array(
                    "draw"            => intval($request->input('draw')),
                    "recordsTotal"    => intval($totalData),
                    "recordsFiltered" => intval($totalFiltered),
                    "data"            => $data
                    );

        echo json_encode($json_data);


        }
    }


    function loadEditPayment(Request $request){

        $receive_payment = ReceivePayments::with('payment_method')->with(['bank_or_mobile_wallet' => function($detail) {
            $detail->with('accounts');
        }])->where('id',$request->id)->first();
       // dd($receive_payment);
        abort_if(!$receive_payment, 404);

        $data = [
            'receive_payment' => $receive_payment,
            'banks_or_mobiles' => BanksOrMobiles::get(),
            'accounts' => Account::orderBy('account_no','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),           
        ];

        return view('elements.form-edit-modal-payment', $data);
    }


    function loadDeletePayment(Request $request){

        $receive_payment = ReceivePayments::with('payment_method')->with(['bank_or_mobile_wallet' => function($detail) {
            $detail->with('accounts');
        }])->where('id',$request->id)->first();
       // dd($receive_payment);
        abort_if(!$receive_payment, 404);

        $data = [
            'receive_payment' => $receive_payment,
            'banks_or_mobiles' => BanksOrMobiles::get(),
            'accounts' => Account::orderBy('account_no','asc')->get(),
            'payment_methods' => PaymentMethods::orderBy('name','asc')->get(),           
        ];

        return view('elements.form-delete-modal-payment', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function paymentDelete(Request $request)
    {
        $receive_payment = ReceivePayments::find($request->id);
        $receive_payment->delete();
        return [
        'status' => 'Payment is deleted successfully.'
        ];
    }

}