<?php

namespace App\Http\Controllers;

use App\Http\Requests\InOutProductHistory\BulkDeleteRequest;
use App\Jobs\BulkAutoLink;
use App\Jobs\BulkAutoSync;
use App\Models\ActivityLog;

use App\Models\Permission;
use App\Models\ProductTag;
use App\Models\User;
use App\Models\ShipmentProduct;
use App\Models\PoShipment;
use App\Models\Size;
use App\Models\ModelName;
use App\Models\OrderManagementDetail;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Requests\RanconProduct\{RanconProductStoreRequest, RanconProductUpdateRequest};
use App\Imports\BulkImport;
use App\Models\RanconProduct;
use App\Models\Feature;
use App\Models\Category;
use App\Models\OrderPurchase;
use App\Models\OrderPurchaseDetail;
use App\Models\OrderManagement;
use App\Models\ProductMainStock;
use App\Models\Shop;
use App\Models\StockLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class RanconProductController extends Controller
{
    public function index()
    {    
        $categories = Category::get();
        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $productCount = RanconProduct::count();

        return view('seller.rancon-product.index', compact('shop', 'categories','productCount'));
    }

    public function create()
    {
        
        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $categories = Category::get();
        $productCount = RanconProduct::count();

        return view('seller.rancon-product.create', compact('shop', 'categories','productCount'));
    }

    public function loadSubcategoryDropdown(Request $request)
    {
        $category = Category::where('id', $request->category_id)->first();
        $cat_name = $category->cat_name;
        $sizes = Size::where('shop_id', Auth::user()->shop_id)->get();
        $subcategories = Category::where('shop_id', Auth::user()->shop_id)->where('parent_category_id', $request->category_id)->get();
        return view('seller.rancon-product.loadSubcategoryDropdown', compact('cat_name','sizes','subcategories'));
    }

    public function edit($id)
    {
        $product = RanconProduct::with('size_details')->where('id',$id)->first();

        $categories = Category::where('shop_id', Auth::user()->shop_id)->where('parent_category_id', 0)->get();
        $subcategories = Category::where('shop_id', Auth::user()->shop_id)->where('parent_category_id','<>', 0)->get();
        $sizes = Size::where('shop_id', Auth::user()->shop_id)->get();

        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        
        $productCount = RanconProduct::where('seller_id', Auth::user()->id)->count();

        return view('seller.rancon-product.edit', compact('product','categories','subcategories','sizes','shop', 'productCount'));
    }

    /**
     * Show details of `product` data
     *
     * @param  int  $productId
     * @return \Illuminate\Http\Response
     */
    public function show($productId)
    {
        $sellerId = Auth::user()->id;

        $product = RanconProduct::where('id', $productId)
                    ->where('shop_id', Auth::user()->shop_id)
                    ->with('category')
                    ->with('supplier')
                    ->quantity()
                    ->totalIncoming()
                    ->first();

        abort_if(!$product, 404);

        $data = [
            'product' => $product
        ];

        return view('seller.rancon-product.show', $data);
    }

    public function data(Request $request)
    {
        if ($request->ajax()){

            if (isset($request->id) && $request->id != null) {
                $product = RanconProduct::findOrFail($request->id);
                $shop = Shop::where('id', Auth::user()->shop_id)->first();                
                $categories = Category::get();
                $data = [
                    'product' => $product,                    
                    'categories' => $categories,
                    'shop' => $shop,
                ];

                return view('seller.rancon-product.form-edit-modal-product', $data);
            }


            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'part_name',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';
            $orderColumnDir = 'asc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'part_name';

            $userRole = 'member';
            $userId = Auth::id();
            

            $data = RanconProduct::searchTable($search)
                ->searchModel($search)
                ->orderBy($orderColumn, $orderColumnDir)
                ->take($limit)
                ->skip($start)
                ->get();
       
               
            
            $totalData = RanconProduct::searchTable($search)->count();


            $table = Datatables::of($data)
            
               
                ->addColumn('id', function ($row) {                    
                    return $row->id;
                })
                
                ->addColumn('part_name', function ($row) {
                    $details = '';
                    if($row->part_name)
                        $details = "<p class='m-0'><span style='white-space:nowrap'>$row->part_name</span>
                            <span class='part_no ml-3 text-xs italic text-gray-500 align-middle'>$row->part_no</span> 
                        </p>";
                    return $details;
                })

                ->addColumn('cost_price', function ($row) {                    
                    return !empty($row->cost_price) ? SettingController::takaBDFormat($row->cost_price) : 0;
                })
                ->addColumn('price', function ($row) {                    
                    return !empty($row->price) ? SettingController::takaBDFormat($row->price) : 0;
                })

                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnEditProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['part_name','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }



    function loadInsertForm(Request $request){
        $categories = Category::get();
        return view('seller.rancon-product.form-insert-modal-product',compact('categories'));
    }

    /**
     * Store new product
     *
     * @param RanconProductStoreRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function insert(RanconProductStoreRequest $request)
    {
        try {
            if(Session::has('product_data')){
                $product = Session::forget('product_data');
            }

            $product = new RanconProduct();                       

            $product->part_no = $request->part_no;
            $product->part_name = $request->part_name;
            $product->cost_price = $request->cost_price;
            $product->price = $request->price;
            $product->save();

            if($product){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Rancon Product created successfully</span>'
                ]);
            }

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()
                    ->with('error', $th->getMessage())
                    ->withInput();
        }
    }

    /**
     * Update the product data
     *
     * @param RanconProductUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(RanconProductUpdateRequest $request)
    {
        try {
            if(Session::has('product_data')){
                Session::forget('product_data');
            }

            $product = RanconProduct::find($request->id); 

            $product->part_no = $request->part_no;
            $product->part_name = $request->part_name;
            $product->cost_price = $request->cost_price;
            $product->price = $request->price;
            $product->save(); 
      
            if($product){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Rancon Product updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    
    function loadDeleteForm(Request $request){

        $product = RanconProduct::where('id',$request->id)->first();
        abort_if(!$product, 404);

        $data = [
            'product' => $product           
        ];

        return view('seller.rancon-product.form-delete-modal-product', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('product_data')){
                session::forget('product_data');
            }

            $product = RanconProduct::find($request->id);
            RanconProduct::destroy($request->id);

            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">Rancon Product is deleted successfully.</span>'
            ];
        }
    }

}