<?php

namespace App\Http\Controllers;
use App\Http\Requests\OrderPurchase\StoreRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Imports\BulkImportPCost;
use App\Models\Product;
use App\Models\DomesticShipper;
use App\Models\PoShipment;
use App\Models\PoShipmentDetail;
use App\Models\ProductMainStock;
use App\Models\StockLog;
use App\Models\Category;
use App\Models\Supplier;
use App\Models\OrderPurchase;
use App\Models\ShipType;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Exports\OrderAnalysisExport;
class PurchaseOrderController extends Controller
{
    public function index()
    {
        return view('seller.purchase_order.index');
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            if (isset($request->id) && $request->id != null) {
                $data = product::where([
                    'id' => $request->id
                ])->first();
                $id = $request->id;
                return view('elements.form-update-product', compact(['data', 'id']));
            }

            $data = product::quantity()->where('shop_id', Auth::user()->shop_id)->orderBy('id', 'desc')->get();

            $table = Datatables::of($data)
                ->addColumn('image', function ($row) {
                    if(!empty($row->image))
                    {
                        return '<span><img src="'.asset($row->image).'" class="cutome_image" ></span>';
                    }
                })
                ->addColumn('qrCode', function ($row) {

                    return QRCode::size(100)->margin(2)->generate($row->part_no);
                })
                ->addColumn('quantity', function ($row) {
                    return '<a class="custome_quantity" href="'.url("seller/see-details/$row->id").'">'.$row->quantity.'</a>' ;
                })
                ->addColumn('manage', function ($row) {
                    return '<span x-on:click=" showEditModal=true"class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnUpdate"><i class="fas fa-pencil-alt"></i></span><span class="bg-red-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnDelete"><i class="fas fa-trash-alt"></i></span><span x-on:click=" showQuantityModal=true"class="modal-open bg-blue-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnQuantity">In/Out</span><span class="modal-open bg-blue-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer"><a href="view-qr-code/'.$row->part_no.'" ><i class="fas fa-print"></i></a></span>';
                })
                ->addColumn('checkbox', function ($row) {
                    // return '<input type="checkbox" class="checkbox checkbox2" name="part_no[]" value="'.$row->part_no.'" style=" height: 17px; width: 17px; margin-top: 10px; padding-top: 10px !important;">';
                    return $row->id;
                })
                // ->rawColumns(['image','manage','quantity','qrCode','checkbox'])
                ->rawColumns(['image','manage','quantity','qrCode'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [            
            'part_no' => 'required|unique:products,part_no|string|max:255',
        ]);
        
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $data = new Product();
        $data->part_name = $request->part_name;
        $data->category_id = $request->category_id;
        $data->part_no = $request->part_no;
        $data->seller_id = Auth::User()->id;
        $data->warehouse_id =  $request->warehouse_id;
        $data->from_where = 1;
        if ($request->hasFile('image')) {
            $upload = $request->file('image');
            $file_type = $upload->getClientOriginalExtension();
            $upload_name =  time() . $upload->getClientOriginalName();
            $destinationPath = public_path('uploads/product');
            $upload->move($destinationPath, $upload_name);
            $data->image = 'uploads/product/'.$upload_name;
        }

        $result = $data->save();

        $productMainStock = new ProductMainStock();
        $productMainStock->product_id = $data->id;
        $productMainStock->quantity = 0;
        $productMainStock->save();

        QrCode::generate($data->part_no, 'qrcodes/'.$data->part_no.'.svg');

        if ($result) {
            return redirect()->back()->with('success', 'Product successfully created');
        } else {
            return redirect()->back()->with('error', 'Wrong Password');
        }
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'part_name' => 'required',
            'part_no' => 'required'
        ],);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $data = product::find($request->id);
        $data->part_name = $request->part_name;
        $data->category_id = $request->category_id;
        $data->part_no = $request->part_no;
        $data->warehouse_id =  $request->warehouse_id;
        if ($request->hasFile('image')) {
            $upload = $request->file('image');
            $file_type = $upload->getClientOriginalExtension();
            $upload_name =  time() . $upload->getClientOriginalName();
            $destinationPath = public_path('uploads/product');
            $upload->move($destinationPath, $upload_name);
            $data->image = 'uploads/product/'.$upload_name;
        }
        $result = $data->save();

        if ($result) {
            return redirect('/product')->with('success', 'Product successfully Updated');
        } else {
            return redirect('/product')->with('error', 'Wrong Password');
        }
    }

    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {
            $product = Product::find($request->id);
            $path = "qrcodes/".$product->part_no.".svg";
            unlink($path);
            unlink($product->image);
            DB::table('products')->where([
                'id' => $request->id
            ])->delete();
            

            
            return [
                'status' => 1
            ];
        }
    }

    public function productUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'check' => 'required',
            'quantity' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $user = Auth::user();
        if($request->quantity > 0)
        {
            $data = ProductMainStock::where('product_id',$request->id)->first();
            if($request->check == 1)
            {
                $quantity = $data->quantity + $request->quantity;
                $data->quantity = $quantity;
                $result = $data->save();

                $stockLog = new StockLog();
                $stockLog->product_id = $request->id;
                $stockLog->quantity = $request->quantity;
                $stockLog->seller_id = Auth::user()->shop_id;
                $stockLog->date = Carbon::now('Asia/Jakarta')->format('Y-m-d H:i A');
                $stockLog->check_in_out = 1;
                $stockLog->save();

                if ($result) {
                    return redirect()->back()->with('success', 'Product quantity successfully checked in');
                } else {
                    return redirect()->back()->with('error', 'Wrong Password');
                }
            }
            else{
                if($data->quantity < $request->quantity){
                    return redirect()->back()->with('danger', 'After CheckOut this quantity. It become less then zero. Please Insert valide quantity value');
                }
                else
                {
                    $quantity = $data->quantity - $request->quantity;
                    $data->quantity = $quantity;
                    $result = $data->save();

                    $stockLog = new StockLog();
                    $stockLog->product_id = $request->id;
                    $stockLog->quantity = $request->quantity;
                    $stockLog->seller_id = Auth::user()->shop_id;
                    $stockLog->date = Carbon::now('Asia/Jakarta')->format('Y-m-d H:i A');
                    $stockLog->check_in_out = 0;
                    $stockLog->save();
                    if ($result) {
                        return redirect()->back()->with('success', 'Product quantity successfully checked out');
                    } else {
                        return redirect()->back()->with('error', 'Wrong Password');
                    }
                }
            }
        }
        return redirect()->back()->with('danger', 'Number must be greater than zero');
    }

    public function productData(Request $request)
    {
        if ($request->ajax()) {
            if (isset($request->id) && $request->id != null) {
                $data = Product::where([
                    'id' => $request->id
                ])->first();
                $id = $request->id;

                return view('elements.form-update-quantity', compact(['data', 'id']));
            }
        }
    }

    public function seeDetails($id)
    {
        $user = Auth::user();
        $quantityLogs = StockLog::where('product_id',$id)->with('seller')->get();
        $product = Product::find($id);
        return view('seller.qunatity-log-details', compact('quantityLogs','product'));
    }

    public function deleteQuantityLog(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            // $stockLog = StockLog::find($request->id);
            // $productMainStock = ProductMainStock::where('product_id',$stockLog->product_id)->first();
            // if($stockLog->check_in_out == 1)
            // {
            //     $quantity = $productMainStock->quantity - $stockLog->quantity;
            //     $productMainStock->quantity = $quantity;
            //     $productMainStock->save();
            // }
            // else
            // {
            //     $quantity = $productMainStock->quantity + $stockLog->quantity;
            //     $productMainStock->quantity = $quantity;
            //     $productMainStock->save();
            // }
            DB::table('stock_logs')->where([
                'id' => $request->id
            ])->delete();

            return [
                'status' => 1
            ];
        }
    }

    public function updateQuantityLog(Request $request)
    {
        $validator = Validator::make($request->all(), [

            'quantity' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $user = Auth::user();
        if($request->quantity > 0)
        {
            $quantityLog = StockLog::find($request->id);
            // dump( $quantityLog);
            $productMainStock = ProductMainStock::where('product_id',$quantityLog->product_id)->first();
            // dump( $productMainStock);
            // exit;
            if($quantityLog->check_in_out == 1)
            {
                $quantity = $productMainStock->quantity - $quantityLog->quantity;
                $quantity = $quantity + $request->quantity ;
                $productMainStock->quantity = $quantity;
                $result = $productMainStock->save();

                $quantityLog->quantity = $request->quantity;
                $quantityLog->save();

                if ($result) {
                    return redirect()->back()->with('success', 'Product quantity successfully Updated');
                } else {
                    return redirect()->back()->with('error', 'Wrong Password');
                }
            }
            else{
                if($productMainStock->quantity < $request->quantity){
                    return redirect()->back()->with('danger', 'After CheckOut this quantity. It become less then zero. Please Insert valide quantity value');
                }
                else
                {
                    $quantity = $productMainStock->quantity + $quantityLog->quantity;
                    $quantity = $quantity - $request->quantity ;
                    $productMainStock->quantity = $quantity;
                    $result = $productMainStock->save();

                    $quantityLog->quantity = $request->quantity;
                    $quantityLog->save();

                    if ($result) {
                        return redirect()->back()->with('success', 'Product quantity successfully Updated');
                    } else {
                        return redirect()->back()->with('error', 'Wrong Password');
                    }
                }
            }
        }
        return redirect()->back()->with('danger', 'Number must be greater then zero');
    }

    public function dataQuantityLog(Request $request)
    {
        if ($request->ajax()) {

            if (isset($request->id) && $request->id != null) {
                $data = StockLog::where([
                    'id' => $request->id
                ])->first();
                $id = $request->id;

                return view('elements.form-update-quantity-log', compact(['data', 'id']));
            }
        }
    }


    public function productCost()
    {
        $categories = Category::where('shop_id', Auth::user()->shop_id)->get();

        $data = [
            'categories' => $categories
        ];

        return view('seller.purchase_order.product_cost', $data);
    }

    public function productCostAnalysis()
    {
        $data = Product::where('shop_id', Auth::user()->shop_id)->get();

        if(session::has('product_data')) {
            $data = session::forget('product_data');
        }
        return view('seller.product_cost_price.index', compact('data'));
    }


    public function createProductCost()
    {
        Session::put('itemArray', []);

        $shopId = Auth::user()->shop_id;

        $products = Product::where('seller_id', $shopId)->get();
        $suppliers = Supplier::where('seller_id', $shopId)->get();

        $data = [
            'products' => ProductTypeAheadResource::collection($products),
            'suppliers' => $suppliers,            
        ];

        return view('seller.purchase_order.create-product-cost', $data);
    }

    


    
        /**
     * Handle the `product stock report` datatable
     * Serverside Datatable
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     *
     */
    public function POProductAnalysisData(Request $request)
    {
        if ($request->ajax()) {
            $shopId = Auth::user()->shop_id;

            $reportStatus = $request->get('status', array());
            $supplierId = $request->get('supplierId', '');
            $categoryId = $request->get('categoryId', '');

            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'id',
                'part_name',
                'part_no',
                'part_name',
                'description',
                'model_id',
                ''
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'asc';

            $orderColumn = isset($orderColumnList[$orderColumnIndex])
                            ? $orderColumnList[$orderColumnIndex]
                            : 'part_name';

            
            $data = Product::searchTable($search)
                ->searchModel($search)
                ->quantity()
                //->with('part_type')
                //->totalIncoming()
                ->orderBy($orderColumn, $orderColumnDir)
                ->take($limit)
                ->skip($start)
                //->orderBy('id','desc')
                ->get();

            $totalData = Product::searchTable($search)->count();
            $table = Datatables::of($data)
                        ->addColumn('checkbox', function ($row) {
                            return $row->id; 
                        })
                        ->addColumn('quantity', function ($row) {
                            return '<a href="'. route('seller quantity details', [ 'id' => $row->id ]) .'" class="text-gray-800 underline">'
                                        . number_format($row->quantity) .
                                    '</a>' ;
                        })
      

                        ->addColumn('report_status', function ($row) {
                            if (trim($row->alert_stock) == '') {
                                return '<span class="badge badge-pill badge-secondary">N/A</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity > $row->alert_stock) {
                                return '<span class="badge badge-pill badge-success">OVER STOCK</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity <= $row->alert_stock && $row->quantity > 0) {
                                return '<span class="badge badge-pill badge-warning">Low Stock</span>';
                            }

                            if ($row->alert_stock >= 0 && $row->quantity <= 0) {
                                return '<span class="badge badge-pill badge-danger">Out 0f Stock</span>';
                            }

                            return '<span class="badge badge-pill badge-secondary">N/A</span>';
                        })
                       
                        ->rawColumns(['checkbox','quantity','supplier_name','report_status'])
                        ->skipPaging()
                        ->setTotalRecords($totalData)
                        ->make(true);

            return $table;
        }
    }




    



    public function updateForm(Request $request)
    {
        if ($request->ajax()){

            if (isset($request->id) && $request->id != null) {
                $data = Product::where([
                    'id' => $request->id
                ])->first();
                $id = $request->id;
                $suppliers = Supplier::all();
                $supplier_id = $data->supplier_id;
                return view('seller.purchase_order.form-update-order-analysis', compact(['data', 'id','suppliers','supplier_id']));
            }
        }
    }

    public function updateReorderStock(Request $request)
    {
        $editid = $request->id;
        $low_stock_reorder = $request->input('low_stock_reorder');
        $out_of_stock_reorder = $request->input('out_of_stock_reorder');
        $supplier_id = $request->input('supplier_id');

        if($low_stock_reorder !='' || $out_of_stock_reorder != '' || $supplier_id != '') {
            $data = array('low_stock_reorder' => $low_stock_reorder, "out_of_stock_reorder" => $out_of_stock_reorder, "supplier_id" => $supplier_id);

            // Call updateData() method of Product Model
            Product::updateData($editid, $data);
            return redirect('order_analysis')->with('success','Product Rorder Stock Updated Successfully');
        }else{
            return redirect('order_analysis')->with('danger','Something has gone wrong');
        }
    }



    public function poSettings(Request $request)
    {
        $data_agent_cargo = DB::table('agent_cargo_name')->get();
         $shipTypes = ShipType::all();

        $data = [
            'data_agent_cargo' =>$data_agent_cargo,
            'title' => 'China Cargo'
        ];

        return view('seller.purchase_order.settings.china_cargo', $data);
    }



    public function createChinaCargo()
    {

         $shipTypes = ShipType::all();

        $data = [
            'shipTypes' => $shipTypes,
        ];

        return view('seller.purchase_order.settings.create_china_cargo', $data);
    }



    /**
     * Store `china_cargo` data
     */
    public function storeChinaCargo(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Field id is required. '
            ], 500);
        }
        try {

            $created_at = date('Y-m-d');
            if (!empty($request)) {
                    $name = isset($request->name) ? $request->name : 0;

                    $data = array(
                        'name' => $name,
                         "created_at" => $created_at,
                    );

                    $insertedId = OrderPurchase::insertData('agent_cargo_name', $data);



                    if (!empty($request->address)) {
                        foreach($request->address as $key => $row ) {

                            $data_sw = array(
                                'location' => isset($request->location[$key]) ? $request->location[$key] : 0,
                                'address' => isset($request->address[$key]) ? $request->address[$key] : 0,
                                 "created_at" => $created_at,
                            );
                            OrderPurchase::insertData('agent_cargo_warehouse', $data_sw);
                        }
                    }



            }

           // http_response_code(500);
           // dd($request->address); die;
            return response()->json([
                'message' => 'Dats Save Successfully.'
           ]);



        } catch (\Throwable $th) {
            report($th);
            return response()->json([
                'message' => 'Something has gone wrong'
           ]);

        }
    }


}
