<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Permission;
use App\Models\User;
use App\Models\StockLog;
use App\Models\RanconProduct;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Actions\OrderManagement\CalculateTotalAmountAction;
use App\Http\Requests\Purchase\{PurchaseStoreRequest, PurchaseUpdateRequest};
use App\Imports\BulkImport;
use App\Models\Product;
use App\Models\Shop;
use App\Models\Purchase;
use App\Models\PurchaseDetails;
use App\Models\PurchaseExtraCharges;
use App\Models\PaymentMethod;
use App\Models\BanksOrMobiles;
use App\Models\Suppliers;
use App\Models\InitialTransaction;
use App\Models\Payments;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use DateTime;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class PurchaseController extends Controller
{
    public function purchases()
    {

        $products =  ProductTypeAheadResource::collection(Product::get());
        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $purchaseCount = Purchase::when(Auth::user()->role=='staff', function ($query){
                            $query->where('shop_id', Auth::user()->shop_id);
                        })->count();
        $shops = Shop::get();
        return view('seller.purchases.index', compact('products','shop', 'purchaseCount','shops'));
    }



    public function data(Request $request)
    {
        if ($request->ajax()){

            if (isset($request->id) && $request->id != null) {
               
                $purchase = Purchase::with('purchase_details')
                ->with(['purchase_details' => function($detail) {
                    $detail->with('products');
                }])->findOrFail($request->id);

                $shop = Shop::where('id', Auth::user()->shop_id)->first();    
                $products =  Product::get();

                
                
                $data = [
                    'purchase' => $purchase,   
                    'products' => ProductTypeAheadResource::collection($products),                 
                    'shops' => Shop::get()
                ];

                return view('seller.purchases.form-edit-modal-purchase', $data);
            }

            $product_name = $request->get('product_name', '');
            $unitId = $request->get('unitId', '');
            $statusId = $request->get('statusId', '-1');
            
            $supplier_id = $request->get('supplier_id', '');
      
        
            $start_date = $request->get('start_date') != null ? date('Y-m-d', strtotime($request->get('start_date'))) : '';
            $end_date = $request->get('end_date') != null ? date('Y-m-d', strtotime($request->get('end_date'))) : '';
 
            

            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'purchases.id',
                'supplier_id',
                'in_total',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'id';

            $userRole = 'member';
            $userId = Auth::id();
            
            $data = Purchase::select('purchases.id', 'purchases.*')->searchTable($search)
                    // ->join('products', 'purchases.product_id', '=', 'products.id')
                    ->join('suppliers', 'purchases.supplier_id', '=', 'suppliers.id')
                    ->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
                        $query->whereBetween('purchases.order_date', [$start_date, $end_date]);
                    })
                    ->when(!empty($supplier_id), function ($query) use ($supplier_id) {
                        $query->where('purchases.supplier_id', $supplier_id);
                    })
                    ->when(Auth::user()->role=='staff', function ($query){
                        $query->where('shop_id', Auth::user()->shop_id);
                    })
                    ->filterByShop($unitId)
                    // ->filterByPurchaseStatus($statusId)
                    // ->with('product')
                     ->with('supplier')
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    ->get();

            
            
            $totalData = Purchase::select('purchases.id', 'purchases.*')->searchTable($search)
                        // ->join('products', 'purchases.product_id', '=', 'products.id')
                         ->join('suppliers', 'purchases.supplier_id', '=', 'suppliers.id')
                         ->filterByShop($unitId)
                         ->when(Auth::user()->role=='staff', function ($query){
                            $query->where('shop_id', Auth::user()->shop_id);
                        })
                        // ->filterByPurchaseStatus($statusId)
                        // ->with('product')
                         ->with('supplier')
                        ->count();


            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;
                })

                ->addColumn('order_date', function ($row) {                    
                    return date('Y-m-d', strtotime($row->order_date));
                })
                
                ->addColumn('supplier_name', function ($row) { 
                    $suppler_details = '<p>';
                        $suppler_details .= $row->supplier->supplier_name;
                        $suppler_details .= "<span class='ml-3 text-xs italic text-gray-500 align-middle'>";
                        $suppler_details .= $row->supplier->address;
                        if($row->supplier->address && $row->supplier->phone)
                        $suppler_details .= ",".$row->supplier->phone;
                        $suppler_details .= "</span> ";
                    $suppler_details .= '<p>';
                    
                    return $suppler_details;
                })

                ->addColumn('product_name', function ($row) {
                })

                ->addColumn('in_total', function ($row) {    
                    return SettingController::takaBDFormat($row->in_total);              
                })
                ->addColumn('status', function ($row) {   
                      
                })

                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">

                        <div class="mt-2 ml-2">
                                <!-- Start -->
                                <button id="BtnViewPurchase" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg xmlns="http://www.w3.org/2000/svg"  width="32" height="32" viewBox="5 2 14 17" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-eye">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>

                            <div class="m-1.5">
                                <!-- Start -->
                                <a href="'. route('purchase.edit', [ 'id' => $row->id ]) .'" class="btn-action--blue mr-2" title="Pay Link">
                                    <button id="BtnEditPurchase" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                        <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                            <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                        </svg>
                                    </button>
                                </a>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteProduct" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['supplier_name','product_name','status','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }



     /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function createOrderId($len=16)
    {
        $nonce_str = Str::random($len);
        return $nonce_str;
    }


    /* Load Suppliers Due
    *
    * @return \Illuminate\View\View
    */
   public function supplierDue(Request $request)
   {
       $supplier_id = $request->supplier_id;

       Session::put('itemArray', []);
       $total_due = 0;
       $purchase_id = '';
       $payable = InitialTransaction::where('transaction_type','payable')->where('supplier_id',$supplier_id)->get();
       if($payable){
        foreach($payable as $row){
            $total_due += $row->amount;
        }
       }
       
       $purchases = Purchase::where('supplier_id',$supplier_id)->get();
       if($purchases){
        foreach($purchases as $row){
            $total_due += $row->in_total;
        }
       }


       $paid = Payments::where('supplier_id',$supplier_id)->get();
       if($paid){
        foreach($paid as $row){
            $total_due -= $row->paid;
        }
       }
       return SettingController::takaBDFormat($total_due);
   }

   public function getSupplierDueById($supplier_id)
   {
       Session::put('itemArray', []);
       $total_due = 0;
       $purchase_id = '';
       $payable = InitialTransaction::where('transaction_type','payable')->where('supplier_id',$supplier_id)->get();
       if($payable){
        foreach($payable as $row){
            $total_due += $row->amount;
        }
       }
       
       $purchases = Purchase::where('supplier_id',$supplier_id)->get();
       if($purchases){
        foreach($purchases as $row){
            $total_due += $row->in_total;
        }
       }

       $paid = Payments::where('supplier_id',$supplier_id)->get();
       if($paid){
        foreach($paid as $row){
            $total_due -= $row->paid;
        }
       }
       return $total_due;
   }

    /**
     * Show create purchase page
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        $sellerId = Auth::user()->id;

        Session::put('itemArray', []);

        $purchase_id = '';
        do {
            $purchase_id = $this->createOrderId();
            $purchase = Purchase::where('id', $purchase_id)->first();
        } while(!empty($purchase));

       
        $rancon_products = RanconProduct::get();
        $products = Product::get();

        $merge = collect($rancon_products)->merge($products);

        // Make the merged collection unique by 'product_code'
        $uniqueProducts = $merge->unique('product_code');

        // If you want to reset the keys
        $uniqueProducts = $uniqueProducts->values();
        
      
       
        $data = [
            'purchase_id' => $purchase_id,
            'suppliers' => Suppliers::get(),
            'products' => ProductTypeAheadResource::collection($products),
            'payment_methods' => PaymentMethod::all(),
            'banks_or_mobiles' => BanksOrMobiles::all(),
            'shops' => Shop::all(),
        ];

        return view('seller.purchases.create', $data);
    }


        /**
     * Store a newly created resource in storage.
     *
     * @param StoreRequest $request
     * @param  \App\Actions\Purchase\CalculateTotalAmountAction $calculateTotalAmount
     * @return Response
     */
    public function store(PurchaseStoreRequest $request, CalculateTotalAmountAction $calculateTotalAmount)
    {
       
        try {
            $sellerId = Auth::user()->id;
            $createdBy = Auth::user()->id;

            $purchaseId = $request->purchase_id;

            DB::beginTransaction();
            
           
        
            $order_date = $request->order_date != null ? date('Y-m-d', strtotime($request->order_date)) : '';
            $purchaseData = new Purchase();
            $purchaseData->order_date = $order_date;
            $purchaseData->supplier_id = $request->supplier_id;
             
            $purchaseData->seller_id= $sellerId;
            $purchaseData->user_id= Auth::id();
            $purchaseData->created_at = new DateTime();
         
            $purchaseData->save();
            $purchaseId = $purchaseData->id;

            $paymentUrl = '';           
            $rcvPaymentId = $this->createPayment($request->paid,$purchaseId,$request);
            
            $this->UpdateStockLog($request,$purchaseId);

            $productPriceTotal = 0;
            $serviceCostTotal = 0;
            $discountTotal = 0;
            $totalAmount = 0;
            $taxRate = 0;

           
            
            if($request->product_id){
                foreach($request->product_id as $idx => $productId) {

                    $cost_price = $request->price[$idx] ?? 0;
                    $orderQty = $request->quantity[$idx] ?? 0;
                    $productPriceTotal += ($cost_price * $orderQty);

                    $purchaseDetailData = new PurchaseDetails();
                    $purchaseDetailData->purchase_id = $purchaseId;
                    $purchaseDetailData->product_id = $productId;
                    $purchaseDetailData->quantity = $orderQty;
                    $purchaseDetailData->cost_price = $cost_price;
                    $purchaseDetailData->seller_id = $sellerId;
                    $purchaseDetailData->created_at = new DateTime();                    
                    $purchaseDetailData->save();
                    
                }
            }
            


            $purchaseData = Purchase::where('id', $purchaseId)->first();   

            $purchaseDtl = Purchase::select('in_total')->where('id',$purchaseId)->first();
            $manualPaymentSumDtl = Purchase::getManualPaymentSum($purchaseId);
            $manualRefundedSumDtl = Purchase::getManualRefundedSum($purchaseId);
            $totalPaidAmount = $manualPaymentSumDtl - $manualRefundedSumDtl;
            

            $totalAmount = $calculateTotalAmount->handle($productPriceTotal, $taxRate, $serviceCostTotal, $request->total_discount);
            
            
           
            $purchaseData->product_price_total = $productPriceTotal;
            $purchaseData->extra_charge_total = $serviceCostTotal;
            $purchaseData->in_total = $totalAmount;           

            
            if($purchaseDtl->in_total == $totalPaidAmount){
               
                $purchaseData->purchase_status = 1;
                
            }
            $purchaseData->save();
            
            DB::commit();

            $responseData = [
                'purchaseId' => $purchaseId,
                // 'productPriceTotal' => $productPriceTotal,
                // 'serviceCost' => $serviceCostTotal,
                // 'discountTotal' => $discountTotal,
                // 'totalAmount' => $totalAmount,
                // 'totalPaid' => $request->paid,  
                // 'totalDue' => $totalAmount-$request->paid,               
                // 'publicUrl' => route('order-management.public-url', [ 'purchase_id' => $purchaseId ]),
                //'moneyReceipt' => route('purchase.money_receipt', [ 'purchase_id' => $purchaseId ,'receive_payment_id' => $rcvPaymentId ]),
                //'editUrl' => route('purchase.edit', [ 'purchase' => $purchaseData ])
            ];

            if($purchaseId){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Purchase created successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }

            //return $this->apiResponse(Response::HTTP_CREATED, 'Order created.', $responseData);

        } catch (\Throwable $th) {
            report($th);

            DB::rollBack();

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
        /**
         * @TODO instead of Throwable, use Exception
         */
    }


        /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $sellerId = Auth::user()->id;
        
        $purchase = Purchase::with('purchase_details')
                ->with(['purchase_details' => function($detail) {
                    $detail->with('product');
                }])
                ->findOrFail($id);
       
        abort_if(!$purchase, 404, __('translation.Data not found'));

        $rancon_products = RanconProduct::get();
        $products = Product::get();
        $merge = collect($rancon_products)->merge($products);


        $payment = Payments::where('purchase_id', $id)->first();        
        $data = [
            'purchase_id' => $id,
            'purchase' => $purchase,  
            'order_payment' =>  isset($payment->paid) ? $payment->paid : 0,      
            'suppliers' => Suppliers::get(),
            'products' => ProductTypeAheadResource::collection($merge),
            'payment_methods' => PaymentMethod::all(),
            'banks_or_mobiles' => BanksOrMobiles::all(),
            'supplierDue' => $this->getSupplierDueById($purchase->supplier_id),
            'shops' => Shop::all(),
        ];

        
        return view('seller.purchases.edit', $data);
    }


        /**
     * @TODO put private key in a file and read it here
     */
    public function createPayment($paid,$purchase_id,$request)
    {
        
        $payment_date = $request->order_date != null ? date('Y-m-d', strtotime($request->order_date)) : date('Y-m-d');
        
        if($request->is_cash_payment){
            $payment_method = PaymentMethod::where('name','Cash')->first();
            $payment_method_id = $payment_method->id;
        }else{
            $payment_method_id = $request->payment_method_id; 
        }

        if($paid>0){
            $paymentDetails = new Payments();
            $paymentDetails->amount = $paid;
            $paymentDetails->paid = $paid;
            $paymentDetails->type = 'supplier';
            $paymentDetails->shop_id = Auth::user()->shop_id;
            $paymentDetails->purchase_id = $purchase_id;
            $paymentDetails->supplier_id = $request->supplier_id;
            $paymentDetails->payment_date = $payment_date;
            $paymentDetails->payment_time = Carbon::now()->format('h:i');
            $paymentDetails->payment_method_id = $payment_method_id;
            $paymentDetails->bank_or_mobile_wallet_id = $request->bank_or_mobile_wallet_id;
            $paymentDetails->account_no_id = $request->account_no_id ?? 0;
            
            $result = $paymentDetails->save();
            return $paymentDetails->id;
        }else{
            return 0;
        }
        
    }

        
     /**
     * This function Save Order Purchase Details
     *
     * @param request  mixed data, int po id
     */
    private function UpdateStockLog($request,$purchase_id){
        
        
        if (isset($request->product_id)) {           
            foreach($request->product_id as $key => $product_id ) {
                $stockLogs = new StockLog();
                $stockLogs->shop_id = Auth::user()->shop_id;
                $stockLogs->purchase_id = $purchase_id;
                $stockLogs->product_id = $product_id;
                
                $stockLogs->quantity = $request->quantity[$key] ? $request->quantity[$key] : 0;
                $stockLogs->cost_price = $request->cost_price[$key] ? $request->cost_price[$key] : 0;
                $stockLogs->seller_id = Auth::user()->id;
                $stockLogs->stock_status = 1;                   
                $stockLogs->save();
            }
            return true;
        }
    }

    /**
     * Update the purchase data
     *
     * @param UpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */

     public function update(PurchaseUpdateRequest $request, CalculateTotalAmountAction $calculateTotalAmount)
    {

        try {
            $sellerId = Auth::user()->id;
            $createdBy = Auth::user()->id;

            $purchaseId = $request->id;
           // dd($request->all());
            $purchaseDetailsTable = (new PurchaseDetails())->getTable(); 
            DB::table($purchaseDetailsTable)
                ->where('purchase_id', $purchaseId)
                ->delete();


            $order_date = $request->order_date != null ? date('Y-m-d', strtotime($request->order_date)) : '';
            
            $purchaseData = Purchase::where('id', $purchaseId)->first();
            $purchaseData->order_date = $order_date;
            $purchaseData->supplier_id = $request->supplier_id;
            
            
            $purchaseData->seller_id= $sellerId;
            $purchaseData->seller_id= Auth::id();
            $purchaseData->created_at = new DateTime();
            
            $purchaseData->save();
            $purchaseId = $purchaseData->id;

            $paymentUrl = '';           
            //$rcvPaymentId = $this->createPayment($request->paid,$purchaseId,$request);
            $stockLogTable = (new StockLog())->getTable(); 
            DB::table($stockLogTable)
                ->where('purchase_id', $purchaseId)
                ->delete();
                
            $this->UpdateStockLog($request,$purchaseId);

            $productPriceTotal = 0;
            $serviceCostTotal = 0;
            $discountTotal = 0;
            $totalAmount = 0;
            $taxRate = 0;

           
            
            if($request->product_id){
                foreach($request->product_id as $idx => $productId) {

                    $cost_price = $request->cost_price[$idx] ?? 0;
                    $orderQty = $request->quantity[$idx] ?? 0;
                    $productPriceTotal += ($cost_price * $orderQty);

                    $purchaseDetailData = new PurchaseDetails();
                    $purchaseDetailData->purchase_id = $purchaseId;
                    $purchaseDetailData->product_id = $productId;
                    $purchaseDetailData->quantity = $orderQty;
                    $purchaseDetailData->cost_price = $cost_price;
                    $purchaseDetailData->seller_id = $sellerId;
                    $purchaseDetailData->created_at = new DateTime();                    
                    $purchaseDetailData->save();
                }
            }
            
       

            


            $purchaseData = Purchase::where('id', $purchaseId)->first();   

            $totalAmount = $calculateTotalAmount->handle($productPriceTotal, $taxRate, $serviceCostTotal, $request->total_discount);

           
            $purchaseData->product_price_total = $productPriceTotal;
            $purchaseData->in_total = $totalAmount;           
            $purchaseData->save();
            
            //DB::commit();

            $responseData = [
                'purchaseId' => $purchaseId,
                // 'productPriceTotal' => $productPriceTotal,
                // 'serviceCost' => $serviceCostTotal,
                // 'discountTotal' => $discountTotal,
                // 'totalAmount' => $totalAmount,
                // 'totalPaid' => $request->paid,  
                // 'totalDue' => $totalAmount-$request->paid,               
                // 'publicUrl' => route('order-management.public-url', [ 'purchase_id' => $purchaseId ]),
                //'moneyReceipt' => route('purchase.money_receipt', [ 'purchase_id' => $purchaseId ,'receive_payment_id' => $rcvPaymentId ]),
                //'editUrl' => route('purchase.edit', [ 'purchase' => $purchaseData ])
            ];
            if($purchaseId){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Purchase updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }

            //return $this->apiResponse(Response::HTTP_CREATED, 'Order created.', $responseData);

        } catch (\Throwable $th) {
            report($th);

            DB::rollBack();

            return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'Sorry, something went wrong. ' . $th->getMessage());
        }
        /**
         * @TODO instead of Throwable, use Exception
         */
    }

 
    
    function loadViewPurchase(Request $request){
        $purchase = Purchase::with('purchase_details')
                ->with(['purchase_details' => function($detail) {
                    $detail->with('product');
                }])
                ->findOrFail($request->id);
                abort_if(!$purchase, 404);

        $data = [
            'purchase' => $purchase           
        ];

        return view('seller.purchases.form-view-modal-purchase', $data);
        

    }
    
    function loadDeleteForm(Request $request){

        $purchase = Purchase::with('purchase_details')
                ->with(['purchase_details' => function($detail) {
                    $detail->with('product');
                }])
                ->findOrFail($request->id);
      
        abort_if(!$purchase, 404);
        
        $data = [
            'purchase' => $purchase           
        ];

        return view('seller.purchases.form-delete-modal-purchase', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('purchase_data')){
                session::forget('purchase_data');
            }

            Purchase::where('id', '=', $request->id)->delete();
            PurchaseDetails::where('purchase_id', '=', $request->id)->delete();

            ActivityLog::updateProductActivityLog('Delete purchase', $request->id);
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">Purchase is deleted successfully.</span>'
            ];
        }
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function bulkDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'bulk_ids' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('purchase_data')){
                session::forget('purchase_data');
            }
            $isBulkDelete = false;
            $arrBulkIds = explode(",",$request->bulk_ids);
            foreach($arrBulkIds as $id){
                Purchase::where('id', '=', $id)->delete();
                PurchaseDetails::where('purchase_id', '=', $id)->delete();
                PurchaseExtraCharges::where('purchase_id', '=', $request->id)->delete();
                $isBulkDelete = true;
            }

            if($isBulkDelete){
                ActivityLog::updateProductActivityLog('Bulk Delete purchase',count($arrBulkIds));
            }
            
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">Purchase is deleted successfully.</span>'
            ];
        }
    }

    

}