<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\ProductMainStock;
use App\Models\Role;
use App\Models\Shop;
use App\Models\Partner;
use App\Models\Payments;
use App\Models\OrderPurchaseDetail;
use App\Models\OrderManagementDetail;
use App\Models\Investment;
use App\Models\ReceivePayments;
use App\Models\Expenses;
use App\Models\Customers;
use App\Models\PaymentMethods;
use App\Models\User;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;

class PartnerController extends Controller
{
    public function managePartner()
    {
        $partners  = User::Where('role','partner')->get();
        $roles = Role::all();
        $title = 'users';
        return view('seller.manage-partner', compact('partners', 'roles', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            
            if (isset($request->id) && $request->id != null) {
                $data = Partner::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;
                $roles = Role::all();

                return view('elements.form-update-partner', compact(['data', 'id', 'roles']));
            }
           
            $data = Partner::with('shop')->orderBy('id', 'desc');

            if( Auth::user()->role =='admin'){
                $data->where('shop_id', Auth::user()->shop_id);
            }
            
            $data->get();
            
            $table = Datatables::of($data)
                ->addColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i');
                })
                ->addColumn('shop_name', function ($row) {
                    
                    return $row->shop->name;  
                    
                })
                ->addColumn('manage', function ($row) {
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                       <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--gray" title="'. __('translation.Receive') .'" data-id="' . $row->id . '" id="BtnPartnerPayments">
                                        <i class="fa fa-money-bill"></i>
                                    </button>
                                </div>';
                    
                })
                ->rawColumns(['manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|min:4',
            'email' => 'required|email|unique:users',
            'phone' => 'required|unique:users|numeric',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $user = Partner::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'shop_id' => Auth::user()->shop_id,
            'is_active' => '1'
        ]);


        return redirect()->back()->with('success', 'Partner successfully created');
    }

    public function update(Request $request)
    {
        $user = Partner::find($request->id);

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->address = $request->address;
        $user->update();

        return redirect('manage-partner')->with('success', __('translation.Data successfully updated'));
    }


    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        }

        $user = Partner::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }


    //    Partner Payment

    public function partnerPayments($partner_id)
    { 
        return view('seller.manage-partner-payments',compact('partner_id'));
    }

    public function partnerPaymentsData(Request $request)
    {           
        $data = Payments::with('partner')
        ->with('payment_method')
        ->where('partner_id',$request->partner_id)
        ->where('shop_id', Auth::user()->shop_id)
        ->orderBy('id', 'desc')->get();
      
        $table = Datatables::of($data)
            ->addColumn('payment_date', function ($row) {
                return $row->payment_date;
            })

            ->addColumn('partner_name', function ($row) {                
                return $row->partner->name;                  
            })

            ->addColumn('payment_method', function ($row) {                
                return $row->payment_method->name;                  
            })

            

            ->addColumn('paid', function ($row) {                
                return number_format($row->paid,2);                  
            })
            ->rawColumns(['paid'])
            ->make(true);

            return $table;
    }

    public function mainStockReport()
    {

        $data = [
            'products' => Product::where('shop_id',Auth::user()->shop_id)->get(),
            'payments' => Payments::where('shop_id',Auth::user()->shop_id)->orderBy('type')->get(),
            'payment_methods' => PaymentMethods::get(),
        ];
        return view('seller.report.stocks.index',$data);
    }

    public function partnerProfit(Request $request)
    {
        $orderPurchaseDetail = OrderPurchaseDetail::selectRaw("*")
                ->with('product');
                if($request->productId){
                    $orderPurchaseDetail->where("product_id", $request->productId);
                }
        $orderPurchaseDetail->get();

        
        $sales = OrderManagementDetail::selectRaw("*")
                ->with('product');

                if($request->productId){
                    $sales->where("product_id", $request->productId);
                }

        $sales->get();

        $mainStocks = ProductMainStock::selectRaw("*")
                ->with('product');
                if($request->productId){
                    $mainStocks->where("product_id", $request->productId);
                }
        $mainStocks->get();

     
        $param['order_date'] = '';
        

        
        $payment_date = date('Y-m-d');
        

        $investment = Investment::with('shop')->with('partner')->where('shop_id', Auth::user()->shop_id)->orderBy('id', 'desc')->get();
        $payments = Payments::with('partner')
        ->with('payment_method')
        ->where('type', 'partner')
        ->where('shop_id', Auth::user()->shop_id)
        ->orderBy('id', 'desc')->get();
       
        $partners = array();
        $total_payment = 0;
        if($payments){
            foreach($payments as $row){
                $partners[$row->partner->name][] = $row->paid;  
            }

            $arr_payments = [];
            $arr_inv_percentage = [];
            foreach($partners as $partner_name=>$arr_item){
            $arr_payments[$partner_name] = array_sum($arr_item); 
            }  

        }
   

        $cashIn = ReceivePayments::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();
        $cashOut = Payments::select('*',DB::raw('sum(paid) as total')                                )
                ->groupBy('type','payment_method_id')
                ->with('payment_method')
                ->where('payment_date','<=', $payment_date)
                
                ->get();

        $expenses = Expenses::select('*',DB::raw('sum(total) as total')                                )
                ->where('entry_date','<=', $payment_date)
                ->get();


        $data = [
            'customer_details' => Customers::where('id',$request->customerId)->first(),
            'orderPurchaseDetail' => $orderPurchaseDetail->get(),
            'sales' => $sales->get(),            
            'mainStocks' => $mainStocks->get(),
            'investment' => $investment,
            'arr_payments' => $arr_payments,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'expenses' => $expenses
        ];

        return view('seller.partner-profit',$data);
    }

}
