<?php 
// LocationController.php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\District;
use App\Models\PostalCode;

class LocationController extends Controller
{
    public function getDistricts()
    {
        $districts = District::distinct('district')->select('district')->get();
        return response()->json($districts);
    }

    public function getThanas($districtName)
    {
        $thanas = District::distinct('thana')->select('thana')->where('district', $districtName)->orderBy('thana','asc')->get();
        return response()->json($thanas);
    }

    public function getPostOffices($thanaName)
    {
        $postalOffices = District::distinct('postoffice')->select('postoffice')->where('thana', $thanaName)->orderBy('postoffice','asc')->get();
        return response()->json($postalOffices);
    }

    public function getPostalCodes($postofficeName)
    {
        $postalCode = District::distinct('postcode')->select('postcode')->where('postoffice', $postofficeName)->orderBy('postcode','asc')->first();
        return response()->json($postalCode);
    }
}
