<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\ProductMainStock;
use App\Models\Role;
use App\Models\Shop;
use App\Models\Investment;
use App\Models\Partner;
use App\Models\User;
use Illuminate\Http\Request;
use Datatables;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;

class InvestmentController extends Controller
{
    public function manageInvestment()
    {
        $investments  = User::Where('role','investment')->get();
        $partners = Partner::where('shop_id',Auth::user()->shop_id)->get();
        $title = 'users';
        return view('seller.manage-investment', compact('investments', 'partners', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {

            if (isset($request->id) && $request->id != null) {
                $data = Investment::where([
                    'id' => $request->id
                ])->first();

                $id = $request->id;
                $partners = Partner::where('shop_id',Auth::user()->shop_id)->get();

                return view('elements.form-update-investment', compact(['data', 'id', 'partners']));
            }
           
            $data = Investment::with('shop')->with('partner')->orderBy('id', 'desc');
            $data->where('shop_id', Auth::user()->shop_id);
            
            
            $data->get();
            
            $table = Datatables::of($data)
                ->addColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i');
                })
                ->addColumn('partner_name', function ($row) {
                    
                    return $row->partner->name;  
                    
                })
                ->addColumn('shop_name', function ($row) {
                    
                    return $row->shop->name;  
                    
                })

                ->addColumn('amount', function ($row) {
                    
                    return number_format($row->amount,2);  
                    
                })
                ->addColumn('manage', function ($row) {
                        return '<div class="w-full text-center">
                                    <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-id="' . $row->id . '" id="BtnUpdate">
                                       <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-id="' . $row->id . '" id="BtnDelete">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>';
                    
                })
                ->rawColumns(['amount','manage'])
                ->make(true);
            return $table;
        }
    }

    public function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'partner_id' => 'required',
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $investment = Investment::create([
            'partner_id' => $request->partner_id,
            'amount' => $request->amount,
            'shop_id' => Auth::user()->shop_id
        ]);


        return redirect()->back()->with('success', 'Investment successfully created');
    }

    public function update(Request $request)
    {
        $investment = Investment::find($request->id);

        $validator = Validator::make($request->all(), [
            'amount' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $investment->amount = $request->amount;
        $investment->update();

        return redirect('manage-investment')->with('success', __('translation.Data successfully updated'));
    }


    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        }

        $user = Investment::where('id', $request->id)->delete();
        return [
            'status' => 1
        ];
    }

}
