<?php

namespace App\Http\Controllers;

use App\Actions\OrderManagement\CalculateTotalAmountAction;
use App\Http\Requests\OrderManagement\DatatableRequest;
use App\Http\Requests\OrderManagement\StoreRequest;
use App\Http\Requests\OrderManagement\UpdateRequest;
use App\Http\Resources\ProductTypeAheadResource;
use App\Models\Channel;
use App\Models\Customer;
use App\Models\CustomerOrder;
use App\Models\OrderManagement;
use App\Models\OrderManagementDetail;
use App\Models\Permission;
use App\Models\Product;
use App\Models\Payment;
use App\Models\ReceivePayment;
use App\Models\ProductPrice;
use App\Models\Category;
use App\Models\PaymentMethod;
use App\Models\BanksOrMobiles;
use App\Models\District;
use App\Models\CustomerShippingMethod;
use App\Models\Shipper;
use App\Models\Shipment;
use App\Models\ShipmentProduct;
use App\Models\ShippingCost;
use App\Models\Shop;
use App\Models\TaxRateSetting;
use App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use Jenssegers\Agent\Agent;
use Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use PDF;
use Carbon\Carbon;
use DateTime;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;

/**
 * @TODO do not include, put KSHER SDK in 'App->Custom' directory
 * @TODO then load KSHER with composer autoloader and use like other classes
 * @TODO you have to put namespace in order to use it
 * @TODO remove all unused variables
 */

class FormsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index($customerType = '0')
    {
        $sellerId = Auth::user()->id;
        $roleName = Auth::user()->role;

        $totalProcessingOrders = OrderManagement::where('seller_id', $sellerId)
                                ->where('order_status', OrderManagement::ORDER_STATUS_PROCESSING)
                                ->customerAsset($roleName)
                                ->count();

        $totalProcessingDropshipperOrders = OrderManagement::where('seller_id', $sellerId)
                                ->where('order_status', OrderManagement::ORDER_STATUS_PROCESSING)
                                ->count();

        $statusSchema = OrderManagement::getStatusSchemaForDatatable($roleName, $customerType);
        $defaultStatusOrderId = array_column($statusSchema[0]['sub_status'], 'id')[0];
        
        $data = [
            'totalProcessingOrders' => $totalProcessingOrders,
            'totalProcessingDropshipperOrders' => $totalProcessingDropshipperOrders,
            'totalProcessingWooCommerce' => '',
            'statusSchema' => $statusSchema,
            'defaultStatusOrderId' => $defaultStatusOrderId,
            'customerType' => $customerType
        ];

        return view('seller.forms.index', $data);
    }

    /**
     * Handle server-side datatable of order managements
     *
     * @param  \App\Http\Requests\OrderManagement\DatatableRequest  $request
     * @return Response
     */
    public function data(DatatableRequest $request)
    {
        $sellerId = Auth::user()->id;

        $orderManagementsTable = (new OrderManagement())->getTable();
        $customersTable = (new Customer())->getTable();
        $shipmentTable = (new Shipment())->getTable();

        $orderStatusId = $request->get('status', 0);

        // return $orderStatusId;


        $search = isset($request->get('search')['value'])
                ? $request->get('search')['value']
                : null;

        $orderColumnIndex = isset($request->get('order')[0]['column'])
                            ? $request->get('order')[0]['column']
                            : 1;
        $orderDir = isset($request->get('order')[0]['dir'])
                    ? $request->get('order')[0]['dir']
                    : 'desc';

        $availableColumnsOrder = [
            'id', 'id'
        ];

        $orderColumnName = isset($availableColumnsOrder[$orderColumnIndex])
                            ? $availableColumnsOrder[$orderColumnIndex]
                            : $availableColumnsOrder[0];

        $roleName = Auth::user()->role;

        $orderManagements = OrderManagement::selectRaw("{$orderManagementsTable}.*")
                ->where("{$orderManagementsTable}.shop_id", Auth::user()->shop_id)
                ->with('shop')
                ->withCount('order_management_details')
                ->joinedDatatable()
                ->with('customer')
                ->searchDatatable($search)
                ->orderBy($orderColumnName, $orderDir)
                ->get();
                
        
        return Datatables::of($orderManagements)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($row) {
                    return $row->id;
                })
                ->addColumn('order_data', function ($row) use ($orderStatusId) {
                    $currentShipment = Shipment::where('id', $row->shipment_row_id)->first();
                    $paymentStatus = '
                        <span class="badge-status--red">
                            '. $row->str_payment_status .'
                        </span>
                    ';

                    if ($row->payment_status == OrderManagement::PAYMENT_STATUS_PAID) {
                        $payment_method = '';
                        if ($row->payment_method == OrderManagement::PAYMENT_METHOD_BANK_TRANSFER)
                            $payment_method = ' by Bank Transfer';
                        elseif ($row->payment_method == OrderManagement::PAYMENT_METHOD_INSTANT)
                            $payment_method = ' by Instant Pay';

                        $paymentStatus = '
                            <span class="badge-status--green">
                                '. $row->str_payment_status . $payment_method .'
                            </span>
                        ';
                    }

                    $channelName = $row->channels->name;
                    $shopName = $row->shop->name;
                    if (!empty($row->channels) && file_exists(public_path($row->channels->image))) {
                        $image = asset($row->channels->image);
                    }
                    else {
                        $image = asset('img/No_Image_Available.jpg');
                    }
                    if ($row->customer_type == 1) {
                        $channelName = 'Dropshipper';
                    }

                    $productDetails = '';
                    $getAllOredredDetails = OrderManagement::getAllOredredDetails($row->id);
                    if(!empty($getAllOredredDetails)){
                        foreach($getAllOredredDetails as $product)
                        $productDetails .= '<div>
                                                <strong>Part No:</strong><span class="">
                                                    '. $product->part_no .'
                                                </span>
                                            </div>
                                            <div>
                                            <strong>Part Name:</strong><span class="">
                                                    '. $product->part_name .'
                                                </span>
                                            </div>';
                    }
                    
            

                        $publicPageBtn = '';
                        
                        
                        $publicPageBtn .= "<a href='". route("forms.owner-particulars", [ "order_id" => $row->order_id ]) ."' target='blank' class='btn-action--green' title='Owner's particulars'>
                                            <i class='fas fa-user'></i>
                                            <span class='ml-2 hidden lg:inline'>Owner's particulars</span>
                                        </a>";
                                            
                        $publicPageBtn .= '<a href="'. route('forms.fees-detail', [ 'order_id' => $row->order_id ]) .'" target="_blank" class="btn-action--blue" title="Fees Details BRTA">
                                            <i class="fas fa-money-bill-alt"></i>
                                            <span class="ml-2 hidden lg:inline">Fees Details BRTA</span>
                                        </a>';

                        $publicPageBtn .= '<a href="'. route('forms.appication-for-registration', [ 'order_id' => $row->order_id ]) .'" target="_blank" class="btn-action--yellow" title="Application For Registration">
                        <i class="fa-solid fa-list"></i>
                                        <span class="ml-2 hidden lg:inline">Application For Registration</span>
                                    </a>';  
                                    
                        $publicPageBtn .= '<a href="'. route('forms.delivery-challan', [ 'order_id' => $row->order_id ]) .'" target="_blank" class="btn-action--red" title="Delivery Challan">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-5 h-5 bi bi-truck" viewBox="0 0 16 16"><path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"></path></svg>
                                        <span class="ml-2 hidden lg:inline">Delivery Chalan</span>
                                    </a>'; 

               
                         
                        
                        $functionalBtns = $publicPageBtn;
                    

                    $rowId = $row->id;
                    if ($orderStatusId >= 10){
                        $rowId = $row->id;
                    }

                    $printDate = '';
                    if ($orderStatusId >= 10 && $currentShipment->print_status == 1){
                        $printDate = '<div class="mb-1 sm:mb-2">
                                             Printed At : ' . date('d-m-Y h:i A', strtotime($currentShipment->print_date_time)) . ' ( ' . $currentShipment->printer->name . ' )
                                        </div>
                                        ';
                    }

                    $totalItemsTitle = 'Total Amount : ';
                    if ($orderStatusId == Shipment::SHIPMENT_STATUS_READY_TO_SHIP){
                        $totalItemsTitle = 'Total Items : ';
                    }

                    return '
                        <div class="border border-solid border-gray-400 lg:border-gray-300 rounded-md hover:bg-blue-50">
                            <div class="border border-dashed border-t-0 border-r-0 border-l-0 border-gray-300">
                                <div class="grid grid-cols-3">
                                    <div class="col-span-3 sm:col-span-1">
                                        <a href="'. route('order_management.edit', [ 'order_management' => $row ]) .'" data-id="'.$row->id.'" order-status-id="'.$row->order_status.'" class="cursor-pointer underline" title="Edit">
                                            <div class="text-center px-2 py-1 sm:py-2">
                                                <span class="font-bold text-gray-400">#</span>
                                                <span class="relative -left-1 text-blue-500 font-bold">
                                                    <strong>'. $rowId .'</strong>
                                                </span>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-span-3 sm:col-span-1">
                                        <div class="px-2 py-1 sm:py-2">
                                            <span class="text-xs sm:text-sm">
                                            <strong>Details</strong>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-span-3 sm:col-span-1">
                                        <div class="px-2 py-1 sm:py-2">
                                        <strong>Actions</strong>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="grid grid-cols-1 lg:grid-cols-3">
                                    <div class="lg:col-span-2">
                                        <div class="grid grid-cols-5">
                                            <div class="col-span-5 sm:col-span-2 px-2 py-2">
                                                <div class="">
                                                    <span class="badge-status--yellow">
                                                        '. $shopName .'
                                                    </span>
                                                </div>
                                                
                                                '. $productDetails .'

                                                <div style="position:relative;z-index:9999;" class="mt-5 flex text-center sm:text-left gap-2">
                                                         '. $functionalBtns .'
                                                    </div>
                                            </div>
                                            <div class="col-span-5 sm:col-span-3">
                                                <div class="text-left px-2 py-2">
                                                    <div>
                                                        <span class="text-gray-600">
                                                            Cust. Name :
                                                        </span>'. $row->customer->customer_name .'
                                                    </div>
                                                    <div>
                                                        <span class="text-gray-600">
                                                            '. $totalItemsTitle .'
                                                        </span> '. currency_symbol('BDT') . number_format((float)$row->in_total, 2, '.', '').'
                                                       ( <a data-order-id="' . $row->id . '" data-shipment-id="' . $row->shipment_row_id . '" class="modal-open cursor-pointer" onClick="productsOrdered(this)">' . $row->order_management_details_count .' Item/s</a> )
                                                    </div>
                                                    <div class="mb-3 text_uppercase">
                                                        <a id="" class="modal-open cursor-pointer text_uppercase"><font class="">' . $paymentStatus .'</font></a>
                                                    </div>
                                                    
                                                    <div class="text-center sm:text-left">
                                                         '. $printDate .'
                                                    </div>
                                                    
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="lg:col-span-1">
                                        <div class="border border-dashed border-r-0 border-b-0 border-l-0 border-gray-300">
                                            <div class="px-2 py-2 lg:text-left">
                                                <div class="text-xs sm:text-sm">
                                                    <span class="text-gray-600">Order Date :</span> '. date('d/m/Y h:i a', strtotime($row->created_at)) .'
                                                </div>
                                                <div class="text-xs sm:text-sm">
                                                    <span class="text-gray-600">Created By :</span> '. $row->creator->name .'
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    ';
                })
                ->rawColumns(['checkbox', 'order_data'])
                ->make(true);
    }

    /**
     * View the owner Particular
     *
     * @param  string  $orderId
     * @return  \Illuminate\View\View
     */
    public function ownerPerticulars($orderId)
    {
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('channels')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->with(['receive_payments' => function($payment) {
                                $payment->orderBy('created_at', 'desc')
                                    ->take(1);
                            }])
                            ->first();
        //dd($orderManagement);                    
        $orderPaymentDeatails = ReceivePayment::where('order_id', $orderManagement->id)->first();

        abort_if(!$orderManagement, Response::HTTP_NOT_FOUND, 'Order not found.');

        $sellerId = $orderManagement->seller_id;

        $data = [
            'orderManagement' => $orderManagement,
            'isSelectedShippingMethod' => CustomerShippingMethod::IS_SELECTED_YES,
            'payment_methodBankTransfer' => OrderManagement::PAYMENT_METHOD_BANK_TRANSFER,
            'payment_methodInstant' => OrderManagement::PAYMENT_METHOD_INSTANT,
            'orderStatusPending' => OrderManagement::ORDER_STATUS_PENDING,
            'orderStatusPendingPayment' => OrderManagement::ORDER_STATUS_PENDING_PAYMENT,
            'orderStatusProcessing' => OrderManagement::ORDER_STATUS_PROCESSING,
            'paymentStatusUnPaid' => OrderManagement::PAYMENT_STATUS_UNPAID,
            'paymentStatusPaid' => OrderManagement::PAYMENT_STATUS_PAID,
            'orderStatusPaymentUnconfirmed' => OrderManagement::ORDER_STATUS_PAYMENT_UNCONFIRMED,
            'orderStatusCancel' => OrderManagement::ORDER_STATUS_CANCEL,
            'statusForInfoAlert' => OrderManagement::getStatusForInfoAlert(),
            'orderPaymentDeatails' => $orderPaymentDeatails,
            'taxEnableValues' => OrderManagement::getAllTaxEnableValues(),
            'taxEnableYes' => OrderManagement::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first()
        ];
        
        return view('seller.forms.owner-particulars', $data);
    }



    public function pdfPrintOwnerParticulars(Request $request){
        $orderId = $request->order_id;
        
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->first();
                           
        $pages = PDF::setOptions(['isPhpEnabled' => true]);
        $pdf = PDF::loadView('seller.forms.owner_particulars_pdf', compact('orderManagement', 'pages'));
                          
        return $pdf->stream('owner-particulars.pdf');
    }



    /**
     * View the fees Detail BRTA
     *
     * @param  string  $orderId
     * @return  \Illuminate\View\View
     */
    public function feesDetailBRTA($orderId)
    {
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('channels')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->with(['receive_payments' => function($payment) {
                                $payment->orderBy('created_at', 'desc')
                                    ->take(1);
                            }])
                            ->first();
        //dd($orderManagement);                    
        $orderPaymentDeatails = ReceivePayment::where('order_id', $orderManagement->id)->first();

        abort_if(!$orderManagement, Response::HTTP_NOT_FOUND, 'Order not found.');

        $sellerId = $orderManagement->seller_id;

        $data = [
            'orderManagement' => $orderManagement,
            'isSelectedShippingMethod' => CustomerShippingMethod::IS_SELECTED_YES,
            'payment_methodBankTransfer' => OrderManagement::PAYMENT_METHOD_BANK_TRANSFER,
            'payment_methodInstant' => OrderManagement::PAYMENT_METHOD_INSTANT,
            'orderStatusPending' => OrderManagement::ORDER_STATUS_PENDING,
            'orderStatusPendingPayment' => OrderManagement::ORDER_STATUS_PENDING_PAYMENT,
            'orderStatusProcessing' => OrderManagement::ORDER_STATUS_PROCESSING,
            'paymentStatusUnPaid' => OrderManagement::PAYMENT_STATUS_UNPAID,
            'paymentStatusPaid' => OrderManagement::PAYMENT_STATUS_PAID,
            'orderStatusPaymentUnconfirmed' => OrderManagement::ORDER_STATUS_PAYMENT_UNCONFIRMED,
            'orderStatusCancel' => OrderManagement::ORDER_STATUS_CANCEL,
            'statusForInfoAlert' => OrderManagement::getStatusForInfoAlert(),
            'orderPaymentDeatails' => $orderPaymentDeatails,
            'taxEnableValues' => OrderManagement::getAllTaxEnableValues(),
            'taxEnableYes' => OrderManagement::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first()
        ];
        
        return view('seller.forms.fees-detail', $data);
    }



    public function pdfFeesDetailBRTA(Request $request){
        $orderId = $request->order_id;
        
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->first();
                          
        $pages = PDF::setOptions(['isPhpEnabled' => true]);
        $pdf = PDF::loadView('seller.forms.fees_detail_pdf', compact('orderManagement', 'pages'));
                          
        return $pdf->stream('fees-detail.pdf');
    }


        /**
     * View the fees Detail BRTA
     *
     * @param  string  $orderId
     * @return  \Illuminate\View\View
     */
    public function applicationForRegistration($orderId)
    {
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('channels')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->with(['receive_payments' => function($payment) {
                                $payment->orderBy('created_at', 'desc')
                                    ->take(1);
                            }])
                            ->first();
        //dd($orderManagement);                    
        $orderPaymentDeatails = ReceivePayment::where('order_id', $orderManagement->id)->first();

        abort_if(!$orderManagement, Response::HTTP_NOT_FOUND, 'Order not found.');

        $sellerId = $orderManagement->seller_id;
        //dd($orderManagement);                    
        $data = [
            'orderManagement' => $orderManagement,
            'isSelectedShippingMethod' => CustomerShippingMethod::IS_SELECTED_YES,
            'payment_methodBankTransfer' => OrderManagement::PAYMENT_METHOD_BANK_TRANSFER,
            'payment_methodInstant' => OrderManagement::PAYMENT_METHOD_INSTANT,
            'orderStatusPending' => OrderManagement::ORDER_STATUS_PENDING,
            'orderStatusPendingPayment' => OrderManagement::ORDER_STATUS_PENDING_PAYMENT,
            'orderStatusProcessing' => OrderManagement::ORDER_STATUS_PROCESSING,
            'paymentStatusUnPaid' => OrderManagement::PAYMENT_STATUS_UNPAID,
            'paymentStatusPaid' => OrderManagement::PAYMENT_STATUS_PAID,
            'orderStatusPaymentUnconfirmed' => OrderManagement::ORDER_STATUS_PAYMENT_UNCONFIRMED,
            'orderStatusCancel' => OrderManagement::ORDER_STATUS_CANCEL,
            'statusForInfoAlert' => OrderManagement::getStatusForInfoAlert(),
            'orderPaymentDeatails' => $orderPaymentDeatails,
            'taxEnableValues' => OrderManagement::getAllTaxEnableValues(),
            'taxEnableYes' => OrderManagement::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first()
        ];
        
        return view('seller.forms.appication-for-registration', $data);
    }


            /**
     * View the fees Detail BRTA
     *
     * @param  string  $orderId
     * @return  \Illuminate\View\View
     */
    public function deliveryChallan($orderId)
    {
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('channels')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->with(['receive_payments' => function($payment) {
                                $payment->orderBy('created_at', 'desc')
                                    ->take(1);
                            }])
                            ->first();
                  
        $orderPaymentDeatails = ReceivePayment::where('order_id', $orderManagement->id)->first();

        abort_if(!$orderManagement, Response::HTTP_NOT_FOUND, 'Order not found.');

        $sellerId = $orderManagement->seller_id;

        $data = [
            'orderManagement' => $orderManagement,
            'isSelectedShippingMethod' => CustomerShippingMethod::IS_SELECTED_YES,
            'payment_methodBankTransfer' => OrderManagement::PAYMENT_METHOD_BANK_TRANSFER,
            'payment_methodInstant' => OrderManagement::PAYMENT_METHOD_INSTANT,
            'orderStatusPending' => OrderManagement::ORDER_STATUS_PENDING,
            'orderStatusPendingPayment' => OrderManagement::ORDER_STATUS_PENDING_PAYMENT,
            'orderStatusProcessing' => OrderManagement::ORDER_STATUS_PROCESSING,
            'paymentStatusUnPaid' => OrderManagement::PAYMENT_STATUS_UNPAID,
            'paymentStatusPaid' => OrderManagement::PAYMENT_STATUS_PAID,
            'orderStatusPaymentUnconfirmed' => OrderManagement::ORDER_STATUS_PAYMENT_UNCONFIRMED,
            'orderStatusCancel' => OrderManagement::ORDER_STATUS_CANCEL,
            'statusForInfoAlert' => OrderManagement::getStatusForInfoAlert(),
            'orderPaymentDeatails' => $orderPaymentDeatails,
            'taxEnableValues' => OrderManagement::getAllTaxEnableValues(),
            'taxEnableYes' => OrderManagement::TAX_ENABLE_YES,
            'taxRateSetting' => TaxRateSetting::where('seller_id', $sellerId)->first()
        ];
        
        return view('seller.forms.delivery-challan', $data);
    }



    public function pdfDeliveryChallan(Request $request){
        $orderId = $request->order_id;
        
        $orderManagement = OrderManagement::where('order_id', $orderId)
                            ->with('shop')
                            ->with('customer')
                            ->with(['order_management_details' => function($detail) {
                                $detail->with('product');
                            }])
                            ->first();
                          
        $pages = PDF::setOptions(['isPhpEnabled' => true]);
        $pdf = PDF::loadView('seller.forms.delivery_challan_pdf', compact('orderManagement', 'pages'));
                          
        return $pdf->stream("delivery-challan-$orderId.pdf");
    }





    public function getOrderedProducts(Request $request)
    {
        $orderId = $request->get('orderId', 0);
        $shipmentId = $request->get('shipmentId', 0);

        $orderDetails = OrderManagementDetail::where('order_management_id', $orderId)->with('product')->get();
        $shipments = ShipmentProduct::where('shipment_id', $shipmentId)->get();

        $productData = [];

        foreach ($orderDetails as $item) {

            $row = [];
            $row[] = '
                <div class="grid grid-cols-1 gap-4">
                    <div>
                        <img src="'. $item->product->image_url .'" class="w-16 md:w-11/12 h-auto" />
                    </div>
                    <div>
                        <span class="whitespace-nowrap text-blue-500">
                            ID : <strong>'. $item->product->id .'</strong>
                        </span>
                    </div>
                </div>
            ';

            $productPrice = $item->price - $item->discount_price;
            $shippedProducts = $item->quantity;
            foreach ($shipments as $shipment){
                if ($shipment->product_id == $item->product_id){
                    $shippedProducts = $shipment->quantity;
                }
            }

            $shippedProductsContents = '';
            if (!empty($shipmentId)){
                $shippedProductsContents = '
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Shipment Qty :
                            </label>
                            <span class="text-gray-900">
                                '. number_format($shippedProducts) .'
                            </span>
                        </div>
                    </div>
                    ';
            }

            $row[] = '
                <div>
                    <div class="mb-1">
                        <strong>'. $item->product->part_name .'</strong>
                    </div>
                    <div class="mb-1">
                        <strong class="text-blue-500">'. $item->product->part_no .'</strong>
                    </div>
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Price :
                            </label>
                            <span>'. currency_symbol('BDT') . number_format(floatval($productPrice), 2) .'</span>
                        </div>
                    </div>
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Ordered Qty :
                            </label>
                            <span class="text-gray-900">
                                '. number_format($item->quantity) .'
                            </span>
                        </div>
                    </div>
                   ' . $shippedProductsContents . '
                    <div class="mb-1">
                        <div class="whitespace-nowrap">
                            <label class="text-gray-700">
                                Total Price :
                            </label>
                            <strong class="">'. currency_symbol('BDT') . number_format(floatval($productPrice * $shippedProducts), 2) .'</strong>
                        </div>
                    </div>
                </div>
            ';

            $productData[] = $row;
        }

        return response()->json([
            'data' => $productData,
        ]);
    }



}
