<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use DB;
class ExpenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $data = Expense::get();
        $title = 'expense';
        return view('expenses.index',compact('data', 'title'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()){

            if (isset($request->reference) && $request->reference != null) {
                $expenses = Expense::where([
                    'reference' => $request->reference
                ])->get();
                return view('expenses.form-update',compact( 'expenses'));
            }
            $payment_date = $request->get("payment_date");

            $start_date = $request->start_date != null ? date('Y-m-d', strtotime($request->start_date)) : '';
            $end_date = $request->end_date != null ? date('Y-m-d', strtotime($request->end_date)) : '';
            $payment_date = $request->get("payment_date") != null ? date('Y-m-d', strtotime($request->get("payment_date"))) : '';
            
            $data = Expense::select(DB::raw('group_concat(name) as names'),
                            DB::raw('sum(amount) as total'),'entry_date','reference','note'
                            )
            ->orderBy('entry_date','asc')
            ->groupBy('reference');

            if($start_date){
                $data = $data->whereBetween('entry_date',[$start_date, $end_date]);
            }
           
            if($payment_date){
                $data = $data->where('entry_date',"$payment_date");
            }

            if(Auth::user()->shop_id){
                $data = $data->where('shop_id',Auth::user()->shop_id);
            }

            $data = $data->get();
           

            $table = Datatables::of($data)

                ->addColumn('entry_date', function ($row) {
                    return $row->entry_date;
                })
                ->addColumn('name', function ($row) {
                    return $row->names;
                })
                ->addColumn('amount', function ($row) {
                    $total = number_format($row->total,2);
                    return "<strong>$total</strong>";
                })
                ->addColumn('manage', function ($row) {
                    return '
                        <div class="w-full text-center">
                            <button type="button" class="modal-open btn-action--green" title="'. __('translation.Edit') .'" x-on:click="showEditModal=true" data-reference="' . $row->reference . '" id="BtnUpdate">
                                <i class="fas fa-pencil-alt"></i>
                            </button>
                            <button type="button" class="btn-action--red" title="'. __('translation.Delete') .'" data-reference="' . $row->reference . '" id="BtnDelete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    ';
                })
                ->rawColumns(['entry_date','name','amount','manage'])
                ->make(true);

            return $table;
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(isset($request->name) && count($request->name) > 0){
            foreach($request->name as $key=>$row){
                if ($row != null) {
                    $expense = new Expense();
                    $expense->reference = $request->reference;
                    $expense->entry_date = $request->entry_date ? date('Y-m-d', strtotime($request->entry_date)) : NULL ;
                    $expense->name = $row;
                    $expense->amount = $request->amount[$key];
                    $expense->note = $request->note;
                    $expense->seller_id = Auth::user()->id;
                    $expense->shop_id = Auth::user()->shop_id;
                    $expense->save();
                }
            }
        }

        if($expense)
        {
            return redirect()->back()->with('success','Expense Added Successfully');
        }
        else{
            return redirect()->back()->with('danger','Something happened wrong');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'reference' => 'required',
            'amount' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }


        Expense::where('reference', $request->reference)->delete();
        if(isset($request->name) && count($request->name) > 0){
            foreach($request->name as $key=>$row){
                if ($row != null) {
                    $expense = new Expense();
                    $expense->reference = $request->reference;
                    $expense->entry_date = $request->entry_date ? date('Y-m-d', strtotime($request->entry_date)) : NULL ;
                    $expense->name = $row;
                    $expense->amount = $request->amount[$key];
                    $expense->note = $request->note;
                    $expense->seller_id = Auth::user()->id;
                    $expense->shop_id = Auth::user()->shop_id;
                    $expense->save();
                }
            }
        }

        if($expense)
        {
            return redirect('expenses')->with('success','Expense Updated Successfully');
        }
        else{
            return redirect('expenses')->with('danger','Something happened wrong');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function delete(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'reference' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => 'Field id is required'
            ]);
        } else {

            Expense::where('reference',$request->reference)->where('seller_id',Auth::user()->id)->delete();

            return [
                'status' => 1
            ];
        }
    }
}
