<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use App\Models\Permission;
use App\Models\User;
use App\Models\InitialTransaction;
use App\Models\ReceivePayments;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Http\Requests\Customers\{CustomerStoreRequest, CustomerUpdateRequest};
use App\Imports\BulkImport;
use App\Models\Product;
use App\Models\OrderManagement;
use App\Models\Customers;
use App\Models\CustomerDetails;
use App\Models\Supplier;
use App\Models\Lender;
use App\Models\Banks;
use App\Models\BanksOrMobiles;
use App\Models\Account;
use App\Models\Shop;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Datatables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

use App\Exports\OrderAnalysisExport;


class CustomerController extends Controller
{
    public function index()
    {

        $shop = Shop::where('id', Auth::user()->shop_id)->first();
        $customerCount = Customers::when(Auth::user()->role=='staff', function ($query){
                            $query->where('shop_id', Auth::user()->shop_id);
                        })
                        ->count();
        $shops = Shop::all();
        return view('seller.customers.index', compact('shop', 'customerCount','shops'));
    }



    public function data(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
      
                $customer = Customers::with('opening_due')->findOrFail($request->id); 
                
                $data = [
                    'shops' =>Shop::all(),
                    'customer' => $customer,
                ];

                return view("seller.customers.modal-templates.edit", $data);
            }

            $product_name = $request->get('product_name', '');
            $customer_type = $request->get('customer_type', '');
            $statusId = $request->get('statusId', '-1');
        
           
            $start = $request->get('start', 0);
            $limit = $request->get('length', 10);
            if ($limit < 1 OR $limit > 100) {
                $limit = 100;
            }

            $search = isset($request->get('search')['value'])
                    ? $request->get('search')['value']
                    : null;

            $orderColumnList = [
                'customers.id',
                'customer_name',
                'phone',
                'company',
                'address',
                'status',
            ];

            $orderColumnIndex = isset($request->get('order')[0]['column'])
                                ? $request->get('order')[0]['column']
                                : 0;
            $orderColumnDir = isset($request->get('order')[0]['dir'])
                                ? $request->get('order')[0]['dir']
                                : 'desc';
            $orderColumnDir = 'desc';

            $orderColumn = $orderColumnList[$orderColumnIndex] ?? 'product_id';

            $userRole = 'member';
            $userId = Auth::id();
            
            $data = Customers::searchTable($search)
                    ->with('opening_due')
                    
                    ->filterByStatus($statusId)
                    ->orderBy($orderColumn, $orderColumnDir)
                    ->take($limit)
                    ->skip($start)
                    // ->when(Auth::user()->role=='staff', function ($query){
                    //     $query->where('shop_id', Auth::user()->shop_id);
                    // })
                    ->get();

          
            
            $totalData = Customers::searchTable($search)
                        ->filterByStatus($statusId)
                        // ->when(Auth::user()->role=='staff', function ($query){
                        //     $query->where('shop_id', Auth::user()->shop_id);
                        // })
                        ->count();
            

            $table = Datatables::of($data)
            
           
                ->addColumn('id', function ($row) {                  
                    return $row->id;                    
                })

                ->addColumn('customer_name', function ($row) {
                    $customer_details = $row->customer_name;
                    return $customer_details;
                })
                ->addColumn('phone', function ($row) {
                    return $row->phone;
                })
                ->addColumn('company', function ($row) {
                    return $row->company;
                })
                ->addColumn('address', function ($row) {
                    return $row->address;
                })
                ->addColumn('total_due', function ($row) {
                    return $this->getCustomerDueById($row->id);
                })

                ->addColumn('status', function ($row) {
                    if($row->status==1){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-green-500/20 text-green-700 rounded-full text-center px-2.5 py-1">Active</div>
                        </div>
                        ';
                    }

                    if($row->status==0){
                        return '
                        <div class="text-center">
                            <div class="text-xs inline-flex font-medium bg-red-500/20 text-red-700 rounded-full text-center px-2.5 py-1">Deactive</div>
                        </div>
                        ';
                    }
                })    
                ->addColumn('actions', function ($row) {
                    $actionContent = '';
                    
                    $actionContent = '
                    <div class="w-full text-center">
                        <div class="flex flex-wrap items-center -m-1.5">
                                <div class="m-1.5">
                                    <button id="BtnStatusChange" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                        <svg class="fill-current text-violet-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                            <path d="M14.3 2.3L5 11.6 1.7 8.3c-.4-.4-1-.4-1.4 0-.4.4-.4 1 0 1.4l4 4c.2.2.4.3.7.3.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0z"></path>
                                        </svg>
                                    </button>
                                </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnEditItem" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-gray-400 dark:text-gray-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M11.7.3c-.4-.4-1-.4-1.4 0l-10 10c-.2.2-.3.4-.3.7v4c0 .6.4 1 1 1h4c.3 0 .5-.1.7-.3l10-10c.4-.4.4-1 0-1.4l-4-4zM4.6 14H2v-2.6l6-6L10.6 8l-6 6zM12 6.6L9.4 4 11 2.4 13.6 5 12 6.6z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                            <div class="m-1.5">
                                <!-- Start -->
                                <button id="BtnDeleteItem" data-id="'.$row->id.'" class="btn bg-white dark:bg-gray-800 border-gray-200 dark:border-gray-700/60 hover:border-gray-300 dark:hover:border-gray-600">
                                    <svg class="fill-current text-red-500 shrink-0" width="16" height="16" viewBox="0 0 16 16">
                                        <path d="M5 7h2v6H5V7zm4 0h2v6H9V7zm3-6v2h4v2h-1v10c0 .6-.4 1-1 1H2c-.6 0-1-.4-1-1V5H0V3h4V1c0-.6.4-1 1-1h6c.6 0 1 .4 1 1zM6 2v1h4V2H6zm7 3H3v9h10V5z"></path>
                                    </svg>
                                </button>
                                <!-- End -->
                            </div>
                        </div>                       
                    </div>
                    ';
                   
                    return $actionContent;
                })
                ->rawColumns(['id','customer_name','status','actions'])
                ->skipPaging()
                ->setTotalRecords($totalData)
                ->make(true);

            return $table;
        }
    }

    public function getCustomerDueById($customer_id)
    {
        Session::put('itemArray', []);
        $total_due = 0;
        $order_id = '';
        $receivable = InitialTransaction::where('transaction_type','receivable')->where('customer_id',$customer_id)->get();
        if($receivable){
         foreach($receivable as $row){
             $total_due += $row->amount;
         }
        }
        
        $sales = OrderManagement::where('customer_id',$customer_id)->get();
        if($sales){
         foreach($sales as $row){
             $total_due += !empty($row->in_total) ? $row->in_total : 0;
         }
        }
 
        $payable = InitialTransaction::where('transaction_type','payable')->where('customer_id',$customer_id)->get();
        if($payable){
         foreach($payable as $row){
             $total_due += $row->amount;
         }
        }
 
        $paid = ReceivePayments::where('customer_id',$customer_id)->get();
        if($paid){
         foreach($paid as $row){
             $total_due -= $row->paid;
         }
        }
        return $total_due;
    }

    function loadInsertForm(Request $request){
        $data = [
            'shops' =>Shop::all(),
        ];
        return view("seller.customers.modal-templates.create",$data);
    }

    /**
     * Store new customer
     *
     * @param CustomerStoreRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function insert(CustomerStoreRequest $request)
    {
        try {
            if(Session::has('customer_date')){
                $customer = Session::forget('customer_date');
            }

            
            $customer = new Customers();
            $customer->customer_name = $request->customer_name ?? NULL;
            $customer->company = $request->company ?? NULL;
            
            $customer->phone = $request->phone ?? NULL;
            $customer->address = $request->address ?? NULL;
            $customer->status = 1;
            $customer->save();
            $customerId = $customer->id; 
 
            if($customerId){

                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Customer created successfully</span>'
                ]);
            }

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()
                    ->with('error', $th->getMessage())
                    ->withInput();
        }
    }

    /**
     * Update the customer data
     *
     * @param CustomerUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(CustomerUpdateRequest $request)
    {
        try {
            if(Session::has('customer_date')){
                Session::forget('customer_date');
            }
            
            $customer = Customers::find($request->id);   
            $customer->customer_name = $request->customer_name ?? NULL;
            $customer->company = $request->company ?? NULL;
            $customer->phone = $request->phone ?? NULL; 
            $customer->address = $request->address ?? NULL;
            $customer->status = 1;
            $customer->save();
            $customerId = $customer->id; 



            
            if($customerId){

                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Customer updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    
    function loadDeleteForm(Request $request){

        $customer = Customers::findOrFail($request->id); 
       
        abort_if(!$customer, 404);

        $data = [
            'customer' => $customer           
        ];

        return view('seller.customers.modal-templates.delete', $data);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);

        $orderManagementDetail = OrderManagement::where('customer_id', '=', $request->id)->first();
        if($orderManagementDetail){
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">This Customer is already purchased Product, You may deactivate only.'
            ]);
        }

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('customer_date')){
                session::forget('customer_date');
            }

            Customers::where('id', '=', $request->id)->delete();

            ActivityLog::updateProductActivityLog('Delete  Customer', $request->id);
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600">This Entry is deleted successfully.</span>'
            ];
        }
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function bulkDelete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'bulk_ids' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 0,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-red-500">Field id is required</span>'
            ]);
        } else {

            if(session::has('customer_date')){
                session::forget('customer_date');
            }
            $isBulkDelete = false;
            $arrBulkIds = explode(",",$request->bulk_ids);
            foreach($arrBulkIds as $id){
                Customers::where('id', '=', $id)->delete();
                $isBulkDelete = true;
            }

            
            if($isBulkDelete){
                ActivityLog::updateProductActivityLog('Bulk Delete  Customers',count($arrBulkIds));
            }
            
                        
            return [
                'status' => 1,
                'message' => '<span class="pt-5 px-5 flex space-x-4 text-green-600"> Customers deleted successfully.</span>'
            ];
        }
    }


    public function statusFormLoad(Request $request)
    {
        if ($request->ajax()){
            
            if (isset($request->id) && $request->id != null) {
      
                $customer = Customers::findOrFail($request->id); 
                
                $data = [
                    'customer' => $customer,
                ];

                return view("seller.customers.modal-templates.status", $data);
            }
        }
    }

        /**
     * Update the stock data
     *
     * @param CustomerUpdateRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateStatus(Request $request)
    {
        try {
            if(Session::has('customer_date')){
                Session::forget('customer_date');
            }
            
            $customer = Customers::find($request->id);   

            $customer->status = $request->status ?? 0;
            $customer->seller_id = Auth::user()->id;
            //$customer->shop_id = Auth::user()->shop_id;
            $customer->save();
            $customerId = $customer->id; 
            
            if($customerId){
                return response()->json([
                    'status' => 1,
                    'message' => '<span class="flex space-x-4 text-green-600">Customer Status updated successfully</span>'
                ]);
            }
            else{
                return redirect()->back()->with('danger','Something happened wrong');
            }


        } catch (\Throwable $th) {
            report($th);
            return $this->apiResponse(500, "Something went wrong. {$th->getMessage()}");
        }
    }


    public function loadCustomerByUnitID(Request $request){
        $data = [
            'customers' => Customers::where('shop_id',$request->shop_id)->get(),
        ];
        return view('elements.load-customer-by-production-unit-id',$data);
    }

    

}