<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\RegisterRequest;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\SMS_ClASS\SMS;
use Tzsk\Otp\Facades\Otp;
use Session;
class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  RegisterRequest $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(RegisterRequest $request)
    {
        try {
            $unique_secret = 'moinuddin';
            $otp = Otp::generate($unique_secret);

            Session::put('user_phone',$request->phone);

            //$response = $this->sendOtp($request->phone, $otp);
            $user = new User();
            $user->name = $request->name;
            $user->username = $request->username;
            $user->contactname = $request->contactname;
            $user->phone = $request->phone;
            //$user->lineid = $request->lineid;
            $user->email = $request->email;
            $user->role = 'member';
            $user->otp = $otp;
            $user->is_active = 0;
            $user->password = Hash::make($request->password);
            $user->save();

            return redirect()->route('verify_mobile');

        } catch (\Throwable $th) {
            report($th);

            return redirect()->back()->with('failed', 'Ops somethings happened. Please try Again');
        }
    }


    public function sendOtp($mobile,$otp)
    {
        // $apiKey = '02a756f62c6e6ba391f9680e48814361';
        // $apiSecretKey = '0dba9623cacdbeab28c8a84510c1e1bf';

        $sms = new SMS($apiKey, $apiSecretKey);
        $body = [
            'msisdn' => $mobile,
            'message' => "Dodo tracking mobile verification. OTP : ".$otp,
            // 'sender' => '',
            // 'scheduled_delivery' => '',
            // 'force' => ''
        ];
       $res = $sms->sendSMS($body);

        if ($res->httpStatusCode == 201) {
            return true;
        } else {
          return false;
        }
    }

}
