<?php

namespace App\Actions\OrderManagement;

class CalculateTotalAmountAction
{
    /**
     * Calculate total amount / in_total of orders
     *
     * @param  double  $subTotal
     * @param  double  $taxRate
     * @param  double  $serviceCost
     * @param  double  $discountTotal
     * @return double
     */
    public function handle($subTotal, $taxRate, $serviceCost, $discountTotal)
    {
        $taxRateValue = 0;
        $subTotalAndShippingCost = $subTotal + $serviceCost;
        if ($taxRate > 0) {
            $taxRateValue = ($subTotalAndShippingCost - $discountTotal) * $taxRate / 100;
        }

        return $subTotalAndShippingCost - $discountTotal + $taxRateValue;
    }
}