<?php
use App\Http\Controllers\SettingsController;

use App\Http\Controllers\AdmissionFormController;
use App\Http\Controllers\FeeDetailsController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\TeachersController;
use App\Http\Controllers\StaffsController;

use App\Http\Controllers\AdmitCardController;
use App\Http\Controllers\SeatPlansController;

use App\Http\Controllers\MarksExportImportController;
use App\Http\Controllers\MarksReportBySubjectController;
use App\Http\Controllers\MarksReportByClassController;
use App\Http\Controllers\MarksController;
use App\Http\Controllers\DailyExpensesController;
use App\Http\Controllers\OthersCostController;
use App\Http\Controllers\SalaryController;

use App\Http\Controllers\PromotionController;
use App\Http\Controllers\StudentIdCardsController;
use App\Http\Controllers\VoterController;
use App\Http\Controllers\ResultController;
use App\Http\Controllers\ExpenseTypesController;

use App\Http\Controllers\ClassController;
use App\Http\Controllers\SectionController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\RemarkController;
use App\Http\Controllers\TransactionsController;


use App\Http\Controllers\ChannelController;


use App\Http\Controllers\DefectStockController;
use App\Http\Controllers\RoleController;

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TrackController;
use App\Http\Controllers\PersonController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\TrackingController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\Admin\ScanTranslationJobController;
use App\Http\Controllers\Admin\TranslationController;
use App\Http\Controllers\SchoolInfoSettingController;
use App\Http\Controllers\Category\CategorySelectController;
use App\Http\Controllers\Category\ParentOnlySelectController;
use App\Http\Controllers\CategoryController;


use App\Http\Controllers\OptController;

use App\Http\Controllers\StaffController;
use App\Http\Controllers\QrCodeController;


use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;

use App\Http\Controllers\ShopController;


// for woo

use App\Http\Controllers\LangSwitcherController;

use App\Http\Controllers\Shop\ShopSelectController;
use App\Http\Controllers\User\LanguageController;


// Route::get('/', [AuthenticatedSessionController ::class, 'create'])->name('front page');
Route::get('/', [TrackController::class, 'index'])->name('front page');
Route::post('/', [TrackController::class, 'getData']);
// Route::get('tes', [TrackController::class, 'getData']);
Route::get('/token', function () {
    return csrf_token();
});

Route::group(['middleware' => ['auth', 'translation']], function () {

    // Route::middleware(['staff'])->group(function () {

    //     Route::get('/staff', function () {
    //         return redirect(route('dashboard'));
    //     });
    //     Route::get('staff/dashboard', [StaffController::class, 'dashboard'])->name('staff dashboard');
    //     Route::get('quantity-update', [StaffController::class, 'quantityUpdate'])->name('quantity update');
    //     Route::get('staff/product/data', [StaffController::class, 'productData'])->name('product data staff');

    //     Route::get('staff/see-details/{id}', [StaffController::class, 'seeDetails'])->name('see quantity details');

    // });


    //Route::middleware(['member', 'staff'])->group(function () {

        Route::get('/person', function () {
            return redirect(route('dashboard'));
        });
        Route::get('/dashboard', [PersonController::class, 'dashboard'])->name('dashboard');
        Route::get('/chart-data', [PersonController::class, 'chartData']);
        Route::get('/person/manage-tracking', [TrackingController::class, 'index'])->name('manage tracking');
        Route::get('/tracking/data', [TrackingController::class, 'data'])->name('data tracking');
        Route::post('/tracking/insert', [TrackingController::class, 'store'])->name('insert tracking');
        Route::post('/tracking/import', [TrackingController::class, 'import'])->name('import tracking');
        Route::post('/tracking/update', [TrackingController::class, 'update'])->name('update order');
        Route::post('/tracking/delete', [TrackingController::class, 'delete'])->name('delete tracking');
        Route::get('/track-page', [TrackingController::class, 'trackPage'])->name('track page');
        // Dashboard
        Route::post('dashboard_fees_details_page_status',  [PersonController::class, 'FeeDetailsPage'])->name('dashboard_fees_details_page_status');
        Route::get('dashboard_fees_details_by_status',  [PersonController::class, 'FeeDetailsDataTable'])->name('dashboard_fees_details_by_status');
        Route::post('get_dashboard_student_details',  [PersonController::class, 'StudentDetails'])->name('get_dashboard_student_details');

        //Tracking
        Route::post('/track-id', [PersonController::class, 'TrackId'])->name('Track Id');


        //Others Collection
        Route::get('others-collection', [OthersCostController::class, 'othersCollection'])->name('others.collection');
        Route::get('others_collection/data', [OthersCostController::class, 'data'])->name('others_collection.data');
        Route::post('others_collection/insert', [OthersCostController::class, 'insert'])->name('others_collection.insert');
        Route::post('others_collection/update', [OthersCostController::class, 'update'])->name('others_collection.update');
        Route::post('others_collection/delete', [OthersCostController::class, 'delete'])->name('others_collection.delete');
        Route::get('others_collection/approve_others_collection_modal', [OthersCostController::class, 'changeStatusModal'])->name('others_collection.approve_others_collection_modal');
        Route::post('others_collection/change-status', [OthersCostController::class, 'changeStatus'])->name('others_collection.change_status');


        //Daily Transaction
        Route::get('transactions', [DailyExpensesController::class, 'dailyExpenses'])->name('transactions');

        //Daily Expense
        Route::get('daily-expense', [DailyExpensesController::class, 'dailyExpenses'])->name('daily.expense');
        Route::get('daily_expense/data', [DailyExpensesController::class, 'data'])->name('daily_expense.data');
        Route::post('daily_expense/insert', [DailyExpensesController::class, 'insert'])->name('daily_expense.insert');
        Route::post('daily_expense/update', [DailyExpensesController::class, 'update'])->name('daily_expense.update');
        Route::post('daily_expense/delete', [DailyExpensesController::class, 'delete'])->name('daily_expense.delete');
        Route::get('daily_expense/approve_daily_expense_modal', [DailyExpensesController::class, 'changeStatusModal'])->name('daily_expense.approve_daily_expense_modal');
        Route::post('daily_expense/change-status', [DailyExpensesController::class, 'changeStatus'])->name('daily_expense.change_status');

        //Daily Expense
        Route::get('salaries', [SalaryController::class, 'salaries'])->name('salaries');
        Route::get('salaries/data', [SalaryController::class, 'data'])->name('salaries.data');
        Route::post('salaries/insert', [SalaryController::class, 'insert'])->name('salaries.insert');
        Route::post('salaries/update', [SalaryController::class, 'update'])->name('salaries.update');
        Route::post('salaries/delete', [SalaryController::class, 'delete'])->name('salaries.delete');
        Route::get('salaries/approve_salaries_modal', [SalaryController::class, 'changeStatusModal'])->name('salaries.approve_salaries_modal');
        Route::post('salaries/change-status', [SalaryController::class, 'changeStatus'])->name('salaries.change_status');
        Route::get('autocomplete', [SalaryController::class,'autocomplete'])->name('autocomplete');

        //staff
        Route::get('manage-staff', [StaffController::class, 'manageStaff'])->name('staff.manage');
        Route::get('staff/data', [StaffController::class, 'data'])->name('staff.data');
        Route::post('staff/insert', [StaffController::class, 'insert'])->name('staff.insert');
        Route::post('staff/update', [StaffController::class, 'update'])->name('staff.update');
        Route::post('staff/delete', [StaffController::class, 'delete'])->name('staff.delete');
        Route::get('staff/password-modal', [StaffController::class, 'changePasswordModal'])->name('staff.change_password_modal');
        Route::post('staff/change-password', [StaffController::class, 'changePassword'])->name('staff.change_password');


        // Roles and permissions
        Route::get('roles', [RoleController::class, 'staffRole'])->name('role');
        Route::get('roles/data', [RoleController::class, 'data'])->name('role.data');
        Route::post('roles/insert', [RoleController::class, 'insert'])->name('role.insert');
        Route::post('roles/update', [RoleController::class, 'update'])->name('role.update');
        Route::post('roles/delete', [RoleController::class, 'delete'])->name('role.delete');

        Route::get('roles/assign/{id}', [RoleController::class, 'assignPermission'])->name('role.assign_permission');
        Route::post('roles/save-assign/{id}', [RoleController::class, 'saveAssignPermission'])->name('assign_permission.save');
        Route::get('roles/no-role', [RoleController::class, 'noRole'])->name('no_role_profile');

        Route::get('permissions', [RoleController::class, 'permissions'])->name('staff.permissions');
        Route::get('permissions/data', [RoleController::class, 'dataPermission'])->name('staff.permissions.data');
        Route::post('permissions/insert', [RoleController::class, 'insertPermission'])->name('staff.permissions.insert');
        Route::post('permissions/update', [RoleController::class, 'updatePermission'])->name('staff.permissions.update');
        Route::post('permissions/delete', [RoleController::class, 'deletePermission'])->name('staff.permissions.delete');




    //seetings
    Route::get('settings/fee', [SettingsController::class, 'fee'])->name('fee');
    Route::post('settings/fee/store', [SettingsController::class, 'storeFee'])->name('settings.fee.store');
    Route::post('settings/fee/getFeeBySessionId', [SettingsController::class, 'getFeeBySessionId'])->name('settings.fee.getFeeBySessionId');
        //categories
        Route::resource('categories', CategoryController::class)->except([ 'create', 'show', 'edit', 'update', 'destroy' ]);
        Route::get('categories/select', [CategorySelectController::class, 'index'])->name('categories.select');
        Route::get('categories-parent/select', [ParentOnlySelectController::class, 'index'])->name('categories-parent.select');
        Route::get('product_list/select', [ParentOnlySelectController::class, 'getProducts'])->name('product_list.select');


        Route::POST('categories_update/{id}',[ CategoryController::class,'updateCategory']);
        Route::get('/categories-delete/{id}', [CategoryController::class, 'delete']);
        Route::POST('post-sortable',[ CategoryController::class,'reOrder']);
        Route::POST('/categories/update_sub_categories',[ CategoryController::class,'updateSubCategory'])->name('update sub category');

        Route::get('categories/get-all-sub-categories', [CategoryController::class, 'getAllSubCategories'])->name('get all sub categories');
        Route::post('categories/fetch-sub-categories', [CategoryController::class, 'fetchSubCategory'])->name('fetch sub categories');


        //shop
        Route::get('shops', [ShopController::class, 'index'])->name('shops');
        Route::get('/shops/data', [ShopController::class, 'data'])->name('shops.data');
        Route::get('/shops/create', [ShopController::class, 'create'])->name('shop.create');
        Route::post('/shops/store', [ShopController::class, 'store'])->name('shop.store');
        Route::post('/shops/update',[ ShopController::class,'update'])->name('shop.update');
        Route::post('/shops/delete', [ShopController::class, 'delete'])->name('shop.delete');

        Route::get('shops/select', [ ShopSelectController::class, 'index' ])->name('shop.select');

        //channels
        Route::resource('channels', ChannelController::class);
        Route::post('channels-update/{id}',[ChannelController::class,'update']);
        Route::get('channels-delete/{id}', [ChannelController::class, 'delete']);


        //Fee Details
        Route::resource('student_fee', FeeDetailsController::class);
        Route::get('fee_list', [FeeDetailsController::class, 'data'])->name('fee_list');
        Route::get('student_fee/create', [FeeDetailsController::class, 'create'])->name('student_fee.create');
        Route::post('filter_others_fee', [FeeDetailsController::class, 'filterOthersFee'])->name('filter_others_fee');
        Route::post('add_remove_others_fee_field', [FeeDetailsController::class, 'addRemoveOthersFeeField'])->name('add_remove_others_fee_field');
        Route::post('status_change_others_fee_field', [FeeDetailsController::class, 'statusChangeOthersFeeField'])->name('status_change_others_fee_field');
        Route::post('student_fee/store', [FeeDetailsController::class, 'store'])->name('studentFee.store');
        Route::post('get_money_receipt', [FeeDetailsController::class, 'getMoneyReceipt'])->name('get_money_receipt');
        Route::get('student_fee_single/{session_id}/{student_id}',  [FeeDetailsController::class, 'studentFeeSingle'])->name('student_fee_single');
        Route::post('fee_status_approve',  [FeeDetailsController::class, 'FeeStatusApprove'])->name('fee_status_approve');
        Route::post('fee_list_by_student_id', [FeeDetailsController::class, 'feeListByStudentID'])->name('fee_list_by_student_id');
        Route::get('student_fee/edit/{id}', [FeeDetailsController::class, 'studentFeeSingleEdit'])->name('student_fee.edit');
        Route::post('student_fee/update', [FeeDetailsController::class, 'update'])->name('studentFee.update');
        Route::post('student_fee/delete', [FeeDetailsController::class, 'delete'])->name('student_fee.delete');
        Route::get('student_fee_history', [FeeDetailsController::class, 'studentFeeHistory'])->name('student_fee_history');
        Route::get('fee_list_history', [FeeDetailsController::class, 'feeListHistory'])->name('fee_list_history');


        //Admission Form
        Route::resource('admission_form', AdmissionFormController::class);
        Route::get('admission_form/edit/{id}', [AdmissionFormController::class, 'editAdmissionForm'])->name('admission_form.edit');
        Route::post('admission_filter_others_fee_existance_checking', [AdmissionFormController::class, 'admissionFilterOthersFeeExistanceChecking'])->name('admission_filter_others_fee_existance_checking');
        Route::post('admission_filter_others_fee', [AdmissionFormController::class, 'admissionFilterOthersFee'])->name('admission_filter_others_fee');
        Route::post('admission_add_remove_others_fee_field', [AdmissionFormController::class, 'admissionAddRemoveOthersFeeField'])->name('admission_add_remove_others_fee_field');
        Route::post('admission_status_change_others_fee_field', [AdmissionFormController::class, 'admissionStatusChangeOthersFeeField'])->name('admission_status_change_others_fee_field');
        Route::post('get_money_receipt_admission', [AdmissionFormController::class, 'getAdmissionMoneyReceipt'])->name('get_money_receipt_admission');
        Route::post('get_student_details_by_code', [AdmissionFormController::class, 'getStudentByCode'])->name('get_student_details_by_code');
        Route::get('admission/confirm', [AdmissionFormController::class, 'confirmAdmission'])->name('admission_form.confirm');
        Route::get('admission_form_list', [AdmissionFormController::class, 'data'])->name('admission_form_list');
        Route::post('admission_form/update', [AdmissionFormController::class, 'update'])->name('admission_form.update');
        Route::post('admission_form_delete', [AdmissionFormController::class, 'deleteStudent'])->name('admission_form.delete');
        Route::post('admission_update_student/{id}', [AdmissionFormController::class, 'updateStudent'])->name('admission_form.updateStudent');


        //Students
        Route::resource('students', StudentController::class);
        Route::get('students_list', [StudentController::class, 'data'])->name('students_list');
        Route::post('students/view', [StudentController::class, 'viewStudentInfo'])->name('students.view');
        Route::get('students/edit/{id}', [StudentController::class, 'editStudent'])->name('students.edit');
        Route::post('/students-delete', [StudentController::class, 'delete'])->name('students.delete');
        Route::post('students/{id}', [StudentController::class, 'update'])->name('students.update');
        Route::post('/unique_roll_validation', [StudentController::class, 'UniqueRollValidation'])->name('unique_roll_validation');
        Route::post('/get_siblings_info', [StudentController::class, 'getSiblingInfo'])->name('get_siblings_info');

        Route::post('/download_students', [StudentController::class, 'DownloadStudents'])->name('download_students');


         //Teachers
         Route::resource('teachers', TeachersController::class);
         Route::get('teachers_list', [TeachersController::class, 'data'])->name('teachers_list');
         Route::get('teachers/view/{id}', [TeachersController::class, 'viewTeacherInfo'])->name('teachers.view');
         Route::get('teachers/edit/{id}', [TeachersController::class, 'editTeacher'])->name('teachers.edit');
         Route::post('/teachers-delete', [TeachersController::class, 'delete'])->name('teachers.delete');
         Route::post('teachers/{id}', [TeachersController::class, 'update'])->name('teachers.update');
         Route::post('/download_teachers', [TeachersController::class, 'DownloadTeachers'])->name('download_teachers');

         //Staffs
         Route::resource('staffs', StaffsController::class);
         Route::get('staffs_list', [StaffsController::class, 'data'])->name('staffs_list');
         Route::get('staffs/view/{id}', [StaffsController::class, 'viewStaffInfo'])->name('staffs.view');
         Route::get('staffs/edit/{id}', [StaffsController::class, 'editStaff'])->name('staffs.edit');
         Route::post('/staffs-delete', [StaffsController::class, 'delete'])->name('staffs.delete');
         Route::post('staffs/{id}', [StaffsController::class, 'update'])->name('staffs.update');
         Route::post('/download_staffs', [StaffsController::class, 'DownloadStaffs'])->name('download_staffs');


        //marks
        Route::group(['prefix' => 'marks'], function () {
            Route::get('/marks_entry_form', [MarksExportImportController::class, 'marksEntryForm'])->name('marks.marks_entry_form');
            Route::get('/mark_sheet_view', [MarksExportImportController::class, 'markSheetView'])->name('mark_sheet_view');
            Route::get('/datatable', [MarksExportImportController::class, 'MarksEntryDataTable'])->name('marks_entry_form_datatable');
            Route::post('/minimum_pass_mark_setting', [MarksExportImportController::class, 'MinimumPassMarkSetting'])->name('minimum_pass_mark_setting');
            Route::get('/excel_export_marks_entry_form', [MarksExportImportController::class, 'MarksEntryExcelExport'])->name('excel_export_marks_entry_form');
            Route::get('/marks_excel_import_form', [MarksExportImportController::class, 'marksExcelImportForm'])->name('marks.marks_excel_import_form');
            Route::post('/excel_import_file', [MarksExportImportController::class, 'excelImport'])->name('marks.excel_import_file');
            Route::post('/print_mark_sheet', [MarksController::class, 'printMarkSheet'])->name('print_mark_sheet');
            Route::get('/edit_marks_by_subject', [MarksReportBySubjectController::class, 'EditMarksBySubjectPage'])->name('marks.edit_marks_by_subject');
        });


        //Results
        Route::resource('results', ResultController::class);
        Route::get('result_students_list', [ResultController::class, 'data'])->name('result.students_list');
        Route::post('results/{id}', [ResultController::class, 'update'])->name('results.update');
        Route::post('/view_all_mark_sheet', [ResultController::class,'printMarkSheet'])->name('view_all_mark_sheet');
        Route::get('/merit_list', [ResultController::class, 'getMeritList'])->name('results.merit_list');
        Route::get('merit_list_datatable', [ResultController::class, 'dataMeritList'])->name('result.merit_list_datatable');
        Route::post('/download_merit_list', [ResultController::class,'downloadMeritList'])->name('download_merit_list');

        Route::get('/marks_by_subject', [MarksReportBySubjectController::class, 'MarksReportBySubjectPage'])->name('results.marks_by_subject');
        Route::get('/marks_report_by_subject', [MarksReportBySubjectController::class, 'MarksReportBySubjectDataTable'])->name('marks_datatable_by_subject');
        Route::get('/edit_marks_sheet_by_subject_id', [MarksReportBySubjectController::class, 'MarksSheetBySubjectIDExcelExportToEdit'])->name('edit_marks_sheet_by_subject_id');
        Route::get('/excel_export_marks_sheet_by_subject_id', [MarksReportBySubjectController::class, 'MarksSheetBySubjectIdPDFExport'])->name('excel_export_marks_sheet_by_subject_id');
        Route::get('/marks_by_class', [MarksReportByClassController::class, 'MarksReportByClassPage'])->name('results.marks_by_class');
        Route::get('/marks_datatable_by_class', [MarksReportByClassController::class, 'MarksReportByClassDataTable'])->name('marks_datatable_by_class');
        Route::post('/PDF_export_marks_by_class', [MarksReportByClassController::class, 'MarksSheetByClassPDFExport'])->name('PDF_export_marks_by_class');
        Route::get('/load_mark_form_to_edit_by_student_id_and_subject_id', [MarksReportBySubjectController::class, 'LoadMarksEditFormBySubjectIdAndStudentId'])->name('load_mark_form_to_edit_by_student_id_and_subject_id');
        Route::post('/store_mark_by_student_id_and_subject_id', [MarksReportBySubjectController::class, 'StoreMarkBySubjectIdAndStudentId'])->name('store_mark_by_student_id_and_subject_id');



        //AdmitCard
        Route::get('/admit_cards', [AdmitCardController::class, 'index'])->name('admit_cards');
        Route::get('/admit_cards_datatable_by_class', [AdmitCardController::class, 'AdmitCardsDataTable'])->name('admit_cards_datatable_by_class');
        Route::post('/PDF_export_admit_cards', [AdmitCardController::class, 'AdmitCardsPDFExport'])->name('PDF_export_admit_cards');

        // Seat Plans
        Route::get('/seat_plans', [SeatPlansController::class, 'SeatPlans'])->name('seat_plans');
        Route::get('/seat_plans_datatable_by_class', [SeatPlansController::class, 'SeatPlansDataTable'])->name('seat_plans_datatable_by_class');
        Route::post('/PDF_export_seat_plan', [SeatPlansController::class, 'SeatPlansPDFExport'])->name('PDF_export_seat_plan');





        //Promotion
        Route::get('promotion', [PromotionController::class, 'index'])->name('promotion');

        Route::get('promotion/data', [PromotionController::class, 'data'])->name('promotion.data');
        Route::get('promotion/promotion_modal', [PromotionController::class, 'promotionModal'])->name('promotion.promotion_modal');
        Route::post('promotion/confirm_promotion', [PromotionController::class, 'confirmPromotion'])->name('promotion.confirm_promotion');


        //Students ID card
        Route::resource('student_id_cards', StudentIdCardsController::class);

        Route::get('student_id_cards_list', [StudentIdCardsController::class, 'data'])->name('student_id_cards_list');
        Route::get('student_id_cards/view/{id}', [StudentIdCardsController::class, 'viewStudentInfo'])->name('student_id_cards.view');
        Route::get('student_id_cards/edit/{id}', [StudentIdCardsController::class, 'editStudent'])->name('student_id_cards.edit');

        // Voter list
        Route::resource('voters', VoterController::class);
        Route::get('voter_list', [VoterController::class, 'data_voter_list'])->name('voter_list');
        Route::post('/PDF_voter_list', [VoterController::class, 'VoterListPDFExport'])->name('PDF_voter_list');

        // ExpenseType
        Route::get('expense_types', [ExpenseTypesController::class, 'index'])->name('expense_types.index');
        Route::post('/expense_type/store', [ExpenseTypesController::class, 'store'])->name('store expense_type');
        Route::POST('expense_type_update/{id}',[ ExpenseTypesController::class,'updateExpenseType']);
        Route::get('/expense_type-delete/{id}', [ExpenseTypesController::class, 'delete']);


        // Class list
        Route::get('classes', [ClassController::class, 'index'])->name('classes.index');
        Route::post('/class/store', [ClassController::class, 'store'])->name('store class');
        Route::POST('class_update/{id}',[ ClassController::class,'updateClass']);
        Route::POST('class-sortable',[ ClassController::class,'classReOrder']);
        Route::get('/class-delete/{id}', [ClassController::class, 'delete']);

        // Section list
         Route::get('sections', [SectionController::class, 'index'])->name('sections.index');
         Route::post('/section/store', [SectionController::class, 'store'])->name('store section');
         Route::POST('section_update/{id}',[ SectionController::class,'updateSection']);
         Route::POST('section-sortable',[ SectionController::class,'sectionReOrder']);
         Route::get('/section-delete/{id}', [SectionController::class, 'delete']);

         // Exam list
         Route::get('exams', [ExamController::class, 'index'])->name('exams.index');
         Route::post('/exam/store', [ExamController::class, 'store'])->name('store exam');
         Route::POST('exam_update/{id}',[ ExamController::class,'updateExam']);
         Route::POST('exam-sortable',[ ExamController::class,'examReOrder']);
         Route::get('/exam-delete/{id}', [ExamController::class, 'delete']);



         // Remark list
         Route::get('remarks', [RemarkController::class, 'index'])->name('remarks.index');
         Route::post('/remark/store', [RemarkController::class, 'store'])->name('store remark');
         Route::POST('remark_update/{id}',[ RemarkController::class,'updateRemark']);
         Route::get('/remark-delete/{id}', [RemarkController::class, 'delete']);


      Route::group(['prefix' => 'reports'], function () {

        Route::get('/expenses_report', [DailyExpensesController::class, 'expenseReport'])->name('reports.expenses');
        Route::post('/PDF_export_expenses', [DailyExpensesController::class, 'expensePDFExport'])->name('PDF_export_expenses');



        Route::resource('student_fee_report', ReportController::class);
        Route::get('report_fee_list', [ReportController::class, 'data_fee_list'])->name('report_fee_list');
        Route::post('/PDF_export_fee_list', [ReportController::class, 'FeeReportPDFExport'])->name('PDF_export_fee_list');

        Route::get('report_transaction_list', [ReportController::class, 'data_transaction_list'])->name('report_transaction_list');
        Route::get('report_student_fee_list_pending', [ReportController::class, 'data_student_fee_list_pending'])->name('report_student_fee_list_pending');
        Route::get('report_student_fee_list_paid', [ReportController::class, 'data_student_fee_list_paid'])->name('report_student_fee_list_paid');
        Route::get('report_others_collection_list', [ReportController::class, 'data_others_collection_list'])->name('report_others_collection_list');
        Route::get('report_expense_list', [ReportController::class, 'data_expense_list'])->name('report_expense_list');
        Route::get('report_salaries_list', [ReportController::class, 'data_salaries_list'])->name('report_salaries_list');
        Route::get('report_transaction_summary', [ReportController::class, 'report_transaction_summary'])->name('report_transaction_summary');
        Route::get('/transaction_report', [ReportController::class, 'transaction_report']);

        Route::post('/PDF_export_transaction_list', [ReportController::class, 'FeeTransactionPDFExport'])->name('PDF_export_transaction_list');





    });


        //report
        Route::get('/report-stock', [ReportController::class, 'report'])->name('product_report');
        Route::get('/report/data', [ReportController::class, 'reportData'])->name('data_product_report');
        // Route::post('filter_product_report', [ReportController::class, 'filterReport'])->name('filter_report');

        Route::get('/report-stock-movements', [ReportController::class, 'stockReport'])->name('stock_movement_report');
        Route::get('/report-stock-movements/data', [ReportController::class, 'stockReportData'])->name('data_stock_movement_report');

        Route::get('activity-log', [ReportController::class, 'activityLog'])->name('activity_log');
        Route::get('/activity-log/data', [ReportController::class, 'dataActivityLog'])->name('activity_log.data');
        Route::post('/undo-activity-log', [ReportController::class, 'undoActivityLog'])->name('activity_log.undo');


        Route::get('school-info-settings', [SettingsController::class, 'school_info_settings'])->name('school-info-settings.index');
        Route::post('school-info-settings/update', [SettingsController::class, 'update_school_info'])->name('school-info-settings.update');



    Route::group(['prefix' => 'admin', 'middleware' => 'admin'], function () {
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('admin dashboard');
        Route::get('manage-person', [AdminController::class, 'managePerson'])->name('manage person');
        Route::get('person/data', [AdminController::class, 'data'])->name('data person');
        Route::post('person/insert', [AdminController::class, 'insert'])->name('insert person');
        Route::post('person/update', [AdminController::class, 'update'])->name('update person');
        Route::post('person/delete', [AdminController::class, 'delete'])->name('delete person');

        Route::get('/user-logo', [AdminController::class, 'userLogo'])->name('user logo');
        Route::post('/user-logo-update', [AdminController::class, 'uploadUserLogo'])->name('upload user logo');
         //package
         Route::get('/package', [PersonController::class, 'package'])->name('package');
         Route::get('/package/data', [PersonController::class, 'data'])->name('data package');
         Route::post('/package/insert', [PersonController::class, 'insert'])->name('insert package');
         Route::post('/package/update', [PersonController::class, 'update'])->name('update package');
         Route::post('/package/delete', [PersonController::class, 'delete'])->name('delete package');
         //trackinglog
         Route::get('person/tracking-log/{id}', [AdminController::class, 'trackingLog'])->name('person tracking log');

        Route::get('translation', [TranslationController::class, 'index'])->name('translation.index');
        Route::post('translation/store', [TranslationController::class, 'store'])->name('translation.store');
        Route::post('translation/update', [TranslationController::class, 'update'])->name('translation.update');
        Route::post('translation/delete', [TranslationController::class, 'delete'])->name('translation.delete');
        Route::get('translation/datatable', [ TranslationController::class, 'dataTable' ])->name('translation.datatable');
        Route::get('translation/show/{id}', [TranslationController::class, 'show'])->name('translation.show');

        Route::get('scan-translation-job', [ScanTranslationJobController::class, 'index'])->name('scan-translation-job.index');
    });


    Route::get('/your_packages', [AccountController::class, 'yourPackages'])->name('your_packages');
    Route::get('/profile', [AccountController::class, 'profile'])->name('profile');
    Route::post('/profile-update', [AccountController::class, 'profileUpdate']);
    Route::post('/change-password', [AccountController::class, 'changePassword'])->name('change_password');

    Route::post('change-language', [LanguageController::class, 'update'])->name('user.change-language');


});


Route::get('verify_mobile', [OptController::class, 'verifyMobile'])->name('verify_mobile');
Route::post('/get-otp', [OptController::class, 'getOtp'])->name('get-otp');
Route::post('/reset-pass', [OptController::class, 'resetpass'])->name('reset-pass');
Route::post('/get-phone', [OptController::class, 'getPhone'])->name('get-phone');
Route::get('/forget_password', [OptController::class, 'forgetPassword'])->name('forget-password');
Route::get('/reset_password', [OptController::class, 'resetPassword'])->name('reset-password');

//order_mangment_buyer_pages
Route::get('order_status/{order_id}', [BuyerPageController::class, 'orderStatus'])->name('order-status');
Route::get('payment-order-notify/{order_id}', [BuyerPageController::class, 'paymentOrderNotify'])->name('payment-order-notify');

Route::get('order_management_buyer/{order_id}', [BuyerPageController::class, 'edit'])->name('order-management.public-url');
Route::post('order_management_buyer/{order_id}', [BuyerPageController::class, 'update'])->name('order-management.buyer.place-order');

Route::post('changePaymentMethod', [BuyerPageController::class, 'changePaymentMethod']);



//Line WebHook
Route::post('line/webhook', [LineController::class, 'triggeredPayload'])->name('line.webhook.payload');
Route::post('line/webhook/ac-sale-notify', [LineController::class, 'triggeredPayloadACSale'])->name('line.webhook.payload.ac');

require __DIR__ . '/auth.php';



 //WC Controller

Route::get('testing', function(){
    $url_record = "https://kradat.com/wp-json/wc/v3/products?consumer_key=ck_fca8f74ec29481d888cce350dcef5a63655e3167&consumer_secret=cs_3c52aa520805aec356b2b4bfcb17801515c591fa&pagination_type=page&page=1&limit=200&per_page=100";
    $response = Illuminate\Support\Facades\Http::get($url_record);
    $response = json_decode($response);
    print_r(($response[0]->id));
});


Route::get('/cron-report', [CronReportController::class,"index"])->name('cronReport');



// Facebook
Route::group(['prefix' => 'facebook'], function () {
    Route::get('/', [FacebookController::class, 'index'])->name('facebook.index');
    Route::get('oauth/authorization', [FacebookController::class, 'facebookAuthorization'])->name('facebook.auth');
    Route::get('oauth/redirect', [FacebookController::class, 'authRedirect'])->name('facebook.auth.redirect');
    Route::get('page/list', [FacebookController::class, 'facebookPageList'])->name('facebook.page.list');
    Route::get('page/edit', [FacebookController::class, 'facebookPageEdit'])->name('facebook.page.edit');
    Route::post('page/delete/{id}', [FacebookController::class, 'facebookPageDelete'])->name('facebook.page.delete');
    Route::post('page/autoreply', [FacebookController::class, 'facebookAutoReplyCampaign'])->name('facebook.autoreply.campaign');

    Route::get('page/subscription', [FacebookController::class,'facebookPageSubscribers']);
});

Route::group(['prefix' => 'dodochat'], function() {
    Route::get('new/app', [SettingController::class, 'DoDoChatApp'])->name('dodochat.app');
    Route::get('activity', [SettingController::class, 'dodochat_users_activity'])->name('dodochat.log');
});


Route::get('shipmentPickOrderCancelForShopee', [ShopeeOrderPurchaseController::class, 'shipmentPickOrderCancelForShopee']);
Route::get('ShopeeMarkAsShippedCancel', [ShopeeOrderPurchaseController::class, 'ShopeeMarkAsShippedCancel']);
Route::get('get_shopee_ordered_products', [ShopeeOrderPurchaseController::class, 'getShopeeOrderedProducts']);

Route::get('lang/{lang}', LangSwitcherController::class)->name('lang-switcher');

