<x-app-layout>
    @section('title', 'Student Fee List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Voter List') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        <form method="POST" action="{{route('PDF_voter_list')}}" id="form-import" enctype="multipart/form-data">
        @csrf
        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">


            <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-5">
                <x-button color="green" id="BtnPdfExport">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Print') }}
                    </span>
                </x-button>
            </div>

        </div>
        </form>

        <div class="overflow-x-auto">
            <table class="w-full" id="__voterListTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Voter Name') }}
                        </th>

                        <th>
                            {{ __('translation.Student') }}
                        </th>
                        <th>
                            {{ __('translation.Current Address') }}
                        </th>

                        <th>
                            {{ __('translation.Ward No') }}
                        </th>


                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('voter_list') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__voterListTable').dataTable({
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {


                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }


                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'voter_name',
                            data: 'voter_name'
                        },

                        {
                            name: 'student_details',
                            data: 'student_details'
                        },


                        {
                            name: 'current_address',
                            data: 'current_address'
                        },

                        {
                            name: 'ward_no',
                            data: 'ward_no'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [2],
                            orderable: false,
                            className: 'text-center'
                        },
                        { "width": "7%", "targets": 0 },
                        { "width": "15%", "targets": 1 },
                        { "width": "75%", "targets": 2 },

                    ],
                    "pageLength": 100,
                    order: [
                        [ 3, 'asc' ]
                    ]
                });
            }

            loadStudentsTable(studentTableUrl);







            const pdfExportUrl = '{{ route('PDF_export_fee_list') }}';
                $(document).on('click', '#BtnPdfExport333', function() {

                $.ajax({
                       type: 'POST',
                        url: pdfExportUrl,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                            status: $("#__selectStatusFilter").val(),
                        },
                    beforeSend: function() {
                       // $('#mark-sheet-wrapper').html('processing...');
                       // $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    console.log(result);

                    //$('#mark-sheet-wrapper').html(result);
                });

            });

            $(document).on('change', '#exam_id', function() {
                var exam_id = $(this).val();
                var session_id = $("#session_id").val();
                var class_id = $("#class_id").val();
                var student_id = $("#student_id").val();
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });


            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
