<x-app-layout>
    @section('title', 'Manage Daily Expense')
        @push('bottom_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    @endpush

    <div class="col-span-12">
        <x-card.card-default>
        <x-card.body>
            @include('transactions.menu')
        </x-card.body>
    </x-card.card-default>

        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    Daily Expense
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <div class="mt-2">
                    @if(session('success'))
                        <x-alert-success>{{ session('success') }}</x-alert-success>
                    @endif
                    @if (session()->has('error'))
                        <x-alert-danger>{{ session('error') }}</x-alert-danger>
                    @endif
                    @if ($errors->any())
                        <x-alert-danger>
                            <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-alert-danger>
                    @endif

                    <x-button class="mb-6" color="green" id="BtnInsert">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">{{ __('translation.Add New Cost') }}</span>
                    </x-button>
                    @if(Auth::user()->role == 'member')
                        <x-button class="mb-6" color="green" id="BtnApproved">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2-square" viewBox="0 0 16 16">
                                <path d="M3 14.5A1.5 1.5 0 0 1 1.5 13V3A1.5 1.5 0 0 1 3 1.5h8a.5.5 0 0 1 0 1H3a.5.5 0 0 0-.5.5v10a.5.5 0 0 0 .5.5h10a.5.5 0 0 0 .5-.5V8a.5.5 0 0 1 1 0v5a1.5 1.5 0 0 1-1.5 1.5H3z"/>
                                <path d="m8.354 10.354 7-7a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0z"/>
                            </svg>
                            <span class="ml-2">{{ __('translation.Approve') }}</span>
                        </x-button>
                    @endif

                </div>

                <div class="flex justify-between flex-col">
                    <div class="overflow-x-none">
                        <table class="w-full" id="datatable">
                            <thead>
                            <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                <th class="px-4 py-2 border-2"></th>
                                <th class="px-4 py-2 border-2">Entry date</th>
                                <th class="px-4 py-2 border-2">Details</th>
                                <th class="px-4 py-2 border-2">Amount</th>
                                <th class="px-4 py-2 border-2">Note</th>
                                <th class="px-4 py-2 border-2">Status</th>
                                <th class="px-4 py-2 border-2">Manage</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>


<!-- insert modal -->
    <x-modal.modal-large class="modal-hide modal-insert">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Add New Expense') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalInsert" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form method="POST" action="{{ route('daily_expense.insert') }}" id="form-insert">
                    @csrf
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-x-3 mt-0">
                        <div class="bg-gray-200 lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">
                             <div class="mt-2">
                                <x-label>Pay For</x-label>
                                <x-select id="expense_type_id" name="expense_type_id">
                                    <option value="">Select</option>
                                    @if($expense_types)
                                        @foreach($expense_types as $expense_type)
                                            <option style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$expense_type->id}}">{{$expense_type->name}}</option>';
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="mt-2">
                                <x-label>Payment Method</x-label>
                                <select id="payment_method" name="payment_method" class="form-control">
                                    <option value='cash'>Cash</option>
                                    <option value='cheque'>Cheque</option>
                                    <option value='mobile_banking'>Mobile Banking</option>
                                </select>
                            </div>

                            <div id="pm_cheque_wrapper">
                                <div class="mt-2">
                                    <x-label>Bank Name</x-label>
                                    <x-select id="bank_name" name="bank_name">
                                        <option value="">Select</option>
                                        @if($banks)
                                        @foreach($banks as $bank)
                                            <option style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$bank->id}}">{{$bank->name}}</option>';
                                        @endforeach
                                        @endif
                                    </x-select>
                                </div>

                                <div class="mt-2">
                                    <x-label>Cheque No</x-label>
                                    <x-input type="text" id="cheque_no" name="cheque_no" value=""></x-input>
                                </div>
                            </div>

                            <div id="pm_mobile_banking_wrapper">
                                <div class="mt-2">
                                    <x-label>Mobile Walet</x-label>
                                    <x-select id="wallet_name" name="wallet_name" >
                                        <option value="">Select</option>
                                        @if($mobile_walets)
                                        @foreach($mobile_walets as $mobile_walet)
                                            <option style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$mobile_walet->id}}">{{$mobile_walet->name}}</option>';
                                        @endforeach
                                        @endif
                                    </x-select>
                                </div>

                                <div class="mt-2">
                                    <x-label>Mobile No</x-label>
                                    <x-input type="text" id="mobile_no" name="mobile_no" value=""></x-input>
                                </div>
                            </div>
                        </div>

                        <div class="bg-gray-200 lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">
                            <div class="mt-2">
                                <x-label>
                                    Amount
                                </x-label>
                                <x-input type="number" name="amount" id="amount" :value="old('amount')" required>
                                </x-input>
                            </div>
                            <div class="mt-2">
                                <x-label>
                                    Note
                                </x-label>
                                <x-textarea name="note" id="note">{{old('note')}}</x-textarea>
                            </div>
                            <div class="flex justify-end mt-4">
                                <x-button color="blue">Save</x-button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>



    {{-- update modal --}}
    <x-modal.modal-large class="modal-hide modal-update">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Update Daily Expense') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalUpdate" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form method="POST" action="{{ route('daily_expense.update') }}"
                      id="form-update"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>

    {{-- update Status --}}
    <x-modal.modal-small class="modal-hide modal-approve-daily-expense">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Change Status') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalStatus" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form style="max-height:90vh" method="POST" action="{{ route('daily_expense.change_status') }}" id="form-status"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-small>


    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="{{asset('js/dataTables.checkboxes.min.js')}}"></script>
        <script>

            $("#pm_mobile_banking_wrapper").hide();
            $("#pm_cheque_wrapper").hide();

            jQuery("#payment_method").on("change", function(){
                if($(this).val()=='cheque'){
                    $("#pm_mobile_banking_wrapper").hide();
                    $("#pm_cheque_wrapper").show();
                }
                else if($(this).val()=='mobile_banking'){
                    $("#pm_cheque_wrapper").hide();
                    $("#pm_mobile_banking_wrapper").show();
                }else{
                    $("#pm_mobile_banking_wrapper").hide();
                    $("#pm_cheque_wrapper").hide();
                    $("#bank_id").val(" ");
                    $("#cheque_no").val(" ");
                    ("#wallet_name").val(" ");
                    $("#mobile_no").val(" ");
                }
            });

            $(document).ready(function() {
                dataTables("{{ route('daily_expense.data') }}?date=" + $(this).val());
                var datatable;
                $('#inputDate').change(function() {
                    datatable.destroy();
                    // console.log($(this).val());
                    dataTables("{{ route('daily_expense.data') }}?date=" + $(this).val());
                });

                function dataTables(url) {
                    // Datatable
                    datatable = $('#datatable').DataTable({
                        ajax: url,
                        processing: true,
                        serverSide: true,
                        columnDefs: [
                            {
                                'targets': 0,
                                orderable: false,
                                'checkboxes': {
                                    'selectRow': true
                                }
                            },

                        ],

                        columns: [

                            {
                                name: 'checkbox',
                                data: 'id'
                            },
                            {
                            name: 'Registered at',
                            data: 'created_at'
                        },
                            {
                                name: 'expense_type',
                                data: 'expense_type'
                            },
                            {
                                name: 'amount',
                                data: 'amount'
                            },
                            {
                                name: 'note',
                                data: 'note'
                            },
                            {
                                name: 'status',
                                data: 'status'
                            },
                            {
                                name: 'manage',
                                data: 'manage'
                            }
                        ]
                    });
                }

                $('#BtnInsert').click(function() {
                    $('.modal-insert').removeClass('modal-hide');
                });

                $(document).on('click', '#BtnShopUpdate', function() {
                    $('.modal-assign-shop').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('daily_expense.data') }}?assign_shop=true&id='+$(this).data('id'),
                        beforeSend: function() {
                            $('#form-assign-shop').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-assign-shop').html(result);
                    });
                });

                $(document).on('click', '#closeAssignShopModal', function() {
                    $('.modal-assign-shop').addClass('modal-hide');
                });

                $(document).on('click', '#BtnUpdate', function() {
                    $('.modal-update').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('daily_expense.data') }}?id=' + $(this).data('id'),
                        beforeSend: function() {
                            $('#form-update').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-update').html(result);
                    });
                });

                $(document).on('click', '#closeModalUpdate', function() {
                    $('.modal-update').addClass('modal-hide');
                });

                $('#closeModalInsert').click(function() {
                    $('.modal-insert').addClass('modal-hide');
                });

                $(document).on('click', '#BtnApproved', function() {
                    $('.modal-approve-daily-expense').removeClass('modal-hide');
                    var rows_selected = datatable.column(0).checkboxes.selected();

                    var arr = [];
                    $.each(rows_selected, function(index, rowId) {
                        arr[index] = rowId;
                    });

                    if (arr.length === 0) {
                        alert("Please Select At Least 1 Row...");
                        return;
                    }
                    var ids = arr.join(",");
                    $.ajax({
                        url: '{{ route('daily_expense.approve_daily_expense_modal') }}?ids='+ids,
                        beforeSend: function() {
                            $('#form-status').html('Loading');
                        }
                    }).done(function(result) {
                        $('#form-status').html(result);
                    });
                });

                $('#closeModalStatus').click(function() {
                    $('.modal-approve-daily-expense').addClass('modal-hide');
                });

                $(document).on('click', '#BtnDelete', function() {
                    let drop = confirm('Are you sure?');
                    if (drop) {
                        $.ajax({
                            url: '{{ route('daily_expense.delete') }}',
                            type: 'post',
                            data: {
                                'id': $(this).data('id'),
                                '_token': $('meta[name=csrf-token]').attr('content')
                            },
                            beforeSend: function() {
                                // Pesan yang muncul ketika memproses delete
                            }
                        }).done(function(result) {
                            if (result.status === 1) {
                                // Pesan jika data berhasil di hapus
                                alert('Data deleted successfully');
                                $('#datatable').DataTable().ajax.reload();
                            } else {
                                alert(result.message);
                            }
                        });
                    }
                });
            });

        </script>
    @endpush

</x-app-layout>
