<x-app-layout>
    @section('title', 'Teachers List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

    <x-card title="{{ __('translation.Teachers List') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-1/4 mb-6 lg:mb-0">
                <a href="{{route('teachers.create')}}">
                    <x-button color="green" id="BtnInsert">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">
                            {{ __('translation.Add Teacher') }}
                        </span>
                    </x-button>
                </a>
            </div>



            <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-5">
                <x-select name="class_id" id="__selectStatusFilter" class="class_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Status') . ' -' }}
                    </option>
                        <option value="all">All</option>
                        <option selected value="1">Active</option>
                        <option value="0">Deactive</option>

                </x-select>
            </div>


            <div class="w-full lg:w-1/4 mb-6 lg:mb-0  sm:ml-2">
                <x-button color="blue" id="BtnDownloadPDF">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                        <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                        <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Download PDF') }}
                    </span>
                </x-button>
            </div>

        </div>

        <div class="overflow-x-auto">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Photo') }}
                        </th>

                        <th>
                            {{ __('translation.Name') }}
                        </th>

                        <th>
                            {{ __('translation.Teacher ID') }}
                        </th>

                        <th>
                            {{ __('translation.Mobile No') }}
                        </th>

                        <th>
                            {{ __('translation.Blood Group') }}
                        </th>

                        <th>
                            {{ __('translation.Action') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>



    <x-modal.modal-full class="modal-student-list modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Download PDF
            </x-modal.title>
            <x-modal.close-button id="closeModalStudentList" />
        </x-modal.header>
        <x-modal.body>
        <div id="student-list-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('teachers_list') }}';
            var status = 'all';

            function loadTeachersTable(url) {
                $('#__studentTable').dataTable({
                    "pageLength": 50,
                    processing: true,
                    serverSide: true,
                    "ajax": {
                        "url": url,
                        data: {
                            status: $("#__selectStatusFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                         return json.data;
                        }

                    },




                    columns: [

                        {
                            name: 'profile_photo',
                            data: 'profile_photo'
                        },

                        {
                            name: 'name',
                            data: 'name'
                        },

                        {
                            name: 'code',
                            data: 'code'
                        },

                        {
                            name: 'mobile_no',
                            data: 'mobile_no'
                        },

                        {
                            name: 'blood_group',
                            data: 'blood_group'
                        },

                        {
                            name: 'action',
                            data: 'action'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                    {"width": "40px",className: 'text-center', orderable: false, "width": "10px", "targets": 0 },
                    { "width": "300px", className: 'text-left', orderable: true, "targets": 1 },
                    { "width": "20px", className: 'text-center', orderable: true,  "targets": 2 },
                    { "width": "60px", className: 'text-center', orderable: true, "targets": 3 },
                    { "width": "70px", className: 'text-center', orderable: false, "targets": 4 },
                    { "width": "20px", className: 'text-center', orderable: false, "targets": 5 },
                    ],
                    order: [
                        [ 0, 'desc' ]
                    ]
                });
            }

            loadTeachersTable(studentTableUrl);

            $('#__selectStatusFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadTeachersTable(studentTableUrl);

            });


            $('#__selectStatusFilter').select2({
                width: 'resolve',
                placeholder: '- Select Status -',
                allowClear: true
            });


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();

                    $.ajax({
                        url: '{{ route('teachers.delete') }}',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Data deleted successfully');

                            $('#__studentTable').dataTable().fnDestroy();
                            loadTeachersTable(studentTableUrl);

                        } else {
                            alert(result.message);
                        }
                    });
                }
            });






            const download_teachers = '{{ route('download_teachers') }}';
            $(document).on('click', '#BtnDownloadPDF', function() {
                var status = $("#__selectStatusFilter").val();
                $.ajax({
                       type: 'POST',
                        url: download_teachers,
                        data: {
                            status: status

                        },
                    beforeSend: function() {
                        $('#student-list-wrapper').html('PDF generating...Please wait....');
                        $('.modal-student-list').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    $('#student-list-wrapper').html(result);
                });
            });

            $('#closeModalStudentList').click(function() {
                $('.modal-student-list').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
