<x-app-layout>
    @section('title', 'Student List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">


    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Students') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-1/4 mb-6 lg:mb-0">
                <a href="{{route('students.create')}}">
                    <x-button color="green" id="BtnInsert">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">
                            {{ __('translation.Add Student') }}
                        </span>
                    </x-button>
                </a>
            </div>



            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value="" selected>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $classe)
                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                    <option value="" selected>
                        {{ '- ' . __('translation.Select Section') . ' -' }}
                    </option>
                    @if (isset($sections))
                        @foreach ($sections as $section)
                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="group_id" id="__selectGroupFilter" class="group_id" style="width: 100%;">
                    <option value="" selected>
                        {{ '- ' . __('translation.Select Group') . ' -' }}
                    </option>
                    @if (isset($groups))
                        @foreach ($groups as $group)
                            <option value="{{$group->id}}">{{$group->group_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="" selected>
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-1/4 mb-6 lg:mb-0  sm:ml-2">
                <x-button color="blue" id="BtnDownloadPDF">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                        <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                        <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Download PDF') }}
                    </span>
                </x-button>
            </div>

        </div>

        <div class="overflow-x-none">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Photo') }}
                        </th>

                        <th>
                            {{ __('translation.Name') }}
                        </th>

                        <th>
                            {{ __('translation.Student ID') }}
                        </th>

                        <th>
                            {{ __('translation.Roll No') }}
                        </th>

                        <th>
                            {{ __('translation.Class') }}
                        </th>

                        <th>
                            {{ __('translation.Section') }}
                        </th>

                        <th>
                            {{ __('translation.Group') }}
                        </th>

                        <th>
                            {{ __('translation.Session') }}
                        </th>


                        <th>
                            {{ __('translation.Action') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif



    <x-modal.modal-full class="modal-student-list modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Download PDF
            </x-modal.title>
            <x-modal.close-button id="closeModalStudentList" />
        </x-modal.header>
        <x-modal.body>
        <div id="student-list-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('students_list') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    "pageLength": 100,
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                            groupId: $("#__selectGroupFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        //console.log(json);
                      if(json.supplier !='' && json.draw=='1'){
                        $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                        $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                        $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                        $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                        }

                         return json.data;
                        }

                    },




                    columns: [

                        {
                            name: 'profile_photo',
                            data: 'profile_photo'
                        },

                        {
                            name: 'name',
                            data: 'name'
                        },

                        {
                            name: 'student_code',
                            data: 'student_code'
                        },

                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },

                        {
                            name: 'class',
                            data: 'class'
                        },

                        {
                            name: 'section',
                            data: 'section'
                        },

                        {
                            name: 'group',
                            data: 'group'
                        },

                        {
                            name: 'session',
                            data: 'session'
                        },

                        {
                            name: 'action',
                            data: 'action'
                        },
                    ],
                    //"order": [[ 3, "desc" ]],
                    pagingType: 'numbers',
                    columnDefs: [
                    {"width": "40px",className: 'text-center', orderable: false, "width": "10px", "targets": 0 },
                    { "width": "250px", className: 'text-left', orderable: false, "targets": 1 },
                    { "width": "80px", className: 'text-center', orderable: false,  "targets": 2 },
                    { "width": "60px", className: 'text-center', orderable: false, "targets": 3 },
                    { "width": "40px", className: 'text-center', orderable: false, "targets": 4 },
                    { "width": "40px", className: 'text-center', orderable: false, "targets": 5 },
                    { "width": "40px", className: 'text-center', orderable: false, "targets": 6 },
                    { "width": "40px", className: 'text-center', orderable: false, "targets": 7 },
                    { "width": "60px", className: 'text-center', orderable: false, "targets": 8 },

                    ],
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectGroupFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });


            $('input[type="search"]').on('keyup', function(e) {

            });



            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });

            $('#__selectGroupFilter').select2({
                width: 'resolve',
                placeholder: '- Select Group -',
                allowClear: true
            });


            $(document).on('click', '.BtnView', function() {
                $.ajax({
                    url: '{{ route('students.view') }}',
                    type: 'post',
                    data: {
                        'id': $(this).data('id'),
                        '_token': $('meta[name=csrf-token]').attr('content')
                    },
                    beforeSend: function() {
                        $('#student-list-wrapper').html('generating...Please wait....');
                        $('.modal-student-list').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    $('#student-list-wrapper').html(result);
                });

            });

            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();

                    $.ajax({
                        l: '{{ route('students.delete') }}',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        $('#student-list-wrapper').html('PDF generating...Please wait....');
                        $('.modal-student-list').removeClass('modal-hide');

                    });
                }
            });






            const download_students = '{{ route('download_students') }}';
            $(document).on('click', '#BtnDownloadPDF', function() {
                var class_id = $("#__selectClassFilter").val();
                var section_id = $("#__selectSectionFilter").val();
                var group_id = $("#__selectGroupFilter").val();
                var session_id = $("#__selectSessionFilter").val();
                $.ajax({
                       type: 'POST',
                        url: download_students,
                        data: {
                            class_id: class_id,
                            section_id: section_id,
                            group_id: group_id,
                            session_id: session_id

                        },
                    beforeSend: function() {
                        $('#student-list-wrapper').html('PDF generating...Please wait....');
                        $('.modal-student-list').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    $('#student-list-wrapper').html(result);
                });
            });

            $('#closeModalStudentList').click(function() {
                $('.modal-student-list').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>

<script type="text/javascript">

    jQuery.fn.extend({
        printElem: function() {
            var cloned = this.clone();
        var printSection = $('#printSection');
        if (printSection.length == 0) {
            printSection = $('<div id="printSection"></div>')
            $('body').append(printSection);
        }
        printSection.append(cloned);
        var toggleBody = $('body *:visible');
        toggleBody.hide();
        $('#printSection, #printSection *').show();
        window.print();
        printSection.remove();
        toggleBody.show();
        }
    });

    $(document).ready(function(){
        $(document).on('click', '#btnPrint', function(){
          $('.printMe').printElem();
      });
    });


    $(document).on('click', '#closeModalMarkSheet', function() {
          $('.modal-mark-sheet').addClass('modal-hide');
          $('body').removeClass('modal-open');
      });

    </script>

    @endpush
</x-app-layout>
