<x-app-layout>
    @section('title', 'Students')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
            background: #f9ffa5;
            color: black;
            border-radius: 7px;
        }
            #__formStudent {
            background: #90ebff;
            padding: 15px;
            border-radius: 20px;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
        <div class="col-span-12">

        @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('students.index') }}" />
                <x-card.title>
                    {{ __('translation.Add New Student') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="alert mb-5 hidden" id="__alertDanger">
                    <span id="__content_alertDanger"></span>
                </x-alert-danger>

                <x-alert-success class="alert mb-5 hidden" id="__alertSuccess">
                    <span id="__content_alertSuccess"></span>
                </x-alert-success>

                <form method="POST" action="{{ route('students.store') }}" id="__formStudent" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="timestamp" name="timestamp" value="{{$timestamp}}">
                    <ul class="nav nav-pills">
                        <li>
                            <a class="active" href="#po-info" data-toggle="tab">{{ __('translation.Student Information') }}</a>
                        </li>
                        <li>
                            <a href="#guardian-details" data-toggle="tab">{{ __("translation.Guardian Information") }}</a>
                        </li>
                        <li>
                            <a href="#payment" data-toggle="tab">{{ __('Payment') }}</a>
                        </li>
                    </ul>

                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="po-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                        {{ __('translation.Students Info') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>


                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">


                                    <div class="lg:col-span-1">
                                        <x-label>
                                            {{ __('translation.Class') }} <x-form.required-mark/>
                                        </x-label>
                                        <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                            <option value=" " selected>
                                                {{ '- ' . __('translation.Select Class') . ' -' }}
                                            </option>
                                            @if (isset($classes))
                                                @foreach($classes as $row)
                                                    <option value="{{$row->id}}">{{$row->class_name}}</option>
                                                @endforeach
                                            @endif
                                        </x-select>
                                    </div>


                                    <div class="lg:col-span-1">
                                        <x-label>
                                            {{ __('translation.Section') }} <x-form.required-mark/>
                                        </x-label>
                                        <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                            <option value="" selected>
                                                {{ '- ' . __('translation.Select Section') . ' -' }}
                                            </option>
                                            @if (isset($sections))
                                                @foreach($sections as $row)
                                                    <option value="{{$row->id}}">{{$row->section_name}}</option>
                                                @endforeach
                                            @endif
                                        </x-select>
                                    </div>


                                    <div class="lg:col-span-1">
                                        <x-label>
                                            {{ __('translation.Session') }} <x-form.required-mark/>
                                        </x-label>
                                        <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                            <option value=" " selected>
                                                {{ '- ' . __('translation.Select Session') . ' -' }}
                                            </option>
                                            @if (isset($sessions))
                                                @foreach($sessions as $row)
                                                    <option value="{{$row->id}}">{{$row->session_name}}</option>
                                                @endforeach
                                            @endif
                                        </x-select>
                                    </div>


                                    <div class="lg:col-span-1">
                                        <x-label>
                                            {{ __('translation.Group') }}
                                        </x-label>
                                        <x-select name="group_id" id="__selectGroupFilter" class="group_id" style="width: 100%;">
                                            <option value=" " selected>
                                                {{ '- ' . __('translation.Select Group') . ' -' }}
                                            </option>
                                            @if (isset($groups))
                                                @foreach($groups as $row)
                                                    <option value="{{$row->id}}">{{$row->group_name}}</option>
                                                @endforeach
                                            @endif
                                        </x-select>
                                    </div>


                                    <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">

                                        <div class="lg:col-span-3">
                                            <div class="sm:col-span-2 lg:col-span-3 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">
                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Roll No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="roll_no" id="roll_no" class="" />
                                                    <span id="messageExistRoll" class="text-bold text-red-700"></span>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Full Name') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="name" id="name" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birth Regi No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="birth_regi_no" id="birth_regi_no" class="birth_regi_no" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Date Of Birth') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="dob" id="dob" class="datepicker-1" />
                                                </div>

                                                <div class="hidden lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Age') }}
                                                    </x-label>
                                                    <x-input type="number" name="age" id="age" class="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birthplace') }}
                                                    </x-label>
                                                    <x-input type="text" name="birthplace" id="birthplace" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Occupation') }}
                                                    </x-label>
                                                    <x-select name="occupation" id="occupation">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select') }} -
                                                        </option>
                                                        <option value="1">
                                                            - {{ __('translation.Worker') }} -
                                                        </option>
                                                        <option value="2">
                                                            - {{ __('translation.Muktijoddha') }} -
                                                        </option>
                                                        <option value="3">
                                                            - {{ __('translation.Upajati') }} -
                                                        </option>
                                                        <option value="4">
                                                            - {{ __('translation.Onath/Etim') }} -
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Religion') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="religion" name="religion" required style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Relegion') }} -
                                                        </option>
                                                        <option value="Islam">
                                                        - {{ __('translation.Islam') }} -
                                                        </option>
                                                        <option value="Hindu">
                                                        - {{ __('translation.Hindu') }} -
                                                        </option>
                                                        <option value="Buddist">
                                                        - {{ __('translation.Buddist') }} -
                                                        </option>
                                                        <option value="Christian">
                                                        - {{ __('translation.Christian') }} -
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Nationality') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="nationality" id="nationality" value="Bangladeshi" required />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Marital Status') }}
                                                    </x-label>
                                                    <div class="flex flex-row">
                                                        <div>
                                                            <x-form.input-radio name="marital_status" id="unmerried" value="0" checked="true">
                                                                {{ __('translation.UnMerried') }}
                                                            </x-form.input-radio>
                                                        </div>
                                                        <div class="ml-5">
                                                            <x-form.input-radio name="marital_status" id="merried" value="1">
                                                                {{ __('translation.Merried') }}
                                                            </x-form.input-radio>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Blood Group') }}
                                                    </x-label>
                                                    <x-select id="blood_group" name="blood_group" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Blood Group') }} -
                                                        </option>
                                                        <option value="A+">
                                                            {{ __('translation.A+') }}
                                                        </option>
                                                        <option value="A-">
                                                            {{ __('translation.A-') }}
                                                        </option>
                                                        <option value="B+">
                                                            {{ __('translation.B+') }}
                                                        </option>
                                                        <option value="AB+">
                                                            {{ __('translation.AB+') }}
                                                        </option>
                                                        <option value="AB-">
                                                            {{ __('translation.AB-') }}
                                                        </option>
                                                        <option value="O+">
                                                            {{ __('translation.O+') }}
                                                        </option>
                                                        <option value="O-">
                                                            {{ __('translation.O-') }}
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Gender') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="gender" name="gender" style="width: 100%">
                                                        <option disabled selected value=" ">
                                                            - {{ __('translation.Select Gender') }} -
                                                        </option>
                                                        <option value="male">
                                                            {{ __('translation.Male') }}
                                                        </option>
                                                        <option value="female">
                                                            {{ __('translation.FeMale') }}
                                                        </option>
                                                        <option value="other">
                                                            {{ __('translation.Other') }}
                                                        </option>
                                                    </x-select>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <div class="mb-2 sm:text-center">
                                                <x-label for="profile_photo">
                                                    {{ __('translation.Proifle Picture') }}
                                                </x-label>
                                            </div>
                                            <label for="profile_photo" class="profile_photo__wrapper block w-full sm:w-50 sm:mx-auto mt-2 border border-dashed border-gray-400 rounded-md relative bg-white shadow-sm cursor-pointer">
                                                <input type="file" name="profile_photo" id="profile_photo" class="profile_photo__field hidden" accept="image/*">
                                                <div class="p-2">
                                                    <div class="h-44 flex items-center justify-center">
                                                        <img style="max-height: 185px;" src="{{ asset('No-Image-Found.png') }}" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                                                    </div>
                                                </div>
                                                <div class="h-7">
                                                    <button type="button" class="profile_photo__remove_button pt-1 pb-2 w-full border-0 outline-none focus:outline-none bg-transparent text-center text-xs text-red-500 hover:underline">
                                                        {{ __('translation.Remove') }}
                                                    </button>
                                                </div>
                                            </label>
                                        </div>


                                        <div class="lg:col-span-4">
                                            <input type="checkbox" name="is_phyically_disabled" id="is_phyically_disabled" />
                                            <label>
                                                {{ __('translation.Is Physically Challenged ?') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-4 phyically_disabled_box">
                                            <x-label>
                                                {{ __('translation.Physically Disabled Type') }}
                                            </x-label>
                                            <x-input type="text" name="phyically_disabled_type" id="phyically_disabled_type" />
                                        </div>



                                        <div class="psc_info lg:col-span-4 flex flex-row items-center justify-between mb-3 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.Primary Result info') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ __("Passing Year") }}
                                            </x-label>
                                            <x-input type="text" name="psc_passing_year" id="psc_passing_year" style="width: 100%" ></x-input>
                                        </div>


                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ __("Primary Roll") }}
                                            </x-label>
                                            <x-input type="text" name="psc_roll_no" id="psc_roll_no" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ __("Primary ID No.") }}
                                            </x-label>
                                            <x-input type="text" name="psc_id_no" id="psc_id_no" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ __("GPA") }}
                                            </x-label>
                                            <x-input type="text" name="psc_gpa" id="psc_gpa" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ __("Scholarship (If any)") }}
                                            </x-label>
                                            <x-select name="psc_scholarship" id="__selectPrimaryScholarship" class="psc_scholarship" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select') . ' -' }}
                                                </option>
                                                <option value="general">General</option>
                                                <option value="talent_poll">Talent Pool</option>
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 psc_info">
                                            <x-label>
                                                {{ '- ' . __('translation.Scholarship ID No') . ' -' }}
                                            </x-label>
                                            <x-input type="text" name="psc_scholarship_id_no" id="psc_scholarship_id_no" style="width: 100%" ></x-input>
                                        </div>



                                        <div class="jsc_info lg:col-span-4 flex flex-row items-center justify-between mb-3 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.JSC Result info') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ __("Passing Year") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_passing_year" id="jsc_passing_year" style="width: 100%" ></x-input>
                                        </div>


                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ __("JSC Roll") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_roll_no" id="jsc_roll_no" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ __("JSC ID No.") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_id_no" id="jsc_id_no" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ __("GPA") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_gpa" id="jsc_gpa" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ __("Scholarship (If any)") }}
                                            </x-label>
                                            <x-select name="jsc_scholarship" id="__selectJSCScholarship" class="jsc_scholarship" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select') . ' -' }}
                                                </option>
                                                <option value="general">General</option>
                                                <option value="talent_poll">Talent Pool</option>
                                            </x-select>
                                        </div>

                                        <div class="jsc_info lg:col-span-1">
                                            <x-label>
                                                {{ '- ' . __('translation.Scholarship ID No') . ' -' }}
                                            </x-label>
                                            <x-input type="text" name="jsc_scholarship_id_no" id="jsc_scholarship_id_no" style="width: 100%" ></x-input>
                                        </div>


                                        <div class="lg:col-span-4">
                                            <input type="checkbox" name="is_siblings_study_here" id="is_siblings_study_here" />
                                            <label>
                                                {{ __('translation.Is your Brother/sister already Admitted in this school ?') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-4 siblings_box">
                                            <x-label>
                                                {{ __('translation.Enter His/Her Student ID no') }} ( Please Use comma for multiple id as 80005,12003)
                                            </x-label>
                                            <x-input type="text" name="siblings_id_no" id="siblings_id_no" />
                                        </div>

                                        <div class="lg:col-span-4" id="AjaxSiblingsInfoWrapper"></div>



                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.Current Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Village') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="village" id="village" />
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Ward No') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="ward_no" id="ward_no" />
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Moholla') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="moholla" id="moholla" />
                                        </div>


                                        <div  class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code" id="__selectPostcodeFilter" class="post_code" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }} <x-form.required-mark/>
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}">{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila" id="__selectUpazilaFilter" class="upazila" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }} <x-form.required-mark/>
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}">{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.District') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="district" id="__selectDistrictFilter" class="district" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}">{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.Permanent Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-4">
                                            <input type="checkbox" checked="true" name="same_as_current" id="same_as_current" />
                                            <label>
                                                {{ __('translation.Same as Current') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village_permanent" id="village_permanent" />
                                        </div>


                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code_permanent" id="__selectPostcodeFilterPermanent" class="post_code_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}">{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila_permanent" id="__selectUpazilaFilterPermanent" class="upazila_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}">{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district_permanent" id="__selectDistrictFilterPermanent" class="district_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}">{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-4">
                                            <x-label>
                                                {{ __('translation.Previous School') }}
                                            </x-label>
                                            <x-input type="text" name="previous_school" id="previous_school" />
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane" id="guardian-details">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                        {{ __('translation.Guardian Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8">

                                    <div>
                                        <x-label>
                                            {{ __("Family Members") }}
                                        </x-label>
                                        <x-input type="number" name="family_members" id="family_members" style="width: 100%" ></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Monthly Income") }} (TK)
                                        </x-label>
                                        <x-input type="text" name="monthly_income" id="monthly_income" style="width: 100%" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Total Family Land/Asset In Amount") }} (TK)
                                        </x-label>
                                        <x-input type="text" name="total_land_or_asset" id="total_land_or_asset" style="width: 100%" ></x-input>
                                    </div>

                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Father's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="fathers_name" id="fathers_name" style="width: 100%" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Father's NID No") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="fathers_NID_no" id="fathers_NID_no" style="width: 100%" ></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Father's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_phone" id="fathers_phone" style="width: 100%"></x-input>
                                    </div>

                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Mother's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="mothers_name" id="mothers_name" style="width: 100%"></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Mothers's NID No") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="mothers_NID_no" id="mothers_NID_no" style="width: 100%" ></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Mother's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_phone" id="mothers_phone" style="width: 100%"></x-input>
                                    </div>
                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Name') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_name" id="legal_guardians_name" style="width: 100%"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Phone No') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_phone" id="legal_guardians_phone" style="width: 100%"></x-input>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8 mt-4">
                                    <div>
                                        <x-label>
                                            {{ __('translation.Make as a Voter') }} <x-form.required-mark/>
                                        </x-label>

                                        <x-select name="voter_type" id="voter_type" style="width: 100%" required>
                                            <option disabled selected value="0">
                                                - {{ __('translation.Select as a Voter') }} -
                                            </option>
                                            <option value="fathers_name" >Father</option>
                                            <option value="mothers_name" >Mother</option>
                                            <option value="legal_guardians_name">Local Guardian</option>
                                        </x-select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="payment">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                        {{ __('translation.Payment') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

									<div id='AjaxFeePaymentWrapper'></div>

                            </div>
                        </div>
                    </div>


                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitStudent">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>

            </x-card.body>
        </x-card.card-default>
    </div>
    @endif



    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>
        <script src="{{ asset('pages/admin/student/form_update.js?_=' . rand()) }}"></script>
        <script>

            $("#roll_no").on("keyup", function(){
                var arr1 = [1,2,3,4,5,6,7,8,9];

                if($("#roll_no").val().length !== 0){
                    if(jQuery.inArray(parseInt($(this).val()), arr1) !== -1){
                        var addleading_zero = $(this).val().toString().padStart(2, '0');
                        $("#roll_no").val(addleading_zero);
                    }else {
                        $("#roll_no").val(parseInt($(this).val()));
                    }
                }
                fn_unique_validation();
            });

            function fn_unique_validation(){
                let class_id = jQuery( "#__selectClassFilter" ).val();
                let section_id = jQuery( "#__selectSectionFilter" ).val();
                var group_id = jQuery( "#__selectGroupFilter" ).val();
                var session_id = jQuery( "#__selectSessionFilter" ).val();
                let roll_no = $("#roll_no").val();

                if(roll_no){
                    jQuery.ajax({
                            type : 'POST',
                            url: '{{ route('unique_roll_validation') }}',
                            data : {
                                class_id:class_id,
                                section_id:section_id,
                                group_id:group_id,
                                session_id:session_id,
                                roll_no:roll_no,
                            },
                            beforeSend: function() {

                            }
                            }).done(function(data) {
                                jQuery("#messageExistRoll").html(data);

                            });
                }

            }

			$('#__selectDivisionFilter').select2({
                width: 'resolve'
            });

            $('#__selectDistrictFilter').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilter').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilter').select2({
                width: 'resolve'
            });

            //Permanent
            $('#__selectDistrictFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilterPermanent').select2({
                width: 'resolve'
            });




			$(".datepicker-1").datepicker({
                dateFormat: 'yy-mm-dd',
				 changeMonth: true,
				 changeYear: true,
				 yearRange: "-20:+0",
            });


            $(".phyically_disabled_box").addClass('hide');
            $("#is_phyically_disabled").on("click", function(){
                check = $("#is_phyically_disabled").is(":checked");
                if(check) {
                    $(".phyically_disabled_box").removeClass('hide');
                } else {
                    $(".phyically_disabled_box").addClass('hide');
                }
            });

            $(".siblings_box").addClass('hide');
            $("#is_siblings_study_here").on("click", function(){
                check = $("#is_siblings_study_here").is(":checked");
                if(check) {
                    $(".siblings_box").removeClass('hide');
                } else {
                    $(".siblings_box").addClass('hide');
                }
            });




            $(".permanent").addClass('hide');
            $("#same_as_current").on("click", function(){
                check = $("#same_as_current").is(":checked");
                if(check) {
                    $(".permanent").addClass('hide');
                } else {
                    $(".permanent").removeClass('hide');
                }
            });


            $("#siblings_id_no").on("keyup", function(){
                fn_get_siblings_info();
            });



            function fn_get_siblings_info(){
                let siblings_id_no = $("#siblings_id_no").val();
                if(siblings_id_no){
                    jQuery.ajax({
                            type : 'POST',
                            url: '{{ route('get_siblings_info') }}',
                            data : {siblings_id_no:siblings_id_no},
                            beforeSend: function() {
                                $('#AjaxSiblingsInfoWrapper').html('processing...');
                                }
                            }).done(function(data) {
                                jQuery("#AjaxSiblingsInfoWrapper").html(data);

                            });
                }

            }

            $('#__formStudent').submit(function(event) {
                event.preventDefault();
                let formData = new FormData($(this)[0]);
                $.ajax({
                    type: $(this).attr('method'),
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
                        $('.alert').addClass('hidden');
                    },
                    success: function(responseJson) {
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        console.log(responseJson);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        $('.alert').addClass('hidden');
                        $('#__alertSuccess').removeClass('hidden');
                        $('#__content_alertSuccess').html(null);
                        $('#__content_alertSuccess').html(responseJson.message);
                        if(responseJson.id){
                            var url = '{{ route('students.view', ":id") }}';
                            url = url.replace(':id', responseJson.id);
                        }else{
                            var url = '{{ route('students.create') }}';
                        }
                        setTimeout(() => {
                            window.location.href = '{{ route('students.index') }}';
                        }, 1500);
                    },
                    error: function(response) {
                        let responseJson = response.responseJSON;
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        $('.alert').addClass('hidden');
                        $('#__alertDanger').removeClass('hidden');
                        $('#__content_alertDanger').html(null);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        if (response.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__content_alertDanger').append(
                                    $('<div/>', {
                                        html: responseJson.errors[field][0],
                                        class: 'mb-2'
                                    })
                                );
                            });
                        }
                        else {
                            $('#__content_alertDanger').html(responseJson.message);
                        }
                    }
                });
                return false;
            });

        </script>


        <script>

            jQuery(document).on('change','#__selectSessionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_session', $(this).val());
                filterOthersFee();
            });

            $(".psc_info").addClass('hide');
            $(".jsc_info").addClass('hide');
            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
               let class_name = $("#__selectClassFilter  option:selected").text().toLowerCase();
            // Show JSC OR PSC Area
               fn_jsc_psc_wrapper_view(class_name);

                localStorage.setItem('fee_taken_class', $(this).val());
                filterOthersFee();
            });

            function fn_jsc_psc_wrapper_view(class_name){
                if(class_name =='six'){
                    $(".psc_info").removeClass('hide');
                    $(".jsc_info").addClass('hide');
                }else if(class_name=='nine'){
                    $(".jsc_info").removeClass('hide');
                    $(".psc_info").addClass('hide');
                }else{
                    $(".jsc_info").addClass('hide');
                    $(".psc_info").addClass('hide');
                }
            }

            jQuery(document).on('change','#__selectSectionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_section', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectGroupFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_group', $(this).val());
                filterOthersFee();
            });

            if(localStorage.getItem('fee_taken_session')){
                var session_id = localStorage.getItem('fee_taken_session');
                $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_class')){
                var session_id = localStorage.getItem('fee_taken_class');
                $("#__selectClassFilter option[value='"+session_id+"']").prop('selected', true);
                let class_name = $("#__selectClassFilter  option:selected").text().toLowerCase();
                // Show JSC OR PSC Area
                fn_jsc_psc_wrapper_view(class_name);
            }


            if(localStorage.getItem('fee_taken_section')){
                var session_id = localStorage.getItem('fee_taken_section');
                $("#__selectSectionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_group')){
                var session_id = localStorage.getItem('fee_taken_group');
                $("#__selectGroupFilter option[value='"+session_id+"']").prop('selected', true);
            }



            jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
                localStorage.removeItem('fee_taken_session');
                localStorage.removeItem('fee_taken_class');
                localStorage.removeItem('fee_taken_section');
                localStorage.removeItem('fee_taken_group');

                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectGroupFilter').val('').trigger('change');

            });


            $('#__selectClassFilter').on('change',function() {
                filterOthersFee();
            });

            filterOthersFee();

            function filterOthersFee(){

                var session_id = jQuery( "#__selectSessionFilter" ).val();

                var class_id = jQuery( "#__selectClassFilter" ).val();
                var section_id = jQuery( "#__selectSectionFilter" ).val();
                var group_id = jQuery( "#__selectGroupFilter" ).val();
				var roll_no = $('#roll_no').val();
                jQuery("#AjaxFeePaymentWrapper").html('');
                if(class_id && session_id){
                    fn_other_fee_existance(class_id,session_id);
                    jQuery('#others_fee').hide();
                    jQuery.ajax({
                            type : 'POST',
                            url: '{{ route('admission_filter_others_fee') }}',
                            data : {class_id:class_id,session_id:session_id,section_id:section_id,group_id:group_id,roll_no:roll_no},
                            beforeSend: function() {
                                    $('#AjaxFeePaymentWrapper').html('processing...');
                                }
                            }).done(function(data) {
                                jQuery("#AjaxFeePaymentWrapper").html(data);

                            });

                }
            }

            function fn_other_fee_existance(class_id,session_id){
                jQuery.ajax({
                            type : 'POST',
                            url: '{{ route('admission_filter_others_fee_existance_checking') }}',
                            data : {class_id:class_id,session_id:session_id},
                            beforeSend: function() {


                            }
                            }).done(function(data) {
                                if(data){
                                        alert(data);
                                    }

                            });
            }

			function clearMonthlyFee(){
				var elements = document.getElementById("monthlyFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#monthly_fee_total").val('0');
                var TotalPayableFee = 0 + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

			function clearOthersFee(){
				var elements = document.getElementById("othersFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#other_amount_total").val('0');
                var TotalPayableFee = parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

                jQuery(document).on('change','#monthlyFee', { passive: true } ,function( e ) {
                    var MonthlyFeeTotalAmount = 0;
                    var fieldName = [];
                $( "#monthlyFee option:selected" ).each(function() {
                    MonthlyFeeTotalAmount += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());

                });

                $( "#monthly_fee_total" ).val(MonthlyFeeTotalAmount);
                $( "#monthly_fee_fields" ).val(fieldName.join(","));

                var TotalPayableFee = MonthlyFeeTotalAmount + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

                });


                jQuery(document).on('change','#othersFee', { passive: true } ,function( e ) {
                    var othersFee = 0;
                    var fieldName = [];
                    var fieldValue = [];
                $( "#othersFee option:selected" ).each(function() {
                    othersFee += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());
                    fieldValue.push($( this ).data('fee'));

                });

                $( "#other_amount_total" ).val(othersFee);
                $( "#others_fee_fields" ).val(fieldName.join("@"));
                $( "#others_fee_details" ).val(fieldValue.join("@"));


                var TotalPayableFee = othersFee + parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

                });


        </script>


    @endpush

</x-app-layout>
