<x-app-layout>
    @section('title', 'Student List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="{{ asset('css/IDCard.css')}}">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Students') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $classe)
                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                    <option value="0" disabled>
                        {{ '- ' . __('translation.Select Section') . ' -' }}
                    </option>
                    @if (isset($sections))
                        @foreach ($sections as $section)
                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

        </div>


        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-1/5 mb-6 lg:mb-0 ml-5 mt-10 id-container">
                <div class="font">
                    <div class="companyname">Kalipur High School<br><span class="tab">Bhairab,Kishoreganj</span></div>
                    <div class="top">
                        <img src="{{ URL::asset('/img/id-cards/character.png') }}" alt="">
                    </div>
                    <div class="">
                        <div class="ename">
                        <p class="p1"><b>MD. RASHEDK AKBER</b></p>
                        </div>
                        <div class="edetails">
                            <P><b>Mobile No :</b> 0174158888</P>
                            <p><b>DOB :</b> 02/11/2001</p>
                            <div class="Address"><b>Address : </b>12,Kalipur, Bhairab (North), Kishoreganj </div>

                        </div>

                        <div style="display:none" class="signature">
                            <img src="{{ URL::asset('/img/id-cards/signature.png') }}" alt="">
                        </div>

                        <div  style="display:none" class="barcode">
                            <img src="{{ URL::asset('/img/id-cards/qr sample.png') }}" alt="">
                        </div>
                        <div class="qr">
                            <img src="{{ URL::asset('/img/id-cards/barcode.png') }}" alt="">
                        </div>


                    </div>
                </div>
            </div>

        <div class="w-full lg:w-4/5 mb-6 lg:mb-0 ml-5">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Name') }}
                        </th>

                        <th>
                            {{ __('translation.Student ID') }}
                        </th>

                        <th>
                            {{ __('translation.Roll No') }}
                        </th>


                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
    </x-card>
   @endif



    <x-modal.modal-full class="modal-mark-sheet modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Mark Sheet
            </x-modal.title>
            <x-modal.close-button id="closeModalMarkSheet" />
        </x-modal.header>
        <x-modal.body>
        <div id="mark-sheet-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('students_list') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        console.log(json);
                        if(json.supplier !='' && json.draw=='1'){
                        $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                        $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                        $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                        $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                        }
                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'name',
                            data: 'name'
                        },

                        {
                            name: 'student_id',
                            data: 'student_id'
                        },


                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [1],
                            orderable: false,
                            className: 'text-center'
                        },

                    ]
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });


            $('input[type="search"]').on('keyup', function(e) {
                $("#arrive_or_over_due").select2('val', '0')
                $("#supplier_id").select2("val", "0");
            });




            $(document).on('click', '#purchase_status_chnage', function() {
                var order_id = $(this).attr('data-id');
                $('#po_chnage_status_modal').modal('show');
                $('#order_id').val(order_id);
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();

                    $.ajax({
                        url: '',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Data deleted successfully');

                            $('#__studentTable').dataTable().fnDestroy();
                            loadStudentsTable(studentTableUrl);

                        } else {
                            alert(result.message);
                        }
                    });
                }
            });






            const markSheetUrl = '{{ route('mark_sheet_view') }}';
                $(document).on('click', '.exportMarkSheet', function() {
                var exam_id = $(this).data('exam_id');
                var session_id = $(this).data('session_id');
                var class_id = $(this).data('class_id');
                var student_id = $(this).data('student_id');
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });

            $(document).on('change', '#exam_id', function() {
                var exam_id = $(this).val();
                var session_id = $("#session_id").val();
                var class_id = $("#class_id").val();
                var student_id = $("#student_id").val();
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });


            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
