<x-app-layout>
    @section('title', 'Students')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
        <div class="col-span-12">

        @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('students.index') }}" />
                <x-card.title>
                    {{ __('translation.Edit Student') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="alert mb-5 hidden" id="__alertDanger">
                    <span id="__content_alertDanger"></span>
                </x-alert-danger>

                <x-alert-success class="alert mb-5 hidden" id="__alertSuccess">
                    <span id="__content_alertSuccess"></span>
                </x-alert-success>

                <form method="POST" action="{{ route('students.store') }}" id="__formStudent" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="timestamp" name="timestamp" value="{{$timestamp}}">
                    <ul class="nav nav-pills">
                        <li class="active">
                            <a  href="#po-info" data-toggle="tab">{{ __('translation.Student Information') }}</a>
                        </li>
                        <li>
                            <a href="#guardian-details" data-toggle="tab">{{ __("translation.Guardian Information") }}</a>
                        </li>
                    </ul>

                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="po-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Students Info') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>


                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">

                                    <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">
                                        <x-input type="hidden" name="class_code" id="class_code" value="" />
                                        <div class="lg:col-span-3">
                                            <div class="sm:col-span-2 lg:col-span-3 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">
                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Roll No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="roll_no" id="roll_no" value="{{$student->current_roll}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Full Name') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="name" id="name" value="{{$student->name}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Date Of Birth') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="dob" id="dob" class="datepicker-1" value="{{$student->dob}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birth Regi No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="birth_regi_no" id="birth_regi_no" class="birth_regi_no" value="{{$student->birth_regi_no}}" />
                                                </div>


                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birthplace') }}
                                                    </x-label>
                                                    <x-input type="text" name="birthplace" id="birthplace" value="{{$student->birthplace}}"/>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Religion') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="religion" name="religion" required style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Relegion') }} -
                                                        </option>
                                                        <option value="Islam" @if($student->religion=='Islam') selected @endif>
                                                        - {{ __('translation.Islam') }} -
                                                        </option>
                                                        <option value="Hindu" @if($student->religion=='Hindu') selected @endif>
                                                        - {{ __('translation.Hindu') }} -
                                                        </option>
                                                        <option value="Buddist" @if($student->religion=='Buddist') selected @endif>
                                                        - {{ __('translation.Buddist') }} -
                                                        </option>
                                                        <option value="Christian" @if($student->religion=='Christian') selected @endif>
                                                        - {{ __('translation.Christian') }} -
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Nationality') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="nationality" id="nationality" value="Bangladeshi" required />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Marital Status') }}
                                                    </x-label>
                                                    <div class="flex flex-row">
                                                        <div>
                                                            <input type="radio" name="marital_status" id="unmerried" value="0"  @if($student->marital_status=='0') checked="true" @endif>
                                                                {{ __('translation.UnMerried') }}
                                                        </div>
                                                        <div class="ml-5">
                                                            <input type="radio" name="marital_status" id="merried" value="1" @if($student->marital_status=='1') checked="true" @endif >
                                                                {{ __('translation.Merried') }}
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Blood Group') }}
                                                    </x-label>
                                                    <x-select id="blood_group" name="blood_group" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Blood Group') }} -
                                                        </option>
                                                        <option value="A+" @if($student->blood_group=='A+') selected @endif>
                                                            {{ __('translation.A+') }}
                                                        </option>
                                                        <option value="A-" @if($student->blood_group=='A-') selected @endif>
                                                            {{ __('translation.A-') }}
                                                        </option>
                                                        <option value="B+" @if($student->blood_group=='B+') selected @endif>
                                                            {{ __('translation.B+') }}
                                                        </option>
                                                        <option value="AB+" @if($student->blood_group=='AB+') selected @endif>
                                                            {{ __('translation.AB+') }}
                                                        </option>
                                                        <option value="AB-" @if($student->blood_group=='AB-') selected @endif>
                                                            {{ __('translation.AB-') }}
                                                        </option>
                                                        <option value="O+" @if($student->blood_group=='O+') selected @endif>
                                                            {{ __('translation.O+') }}
                                                        </option>
                                                        <option value="O-" @if($student->blood_group=='O-') selected @endif>
                                                            {{ __('translation.O-') }}
                                                        </option>

                                                    </x-select>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <div class="mb-2 sm:text-center">
                                                <x-label for="profile_photo">
                                                    {{ __('translation.Proifle Picture') }}
                                                </x-label>
                                            </div>
                                            <label for="profile_photo" class="profile_photo__wrapper block w-full sm:w-60 sm:mx-auto mt-2 border border-dashed border-gray-400 rounded-md relative bg-white shadow-sm cursor-pointer">
                                                <input type="file" name="profile_photo" id="profile_photo" class="profile_photo__field hidden" accept="image/*">
                                                <div class="p-2">
                                                    <div class="h-44 flex items-center justify-center">
                                                        <img style="max-height: 185px;" src="{{ asset('No-Image-Found.png') }}" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                                                    </div>
                                                </div>
                                                <div class="h-7">
                                                    <button type="button" class="profile_photo__remove_button hidden pt-1 pb-2 w-full border-0 outline-none focus:outline-none bg-transparent text-center text-xs text-red-500 hover:underline">
                                                        {{ __('translation.Remove') }}
                                                    </button>
                                                </div>
                                            </label>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Class') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Class') . ' -' }}
                                                </option>
                                                @if (isset($classes))
                                                    @foreach($classes as $row)
                                                        <option data-class_code="{{$row->class_code}}" value="{{$row->id}}" @if($student->class_id==$row->id) selected @endif >{{$row->class_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Section') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                                <option value="" selected>
                                                    {{ '- ' . __('translation.Select Section') . ' -' }}
                                                </option>
                                                @if (isset($sections))
                                                    @foreach($sections as $row)
                                                        <option value="{{$row->id}}" @if($student->section_id==$row->id) selected @endif >{{$row->section_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Session') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Session') . ' -' }}
                                                </option>
                                                @if (isset($sessions))
                                                    @foreach($sessions as $row)
                                                        <option value="{{$row->id}}" @if($student->session_id==$row->id) selected @endif >{{$row->session_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Group') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="group_id" id="__selectGroupFilter" class="group_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Group') . ' -' }}
                                                </option>
                                                @if (isset($groups))
                                                    @foreach($groups as $row)
                                                        <option value="{{$row->id}}" @if($student->group_id==$row->id) selected @endif>{{$row->group_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>



                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Current Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <?php
                                        $current_address = json_decode($student->current_address,true);
                                        $same_as_current = $student->same_as_current;

                                        $permanent_address = json_decode($student->permanent_address,true);

                                        if($same_as_current=='on'){
                                            $permanent_add_village = $current_address['village'];
                                            $permanent_add_post_code = $current_address['post_code'];
                                            $permanent_add_post_code = $current_address['post_code'];
                                            $permanent_add_upazila = $current_address['upazila'];
                                            $permanent_add_district = $current_address['district'];
                                        }else{
                                            $permanent_add_village = $permanent_address['village'];
                                            $permanent_add_post_code = $permanent_address['post_code'];
                                            $permanent_add_post_code = $permanent_address['post_code'];
                                            $permanent_add_upazila = $permanent_address['upazila'];
                                            $permanent_add_district = $permanent_address['district'];
                                        }

                                        ?>
                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Village') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="village" id="village" value="{{$current_address['village']}}" />
                                        </div>


                                        <div  class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code" id="__selectPostcodeFilter" class="post_code" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }} <x-form.required-mark/>
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" @if($current_address['post_code']==$item['postOffice']) selected @endif>{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila" id="__selectUpazilaFilter" class="upazila" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }} <x-form.required-mark/>
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($current_address['upazila']==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.District') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="district" id="__selectDistrictFilter" class="district" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($current_address['district']==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Permanent Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-4">
                                            <input type="checkbox" checked="true" name="same_as_current" id="same_as_current" />
                                            <label>
                                                {{ __('translation.Same as Current') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village_permanent" id="village_permanent" value="{{$permanent_add_village}}" />
                                        </div>


                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code_permanent" id="__selectPostcodeFilterPermanent" class="post_code_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" @if($permanent_add_post_code==$item['postOffice']) selected @endif >{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila_permanent" id="__selectUpazilaFilterPermanent" class="upazila_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($permanent_add_upazila==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district_permanent" id="__selectDistrictFilterPermanent" class="district_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($permanent_add_district==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane" id="guardian-details">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Guardian Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8">

                                    <div>
                                        <x-label>
                                            {{ __("Father's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="fathers_name" id="fathers_name" style="width: 100%" value="{{$student->fathers_name}}" ></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Father's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_phone" id="fathers_phone" style="width: 100%" value="{{$student->fathers_phone}}"></x-input>
                                    </div>

                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Mother's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="mothers_name" id="mothers_name" style="width: 100%" value="{{$student->mothers_name}}"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Mothers's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_phone" id="mothers_phone" style="width: 100%" value="{{$student->mothers_phone}}"></x-input>
                                    </div>
                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Name') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_name" id="legal_guardians_name" style="width: 100%" value="{{$student->legal_guardians_name}}"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Phone No') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_phone" id="legal_guardians_phone" style="width: 100%" value="{{$student->legal_guardians_phone}}"></x-input>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8 mt-4">
                                    <div>
                                        <x-label>
                                            {{ __('translation.Make as a Voter') }} <x-form.required-mark/>
                                        </x-label>

                                        <x-select name="voter_type" id="voter_type" style="width: 100%" required>
                                            <option disabled selected value="0">
                                                - {{ __('translation.Select as a Voter') }} -
                                            </option>
                                            <option value="fathers_name" @if($student->voter_type=='fathers_name') selected @endif >Father</option>
                                            <option value="mothers_name" @if($student->voter_type=='mothers_name') selected @endif >Mother</option>
                                            <option value="legal_guardians_name" @if($student->voter_type=='legal_guardians_name') selected @endif>Local Guardian</option>
                                        </x-select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitStudent">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>

            </x-card.body>
        </x-card.card-default>
    </div>
    @endif



    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>
        <script src="{{ asset('pages/admin/student/form_update.js?_=' . rand()) }}"></script>
        <script>

			$('#__selectDivisionFilter').select2({
                width: 'resolve'
            });

            $('#__selectDistrictFilter').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilter').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilter').select2({
                width: 'resolve'
            });

            //Permanent
            $('#__selectDistrictFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilterPermanent').select2({
                width: 'resolve'
            });




			$(".datepicker-1").datepicker({
                dateFormat: 'yy-mm-dd',
				 changeMonth: true,
				 changeYear: true,
				 yearRange: "-20:+0",
            });


            $(".permanent").addClass('hide');
            $("#same_as_current").on("click", function(){
            check = $("#same_as_current").is(":checked");
            if(check) {
                $(".permanent").addClass('hide');
            } else {
                $(".permanent").removeClass('hide');
            }
        });

            $('#__formStudent').submit(function(event) {
                event.preventDefault();
                let formData = new FormData($(this)[0]);
                $.ajax({
                    type: $(this).attr('method'),
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
                        $('.alert').addClass('hidden');
                    },
                    success: function(responseJson) {
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        console.log(responseJson);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        $('.alert').addClass('hidden');
                        $('#__alertSuccess').removeClass('hidden');
                        $('#__content_alertSuccess').html(null);
                        $('#__content_alertSuccess').html(responseJson.message);
                        if(responseJson.id){
                            var url = '{{ route('students.view', ":id") }}';
                            url = url.replace(':id', responseJson.id);
                        }else{
                            var url = '{{ route('students.create') }}';
                        }
                        setTimeout(() => {
                            window.location.href = url;
                        }, 1500);
                    },
                    error: function(response) {
                        let responseJson = response.responseJSON;
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        $('.alert').addClass('hidden');
                        $('#__alertDanger').removeClass('hidden');
                        $('#__content_alertDanger').html(null);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        if (response.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__content_alertDanger').append(
                                    $('<div/>', {
                                        html: responseJson.errors[field][0],
                                        class: 'mb-2'
                                    })
                                );
                            });
                        }
                        else {
                            $('#__content_alertDanger').html(responseJson.message);
                        }
                    }
                });
                return false;
            });

        </script>


        <script>

            jQuery(document).on('change','#__selectSessionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_session', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_class', $(this).val());
                var class_code = $("#__selectClassFilter  option:selected").data('class_code');
                $("#class_code").val(class_code);
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectSectionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_section', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectGroupFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_group', $(this).val());
                filterOthersFee();
            });

            if(localStorage.getItem('fee_taken_session')){
                var session_id = localStorage.getItem('fee_taken_session');
                $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_class')){
                var session_id = localStorage.getItem('fee_taken_class');
                $("#__selectClassFilter option[value='"+session_id+"']").prop('selected', true);
            }


            if(localStorage.getItem('fee_taken_section')){
                var session_id = localStorage.getItem('fee_taken_section');
                $("#__selectSectionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_group')){
                var session_id = localStorage.getItem('fee_taken_group');
                $("#__selectGroupFilter option[value='"+session_id+"']").prop('selected', true);
            }



            jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
                localStorage.removeItem('fee_taken_session');
                localStorage.removeItem('fee_taken_class');
                localStorage.removeItem('fee_taken_section');
                localStorage.removeItem('fee_taken_group');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectGroupFilter').val('').trigger('change');
            });

        </script>


    @endpush

</x-app-layout>
